/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import java.util.Arrays;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.query.Query;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class DefaultObjectMapperTest {
    ObjectMapper mapper = new DefaultObjectMapper();

    @Test
    public void testDateTime() throws Exception {
        DateTime time = DateTimes.nowUtc();
        Assert.assertEquals((Object)StringUtils.format((String)"\"%s\"", (Object[])new Object[]{time}), (Object)this.mapper.writeValueAsString((Object)time));
    }

    @Test
    public void testYielder() throws Exception {
        Sequence sequence = Sequences.simple(Arrays.asList("a", "b", null, DateTimes.utc((long)2L), 5, DateTimeZone.UTC, "c"));
        Assert.assertEquals((Object)"[\"a\",\"b\",null,\"1970-01-01T00:00:00.002Z\",5,\"UTC\",\"c\"]", (Object)this.mapper.writeValueAsString((Object)Yielders.each((Sequence)sequence)));
    }

    @Test
    public void testUnknownType() throws JsonProcessingException {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper("testService");
        try {
            objectMapper.readValue("{\"queryType\":\"random\",\"name\":\"does-not-matter\"}", Query.class);
        }
        catch (InvalidTypeIdException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)message, (boolean)message.startsWith("Please make sure to load all the necessary extensions and jars with type 'random' on 'testService' service."));
            return;
        }
        Assert.fail((String)"We expect InvalidTypeIdException to be thrown");
    }

    @Test
    public void testUnknownTypeWithUnknownService() throws JsonProcessingException {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper((String)null);
        try {
            objectMapper.readValue("{\"queryType\":\"random\",\"name\":\"does-not-matter\"}", Query.class);
        }
        catch (InvalidTypeIdException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)message, (boolean)message.startsWith("Please make sure to load all the necessary extensions and jars with type 'random'."));
            return;
        }
        Assert.fail((String)"We expect InvalidTypeIdException to be thrown");
    }
}

