/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.ConcatSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceTestHelper;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.TestSequence;
import org.apache.druid.java.util.common.guava.UnsupportedSequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.junit.Test;

public class ConcatSequenceTest {
    @Test
    public void testAccumulationSingle() throws Exception {
        this.testAll(Collections.singletonList(Arrays.asList(1, 2, 3, 4, 5)));
    }

    @Test
    public void testAccumulationMultiple() throws Exception {
        this.testAll(Arrays.asList(Arrays.asList(1, 2, 3, 4, 5), Arrays.asList(6, 7, 8), Arrays.asList(9, 10, 11, 12)));
    }

    @Test
    public void testAccumulationMultipleAndEmpty() throws Exception {
        this.testAll(Arrays.asList(Arrays.asList(1, 2, 3, 4, 5), Collections.emptyList(), Arrays.asList(6, 7, 8), Arrays.asList(9, 10, 11, 12)));
    }

    @Test
    public void testAccumulationMultipleAndEmpty1() throws Exception {
        this.testAll(Arrays.asList(Arrays.asList(1, 2, 3, 4, 5), Collections.emptyList(), Arrays.asList(6, 7, 8), Arrays.asList(9, 10, 11, 12), Collections.emptyList()));
    }

    @Test
    public void testAccumulationMultipleAndEmpty2() throws Exception {
        this.testAll(Arrays.asList(Collections.emptyList(), Arrays.asList(1, 2, 3, 4, 5), Collections.emptyList(), Arrays.asList(6, 7, 8), Arrays.asList(9, 10, 11, 12)));
    }

    @Test
    public void testClosingOfSequenceSequence() throws Exception {
        final int[] closedCount = new int[]{0};
        Sequence seq = Sequences.concat((Sequence)new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Sequence<Integer>, Iterator<Sequence<Integer>>>(){

            public Iterator<Sequence<Integer>> make() {
                return Arrays.asList(Sequences.simple(Arrays.asList(1, 2, 3, 4)), Sequences.simple(Arrays.asList(5, 6, 7, 8))).iterator();
            }

            public void cleanup(Iterator<Sequence<Integer>> iterFromMake) {
                closedCount[0] = closedCount[0] + 1;
            }
        }));
        Assert.assertEquals((int)9, (int)((Integer)seq.accumulate((Object)1, (Accumulator)new Accumulator<Integer, Integer>(){

            public Integer accumulate(Integer accumulated, Integer in) {
                Assert.assertEquals((Object)accumulated, (Object)in);
                return accumulated + 1;
            }
        })));
        Assert.assertEquals((int)1, (int)closedCount[0]);
        Yielder yielder = seq.toYielder((Object)1, (YieldingAccumulator)new YieldingAccumulator<Integer, Integer>(){

            public Integer accumulate(Integer accumulated, Integer in) {
                Assert.assertEquals((Object)accumulated, (Object)in);
                return accumulated + 1;
            }
        });
        Assert.assertEquals((int)9, (int)((Integer)yielder.get()));
        Assert.assertEquals((int)1, (int)closedCount[0]);
        yielder.close();
        Assert.assertEquals((int)2, (int)closedCount[0]);
    }

    @Test
    public void testClosingOfSequenceSequenceWhenExceptionThrown() {
        final AtomicInteger closedCount = new AtomicInteger(0);
        Sequence seq = Sequences.concat((Sequence)new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Sequence<Integer>, Iterator<Sequence<Integer>>>(){

            public Iterator<Sequence<Integer>> make() {
                return Arrays.asList(Sequences.simple(Arrays.asList(1, 2, 3, 4)), new UnsupportedSequence()).iterator();
            }

            public void cleanup(Iterator<Sequence<Integer>> iterFromMake) {
                closedCount.incrementAndGet();
            }
        }));
        SequenceTestHelper.testClosed(closedCount, (Sequence<Integer>)seq);
    }

    @Test
    public void testEnsureNextSequenceIsCalledLazilyInToYielder() throws Exception {
        final AtomicBoolean lastSeqFullyRead = new AtomicBoolean(true);
        Sequence seq = Sequences.concat((Sequence)Sequences.map((Sequence)Sequences.simple((Iterable)ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2, (Object)3), (Object)ImmutableList.of((Object)4, (Object)5, (Object)6))), (Function)new Function<ImmutableList<Integer>, Sequence<Integer>>(){

            public Sequence<Integer> apply(final ImmutableList<Integer> input) {
                if (lastSeqFullyRead.getAndSet(false)) {
                    return Sequences.simple((Iterable)new Iterable<Integer>(){
                        private Iterator<Integer> baseIter;
                        {
                            this.baseIter = input.iterator();
                        }

                        @Override
                        public Iterator<Integer> iterator() {
                            return new Iterator<Integer>(){

                                @Override
                                public boolean hasNext() {
                                    boolean result = baseIter.hasNext();
                                    if (!result) {
                                        lastSeqFullyRead.set(true);
                                    }
                                    return result;
                                }

                                @Override
                                public Integer next() {
                                    return (Integer)baseIter.next();
                                }

                                @Override
                                public void remove() {
                                    throw new UnsupportedOperationException("Remove Not Supported");
                                }
                            };
                        }
                    });
                }
                throw new IllegalStateException("called before previous sequence is read fully");
            }
        }));
        Yielder yielder = seq.toYielder(null, (YieldingAccumulator)new YieldingAccumulator<Integer, Integer>(){

            public Integer accumulate(Integer accumulated, Integer in) {
                this.yield();
                return in;
            }
        });
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (!yielder.isDone()) {
            result.add((Integer)yielder.get());
            yielder = yielder.next(null);
        }
        yielder.close();
        Assert.assertEquals((Object)ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6), result);
    }

    public void testAll(Iterable<List<Integer>> vals) throws IOException {
        Iterable theSequences = Iterables.transform(vals, (Function)new Function<Iterable<Integer>, TestSequence<Integer>>(){

            public TestSequence<Integer> apply(Iterable<Integer> input) {
                return new TestSequence<Integer>(input);
            }
        });
        ArrayList accumulationSeqs = Lists.newArrayList((Iterable)theSequences);
        SequenceTestHelper.testAccumulation("", (Sequence<Integer>)new ConcatSequence(Sequences.simple((Iterable)accumulationSeqs)), Lists.newArrayList((Iterable)Iterables.concat(vals)));
        for (TestSequence sequence : accumulationSeqs) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
        ArrayList yieldSeqs = Lists.newArrayList((Iterable)theSequences);
        SequenceTestHelper.testYield("", (Sequence<Integer>)new ConcatSequence(Sequences.simple((Iterable)yieldSeqs)), Lists.newArrayList((Iterable)Iterables.concat(vals)));
        for (TestSequence sequence : yieldSeqs) {
            Assert.assertTrue((boolean)sequence.isClosed());
        }
    }
}

