/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.TopNSequence;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class TopNSequenceTest {
    private static final List<String> EMPTY = Collections.emptyList();
    private static final List<String> SINGLE = Collections.singletonList("a");
    private static final List<String> RAW_ASC = Lists.newArrayList((Iterable)Splitter.fixedLength((int)1).split((CharSequence)"abcdefghijk"));
    private static final List<String> RAW_DESC = Lists.newArrayList((Iterable)Splitter.fixedLength((int)1).split((CharSequence)"kjihgfedcba"));

    @RunWith(value=Parameterized.class)
    public static class TopNSequenceEvenOddTest {
        private static final Ordering<String> EVENODD = Ordering.from(Comparator.comparing(s -> 1 - s.charAt(0) % 2));
        private String expected;
        private List<String> rawInput;

        @Parameterized.Parameters(name="rawInput={1}")
        public static Collection<Object[]> makeTestData() {
            Object[][] data = new Object[][]{{"acegikbdfhj", RAW_ASC}, {"kigecajhfdb", RAW_DESC}};
            return Arrays.asList(data);
        }

        public TopNSequenceEvenOddTest(String expected, List<String> rawInput) {
            this.expected = expected;
            this.rawInput = rawInput;
        }

        @Test
        public void testStability() {
            for (int limit = 0; limit < this.expected.length() + 1; ++limit) {
                TopNSequence sequence = new TopNSequence(Sequences.simple(this.rawInput), EVENODD, limit);
                Assert.assertEquals((String)("limit = " + limit), (Object)this.expected.substring(0, Math.min(limit, this.expected.length())), (Object)Joiner.on((String)"").join((Iterable)sequence.toList()));
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class TopNSequenceAscDescTest {
        private static final Ordering<String> ASC = Ordering.natural();
        private static final Ordering<String> DESC = Ordering.natural().reverse();
        private Ordering<String> ordering;
        private List<String> rawInput;
        private int limit;

        @Parameterized.Parameters(name="comparator={0}, rawInput={1}, limit={2}")
        public static Collection<Object[]> makeTestData() {
            Object[][] data = new Object[][]{{ASC, RAW_ASC, RAW_ASC.size() - 2}, {ASC, RAW_ASC, RAW_ASC.size()}, {ASC, RAW_ASC, RAW_ASC.size() + 2}, {ASC, RAW_ASC, 0}, {ASC, SINGLE, 0}, {ASC, SINGLE, 1}, {ASC, SINGLE, 2}, {ASC, SINGLE, 3}, {ASC, EMPTY, 0}, {ASC, EMPTY, 1}, {DESC, RAW_DESC, RAW_DESC.size() - 2}, {DESC, RAW_DESC, RAW_DESC.size()}, {DESC, RAW_DESC, RAW_DESC.size() + 2}, {DESC, RAW_DESC, 0}, {DESC, RAW_DESC, 0}, {DESC, SINGLE, 1}, {DESC, SINGLE, 2}, {DESC, SINGLE, 3}, {DESC, EMPTY, 0}, {DESC, EMPTY, 1}};
            return Arrays.asList(data);
        }

        public TopNSequenceAscDescTest(Ordering<String> ordering, List<String> rawInput, int limit) {
            this.ordering = ordering;
            this.rawInput = rawInput;
            this.limit = limit;
        }

        @Test
        public void testOrderByWithLimit() {
            List<String> expected = this.rawInput.subList(0, Math.min(this.limit, this.rawInput.size()));
            ArrayList inputs = Lists.newArrayList(this.rawInput);
            Collections.shuffle(inputs, new Random(2L));
            TopNSequence result = new TopNSequence(Sequences.simple((Iterable)inputs), this.ordering, this.limit);
            Assert.assertEquals(expected, (Object)result.toList());
        }
    }
}

