/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.AbstractFlatTextFormatParser;
import org.apache.druid.java.util.common.parsers.CSVParser;
import org.apache.druid.java.util.common.parsers.DelimitedParser;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.common.parsers.Parser;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FlatTextFormatParserTest
extends InitializedNullHandlingTest {
    private static final FlatTextFormatParserFactory PARSER_FACTORY = new FlatTextFormatParserFactory();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final AbstractFlatTextFormatParser.FlatTextFormat format;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{AbstractFlatTextFormatParser.FlatTextFormat.CSV}, (Object)new Object[]{AbstractFlatTextFormatParser.FlatTextFormat.DELIMITED});
    }

    public FlatTextFormatParserTest(AbstractFlatTextFormatParser.FlatTextFormat format) {
        this.format = format;
    }

    @Test
    public void testValidHeader() {
        String header = FlatTextFormatParserTest.concat(this.format, "time", "value1", "value2");
        Parser<String, Object> parser = PARSER_FACTORY.get(this.format, header);
        Assert.assertEquals((Object)ImmutableList.of((Object)"time", (Object)"value1", (Object)"value2"), (Object)parser.getFieldNames());
    }

    @Test
    public void testDuplicatedColumnName() {
        String header = FlatTextFormatParserTest.concat(this.format, "time", "value1", "value2", "value2");
        this.expectedException.expect(ParseException.class);
        this.expectedException.expectMessage(StringUtils.format((String)"Unable to parse header [%s]", (Object[])new Object[]{header}));
        PARSER_FACTORY.get(this.format, header);
    }

    @Test
    public void testWithHeader() {
        String header = FlatTextFormatParserTest.concat(this.format, "time", "value1", "value2");
        Parser<String, Object> parser = PARSER_FACTORY.get(this.format, header);
        String body = FlatTextFormatParserTest.concat(this.format, "hello", "world", "foo");
        Map jsonMap = parser.parseToMap(body);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"time", (Object)"hello", (Object)"value1", (Object)"world", (Object)"value2", (Object)"foo"), (Object)jsonMap);
    }

    @Test
    public void testWithoutHeader() {
        Parser<String, Object> parser = PARSER_FACTORY.get(this.format);
        String body = FlatTextFormatParserTest.concat(this.format, "hello", "world", "foo");
        Map jsonMap = parser.parseToMap(body);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"column_1", (Object)"hello", (Object)"column_2", (Object)"world", (Object)"column_3", (Object)"foo"), (Object)jsonMap);
    }

    @Test
    public void testWithSkipHeaderRows() {
        int index;
        int skipHeaderRows = 2;
        Parser<String, Object> parser = PARSER_FACTORY.get(this.format, false, 2);
        parser.startFileFromBeginning();
        String[] body = new String[]{FlatTextFormatParserTest.concat(this.format, "header", "line", "1"), FlatTextFormatParserTest.concat(this.format, "header", "line", "2"), FlatTextFormatParserTest.concat(this.format, "hello", "world", "foo")};
        for (index = 0; index < 2; ++index) {
            Assert.assertNull((Object)parser.parseToMap(body[index]));
        }
        Map jsonMap = parser.parseToMap(body[index]);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"column_1", (Object)"hello", (Object)"column_2", (Object)"world", (Object)"column_3", (Object)"foo"), (Object)jsonMap);
    }

    @Test
    public void testWithHeaderRow() {
        Parser<String, Object> parser = PARSER_FACTORY.get(this.format, true, 0);
        parser.startFileFromBeginning();
        String[] body = new String[]{FlatTextFormatParserTest.concat(this.format, "time", "value1", "value2"), FlatTextFormatParserTest.concat(this.format, "hello", "world", "foo")};
        Assert.assertNull((Object)parser.parseToMap(body[0]));
        Map jsonMap = parser.parseToMap(body[1]);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"time", (Object)"hello", (Object)"value1", (Object)"world", (Object)"value2", (Object)"foo"), (Object)jsonMap);
    }

    @Test
    public void testWithHeaderRowOfEmptyColumns() {
        Parser<String, Object> parser = PARSER_FACTORY.get(this.format, true, 0);
        parser.startFileFromBeginning();
        String[] body = new String[]{FlatTextFormatParserTest.concat(this.format, "time", "", "value2", ""), FlatTextFormatParserTest.concat(this.format, "hello", "world", "foo", "bar")};
        Assert.assertNull((Object)parser.parseToMap(body[0]));
        Map jsonMap = parser.parseToMap(body[1]);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"time", (Object)"hello", (Object)"column_2", (Object)"world", (Object)"value2", (Object)"foo", (Object)"column_4", (Object)"bar"), (Object)jsonMap);
    }

    @Test
    public void testWithDifferentHeaderRows() {
        Parser<String, Object> parser = PARSER_FACTORY.get(this.format, true, 0);
        parser.startFileFromBeginning();
        String[] body = new String[]{FlatTextFormatParserTest.concat(this.format, "time", "value1", "value2"), FlatTextFormatParserTest.concat(this.format, "hello", "world", "foo")};
        Assert.assertNull((Object)parser.parseToMap(body[0]));
        Map jsonMap = parser.parseToMap(body[1]);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"time", (Object)"hello", (Object)"value1", (Object)"world", (Object)"value2", (Object)"foo"), (Object)jsonMap);
        parser.startFileFromBeginning();
        String[] body2 = new String[]{FlatTextFormatParserTest.concat(this.format, "time", "value1", "value2", "value3"), FlatTextFormatParserTest.concat(this.format, "hello", "world", "foo", "bar")};
        Assert.assertNull((Object)parser.parseToMap(body2[0]));
        jsonMap = parser.parseToMap(body2[1]);
        Assert.assertEquals((String)"jsonMap", (Object)ImmutableMap.of((Object)"time", (Object)"hello", (Object)"value1", (Object)"world", (Object)"value2", (Object)"foo", (Object)"value3", (Object)"bar"), (Object)jsonMap);
    }

    @Test
    public void testWithoutStartFileFromBeginning() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("hasHeaderRow or maxSkipHeaderRows is not supported. Please check the indexTask supports these options.");
        int skipHeaderRows = 2;
        Parser<String, Object> parser = PARSER_FACTORY.get(this.format, false, 2);
        String[] body = new String[]{FlatTextFormatParserTest.concat(this.format, "header", "line", "1"), FlatTextFormatParserTest.concat(this.format, "header", "line", "2"), FlatTextFormatParserTest.concat(this.format, "hello", "world", "foo")};
        parser.parseToMap(body[0]);
    }

    @Test
    public void testWithNullValues() {
        Parser<String, Object> parser = PARSER_FACTORY.get(this.format, true, 0);
        parser.startFileFromBeginning();
        String[] body = new String[]{FlatTextFormatParserTest.concat(this.format, "time", "value1", "value2"), FlatTextFormatParserTest.concat(this.format, "hello", "world", "")};
        Assert.assertNull((Object)parser.parseToMap(body[0]));
        Map jsonMap = parser.parseToMap(body[1]);
        Assert.assertNull(jsonMap.get("value2"));
    }

    private static String concat(AbstractFlatTextFormatParser.FlatTextFormat format, String ... values) {
        return Arrays.stream(values).collect(Collectors.joining(format.getDefaultDelimiter()));
    }

    private static class FlatTextFormatParserFactory {
        private FlatTextFormatParserFactory() {
        }

        public Parser<String, Object> get(AbstractFlatTextFormatParser.FlatTextFormat format) {
            return this.get(format, false, 0);
        }

        public Parser<String, Object> get(AbstractFlatTextFormatParser.FlatTextFormat format, boolean hasHeaderRow, int maxSkipHeaderRows) {
            switch (format) {
                case CSV: {
                    return new CSVParser(null, hasHeaderRow, maxSkipHeaderRows);
                }
                case DELIMITED: {
                    return new DelimitedParser("\t", null, hasHeaderRow, maxSkipHeaderRows);
                }
            }
            throw new IAE("Unknown format[%s]", new Object[]{format});
        }

        public Parser<String, Object> get(AbstractFlatTextFormatParser.FlatTextFormat format, String header) {
            switch (format) {
                case CSV: {
                    return new CSVParser(null, header);
                }
                case DELIMITED: {
                    return new DelimitedParser("\t", null, header);
                }
            }
            throw new IAE("Unknown format[%s]", new Object[]{format});
        }
    }
}

