/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.core;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.druid.java.util.emitter.core.ComposingEmitter;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ComposingEmitterTest {
    private List<Emitter> childEmitters;
    private ComposingEmitter composingEmitter;

    @Before
    public void setup() {
        this.childEmitters = ImmutableList.of((Object)((Emitter)EasyMock.createMock(Emitter.class)), (Object)((Emitter)EasyMock.createMock(Emitter.class)));
        this.composingEmitter = new ComposingEmitter(this.childEmitters);
    }

    @Test
    public void testStart() {
        for (Emitter emitter : this.childEmitters) {
            emitter.start();
            EasyMock.replay((Object[])new Object[]{emitter});
        }
        this.composingEmitter.start();
    }

    @Test
    public void testEmit() {
        Event e = (Event)EasyMock.createMock(Event.class);
        for (Emitter emitter : this.childEmitters) {
            emitter.emit(e);
            EasyMock.replay((Object[])new Object[]{emitter});
        }
        this.composingEmitter.emit(e);
    }

    @Test
    public void testFlush() throws IOException {
        for (Emitter emitter : this.childEmitters) {
            emitter.flush();
            EasyMock.replay((Object[])new Object[]{emitter});
        }
        this.composingEmitter.flush();
    }

    @Test
    public void testClose() throws IOException {
        for (Emitter emitter : this.childEmitters) {
            emitter.close();
            EasyMock.replay((Object[])new Object[]{emitter});
        }
        this.composingEmitter.close();
    }

    @After
    public void tearDown() {
        for (Emitter emitter : this.childEmitters) {
            EasyMock.verify((Object[])new Object[]{emitter});
        }
    }
}

