/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.core.EventMap;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.CgroupCpuMonitor;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class CgroupCpuMonitorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File procDir;
    private File cgroupDir;
    private CgroupDiscoverer discoverer;

    @Before
    public void setUp() throws IOException {
        this.cgroupDir = this.temporaryFolder.newFolder();
        this.procDir = this.temporaryFolder.newFolder();
        this.discoverer = new ProcCgroupDiscoverer(this.procDir.toPath());
        TestUtils.setUpCgroups(this.procDir, this.cgroupDir);
        File cpuDir = new File(this.cgroupDir, "cpu,cpuacct/system.slice/some.service/f12ba7e0-fa16-462e-bb9d-652ccc27f0ee");
        FileUtils.mkdirp((File)cpuDir);
        TestUtils.copyOrReplaceResource("/cpu.shares", new File(cpuDir, "cpu.shares"));
        TestUtils.copyOrReplaceResource("/cpu.cfs_quota_us", new File(cpuDir, "cpu.cfs_quota_us"));
        TestUtils.copyOrReplaceResource("/cpu.cfs_period_us", new File(cpuDir, "cpu.cfs_period_us"));
    }

    @Test
    public void testMonitor() {
        CgroupCpuMonitor monitor = new CgroupCpuMonitor(this.discoverer, (Map)ImmutableMap.of(), "some_feed");
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        Assert.assertTrue((boolean)monitor.doMonitor((ServiceEmitter)emitter));
        List<Event> actualEvents = emitter.getEvents();
        Assert.assertEquals((long)2L, (long)actualEvents.size());
        EventMap sharesEvent = actualEvents.get(0).toMap();
        EventMap coresEvent = actualEvents.get(1).toMap();
        Assert.assertEquals((Object)"cgroup/cpu/shares", sharesEvent.get("metric"));
        Assert.assertEquals((Object)1024L, sharesEvent.get("value"));
        Assert.assertEquals((Object)"cgroup/cpu/cores_quota", coresEvent.get("metric"));
        Assert.assertEquals((Object)3.0, coresEvent.get("value"));
    }

    @Test
    public void testQuotaCompute() {
        Assert.assertEquals((double)-1.0, (double)CgroupCpuMonitor.computeProcessorQuota((long)-1L, (long)100000L), (double)0.0);
        Assert.assertEquals((double)0.0, (double)CgroupCpuMonitor.computeProcessorQuota((long)0L, (long)100000L), (double)0.0);
        Assert.assertEquals((double)-1.0, (double)CgroupCpuMonitor.computeProcessorQuota((long)100000L, (long)0L), (double)0.0);
        Assert.assertEquals((double)2.0, (double)CgroupCpuMonitor.computeProcessorQuota((long)200000L, (long)100000L), (double)0.0);
        Assert.assertEquals((double)0.5, (double)CgroupCpuMonitor.computeProcessorQuota((long)50000L, (long)100000L), (double)0.0);
    }
}

