/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.matchers;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.matchers.LambdaMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class DruidMatchers {
    public static <T, S> LambdaMatcher<T, S> fn(String name, Function<T, S> fn, Matcher<S> matcher) {
        return new LambdaMatcher<T, S>(name + ": ", fn, matcher);
    }

    public static <K, V> Matcher<Map<? extends K, ? extends V>> mapMatcher(Object ... keysAndValues) {
        if (keysAndValues.length % 2 == 1) {
            throw new IAE("keysAndValues should be pairs, but had an odd length [%s]", new Object[]{keysAndValues.length});
        }
        ArrayList<Matcher> entryMatchers = new ArrayList<Matcher>();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            entryMatchers.add(Matchers.hasEntry((Object)keysAndValues[i], (Object)keysAndValues[i + 1]));
        }
        return Matchers.allOf(entryMatchers);
    }
}

