/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.math.BigInteger;
import org.apache.druid.math.expr.ArrayExpr;
import org.apache.druid.math.expr.BigIntegerExpr;
import org.apache.druid.math.expr.ComplexExpr;
import org.apache.druid.math.expr.DoubleExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeFactory;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.LongExpr;
import org.apache.druid.math.expr.NullDoubleExpr;
import org.apache.druid.math.expr.NullLongExpr;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.math.expr.StringExpr;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategiesTest;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class ConstantExprTest
extends InitializedNullHandlingTest {
    @Test
    public void testLongArrayExpr() {
        ArrayExpr arrayExpr = new ArrayExpr(ExpressionType.LONG_ARRAY, (Object[])new Long[]{1L, 3L});
        this.checkExpr((Expr)arrayExpr, true, "[1, 3]", "ARRAY<LONG>[1, 3]", (Expr)arrayExpr);
    }

    @Test
    public void testStringArrayExpr() {
        ArrayExpr arrayExpr = new ArrayExpr(ExpressionType.STRING_ARRAY, (Object[])new String[]{"foo", "bar"});
        this.checkExpr((Expr)arrayExpr, true, "[foo, bar]", "ARRAY<STRING>['foo', 'bar']", (Expr)arrayExpr);
    }

    @Test
    public void testBigIntegerExpr() {
        this.checkExpr((Expr)new BigIntegerExpr(BigInteger.valueOf(37L)), true, "37", "37", (Expr)new LongExpr(Long.valueOf(37L)));
    }

    @Test
    public void testComplexExpr() {
        TypeStrategies.registerComplex((String)"nullablePair", (TypeStrategy)new TypeStrategiesTest.NullableLongPairTypeStrategy());
        ComplexExpr complexExpr = new ComplexExpr(ExpressionTypeFactory.getInstance().ofComplex("nullablePair"), (Object)new TypeStrategiesTest.NullableLongPair(21L, 37L));
        this.checkExpr((Expr)complexExpr, true, "Pair{lhs=21, rhs=37}", "complex_decode_base64('nullablePair', 'AAAAAAAAAAAVAAAAAAAAAAAl')", (Expr)complexExpr);
    }

    @Test
    public void testDoubleExpr() {
        this.checkExpr((Expr)new DoubleExpr(Double.valueOf(11.73)), true, "11.73", "11.73", (Expr)new DoubleExpr(Double.valueOf(11.73)));
    }

    @Test
    public void testNullDoubleExpr() {
        TypeStrategies.registerComplex((String)"nullablePair", (TypeStrategy)new TypeStrategiesTest.NullableLongPairTypeStrategy());
        this.checkExpr((Expr)new NullDoubleExpr(), true, "null", "null", (Expr)new StringExpr(null));
    }

    @Test
    public void testNullLongExpr() {
        this.checkExpr((Expr)new NullLongExpr(), true, "null", "null", (Expr)new StringExpr(null));
    }

    @Test
    public void testLong() {
        this.checkExpr((Expr)new LongExpr(Long.valueOf(11L)), true, "11", "11", (Expr)new LongExpr(Long.valueOf(11L)));
    }

    @Test
    public void testString() {
        this.checkExpr((Expr)new StringExpr("some"), true, "some", "'some'", (Expr)new StringExpr("some"));
    }

    @Test
    public void testStringNull() {
        this.checkExpr((Expr)new StringExpr(null), true, null, "null", (Expr)new StringExpr(null));
    }

    private void checkExpr(Expr expr, boolean supportsSingleThreaded, String expectedToString, String expectedStringify, Expr expectedReparsedExpr) {
        Expr.ObjectBinding bindings = InputBindings.nilBindings();
        if (expr.getLiteralValue() != null) {
            Assert.assertNotSame((Object)expr.eval(bindings), (Object)expr.eval(bindings));
        }
        Expr singleExpr = Expr.singleThreaded((Expr)expr);
        if (supportsSingleThreaded) {
            Assert.assertSame((Object)singleExpr.eval(bindings), (Object)singleExpr.eval(bindings));
        } else {
            Assert.assertNotSame((Object)singleExpr.eval(bindings), (Object)singleExpr.eval(bindings));
        }
        Assert.assertEquals((Object)expectedToString, (Object)expr.toString());
        Assert.assertEquals((Object)expectedStringify, (Object)expr.stringify());
        Assert.assertEquals((Object)expectedToString, (Object)singleExpr.toString());
        String stringify = singleExpr.stringify();
        Expr reParsedExpr = Parser.parse((String)stringify, (ExprMacroTable)ExprMacroTable.nil());
        Assert.assertEquals((Object)expectedReparsedExpr, (Object)reParsedExpr);
    }
}

