/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class QueryDataSourceTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final TimeseriesQuery queryOnTable = Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals("2000/3000").granularity(Granularities.ALL).build();
    private final TimeseriesQuery queryOnLookup = Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new LookupDataSource("lookyloo")).intervals("2000/3000").granularity(Granularities.ALL).build();
    private final QueryDataSource queryOnTableDataSource = new QueryDataSource((Query)this.queryOnTable);
    private final QueryDataSource queryOnLookupDataSource = new QueryDataSource((Query)this.queryOnLookup);
    private final GroupByQuery groupByQuery = new GroupByQuery.Builder().setDataSource((DataSource)this.queryOnTableDataSource).setGranularity(Granularities.ALL).setInterval("2000/3000").build();
    private final QueryDataSource queryDataSource = new QueryDataSource((Query)this.groupByQuery);

    @Test
    public void test_getTableNames_table() {
        Assert.assertEquals(Collections.singleton("foo"), (Object)this.queryOnTableDataSource.getTableNames());
    }

    @Test
    public void test_getTableNames_lookup() {
        Assert.assertEquals(Collections.emptySet(), (Object)this.queryOnLookupDataSource.getTableNames());
    }

    @Test
    public void test_getChildren_table() {
        Assert.assertEquals(Collections.singletonList(new TableDataSource("foo")), (Object)this.queryOnTableDataSource.getChildren());
    }

    @Test
    public void test_getChildren_lookup() {
        Assert.assertEquals(Collections.singletonList(new LookupDataSource("lookyloo")), (Object)this.queryOnLookupDataSource.getChildren());
    }

    @Test
    public void test_isCacheable_table() {
        Assert.assertFalse((boolean)this.queryOnTableDataSource.isCacheable(true));
        Assert.assertFalse((boolean)this.queryOnTableDataSource.isCacheable(false));
    }

    @Test
    public void test_isCacheable_lookup() {
        Assert.assertFalse((boolean)this.queryOnLookupDataSource.isCacheable(true));
        Assert.assertFalse((boolean)this.queryOnLookupDataSource.isCacheable(false));
    }

    @Test
    public void test_isConcrete_table() {
        Assert.assertFalse((boolean)this.queryOnTableDataSource.isConcrete());
    }

    @Test
    public void test_isConcrete_lookup() {
        Assert.assertFalse((boolean)this.queryOnLookupDataSource.isConcrete());
    }

    @Test
    public void test_isGlobal_table() {
        Assert.assertFalse((boolean)this.queryOnTableDataSource.isGlobal());
    }

    @Test
    public void test_isGlobal_lookup() {
        Assert.assertTrue((boolean)this.queryOnLookupDataSource.isGlobal());
    }

    @Test
    public void test_withChildren_empty() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Must have exactly one child");
        DataSource ignored = this.queryOnLookupDataSource.withChildren(Collections.emptyList());
    }

    @Test
    public void test_withChildren_single() {
        TableDataSource barTable = new TableDataSource("bar");
        QueryDataSource transformed = (QueryDataSource)this.queryOnLookupDataSource.withChildren(Collections.singletonList(barTable));
        Assert.assertEquals((Object)barTable, (Object)transformed.getQuery().getDataSource());
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(QueryDataSource.class).usingGetClass().withNonnullFields(new String[]{"query"}).verify();
    }

    @Test
    public void test_serde() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        QueryDataSource deserialized = (QueryDataSource)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)this.queryOnTableDataSource), DataSource.class);
        Assert.assertEquals((Object)this.queryOnTableDataSource, (Object)deserialized);
    }

    @Test
    public void test_withSegmentMapFunction() {
        Function parentsegmentMapFunction = this.queryDataSource.createSegmentMapFunction((Query)this.groupByQuery, new AtomicLong());
        Function childsegmentMapFunction = this.queryOnTableDataSource.createSegmentMapFunction((Query)this.groupByQuery, new AtomicLong());
        Assert.assertEquals((Object)parentsegmentMapFunction, (Object)childsegmentMapFunction);
    }
}

