/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.utils.CloseableUtils;

public class TestBufferPool
implements NonBlockingPool<ByteBuffer>,
BlockingPool<ByteBuffer> {
    private final AtomicLong takeCount = new AtomicLong(0L);
    private final ConcurrentHashMap<Long, RuntimeException> takenFromMap = new ConcurrentHashMap();
    private final Supplier<ResourceHolder<ByteBuffer>> generator;
    private final int maxCount;

    private TestBufferPool(Supplier<ResourceHolder<ByteBuffer>> generator, int maxCount) {
        this.generator = generator;
        this.maxCount = maxCount;
    }

    public static TestBufferPool onHeap(int bufferSize, int maxCount) {
        return new TestBufferPool(() -> new ReferenceCountingResourceHolder((Object)ByteBuffer.allocate(bufferSize), () -> {}), maxCount);
    }

    public static TestBufferPool offHeap(int bufferSize, int maxCount) {
        return new TestBufferPool(() -> ByteBufferUtils.allocateDirect((int)bufferSize), maxCount);
    }

    public int maxSize() {
        return this.maxCount;
    }

    public ResourceHolder<ByteBuffer> take() {
        List<ReferenceCountingResourceHolder<ByteBuffer>> holders = this.takeBatch(1);
        if (holders.isEmpty()) {
            throw new ISE("Too many objects outstanding", new Object[0]);
        }
        return (ResourceHolder)Iterables.getOnlyElement(holders);
    }

    public List<ReferenceCountingResourceHolder<ByteBuffer>> takeBatch(int elementNum, long timeoutMs) {
        return this.takeBatch(elementNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReferenceCountingResourceHolder<ByteBuffer>> takeBatch(int elementNum) {
        TestBufferPool testBufferPool = this;
        synchronized (testBufferPool) {
            if (this.takenFromMap.size() + elementNum <= this.maxCount) {
                ArrayList<ReferenceCountingResourceHolder<ByteBuffer>> retVal = new ArrayList<ReferenceCountingResourceHolder<ByteBuffer>>();
                try {
                    for (int i = 0; i < elementNum; ++i) {
                        ResourceHolder<ByteBuffer> holder = this.generator.get();
                        ByteBuffer o = (ByteBuffer)holder.get();
                        long ticker = this.takeCount.getAndIncrement();
                        this.takenFromMap.put(ticker, new RuntimeException());
                        retVal.add((ReferenceCountingResourceHolder<ByteBuffer>)new ReferenceCountingResourceHolder((Object)o, () -> {
                            this.takenFromMap.remove(ticker);
                            holder.close();
                        }));
                    }
                }
                catch (Throwable e) {
                    throw CloseableUtils.closeAndWrapInCatch((Throwable)e, () -> CloseableUtils.closeAll((Iterable)retVal));
                }
                return retVal;
            }
            return Collections.emptyList();
        }
    }

    public long getPendingRequests() {
        return 0L;
    }

    public long getOutstandingObjectCount() {
        return this.takenFromMap.size();
    }

    public Collection<RuntimeException> getOutstandingExceptionsCreated() {
        return this.takenFromMap.values();
    }
}

