/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMaxAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.HistogramAggregatorFactory;
import org.apache.druid.query.aggregation.JavaScriptAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.SuppressedAggregatorFactory;
import org.apache.druid.query.aggregation.any.DoubleAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.FloatAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.LongAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.StringAnyAggregatorFactory;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.first.DoubleFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.FloatFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.LongFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.aggregation.last.DoubleLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.FloatLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.LongLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.StringLastAggregatorFactory;
import org.apache.druid.query.aggregation.mean.DoubleMeanAggregatorFactory;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class AggregatorFactoryTest
extends InitializedNullHandlingTest {
    @Test
    public void testMergeAggregators() {
        Assert.assertNull((Object)AggregatorFactory.mergeAggregators(null));
        Assert.assertNull((Object)AggregatorFactory.mergeAggregators((List)ImmutableList.of()));
        ArrayList<Object[]> aggregatorsToBeMerged = new ArrayList<Object[]>();
        aggregatorsToBeMerged.add(null);
        Assert.assertNull((Object)AggregatorFactory.mergeAggregators(aggregatorsToBeMerged));
        Object[] emptyAggFactory = new AggregatorFactory[]{};
        aggregatorsToBeMerged.clear();
        aggregatorsToBeMerged.add(emptyAggFactory);
        Assert.assertArrayEquals((Object[])emptyAggFactory, (Object[])AggregatorFactory.mergeAggregators(aggregatorsToBeMerged));
        aggregatorsToBeMerged.clear();
        aggregatorsToBeMerged.add(emptyAggFactory);
        aggregatorsToBeMerged.add(null);
        Assert.assertNull((Object)AggregatorFactory.mergeAggregators(aggregatorsToBeMerged));
        aggregatorsToBeMerged.clear();
        AggregatorFactory[] af1 = new AggregatorFactory[]{new LongMaxAggregatorFactory("name", "fieldName1")};
        AggregatorFactory[] af2 = new AggregatorFactory[]{new LongMaxAggregatorFactory("name", "fieldName2")};
        Assert.assertArrayEquals((Object[])new AggregatorFactory[]{new LongMaxAggregatorFactory("name", "name")}, (Object[])AggregatorFactory.mergeAggregators((List)ImmutableList.of((Object)af1, (Object)af2)));
        aggregatorsToBeMerged.clear();
        af1 = new AggregatorFactory[]{new LongMaxAggregatorFactory("name", "fieldName1")};
        af2 = new AggregatorFactory[]{new DoubleMaxAggregatorFactory("name", "fieldName2")};
        Assert.assertNull((Object)AggregatorFactory.mergeAggregators((List)ImmutableList.of((Object)af1, (Object)af2)));
    }

    @Test
    public void testResultArraySignature() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2000/3000").granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count"), new JavaScriptAggregatorFactory("js", (List)ImmutableList.of((Object)"col"), "function(a,b) { return a + b; }", "function() { return 0; }", "function(a,b) { return a + b }", new JavaScriptConfig(true)), new LongSumAggregatorFactory("longSum", "long-col"), new LongMinAggregatorFactory("longMin", "long-col"), new LongMaxAggregatorFactory("longMax", "long-col"), new LongFirstAggregatorFactory("longFirst", "long-col", null), new LongLastAggregatorFactory("longLast", "long-col", null), new LongAnyAggregatorFactory("longAny", "long-col"), new DoubleSumAggregatorFactory("doubleSum", "double-col"), new DoubleMinAggregatorFactory("doubleMin", "double-col"), new DoubleMaxAggregatorFactory("doubleMax", "double-col"), new DoubleFirstAggregatorFactory("doubleFirst", "double-col", null), new DoubleLastAggregatorFactory("doubleLast", "double-col", null), new DoubleAnyAggregatorFactory("doubleAny", "double-col"), new DoubleMeanAggregatorFactory("doubleMean", "double-col"), new FloatSumAggregatorFactory("floatSum", "float-col"), new FloatMinAggregatorFactory("floatMin", "float-col"), new FloatMaxAggregatorFactory("floatMax", "float-col"), new FloatFirstAggregatorFactory("floatFirst", "float-col", null), new FloatLastAggregatorFactory("floatLast", "float-col", null), new FloatAnyAggregatorFactory("floatAny", "float-col"), new StringFirstAggregatorFactory("stringFirst", "col", null, Integer.valueOf(1024)), new StringLastAggregatorFactory("stringLast", "col", null, Integer.valueOf(1024)), new StringAnyAggregatorFactory("stringAny", "col", Integer.valueOf(1024), Boolean.valueOf(true)), new CardinalityAggregatorFactory("cardinality", (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"some-col")), false), new HyperUniquesAggregatorFactory("hyperUnique", "hyperunique"), new HistogramAggregatorFactory("histogram", "histogram", (List)ImmutableList.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.75f))), new FilteredAggregatorFactory((AggregatorFactory)new HyperUniquesAggregatorFactory("filtered", "hyperunique"), (DimFilter)new SelectorDimFilter("col", "hello", null)), new SuppressedAggregatorFactory((AggregatorFactory)new HyperUniquesAggregatorFactory("suppressed", "hyperunique"))}).postAggregators(new PostAggregator[]{new FinalizingFieldAccessPostAggregator("count-finalize", "count"), new FinalizingFieldAccessPostAggregator("js-finalize", "js"), new FinalizingFieldAccessPostAggregator("longSum-finalize", "longSum"), new FinalizingFieldAccessPostAggregator("longMin-finalize", "longMin"), new FinalizingFieldAccessPostAggregator("longMax-finalize", "longMax"), new FinalizingFieldAccessPostAggregator("longFirst-finalize", "longFirst"), new FinalizingFieldAccessPostAggregator("longLast-finalize", "longLast"), new FinalizingFieldAccessPostAggregator("longAny-finalize", "longAny"), new FinalizingFieldAccessPostAggregator("doubleSum-finalize", "doubleSum"), new FinalizingFieldAccessPostAggregator("doubleMin-finalize", "doubleMin"), new FinalizingFieldAccessPostAggregator("doubleMax-finalize", "doubleMax"), new FinalizingFieldAccessPostAggregator("doubleFirst-finalize", "doubleFirst"), new FinalizingFieldAccessPostAggregator("doubleLast-finalize", "doubleLast"), new FinalizingFieldAccessPostAggregator("doubleAny-finalize", "doubleAny"), new FinalizingFieldAccessPostAggregator("doubleMean-finalize", "doubleMean"), new FinalizingFieldAccessPostAggregator("floatSum-finalize", "floatSum"), new FinalizingFieldAccessPostAggregator("floatMin-finalize", "floatMin"), new FinalizingFieldAccessPostAggregator("floatMax-finalize", "floatMax"), new FinalizingFieldAccessPostAggregator("floatFirst-finalize", "floatFirst"), new FinalizingFieldAccessPostAggregator("floatLast-finalize", "floatLast"), new FinalizingFieldAccessPostAggregator("floatAny-finalize", "floatAny"), new FinalizingFieldAccessPostAggregator("stringFirst-finalize", "stringFirst"), new FinalizingFieldAccessPostAggregator("stringLast-finalize", "stringLast"), new FinalizingFieldAccessPostAggregator("stringAny-finalize", "stringAny"), new FinalizingFieldAccessPostAggregator("cardinality-finalize", "cardinality"), new FinalizingFieldAccessPostAggregator("hyperUnique-finalize", "hyperUnique"), new FinalizingFieldAccessPostAggregator("histogram-finalize", "histogram"), new FinalizingFieldAccessPostAggregator("filtered-finalize", "filtered"), new FinalizingFieldAccessPostAggregator("suppressed-finalize", "suppressed")}).build();
        Assert.assertEquals((Object)RowSignature.builder().addTimeColumn().add("count", ColumnType.LONG).add("js", ColumnType.FLOAT).add("longSum", ColumnType.LONG).add("longMin", ColumnType.LONG).add("longMax", ColumnType.LONG).add("longFirst", null).add("longLast", null).add("longAny", ColumnType.LONG).add("doubleSum", ColumnType.DOUBLE).add("doubleMin", ColumnType.DOUBLE).add("doubleMax", ColumnType.DOUBLE).add("doubleFirst", null).add("doubleLast", null).add("doubleAny", ColumnType.DOUBLE).add("doubleMean", null).add("floatSum", ColumnType.FLOAT).add("floatMin", ColumnType.FLOAT).add("floatMax", ColumnType.FLOAT).add("floatFirst", null).add("floatLast", null).add("floatAny", ColumnType.FLOAT).add("stringFirst", null).add("stringLast", null).add("stringAny", ColumnType.STRING).add("cardinality", null).add("hyperUnique", null).add("histogram", null).add("filtered", null).add("suppressed", null).add("count-finalize", ColumnType.LONG).add("js-finalize", ColumnType.FLOAT).add("longSum-finalize", ColumnType.LONG).add("longMin-finalize", ColumnType.LONG).add("longMax-finalize", ColumnType.LONG).add("longFirst-finalize", ColumnType.LONG).add("longLast-finalize", ColumnType.LONG).add("longAny-finalize", ColumnType.LONG).add("doubleSum-finalize", ColumnType.DOUBLE).add("doubleMin-finalize", ColumnType.DOUBLE).add("doubleMax-finalize", ColumnType.DOUBLE).add("doubleFirst-finalize", ColumnType.DOUBLE).add("doubleLast-finalize", ColumnType.DOUBLE).add("doubleAny-finalize", ColumnType.DOUBLE).add("doubleMean-finalize", ColumnType.DOUBLE).add("floatSum-finalize", ColumnType.FLOAT).add("floatMin-finalize", ColumnType.FLOAT).add("floatMax-finalize", ColumnType.FLOAT).add("floatFirst-finalize", ColumnType.FLOAT).add("floatLast-finalize", ColumnType.FLOAT).add("floatAny-finalize", ColumnType.FLOAT).add("stringFirst-finalize", ColumnType.STRING).add("stringLast-finalize", ColumnType.STRING).add("stringAny-finalize", ColumnType.STRING).add("cardinality-finalize", ColumnType.DOUBLE).add("hyperUnique-finalize", ColumnType.DOUBLE).add("histogram-finalize", HistogramAggregatorFactory.TYPE_VISUAL).add("filtered-finalize", ColumnType.DOUBLE).add("suppressed-finalize", ColumnType.DOUBLE).build(), (Object)new TimeseriesQueryQueryToolChest().resultArraySignature(query));
    }

    @Test
    public void testWithName() {
        List<AggregatorFactory> aggregatorFactories = Arrays.asList(new CountAggregatorFactory("col"), new JavaScriptAggregatorFactory("col", (List)ImmutableList.of((Object)"col"), "function(a,b) { return a + b; }", "function() { return 0; }", "function(a,b) { return a + b }", new JavaScriptConfig(true)), new LongSumAggregatorFactory("col", "long-col"), new LongMinAggregatorFactory("col", "long-col"), new LongMaxAggregatorFactory("col", "long-col"), new LongFirstAggregatorFactory("col", "long-col", null), new LongLastAggregatorFactory("col", "long-col", null), new LongAnyAggregatorFactory("col", "long-col"), new DoubleSumAggregatorFactory("col", "double-col"), new DoubleMinAggregatorFactory("col", "double-col"), new DoubleMaxAggregatorFactory("col", "double-col"), new DoubleFirstAggregatorFactory("col", "double-col", null), new DoubleLastAggregatorFactory("col", "double-col", null), new DoubleAnyAggregatorFactory("col", "double-col"), new DoubleMeanAggregatorFactory("col", "double-col"), new FloatSumAggregatorFactory("col", "float-col"), new FloatMinAggregatorFactory("col", "float-col"), new FloatMaxAggregatorFactory("col", "float-col"), new FloatFirstAggregatorFactory("col", "float-col", null), new FloatLastAggregatorFactory("col", "float-col", null), new FloatAnyAggregatorFactory("col", "float-col"), new StringFirstAggregatorFactory("col", "col", null, Integer.valueOf(1024)), new StringLastAggregatorFactory("col", "col", null, Integer.valueOf(1024)), new StringAnyAggregatorFactory("col", "col", Integer.valueOf(1024), Boolean.valueOf(true)), new StringAnyAggregatorFactory("col", "col", Integer.valueOf(1024), Boolean.valueOf(false)), new CardinalityAggregatorFactory("col", (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"some-col")), false), new HyperUniquesAggregatorFactory("col", "hyperunique"), new HistogramAggregatorFactory("col", "histogram", (List)ImmutableList.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.75f))), new FilteredAggregatorFactory((AggregatorFactory)new HyperUniquesAggregatorFactory("col", "hyperunique"), (DimFilter)new SelectorDimFilter("col", "hello", null), "col"), new SuppressedAggregatorFactory((AggregatorFactory)new HyperUniquesAggregatorFactory("col", "hyperunique")));
        for (AggregatorFactory aggregatorFactory : aggregatorFactories) {
            Assert.assertEquals((Object)aggregatorFactory, (Object)aggregatorFactory.withName("col"));
            Assert.assertEquals((Object)"newTest", (Object)aggregatorFactory.withName("newTest").getName());
        }
    }
}

