/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.SerializablePairLongFloat;
import org.apache.druid.query.aggregation.SerializablePairLongFloatComplexColumn;
import org.apache.druid.query.aggregation.SerializablePairLongFloatComplexMetricSerde;
import org.apache.druid.query.aggregation.SingleObjectColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.writeout.HeapByteBufferWriteOutBytes;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.junit.Assert;
import org.junit.Test;

public class SerializablePairLongFloatComplexMetricSerdeTest {
    private static final SerializablePairLongFloatComplexMetricSerde COMPRESSED_SERDE;
    private final Random random = new Random(0L);

    @Test
    public void testSingle() throws Exception {
        this.assertExpected((List<SerializablePairLongFloat>)ImmutableList.of((Object)new SerializablePairLongFloat(Long.valueOf(100L), Float.valueOf(10.0f))), 75);
    }

    @Test
    public void testLargeRHS() throws Exception {
        this.assertExpected((List<SerializablePairLongFloat>)ImmutableList.of((Object)new SerializablePairLongFloat(Long.valueOf(100L), Float.valueOf(this.random.nextFloat()))), 75);
    }

    @Test
    public void testCompressable() throws Exception {
        int i;
        int numLongs = 10;
        ArrayList<SerializablePairLongFloat> valueList = new ArrayList<SerializablePairLongFloat>();
        ArrayList<Float> floatList = new ArrayList<Float>();
        for (i = 0; i < numLongs; ++i) {
            floatList.add(Float.valueOf(this.random.nextFloat()));
        }
        for (i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongFloat(Long.valueOf(Integer.MAX_VALUE + (long)i), (Float)floatList.get(i % numLongs)));
        }
        this.assertExpected(valueList, 80418);
    }

    @Test
    public void testHighlyCompressable() throws Exception {
        ArrayList<SerializablePairLongFloat> valueList = new ArrayList<SerializablePairLongFloat>();
        Float floatValue = Float.valueOf(this.random.nextFloat());
        for (int i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongFloat(Long.valueOf(Integer.MAX_VALUE + (long)i), floatValue));
        }
        this.assertExpected(valueList, 80260);
    }

    @Test
    public void testRandom() throws Exception {
        ArrayList<SerializablePairLongFloat> valueList = new ArrayList<SerializablePairLongFloat>();
        for (int i = 0; i < 10000; ++i) {
            valueList.add(new SerializablePairLongFloat(Long.valueOf(this.random.nextLong()), Float.valueOf(this.random.nextFloat())));
        }
        this.assertExpected(valueList, 170749);
    }

    @Test
    public void testNullRHS() throws Exception {
        this.assertExpected((List<SerializablePairLongFloat>)ImmutableList.of((Object)new SerializablePairLongFloat(Long.valueOf(100L), null)), 71);
    }

    @Test
    public void testEmpty() throws Exception {
        this.assertExpected(Collections.emptyList(), 57);
    }

    @Test
    public void testSingleNull() throws Exception {
        this.assertExpected(Arrays.asList(new SerializablePairLongFloat[]{null}), 58);
    }

    @Test
    public void testMultipleNull() throws Exception {
        this.assertExpected(Arrays.asList(null, null, null, null), 59);
    }

    private ByteBuffer assertExpected(List<SerializablePairLongFloat> expected, int expectedCompressedSize) throws IOException {
        OnHeapMemorySegmentWriteOutMedium writeOutMedium = new OnHeapMemorySegmentWriteOutMedium();
        ByteBuffer compressedBuffer = SerializablePairLongFloatComplexMetricSerdeTest.serializeAllValuesToByteBuffer(expected, COMPRESSED_SERDE.getSerializer((SegmentWriteOutMedium)writeOutMedium, "not-used"), expectedCompressedSize).asReadOnlyBuffer();
        try (ComplexColumn compressedCol = this.createComplexColumn(compressedBuffer);){
            for (int i = 0; i < expected.size(); ++i) {
                Assert.assertEquals((Object)expected.get(i), (Object)compressedCol.getRowValue(i));
            }
        }
        return compressedBuffer;
    }

    private ComplexColumn createComplexColumn(ByteBuffer byteBuffer) {
        ColumnBuilder builder = new ColumnBuilder();
        int serializedSize = byteBuffer.remaining();
        COMPRESSED_SERDE.deserializeColumn(byteBuffer, builder);
        builder.setType(ValueType.COMPLEX);
        ColumnHolder columnHolder = builder.build();
        ComplexColumn col = (ComplexColumn)columnHolder.getColumn();
        if (col instanceof SerializablePairLongFloatComplexColumn) {
            Assert.assertEquals((long)serializedSize, (long)col.getLength());
        }
        Assert.assertEquals((Object)"serializablePairLongFloat", (Object)col.getTypeName());
        Assert.assertEquals(SerializablePairLongFloat.class, (Object)col.getClazz());
        return col;
    }

    private static ByteBuffer serializeAllValuesToByteBuffer(List<SerializablePairLongFloat> values, GenericColumnSerializer serializer, int expectedSize) throws IOException {
        serializer.open();
        final AtomicReference<Object> reference = new AtomicReference<Object>(null);
        SingleObjectColumnValueSelector<SerializablePairLongFloat> valueSelector = new SingleObjectColumnValueSelector<SerializablePairLongFloat>(SerializablePairLongFloat.class){

            @Nullable
            public SerializablePairLongFloat getObject() {
                return (SerializablePairLongFloat)reference.get();
            }
        };
        for (SerializablePairLongFloat selector : values) {
            reference.set(selector);
            serializer.serialize((ColumnValueSelector)valueSelector);
        }
        return SerializablePairLongFloatComplexMetricSerdeTest.serializeToByteBuffer((GenericColumnSerializer<SerializablePairLongFloat>)serializer, expectedSize);
    }

    private static ByteBuffer serializeToByteBuffer(GenericColumnSerializer<SerializablePairLongFloat> serializer, int expectedSize) throws IOException {
        HeapByteBufferWriteOutBytes channel = new HeapByteBufferWriteOutBytes();
        serializer.writeTo((WritableByteChannel)channel, null);
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)channel.size()).order(ByteOrder.nativeOrder());
        channel.readFully(0L, byteBuffer);
        byteBuffer.flip();
        if (expectedSize > -1) {
            Assert.assertEquals((long)expectedSize, (long)serializer.getSerializedSize());
        }
        Assert.assertEquals((long)serializer.getSerializedSize(), (long)byteBuffer.limit());
        return byteBuffer;
    }

    static {
        NullHandling.initializeForTests();
        COMPRESSED_SERDE = new SerializablePairLongFloatComplexMetricSerde();
    }
}

