/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.any.StringAnyAggregator;
import org.apache.druid.query.aggregation.any.StringAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.StringAnyVectorAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.vector.TestVectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.virtual.FallbackVirtualColumnTest;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringAnyAggregatorFactoryTest
extends InitializedNullHandlingTest {
    private static final String NAME = "NAME";
    private static final String FIELD_NAME = "FIELD_NAME";
    private static final int MAX_STRING_BYTES = 10;
    private TestColumnSelectorFactory columnInspector;
    private ColumnCapabilities capabilities;
    private TestVectorColumnSelectorFactory vectorSelectorFactory;
    private StringAnyAggregatorFactory target;

    @Before
    public void setUp() {
        this.target = new StringAnyAggregatorFactory(NAME, FIELD_NAME, Integer.valueOf(10), Boolean.valueOf(true));
        this.columnInspector = new TestColumnSelectorFactory();
        this.vectorSelectorFactory = new TestVectorColumnSelectorFactory();
        this.capabilities = ColumnCapabilitiesImpl.createDefault().setHasMultipleValues(true);
        this.vectorSelectorFactory.addCapabilities(FIELD_NAME, this.capabilities);
        this.vectorSelectorFactory.addMVDVS(FIELD_NAME, new FallbackVirtualColumnTest.SameMultiVectorSelector());
    }

    @Test
    public void canVectorizeWithoutCapabilitiesShouldReturnTrue() {
        Assert.assertTrue((boolean)this.target.canVectorize((ColumnInspector)this.columnInspector));
    }

    @Test
    public void factorizeVectorWithoutCapabilitiesShouldReturnAggregatorWithMultiDimensionSelector() {
        StringAnyVectorAggregator aggregator = this.target.factorizeVector((VectorColumnSelectorFactory)this.vectorSelectorFactory);
        Assert.assertNotNull((Object)aggregator);
    }

    @Test
    public void factorizeVectorWithUnknownCapabilitiesShouldReturnAggregatorWithMultiDimensionSelector() {
        StringAnyVectorAggregator aggregator = this.target.factorizeVector((VectorColumnSelectorFactory)this.vectorSelectorFactory);
        Assert.assertNotNull((Object)aggregator);
    }

    @Test
    public void factorizeVectorWithMultipleValuesCapabilitiesShouldReturnAggregatorWithMultiDimensionSelector() {
        StringAnyVectorAggregator aggregator = this.target.factorizeVector((VectorColumnSelectorFactory)this.vectorSelectorFactory);
        Assert.assertNotNull((Object)aggregator);
    }

    @Test
    public void factorizeVectorWithoutMultipleValuesCapabilitiesShouldReturnAggregatorWithSingleDimensionSelector() {
        StringAnyVectorAggregator aggregator = this.target.factorizeVector((VectorColumnSelectorFactory)this.vectorSelectorFactory);
        Assert.assertNotNull((Object)aggregator);
    }

    @Test
    public void testFactorize() {
        Aggregator res = this.target.factorize((ColumnSelectorFactory)new TestColumnSelectorFactory());
        Assert.assertTrue((boolean)(res instanceof StringAnyAggregator));
        res.aggregate();
        Assert.assertEquals(null, (Object)res.get());
        StringAnyVectorAggregator vectorAggregator = this.target.factorizeVector((VectorColumnSelectorFactory)this.vectorSelectorFactory);
        Assert.assertTrue((boolean)vectorAggregator.isAggregateMultipleValues());
    }

    @Test
    public void testSvdStringAnyAggregator() {
        TestColumnSelectorFactory columnSelectorFactory = new TestColumnSelectorFactory();
        Aggregator res = this.target.factorize((ColumnSelectorFactory)columnSelectorFactory);
        Assert.assertTrue((boolean)(res instanceof StringAnyAggregator));
        columnSelectorFactory.moveSelectorCursorToNext();
        res.aggregate();
        Assert.assertEquals((Object)"CCCC", (Object)res.get());
    }

    @Test
    public void testMvdStringAnyAggregator() {
        TestColumnSelectorFactory columnSelectorFactory = new TestColumnSelectorFactory();
        Aggregator res = this.target.factorize((ColumnSelectorFactory)columnSelectorFactory);
        Assert.assertTrue((boolean)(res instanceof StringAnyAggregator));
        columnSelectorFactory.moveSelectorCursorToNext();
        columnSelectorFactory.moveSelectorCursorToNext();
        res.aggregate();
        Assert.assertEquals((Object)"[AAAA, AAA", (Object)res.get());
    }

    @Test
    public void testMvdStringAnyAggregatorWithAggregateMultipleToFalse() {
        StringAnyAggregatorFactory target = new StringAnyAggregatorFactory(NAME, FIELD_NAME, Integer.valueOf(10), Boolean.valueOf(false));
        TestColumnSelectorFactory columnSelectorFactory = new TestColumnSelectorFactory();
        Aggregator res = target.factorize((ColumnSelectorFactory)columnSelectorFactory);
        Assert.assertTrue((boolean)(res instanceof StringAnyAggregator));
        columnSelectorFactory.moveSelectorCursorToNext();
        columnSelectorFactory.moveSelectorCursorToNext();
        res.aggregate();
        Assert.assertEquals((Object)"AAAA", (Object)res.get());
    }

    static class TestColumnSelectorFactory
    implements ColumnSelectorFactory {
        List<String> mvd = Lists.newArrayList((Object[])new String[]{"AAAA", "AAAAB", "AAAC"});
        final Object[] mvds = new Object[]{null, "CCCC", this.mvd, "BBBB", "EEEE"};
        Integer maxStringBytes = 1024;
        TestObjectColumnSelector<Object> objectColumnSelector = new TestObjectColumnSelector<Object>(this.mvds);

        TestColumnSelectorFactory() {
        }

        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return null;
        }

        public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
            return this.objectColumnSelector;
        }

        public ColumnCapabilities getColumnCapabilities(String columnName) {
            return ColumnCapabilitiesImpl.createDefault().setHasMultipleValues(true);
        }

        public void moveSelectorCursorToNext() {
            this.objectColumnSelector.increment();
        }
    }
}

