/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.aggregation.SerializablePairLongDouble;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.first.DoubleFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.DoubleFirstVectorAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DoubleFirstVectorAggregationTest
extends InitializedNullHandlingTest {
    private static final double EPSILON = 1.0E-5;
    private static final double[] VALUES = new double[]{7.8, 11.0, 23.67, 60.0};
    private static final long[] LONG_VALUES = new long[]{1L, 2L, 3L, 4L};
    private static final float[] FLOAT_VALUES = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
    private static final double[] DOUBLE_VALUES = new double[]{1.0, 2.0, 3.0, 4.0};
    private static final String NAME = "NAME";
    private static final String FIELD_NAME = "FIELD_NAME";
    private static final String FIELD_NAME_LONG = "LONG_NAME";
    private static final String TIME_COL = "__time";
    private final long[] times = new long[]{2345001L, 2345100L, 2345200L, 2345300L};
    private final SerializablePairLongDouble[] pairs = new SerializablePairLongDouble[]{new SerializablePairLongDouble(Long.valueOf(2345001L), Double.valueOf(1.0)), new SerializablePairLongDouble(Long.valueOf(2345100L), Double.valueOf(2.0)), new SerializablePairLongDouble(Long.valueOf(2345200L), Double.valueOf(3.0)), new SerializablePairLongDouble(Long.valueOf(2345300L), Double.valueOf(4.0))};
    private VectorObjectSelector selector;
    private BaseLongVectorValueSelector timeSelector;
    private ByteBuffer buf;
    private DoubleFirstVectorAggregator target;
    private DoubleFirstAggregatorFactory doubleFirstAggregatorFactory;
    private VectorColumnSelectorFactory selectorFactory;
    private VectorValueSelector nonLongValueSelector;

    @Before
    public void setup() {
        byte[] randomBytes = new byte[1024];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        this.buf = ByteBuffer.wrap(randomBytes);
        this.timeSelector = new BaseLongVectorValueSelector((ReadableVectorOffset)new NoFilterVectorOffset(this.times.length, 0, this.times.length){}){

            public long[] getLongVector() {
                return DoubleFirstVectorAggregationTest.this.times;
            }

            @Nullable
            public boolean[] getNullVector() {
                return null;
            }
        };
        this.selector = new VectorObjectSelector(){

            public Object[] getObjectVector() {
                return DoubleFirstVectorAggregationTest.this.pairs;
            }

            public int getMaxVectorSize() {
                return 4;
            }

            public int getCurrentVectorSize() {
                return 0;
            }
        };
        this.nonLongValueSelector = new BaseLongVectorValueSelector((ReadableVectorOffset)new NoFilterVectorOffset(LONG_VALUES.length, 0, LONG_VALUES.length)){

            public long[] getLongVector() {
                return LONG_VALUES;
            }

            public float[] getFloatVector() {
                return FLOAT_VALUES;
            }

            public double[] getDoubleVector() {
                return DOUBLE_VALUES;
            }

            @Nullable
            public boolean[] getNullVector() {
                return null;
            }

            public int getMaxVectorSize() {
                return 4;
            }

            public int getCurrentVectorSize() {
                return 4;
            }
        };
        this.selectorFactory = new VectorColumnSelectorFactory(){

            public ReadableVectorInspector getReadableVectorInspector() {
                return new NoFilterVectorOffset(VALUES.length, 0, VALUES.length);
            }

            public SingleValueDimensionVectorSelector makeSingleValueDimensionSelector(DimensionSpec dimensionSpec) {
                return null;
            }

            public MultiValueDimensionVectorSelector makeMultiValueDimensionSelector(DimensionSpec dimensionSpec) {
                return null;
            }

            public VectorValueSelector makeValueSelector(String column) {
                if (DoubleFirstVectorAggregationTest.TIME_COL.equals(column)) {
                    return DoubleFirstVectorAggregationTest.this.timeSelector;
                }
                if (DoubleFirstVectorAggregationTest.FIELD_NAME_LONG.equals(column)) {
                    return DoubleFirstVectorAggregationTest.this.nonLongValueSelector;
                }
                return null;
            }

            public VectorObjectSelector makeObjectSelector(String column) {
                if (DoubleFirstVectorAggregationTest.FIELD_NAME.equals(column)) {
                    return DoubleFirstVectorAggregationTest.this.selector;
                }
                return null;
            }

            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                if (DoubleFirstVectorAggregationTest.FIELD_NAME.equals(column)) {
                    return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.DOUBLE);
                }
                if (DoubleFirstVectorAggregationTest.FIELD_NAME_LONG.equals(column)) {
                    return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.LONG);
                }
                return null;
            }
        };
        this.target = new DoubleFirstVectorAggregator((VectorValueSelector)this.timeSelector, this.selector);
        this.clearBufferForPositions(0, 0);
        this.doubleFirstAggregatorFactory = new DoubleFirstAggregatorFactory(NAME, FIELD_NAME, TIME_COL);
    }

    @Test
    public void testFactory() {
        Assert.assertTrue((boolean)this.doubleFirstAggregatorFactory.canVectorize((ColumnInspector)this.selectorFactory));
        VectorAggregator vectorAggregator = this.doubleFirstAggregatorFactory.factorizeVector(this.selectorFactory);
        Assert.assertNotNull((Object)vectorAggregator);
        Assert.assertEquals(DoubleFirstVectorAggregator.class, vectorAggregator.getClass());
    }

    @Test
    public void initValueShouldInitZero() {
        this.target.initValue(this.buf, 0);
        double initVal = this.buf.getDouble(0);
        Assert.assertEquals((double)0.0, (double)initVal, (double)1.0E-5);
    }

    @Test
    public void aggregate() {
        this.target.aggregate(this.buf, 0, 0, this.pairs.length);
        Pair result = (Pair)this.target.get(this.buf, 0);
        Assert.assertEquals((long)((Long)this.pairs[0].lhs), (long)((Long)result.lhs));
        Assert.assertEquals((double)((Double)this.pairs[0].rhs), (double)((Double)result.rhs), (double)1.0E-5);
    }

    @Test
    public void aggregateWithNulls() {
        this.target.aggregate(this.buf, 0, 0, this.pairs.length);
        Pair result = (Pair)this.target.get(this.buf, 0);
        Assert.assertEquals((long)((Long)this.pairs[0].lhs), (long)((Long)result.lhs));
        Assert.assertEquals((double)((Double)this.pairs[0].rhs), (double)((Double)result.rhs), (double)1.0E-5);
    }

    @Test
    public void aggregateBatchWithoutRows() {
        int[] positions = new int[]{0, 43, 70};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        this.target.aggregate(this.buf, 3, positions, null, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            Pair result = (Pair)this.target.get(this.buf, positions[i] + positionOffset);
            Assert.assertEquals((long)((Long)this.pairs[i].getLhs()), (long)((Long)result.lhs));
            Assert.assertEquals((double)((Double)this.pairs[i].rhs), (double)((Double)result.rhs), (double)1.0E-5);
        }
    }

    @Test
    public void aggregateBatchWithRows() {
        int[] positions = new int[]{0, 43, 70};
        int[] rows = new int[]{3, 0, 2};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        this.target.aggregate(this.buf, 3, positions, rows, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            Pair result = (Pair)this.target.get(this.buf, positions[i] + positionOffset);
            Assert.assertEquals((long)((Long)this.pairs[rows[i]].lhs), (long)((Long)result.lhs));
            Assert.assertEquals((double)((Double)this.pairs[rows[i]].rhs), (double)((Double)result.rhs), (double)1.0E-5);
        }
    }

    private void clearBufferForPositions(int offset, int ... positions) {
        for (int position : positions) {
            this.target.init(this.buf, offset + position);
        }
    }
}

