/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.aggregation.SerializablePairLongFloat;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.first.FloatFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.FloatFirstVectorAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FloatFirstVectorAggregationTest
extends InitializedNullHandlingTest {
    private static final double EPSILON = 1.0E-5;
    private static final float[] VALUES = new float[]{7.2f, 15.6f, 2.1f, 150.0f};
    private static final long[] LONG_VALUES = new long[]{1L, 2L, 3L, 4L};
    private static final float[] FLOAT_VALUES = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
    private static final double[] DOUBLE_VALUES = new double[]{1.0, 2.0, 3.0, 4.0};
    private static final boolean[] NULLS = new boolean[]{false, false, false, false};
    private static final String NAME = "NAME";
    private static final String FIELD_NAME = "FIELD_NAME";
    private static final String FIELD_NAME_LONG = "LONG_NAME";
    private static final String TIME_COL = "__time";
    private final long[] times = new long[]{2345001L, 2345100L, 2345200L, 2345300L};
    private final SerializablePairLongFloat[] pairs = new SerializablePairLongFloat[]{new SerializablePairLongFloat(Long.valueOf(2345001L), Float.valueOf(1.2f)), new SerializablePairLongFloat(Long.valueOf(2345100L), Float.valueOf(2.2f)), new SerializablePairLongFloat(Long.valueOf(2345200L), Float.valueOf(3.2f)), new SerializablePairLongFloat(Long.valueOf(2345300L), Float.valueOf(4.2f))};
    private final SerializablePairLongFloat[] nullPairs = new SerializablePairLongFloat[]{null, null, null, null};
    private VectorObjectSelector selector;
    private VectorObjectSelector selector1;
    private BaseLongVectorValueSelector timeSelector;
    private ByteBuffer buf;
    private FloatFirstVectorAggregator target;
    private FloatFirstVectorAggregator target1;
    private FloatFirstAggregatorFactory floatFirstAggregatorFactory;
    private VectorColumnSelectorFactory selectorFactory;
    private VectorValueSelector nonFloatValueSelector;

    @Before
    public void setup() {
        byte[] randomBytes = new byte[1024];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        this.buf = ByteBuffer.wrap(randomBytes);
        this.timeSelector = new BaseLongVectorValueSelector((ReadableVectorOffset)new NoFilterVectorOffset(this.times.length, 0, this.times.length){}){

            public long[] getLongVector() {
                return FloatFirstVectorAggregationTest.this.times;
            }

            @Nullable
            public boolean[] getNullVector() {
                return null;
            }
        };
        this.selector = new VectorObjectSelector(){

            public Object[] getObjectVector() {
                return FloatFirstVectorAggregationTest.this.pairs;
            }

            public int getMaxVectorSize() {
                return 4;
            }

            public int getCurrentVectorSize() {
                return 0;
            }
        };
        this.selector1 = new VectorObjectSelector(){

            public Object[] getObjectVector() {
                return FloatFirstVectorAggregationTest.this.nullPairs;
            }

            public int getMaxVectorSize() {
                return 4;
            }

            public int getCurrentVectorSize() {
                return 0;
            }
        };
        this.nonFloatValueSelector = new BaseLongVectorValueSelector((ReadableVectorOffset)new NoFilterVectorOffset(LONG_VALUES.length, 0, LONG_VALUES.length)){

            public long[] getLongVector() {
                return LONG_VALUES;
            }

            public float[] getFloatVector() {
                return FLOAT_VALUES;
            }

            public double[] getDoubleVector() {
                return DOUBLE_VALUES;
            }

            @Nullable
            public boolean[] getNullVector() {
                return NULLS;
            }

            public int getMaxVectorSize() {
                return 4;
            }

            public int getCurrentVectorSize() {
                return 4;
            }
        };
        this.selectorFactory = new VectorColumnSelectorFactory(){

            public ReadableVectorInspector getReadableVectorInspector() {
                return new NoFilterVectorOffset(VALUES.length, 0, VALUES.length);
            }

            public SingleValueDimensionVectorSelector makeSingleValueDimensionSelector(DimensionSpec dimensionSpec) {
                return null;
            }

            public MultiValueDimensionVectorSelector makeMultiValueDimensionSelector(DimensionSpec dimensionSpec) {
                return null;
            }

            public VectorValueSelector makeValueSelector(String column) {
                if (FloatFirstVectorAggregationTest.TIME_COL.equals(column)) {
                    return FloatFirstVectorAggregationTest.this.timeSelector;
                }
                if (FloatFirstVectorAggregationTest.FIELD_NAME.equals(column)) {
                    return FloatFirstVectorAggregationTest.this.nonFloatValueSelector;
                }
                return null;
            }

            public VectorObjectSelector makeObjectSelector(String column) {
                if (FloatFirstVectorAggregationTest.FIELD_NAME.equals(column)) {
                    return FloatFirstVectorAggregationTest.this.selector;
                }
                return null;
            }

            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                if (FloatFirstVectorAggregationTest.FIELD_NAME.equals(column)) {
                    return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.FLOAT);
                }
                if (FloatFirstVectorAggregationTest.FIELD_NAME_LONG.equals(column)) {
                    return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.LONG);
                }
                return null;
            }
        };
        this.target = new FloatFirstVectorAggregator((VectorValueSelector)this.timeSelector, this.selector);
        this.target1 = new FloatFirstVectorAggregator((VectorValueSelector)this.timeSelector, this.selector1);
        this.clearBufferForPositions(0, 0);
        this.floatFirstAggregatorFactory = new FloatFirstAggregatorFactory(NAME, FIELD_NAME, TIME_COL);
    }

    @Test
    public void testFactory() {
        Assert.assertTrue((boolean)this.floatFirstAggregatorFactory.canVectorize((ColumnInspector)this.selectorFactory));
        VectorAggregator vectorAggregator = this.floatFirstAggregatorFactory.factorizeVector(this.selectorFactory);
        Assert.assertNotNull((Object)vectorAggregator);
        Assert.assertEquals(FloatFirstVectorAggregator.class, vectorAggregator.getClass());
    }

    @Test
    public void initValueShouldBeZero() {
        this.target.initValue(this.buf, 0);
        float initVal = this.buf.getFloat(0);
        Assert.assertEquals((double)0.0, (double)initVal, (double)1.0E-5);
    }

    @Test
    public void aggregate() {
        this.target.init(this.buf, 0);
        this.target.aggregate(this.buf, 0, 0, VALUES.length);
        Pair result = (Pair)this.target.get(this.buf, 0);
        Assert.assertEquals((long)((Long)this.pairs[0].lhs), (long)((Long)result.lhs));
        Assert.assertEquals((double)((Float)this.pairs[0].rhs).floatValue(), (double)((Float)result.rhs).floatValue(), (double)1.0E-5);
    }

    @Test
    public void aggregateNulls1() {
        this.target1.init(this.buf, 0);
        this.target1.aggregate(this.buf, 0, 0, VALUES.length);
        Pair result = (Pair)this.target1.get(this.buf, 0);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((Long)result.lhs));
        Assert.assertEquals((Object)NullHandling.defaultFloatValue(), (Object)result.rhs);
    }

    @Test
    public void aggregateWithNulls() {
        this.target.aggregate(this.buf, 0, 0, VALUES.length);
        Pair result = (Pair)this.target.get(this.buf, 0);
        Assert.assertEquals((long)((Long)this.pairs[0].lhs), (long)((Long)result.lhs));
        Assert.assertEquals((double)((Float)this.pairs[0].rhs).floatValue(), (double)((Float)result.rhs).floatValue(), (double)1.0E-5);
    }

    @Test
    public void aggregateBatchWithoutRows() {
        int[] positions = new int[]{0, 43, 70};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        this.target.aggregate(this.buf, 3, positions, null, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            Pair result = (Pair)this.target.get(this.buf, positions[i] + positionOffset);
            Assert.assertEquals((long)((Long)this.pairs[i].getLhs()), (long)((Long)result.lhs));
            if (!NullHandling.replaceWithDefault() && NULLS[i]) {
                Assert.assertNull((Object)result.rhs);
                continue;
            }
            Assert.assertEquals((double)((Float)this.pairs[i].rhs).floatValue(), (double)((Float)result.rhs).floatValue(), (double)1.0E-5);
        }
    }

    @Test
    public void aggregateBatchWithRows() {
        int[] positions = new int[]{0, 43, 70};
        int[] rows = new int[]{3, 2, 0};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        this.target.aggregate(this.buf, 3, positions, rows, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            Pair result = (Pair)this.target.get(this.buf, positions[i] + positionOffset);
            Assert.assertEquals((long)this.times[rows[i]], (long)((Long)result.lhs));
            if (!NullHandling.replaceWithDefault() && NULLS[rows[i]]) {
                Assert.assertNull((Object)result.rhs);
                continue;
            }
            Assert.assertEquals((double)((Float)this.pairs[rows[i]].rhs).floatValue(), (double)((Float)result.rhs).floatValue(), (double)1.0E-5);
        }
    }

    private void clearBufferForPositions(int offset, int ... positions) {
        for (int position : positions) {
            this.target.init(this.buf, offset + position);
        }
    }
}

