/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.query.aggregation.TestLongColumnSelector;
import org.apache.druid.query.aggregation.TestObjectColumnSelector;
import org.apache.druid.query.aggregation.first.LongFirstAggregatorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LongFirstAggregationTest
extends InitializedNullHandlingTest {
    private LongFirstAggregatorFactory longFirstAggFactory;
    private LongFirstAggregatorFactory combiningAggFactory;
    private ColumnSelectorFactory colSelectorFactory;
    private TestLongColumnSelector timeSelector;
    private TestLongColumnSelector customTimeSelector;
    private TestLongColumnSelector valueSelector;
    private TestObjectColumnSelector objectSelector;
    private long[] longValues = new long[]{185L, -216L, -128751132L, Long.MIN_VALUE};
    private long[] times = new long[]{1123126751L, 1784247991L, 1854329816L, 1000000000L};
    private long[] customTimes = new long[]{2L, 1L, 3L, 4L};
    private SerializablePairLongLong[] pairs = new SerializablePairLongLong[]{new SerializablePairLongLong(Long.valueOf(1L), Long.valueOf(113267L)), new SerializablePairLongLong(Long.valueOf(1L), Long.valueOf(5437384L)), new SerializablePairLongLong(Long.valueOf(6L), Long.valueOf(34583458L)), new SerializablePairLongLong(Long.valueOf(88L), Long.valueOf(34583452L))};

    @Before
    public void setup() {
        this.longFirstAggFactory = new LongFirstAggregatorFactory("billy", "nilly", null);
        this.combiningAggFactory = (LongFirstAggregatorFactory)this.longFirstAggFactory.getCombiningFactory();
        this.timeSelector = new TestLongColumnSelector(this.times);
        this.customTimeSelector = new TestLongColumnSelector(this.customTimes);
        this.valueSelector = new TestLongColumnSelector(this.longValues);
        this.objectSelector = new TestObjectColumnSelector<SerializablePairLongLong>(this.pairs);
        this.colSelectorFactory = (ColumnSelectorFactory)EasyMock.createMock(ColumnSelectorFactory.class);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("__time")).andReturn((Object)this.timeSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("customTime")).andReturn((Object)this.customTimeSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("nilly")).andReturn((Object)this.valueSelector);
        EasyMock.expect((Object)this.colSelectorFactory.makeColumnValueSelector("billy")).andReturn((Object)this.objectSelector);
        EasyMock.expect((Object)this.colSelectorFactory.getColumnCapabilities("nilly")).andReturn((Object)new ColumnCapabilitiesImpl().setType(ColumnType.LONG));
        EasyMock.expect((Object)this.colSelectorFactory.getColumnCapabilities("billy")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.colSelectorFactory});
    }

    @Test
    public void testLongFirstAggregator() {
        Aggregator agg = this.longFirstAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        Assert.assertEquals((long)this.times[3], (long)((Long)result.lhs));
        Assert.assertEquals((long)this.longValues[3], (long)((Long)result.rhs));
        Assert.assertEquals((long)this.longValues[3], (long)agg.getLong());
        Assert.assertEquals((double)this.longValues[3], (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testLongFirstAggregatorWithTimeColumn() {
        Aggregator agg = new LongFirstAggregatorFactory("billy", "nilly", "customTime").factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        Assert.assertEquals((long)this.customTimes[1], (long)((Long)result.lhs));
        Assert.assertEquals((long)this.longValues[1], (long)((Long)result.rhs));
        Assert.assertEquals((long)this.longValues[1], (long)agg.getLong());
        Assert.assertEquals((double)this.longValues[1], (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testLongFirstBufferAggregator() {
        BufferAggregator agg = new LongFirstAggregatorFactory("billy", "nilly", "customTime").factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.longFirstAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        Assert.assertEquals((long)this.customTimes[1], (long)((Long)result.lhs));
        Assert.assertEquals((long)this.longValues[1], (long)((Long)result.rhs));
        Assert.assertEquals((long)this.longValues[1], (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.longValues[1], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testLongFirstBufferAggregatorWithTimeColumn() {
        BufferAggregator agg = this.longFirstAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.longFirstAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        Assert.assertEquals((long)this.times[3], (long)((Long)result.lhs));
        Assert.assertEquals((long)this.longValues[3], (long)((Long)result.rhs));
        Assert.assertEquals((long)this.longValues[3], (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)this.longValues[3], (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testCombine() {
        SerializablePairLongLong pair1 = new SerializablePairLongLong(Long.valueOf(1467225000L), Long.valueOf(1263L));
        SerializablePairLongLong pair2 = new SerializablePairLongLong(Long.valueOf(1467240000L), Long.valueOf(752713L));
        Assert.assertEquals((Object)pair1, (Object)this.longFirstAggFactory.combine((Object)pair1, (Object)pair2));
    }

    @Test
    public void testComparatorWithNulls() {
        SerializablePairLongLong pair1 = new SerializablePairLongLong(Long.valueOf(1467225000L), Long.valueOf(1263L));
        SerializablePairLongLong pair2 = new SerializablePairLongLong(Long.valueOf(1467240000L), null);
        Comparator comparator = this.longFirstAggFactory.getComparator();
        Assert.assertEquals((long)1L, (long)comparator.compare(pair1, pair2));
        Assert.assertEquals((long)0L, (long)comparator.compare(pair1, pair1));
        Assert.assertEquals((long)0L, (long)comparator.compare(pair2, pair2));
        Assert.assertEquals((long)-1L, (long)comparator.compare(pair2, pair1));
    }

    @Test
    public void testLongFirstCombiningAggregator() {
        Aggregator agg = this.combiningAggFactory.factorize(this.colSelectorFactory);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        this.aggregate(agg);
        Pair result = (Pair)agg.get();
        SerializablePairLongLong expected = this.pairs[0];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((Object)expected.rhs, (Object)result.rhs);
        Assert.assertEquals((long)((Long)expected.rhs), (long)agg.getLong());
        Assert.assertEquals((double)((Long)expected.rhs).longValue(), (double)agg.getFloat(), (double)1.0E-4);
    }

    @Test
    public void testLongFirstCombiningBufferAggregator() {
        BufferAggregator agg = this.combiningAggFactory.factorizeBuffered(this.colSelectorFactory);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.longFirstAggFactory.getMaxIntermediateSizeWithNulls()]);
        agg.init(buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        this.aggregate(agg, buffer, 0);
        Pair result = (Pair)agg.get(buffer, 0);
        SerializablePairLongLong expected = this.pairs[0];
        Assert.assertEquals((Object)expected.lhs, (Object)result.lhs);
        Assert.assertEquals((Object)expected.rhs, (Object)result.rhs);
        Assert.assertEquals((long)((Long)expected.rhs), (long)agg.getLong(buffer, 0));
        Assert.assertEquals((double)((Long)expected.rhs).longValue(), (double)agg.getFloat(buffer, 0), (double)1.0E-4);
    }

    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        String longSpecJson = "{\"type\":\"longFirst\",\"name\":\"billy\",\"fieldName\":\"nilly\"}";
        AggregatorFactory deserialized = (AggregatorFactory)mapper.readValue(longSpecJson, AggregatorFactory.class);
        Assert.assertEquals((Object)this.longFirstAggFactory, (Object)deserialized);
        Assert.assertArrayEquals((byte[])this.longFirstAggFactory.getCacheKey(), (byte[])deserialized.getCacheKey());
    }

    @Test
    public void testLongFirstAggregeCombiner() {
        TestObjectColumnSelector<SerializablePairLongLong> columnSelector = new TestObjectColumnSelector<SerializablePairLongLong>(this.pairs);
        AggregateCombiner longFirstAggregateCombiner = this.combiningAggFactory.makeAggregateCombiner();
        longFirstAggregateCombiner.reset(columnSelector);
        Assert.assertEquals((Object)this.pairs[0], (Object)longFirstAggregateCombiner.getObject());
        columnSelector.increment();
        longFirstAggregateCombiner.fold(columnSelector);
        Assert.assertEquals((Object)this.pairs[0], (Object)longFirstAggregateCombiner.getObject());
        columnSelector.increment();
        longFirstAggregateCombiner.fold(columnSelector);
        Assert.assertEquals((Object)this.pairs[0], (Object)longFirstAggregateCombiner.getObject());
        longFirstAggregateCombiner.reset(columnSelector);
        Assert.assertEquals((Object)this.pairs[2], (Object)longFirstAggregateCombiner.getObject());
    }

    private void aggregate(Aggregator agg) {
        agg.aggregate();
        this.timeSelector.increment();
        this.customTimeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }

    private void aggregate(BufferAggregator agg, ByteBuffer buff, int position) {
        agg.aggregate(buff, position);
        this.timeSelector.increment();
        this.customTimeSelector.increment();
        this.valueSelector.increment();
        this.objectSelector.increment();
    }
}

