/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.StringFirstVectorAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;

public class StringFirstVectorAggregatorTest
extends InitializedNullHandlingTest {
    private static final double EPSILON = 1.0E-5;
    private static final String[] VALUES = new String[]{"a", "b", null, "c"};
    private static final long[] LONG_VALUES = new long[]{1L, 2L, 3L, 4L};
    private static final String[] STRING_VALUES = new String[]{"1", "2", "3", "4"};
    private static final float[] FLOAT_VALUES = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
    private static final double[] DOUBLE_VALUES = new double[]{1.0, 2.0, 3.0, 4.0};
    private static final boolean[] NULLS = new boolean[]{false, false, true, false};
    private static final String NAME = "NAME";
    private static final String FIELD_NAME = "FIELD_NAME";
    private static final String FIELD_NAME_LONG = "LONG_NAME";
    private static final String TIME_COL = "__time";
    private final long[] times = new long[]{2436L, 6879L, 7888L, 8224L};
    private final long[] timesSame = new long[]{2436L, 2436L};
    private final SerializablePairLongString[] pairs = new SerializablePairLongString[]{new SerializablePairLongString(Long.valueOf(2345001L), "first"), new SerializablePairLongString(Long.valueOf(2345100L), "notFirst")};
    @Mock
    private VectorObjectSelector selector;
    @Mock
    private VectorObjectSelector selectorForPairs;
    @Mock
    private BaseLongVectorValueSelector timeSelector;
    @Mock
    private BaseLongVectorValueSelector timeSelectorForPairs;
    private ByteBuffer buf;
    private StringFirstVectorAggregator target;
    private StringFirstVectorAggregator targetWithPairs;
    private StringFirstAggregatorFactory stringFirstAggregatorFactory;
    private StringFirstAggregatorFactory stringFirstAggregatorFactory1;
    private VectorColumnSelectorFactory selectorFactory;
    private VectorValueSelector nonStringValueSelector;

    @Before
    public void setup() {
        byte[] randomBytes = new byte[1024];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        this.buf = ByteBuffer.wrap(randomBytes);
        this.timeSelector = new BaseLongVectorValueSelector((ReadableVectorOffset)new NoFilterVectorOffset(this.times.length, 0, this.times.length)){

            public long[] getLongVector() {
                return StringFirstVectorAggregatorTest.this.times;
            }

            @Nullable
            public boolean[] getNullVector() {
                return null;
            }
        };
        this.selector = new VectorObjectSelector(){

            public Object[] getObjectVector() {
                return VALUES;
            }

            public int getMaxVectorSize() {
                return 4;
            }

            public int getCurrentVectorSize() {
                return 0;
            }
        };
        this.timeSelectorForPairs = new BaseLongVectorValueSelector((ReadableVectorOffset)new NoFilterVectorOffset(this.timesSame.length, 0, this.timesSame.length)){

            public long[] getLongVector() {
                return StringFirstVectorAggregatorTest.this.timesSame;
            }

            @Nullable
            public boolean[] getNullVector() {
                return null;
            }
        };
        this.selectorForPairs = new VectorObjectSelector(){

            public Object[] getObjectVector() {
                return StringFirstVectorAggregatorTest.this.pairs;
            }

            public int getMaxVectorSize() {
                return 2;
            }

            public int getCurrentVectorSize() {
                return 0;
            }
        };
        this.nonStringValueSelector = new BaseLongVectorValueSelector((ReadableVectorOffset)new NoFilterVectorOffset(LONG_VALUES.length, 0, LONG_VALUES.length)){

            public long[] getLongVector() {
                return LONG_VALUES;
            }

            public float[] getFloatVector() {
                return FLOAT_VALUES;
            }

            public double[] getDoubleVector() {
                return DOUBLE_VALUES;
            }

            @Nullable
            public boolean[] getNullVector() {
                return NULLS;
            }

            public int getMaxVectorSize() {
                return 4;
            }

            public int getCurrentVectorSize() {
                return 4;
            }
        };
        this.selectorFactory = new VectorColumnSelectorFactory(){

            public ReadableVectorInspector getReadableVectorInspector() {
                return new NoFilterVectorOffset(VALUES.length, 0, VALUES.length);
            }

            public SingleValueDimensionVectorSelector makeSingleValueDimensionSelector(DimensionSpec dimensionSpec) {
                return null;
            }

            public MultiValueDimensionVectorSelector makeMultiValueDimensionSelector(DimensionSpec dimensionSpec) {
                return null;
            }

            public VectorValueSelector makeValueSelector(String column) {
                if (StringFirstVectorAggregatorTest.TIME_COL.equals(column)) {
                    return StringFirstVectorAggregatorTest.this.timeSelector;
                }
                if (StringFirstVectorAggregatorTest.FIELD_NAME_LONG.equals(column)) {
                    return StringFirstVectorAggregatorTest.this.nonStringValueSelector;
                }
                return null;
            }

            public VectorObjectSelector makeObjectSelector(String column) {
                if (StringFirstVectorAggregatorTest.FIELD_NAME.equals(column)) {
                    return StringFirstVectorAggregatorTest.this.selector;
                }
                return null;
            }

            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                if (StringFirstVectorAggregatorTest.FIELD_NAME.equals(column)) {
                    return ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities();
                }
                if (StringFirstVectorAggregatorTest.FIELD_NAME_LONG.equals(column)) {
                    return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.LONG);
                }
                return null;
            }
        };
        this.target = new StringFirstVectorAggregator((VectorValueSelector)this.timeSelector, this.selector, 10);
        this.targetWithPairs = new StringFirstVectorAggregator((VectorValueSelector)this.timeSelectorForPairs, this.selectorForPairs, 10);
        this.clearBufferForPositions(0, 0);
        this.stringFirstAggregatorFactory = new StringFirstAggregatorFactory(NAME, FIELD_NAME, TIME_COL, Integer.valueOf(10));
        this.stringFirstAggregatorFactory1 = new StringFirstAggregatorFactory(NAME, FIELD_NAME_LONG, TIME_COL, Integer.valueOf(10));
    }

    @Test
    public void testAggregateWithPairs() {
        this.targetWithPairs.aggregate(this.buf, 0, 0, this.pairs.length);
        Pair result = (Pair)this.targetWithPairs.get(this.buf, 0);
        Assert.assertEquals((long)((Long)this.pairs[0].lhs), (long)((Long)result.lhs));
        Assert.assertEquals((Object)this.pairs[0].rhs, (Object)result.rhs);
    }

    @Test
    public void testFactory() {
        Assert.assertTrue((boolean)this.stringFirstAggregatorFactory.canVectorize((ColumnInspector)this.selectorFactory));
        VectorAggregator vectorAggregator = this.stringFirstAggregatorFactory.factorizeVector(this.selectorFactory);
        Assert.assertNotNull((Object)vectorAggregator);
        Assert.assertEquals(StringFirstVectorAggregator.class, vectorAggregator.getClass());
    }

    @Test
    public void initValueShouldBeMaxDate() {
        this.target.init(this.buf, 0);
        long initVal = this.buf.getLong(0);
        Assert.assertEquals((long)DateTimes.MAX.getMillis(), (long)initVal);
    }

    @Test
    public void aggregate() {
        this.target.aggregate(this.buf, 0, 0, VALUES.length);
        Pair result = (Pair)this.target.get(this.buf, 0);
        Assert.assertEquals((long)this.times[0], (long)((Long)result.lhs));
        Assert.assertEquals((Object)VALUES[0], (Object)result.rhs);
    }

    @Test
    public void testStringEarliestOnNonStringColumns() {
        Assert.assertTrue((boolean)this.stringFirstAggregatorFactory1.canVectorize((ColumnInspector)this.selectorFactory));
        VectorAggregator vectorAggregator = this.stringFirstAggregatorFactory1.factorizeVector(this.selectorFactory);
        Assert.assertNotNull((Object)vectorAggregator);
        Assert.assertEquals(StringFirstVectorAggregator.class, vectorAggregator.getClass());
        vectorAggregator.aggregate(this.buf, 0, 0, LONG_VALUES.length);
        Pair result = (Pair)vectorAggregator.get(this.buf, 0);
        Assert.assertEquals((long)this.times[0], (long)((Long)result.lhs));
        Assert.assertEquals((Object)STRING_VALUES[0], (Object)result.rhs);
    }

    @Test
    public void aggregateBatchWithoutRows() {
        int[] positions = new int[]{0, 43, 70};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        this.target.aggregate(this.buf, 3, positions, null, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            Pair result = (Pair)this.target.get(this.buf, positions[i] + positionOffset);
            Assert.assertEquals((long)this.times[i], (long)((Long)result.lhs));
            Assert.assertEquals((Object)VALUES[i], (Object)result.rhs);
        }
    }

    @Test
    public void aggregateBatchWithRows() {
        int[] positions = new int[]{0, 43, 70};
        int[] rows = new int[]{3, 2, 0};
        int positionOffset = 2;
        this.clearBufferForPositions(positionOffset, positions);
        this.target.aggregate(this.buf, 3, positions, rows, positionOffset);
        for (int i = 0; i < positions.length; ++i) {
            Pair result = (Pair)this.target.get(this.buf, positions[i] + positionOffset);
            Assert.assertEquals((long)this.times[rows[i]], (long)((Long)result.lhs));
            Assert.assertEquals((Object)VALUES[rows[i]], (Object)result.rhs);
        }
    }

    private void clearBufferForPositions(int offset, int ... positions) {
        for (int position : positions) {
            this.target.init(this.buf, offset + position);
        }
    }
}

