/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import inet.ipaddr.ipv6.IPv6Address;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.query.expression.IPv6AddressExprUtils;
import org.junit.Assert;
import org.junit.Test;

public class IPv6AddressExprUtilsTest {
    private static final List<String> VALID_IPV6_ADDRESSES = Arrays.asList("2001:db8:85a3:8d3:1319:8a2e:370:7348", "::", "2001::8a2e:370:7348", "::8a2e:370:7348");
    private static final List<String> INVALID_IPV6_ADDRESSES = Arrays.asList("druid.apache.org", "190.0.0.0", "gff2::8a2e:370:7348", "023a:8a2e:7348", "2001:0db8:/32");
    private static final List<String> VALID_IPV6_SUBNETS = Arrays.asList("2001:db8:85a3:8d3::/64", "2001:db8::/8");
    private static final List<String> INVALID_IPV6_SUBNETS = Arrays.asList("2001:db8:85a3::/129", "f3ed::");

    @Test
    public void testIsValidIPv6AddressNull() {
        Assert.assertFalse((boolean)IPv6AddressExprUtils.isValidIPv6Address(null));
    }

    @Test
    public void testIsValidIPv6Address() {
        for (String address : VALID_IPV6_ADDRESSES) {
            Assert.assertTrue((String)this.getErrMsg(address), (boolean)IPv6AddressExprUtils.isValidIPv6Address((String)address));
        }
    }

    @Test
    public void testIsValidIPv6AddressNotIpAddress() {
        for (String address : INVALID_IPV6_ADDRESSES) {
            Assert.assertFalse((String)this.getErrMsg(address), (boolean)IPv6AddressExprUtils.isValidIPv6Address((String)address));
        }
    }

    @Test
    public void testIsValidSubnetNull() {
        Assert.assertFalse((boolean)IPv6AddressExprUtils.isValidIPv6Subnet(null));
    }

    @Test
    public void testIsValidIPv6SubnetValid() {
        for (String address : VALID_IPV6_SUBNETS) {
            Assert.assertTrue((String)this.getErrMsg(address), (boolean)IPv6AddressExprUtils.isValidIPv6Subnet((String)address));
        }
    }

    @Test
    public void testIsValidIPv6SubnetInvalid() {
        for (String address : INVALID_IPV6_SUBNETS) {
            Assert.assertFalse((String)this.getErrMsg(address), (boolean)IPv6AddressExprUtils.isValidIPv6Subnet((String)address));
        }
    }

    @Test
    public void testParseNullString() {
        Assert.assertNull((Object)IPv6AddressExprUtils.parse((String)null));
    }

    @Test
    public void testParseNullBytes() {
        Assert.assertNull((Object)IPv6AddressExprUtils.parse((byte[])null));
    }

    @Test
    public void testParseIPv6() {
        for (String string : VALID_IPV6_ADDRESSES) {
            String errMsg = this.getErrMsg(string);
            IPv6Address address = IPv6AddressExprUtils.parse((String)string);
            Assert.assertNotNull((String)errMsg, (Object)address);
            Assert.assertEquals((String)errMsg, (Object)string, (Object)address.toString());
        }
    }

    @Test
    public void testParseNotIpV6Addresses() {
        for (String address : INVALID_IPV6_ADDRESSES) {
            Assert.assertNull((String)this.getErrMsg(address), (Object)IPv6AddressExprUtils.parse((String)address));
        }
    }

    private String getErrMsg(String msg) {
        String prefix = "Failed: ";
        return prefix + msg;
    }
}

