/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.compress.utils.Lists;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.lookup.LookupExtractor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class MapBasedLookupExtractorTest {
    protected final Map<String, String> simpleLookupMap = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"null", (Object)"", (Object)"empty String", (Object)"", (Object)"", (Object)"empty_string");

    @BeforeClass
    public static void setUpClass() {
        NullHandling.initializeForTests();
    }

    protected abstract LookupExtractor makeLookupExtractor(Map<String, String> var1);

    @Test
    public void test_unapplyAll_simple() {
        LookupExtractor lookup = this.makeLookupExtractor(this.simpleLookupMap);
        Assert.assertEquals(Collections.singletonList("foo"), this.unapply(lookup, "bar"));
        if (NullHandling.sqlCompatible()) {
            Assert.assertEquals(Collections.emptySet(), (Object)Sets.newHashSet(this.unapply(lookup, null)));
            Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"null", "empty String"}), (Object)Sets.newHashSet(this.unapply(lookup, "")));
        } else {
            Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"null", "empty String"}), (Object)Sets.newHashSet(this.unapply(lookup, null)));
        }
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{""}), (Object)Sets.newHashSet(this.unapply(lookup, "empty_string")));
        Assert.assertEquals((String)"not existing value returns empty list", Collections.emptyList(), this.unapply(lookup, "not There"));
    }

    @Test
    public void test_asMap_simple() {
        LookupExtractor lookup = this.makeLookupExtractor(this.simpleLookupMap);
        Assert.assertTrue((boolean)lookup.supportsAsMap());
        Assert.assertEquals(this.simpleLookupMap, (Object)lookup.asMap());
    }

    @Test
    public void test_apply_simple() {
        LookupExtractor lookup = this.makeLookupExtractor(this.simpleLookupMap);
        Assert.assertEquals((Object)"bar", (Object)lookup.apply("foo"));
        Assert.assertEquals((Object)(NullHandling.sqlCompatible() ? "" : null), (Object)lookup.apply("null"));
        Assert.assertEquals((Object)(NullHandling.sqlCompatible() ? "" : null), (Object)lookup.apply("empty String"));
        Assert.assertEquals((Object)"empty_string", (Object)lookup.apply(""));
        Assert.assertEquals((Object)(NullHandling.sqlCompatible() ? null : "empty_string"), (Object)lookup.apply(null));
    }

    @Test
    public void test_apply_nullKey() {
        HashMap<String, String> mapWithNullKey = new HashMap<String, String>();
        mapWithNullKey.put(null, "nv");
        LookupExtractor lookup = this.makeLookupExtractor(mapWithNullKey);
        Assert.assertNull((Object)lookup.apply("missing"));
        Assert.assertNull((Object)lookup.apply(""));
        Assert.assertNull((Object)lookup.apply(null));
    }

    @Test
    public void test_unapply_nullKey() {
        HashMap<String, String> mapWithNullKey = new HashMap<String, String>();
        mapWithNullKey.put(null, "nv");
        LookupExtractor lookup = this.makeLookupExtractor(mapWithNullKey);
        Assert.assertEquals(NullHandling.sqlCompatible() ? Collections.emptyList() : Collections.singletonList(null), this.unapply(lookup, "nv"));
        Assert.assertEquals(Collections.emptyList(), this.unapply(lookup, null));
    }

    @Test
    public void test_apply_nullValue() {
        HashMap<String, String> mapWithNullKey = new HashMap<String, String>();
        mapWithNullKey.put("nk", null);
        LookupExtractor lookup = this.makeLookupExtractor(mapWithNullKey);
        Assert.assertNull((Object)lookup.apply("nk"));
    }

    @Test
    public void test_unapply_nullValue() {
        HashMap<String, String> mapWithNullKey = new HashMap<String, String>();
        mapWithNullKey.put("nk", null);
        LookupExtractor lookup = this.makeLookupExtractor(mapWithNullKey);
        Assert.assertEquals(Collections.singletonList("nk"), this.unapply(lookup, null));
    }

    @Test
    public void test_apply_emptyStringValue() {
        HashMap<String, String> mapWithNullKey = new HashMap<String, String>();
        mapWithNullKey.put("nk", "");
        LookupExtractor lookup = this.makeLookupExtractor(mapWithNullKey);
        Assert.assertEquals((Object)(NullHandling.sqlCompatible() ? "" : null), (Object)lookup.apply("nk"));
    }

    @Test
    public void test_unapply_emptyStringValue() {
        HashMap<String, String> mapWithNullKey = new HashMap<String, String>();
        mapWithNullKey.put("nk", "");
        LookupExtractor lookup = this.makeLookupExtractor(mapWithNullKey);
        Assert.assertEquals(NullHandling.sqlCompatible() ? Collections.emptyList() : Collections.singletonList("nk"), this.unapply(lookup, null));
        if (NullHandling.sqlCompatible()) {
            Assert.assertEquals(Collections.singletonList("nk"), this.unapply(lookup, ""));
        }
    }

    @Test
    public void test_apply_nullAndEmptyStringKey() {
        HashMap<String, String> mapWithNullKey = new HashMap<String, String>();
        mapWithNullKey.put(null, "nv");
        mapWithNullKey.put("", "empty");
        LookupExtractor lookup = this.makeLookupExtractor(mapWithNullKey);
        Assert.assertNull((Object)lookup.apply("missing"));
        Assert.assertEquals((Object)"empty", (Object)lookup.apply(""));
        Assert.assertEquals((Object)(NullHandling.sqlCompatible() ? null : "empty"), (Object)lookup.apply(null));
    }

    @Test
    public void test_unapply_nullAndEmptyStringKey() {
        HashMap<String, String> mapWithNullKey = new HashMap<String, String>();
        mapWithNullKey.put(null, "nv");
        mapWithNullKey.put("", "empty");
        LookupExtractor lookup = this.makeLookupExtractor(mapWithNullKey);
        Assert.assertEquals(Collections.singletonList(""), this.unapply(lookup, "empty"));
        Assert.assertEquals(NullHandling.sqlCompatible() ? Collections.emptyList() : Collections.singletonList(null), this.unapply(lookup, "nv"));
    }

    @Test
    public void test_estimateHeapFootprint() {
        Assert.assertEquals((long)0L, (long)this.makeLookupExtractor(Collections.emptyMap()).estimateHeapFootprint());
        Assert.assertEquals((long)388L, (long)this.makeLookupExtractor(this.simpleLookupMap).estimateHeapFootprint());
    }

    protected List<String> unapply(LookupExtractor lookup, @Nullable String s) {
        return Lists.newArrayList((Iterator)lookup.unapplyAll(Collections.singleton(s)));
    }
}

