/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.BySegmentQueryRunner;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.TestBufferPool;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.TimeFormatExtractionFn;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupByLimitPushDownMultiNodeMergeTest {
    public static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final IndexMergerV9 INDEX_MERGER_V9;
    private static final IndexIO INDEX_IO;
    private File tmpDir;
    private QueryRunnerFactory<ResultRow, GroupByQuery> groupByFactory;
    private QueryRunnerFactory<ResultRow, GroupByQuery> groupByFactory2;
    private List<IncrementalIndex> incrementalIndices = new ArrayList<IncrementalIndex>();
    private List<QueryableIndex> groupByIndices = new ArrayList<QueryableIndex>();
    private ExecutorService executorService;
    private Closer resourceCloser;
    public static final QueryWatcher NOOP_QUERYWATCHER;

    private IncrementalIndex makeIncIndex(boolean withRollup) {
        return this.makeIncIndex(withRollup, Arrays.asList(new StringDimensionSchema("dimA"), new LongDimensionSchema("metA")));
    }

    private IncrementalIndex makeIncIndex(boolean withRollup, List<DimensionSchema> dimensions) {
        return new OnheapIncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec(Arrays.asList(new StringDimensionSchema("dimA"), new LongDimensionSchema("metA")))).withRollup(withRollup).build()).setMaxRowCount(1000).build();
    }

    @Before
    public void setup() throws Exception {
        this.tmpDir = FileUtils.createTempDir();
        List<String> dimNames = Arrays.asList("dimA", "metA");
        IncrementalIndex indexA = this.makeIncIndex(false);
        this.incrementalIndices.add(indexA);
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("dimA", "pomegranate");
        event.put("metA", 2395L);
        MapBasedInputRow row = new MapBasedInputRow(1505260888888L, dimNames, event);
        indexA.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("metA", 8L);
        row = new MapBasedInputRow(1505260800000L, dimNames, event);
        indexA.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "pomegranate");
        event.put("metA", 5028L);
        row = new MapBasedInputRow(1505264400000L, dimNames, event);
        indexA.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("metA", 7L);
        row = new MapBasedInputRow(1505264400400L, dimNames, event);
        indexA.add((InputRow)row);
        File fileA = INDEX_MERGER_V9.persist(indexA, new File(this.tmpDir, "A"), IndexSpec.DEFAULT, null);
        QueryableIndex qindexA = INDEX_IO.loadIndex(fileA);
        IncrementalIndex indexB = this.makeIncIndex(false);
        this.incrementalIndices.add(indexB);
        event = new HashMap();
        event.put("dimA", "pomegranate");
        event.put("metA", 4718L);
        row = new MapBasedInputRow(1505260800000L, dimNames, event);
        indexB.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("metA", 18L);
        row = new MapBasedInputRow(1505260800000L, dimNames, event);
        indexB.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "pomegranate");
        event.put("metA", 2698L);
        row = new MapBasedInputRow(1505264400000L, dimNames, event);
        indexB.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("metA", 3L);
        row = new MapBasedInputRow(1505264400000L, dimNames, event);
        indexB.add((InputRow)row);
        File fileB = INDEX_MERGER_V9.persist(indexB, new File(this.tmpDir, "B"), IndexSpec.DEFAULT, null);
        QueryableIndex qindexB = INDEX_IO.loadIndex(fileB);
        IncrementalIndex indexC = this.makeIncIndex(false);
        this.incrementalIndices.add(indexC);
        event = new HashMap();
        event.put("dimA", "pomegranate");
        event.put("metA", 2395L);
        row = new MapBasedInputRow(1505260800000L, dimNames, event);
        indexC.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("metA", 8L);
        row = new MapBasedInputRow(1605260800000L, dimNames, event);
        indexC.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "pomegranate");
        event.put("metA", 5028L);
        row = new MapBasedInputRow(1705264400000L, dimNames, event);
        indexC.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("metA", 7L);
        row = new MapBasedInputRow(1805264400000L, dimNames, event);
        indexC.add((InputRow)row);
        File fileC = INDEX_MERGER_V9.persist(indexC, new File(this.tmpDir, "C"), IndexSpec.DEFAULT, null);
        QueryableIndex qindexC = INDEX_IO.loadIndex(fileC);
        IncrementalIndex indexD = this.makeIncIndex(false);
        this.incrementalIndices.add(indexD);
        event = new HashMap();
        event.put("dimA", "pomegranate");
        event.put("metA", 4718L);
        row = new MapBasedInputRow(1505260800000L, dimNames, event);
        indexD.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("metA", 18L);
        row = new MapBasedInputRow(1605260800000L, dimNames, event);
        indexD.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "pomegranate");
        event.put("metA", 2698L);
        row = new MapBasedInputRow(1705264400000L, dimNames, event);
        indexD.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("metA", 3L);
        row = new MapBasedInputRow(1805264400000L, dimNames, event);
        indexD.add((InputRow)row);
        File fileD = INDEX_MERGER_V9.persist(indexD, new File(this.tmpDir, "D"), IndexSpec.DEFAULT, null);
        QueryableIndex qindexD = INDEX_IO.loadIndex(fileD);
        List<String> dimNames2 = Arrays.asList("dimA", "dimB", "metA");
        List<DimensionSchema> dimensions = Arrays.asList(new StringDimensionSchema("dimA"), new StringDimensionSchema("dimB"), new LongDimensionSchema("metA"));
        IncrementalIndex indexE = this.makeIncIndex(false, dimensions);
        this.incrementalIndices.add(indexE);
        event = new HashMap();
        event.put("dimA", "pomegranate");
        event.put("dimB", "raw");
        event.put("metA", 5L);
        row = new MapBasedInputRow(1505260800000L, dimNames2, event);
        indexE.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("dimB", "ripe");
        event.put("metA", 9L);
        row = new MapBasedInputRow(1605260800000L, dimNames2, event);
        indexE.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "pomegranate");
        event.put("dimB", "raw");
        event.put("metA", 3L);
        row = new MapBasedInputRow(1705264400000L, dimNames2, event);
        indexE.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "mango");
        event.put("dimB", "ripe");
        event.put("metA", 7L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexE.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "grape");
        event.put("dimB", "raw");
        event.put("metA", 5L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexE.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "apple");
        event.put("dimB", "ripe");
        event.put("metA", 3L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexE.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "apple");
        event.put("dimB", "raw");
        event.put("metA", 1L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexE.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "apple");
        event.put("dimB", "ripe");
        event.put("metA", 4L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexE.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "apple");
        event.put("dimB", "raw");
        event.put("metA", 1L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexE.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "banana");
        event.put("dimB", "ripe");
        event.put("metA", 4L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexE.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "orange");
        event.put("dimB", "raw");
        event.put("metA", 9L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexE.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "peach");
        event.put("dimB", "ripe");
        event.put("metA", 7L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexE.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "orange");
        event.put("dimB", "raw");
        event.put("metA", 2L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexE.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "strawberry");
        event.put("dimB", "ripe");
        event.put("metA", 10L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexE.add((InputRow)row);
        File fileE = INDEX_MERGER_V9.persist(indexE, new File(this.tmpDir, "E"), IndexSpec.DEFAULT, null);
        QueryableIndex qindexE = INDEX_IO.loadIndex(fileE);
        IncrementalIndex indexF = this.makeIncIndex(false, dimensions);
        this.incrementalIndices.add(indexF);
        event = new HashMap();
        event.put("dimA", "kiwi");
        event.put("dimB", "raw");
        event.put("metA", 7L);
        row = new MapBasedInputRow(1505260800000L, dimNames2, event);
        indexF.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "watermelon");
        event.put("dimB", "ripe");
        event.put("metA", 14L);
        row = new MapBasedInputRow(1605260800000L, dimNames2, event);
        indexF.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "kiwi");
        event.put("dimB", "raw");
        event.put("metA", 8L);
        row = new MapBasedInputRow(1705264400000L, dimNames2, event);
        indexF.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "kiwi");
        event.put("dimB", "ripe");
        event.put("metA", 8L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexF.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "lemon");
        event.put("dimB", "raw");
        event.put("metA", 3L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexF.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "cherry");
        event.put("dimB", "ripe");
        event.put("metA", 2L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexF.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "cherry");
        event.put("dimB", "raw");
        event.put("metA", 7L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexF.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "avocado");
        event.put("dimB", "ripe");
        event.put("metA", 12L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexF.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "cherry");
        event.put("dimB", "raw");
        event.put("metA", 3L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexF.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "plum");
        event.put("dimB", "ripe");
        event.put("metA", 5L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexF.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "plum");
        event.put("dimB", "raw");
        event.put("metA", 3L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexF.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "lime");
        event.put("dimB", "ripe");
        event.put("metA", 7L);
        row = new MapBasedInputRow(1805264400000L, dimNames2, event);
        indexF.add((InputRow)row);
        File fileF = INDEX_MERGER_V9.persist(indexF, new File(this.tmpDir, "F"), IndexSpec.DEFAULT, null);
        QueryableIndex qindexF = INDEX_IO.loadIndex(fileF);
        this.groupByIndices = Arrays.asList(qindexA, qindexB, qindexC, qindexD, qindexE, qindexF);
        this.resourceCloser = Closer.create();
        this.setupGroupByFactory();
    }

    private void setupGroupByFactory() {
        this.executorService = Execs.multiThreaded((int)3, (String)"GroupByThreadPool[%d]");
        TestBufferPool bufferPool = TestBufferPool.offHeap(10000000, Integer.MAX_VALUE);
        TestBufferPool mergePool = TestBufferPool.offHeap(10000000, 2);
        TestBufferPool mergePool2 = TestBufferPool.offHeap(10000000, 2);
        this.resourceCloser.register(() -> {
            Assert.assertEquals((long)0L, (long)bufferPool.getOutstandingObjectCount());
            Assert.assertEquals((long)0L, (long)mergePool.getOutstandingObjectCount());
            Assert.assertEquals((long)0L, (long)mergePool2.getOutstandingObjectCount());
        });
        GroupByQueryConfig config = new GroupByQueryConfig(){

            public int getBufferGrouperInitialBuckets() {
                return -1;
            }

            public HumanReadableBytes getMaxOnDiskStorage() {
                return HumanReadableBytes.valueOf((long)1000000000L);
            }
        };
        config.setSingleThreaded(false);
        DruidProcessingConfig druidProcessingConfig = new DruidProcessingConfig(){

            public int getNumThreads() {
                return 2;
            }

            public String getFormatString() {
                return null;
            }
        };
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        GroupingEngine groupingEngine = new GroupingEngine(druidProcessingConfig, configSupplier, (NonBlockingPool)bufferPool, (BlockingPool)mergePool, TestHelper.makeJsonMapper(), new ObjectMapper((JsonFactory)new SmileFactory()), NOOP_QUERYWATCHER);
        GroupingEngine groupingEngine2 = new GroupingEngine(druidProcessingConfig, configSupplier, (NonBlockingPool)bufferPool, (BlockingPool)mergePool2, TestHelper.makeJsonMapper(), new ObjectMapper((JsonFactory)new SmileFactory()), NOOP_QUERYWATCHER);
        this.groupByFactory = new GroupByQueryRunnerFactory(groupingEngine, new GroupByQueryQueryToolChest(groupingEngine));
        this.groupByFactory2 = new GroupByQueryRunnerFactory(groupingEngine2, new GroupByQueryQueryToolChest(groupingEngine2));
    }

    @After
    public void tearDown() throws Exception {
        for (IncrementalIndex incrementalIndex : this.incrementalIndices) {
            incrementalIndex.close();
        }
        for (QueryableIndex queryableIndex : this.groupByIndices) {
            queryableIndex.close();
        }
        this.resourceCloser.close();
        if (this.tmpDir != null) {
            FileUtils.deleteDirectory((File)this.tmpDir);
        }
    }

    @Test
    public void testDescendingNumerics() {
        QueryToolChest toolChest = this.groupByFactory.getToolchest();
        FinalizeResultsQueryRunner theRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.groupByFactory.mergeRunners(this.executorService, this.getRunner1(2))), toolChest);
        FinalizeResultsQueryRunner theRunner2 = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.groupByFactory2.mergeRunners(this.executorService, this.getRunner2(3))), toolChest);
        FinalizeResultsQueryRunner finalRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults((QueryRunner)new QueryRunner<ResultRow>((QueryRunner)theRunner, (QueryRunner)theRunner2){
            final /* synthetic */ QueryRunner val$theRunner;
            final /* synthetic */ QueryRunner val$theRunner2;
            {
                this.val$theRunner = queryRunner;
                this.val$theRunner2 = queryRunner2;
            }

            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)this.val$theRunner.run(queryPlus, responseContext), (Object)this.val$theRunner2.run(queryPlus, responseContext))).flatMerge(Function.identity(), queryPlus.getQuery().getResultOrdering());
            }
        }), toolChest);
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)1500000000000L, (long)1900000000000L)));
        DefaultLimitSpec ls2 = new DefaultLimitSpec(Arrays.asList(new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC), new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC), new OrderByColumnSpec("d2", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(100));
        GroupByQuery query = GroupByQuery.builder().setDataSource("blah").setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("d0:v", "timestamp_extract(\"__time\",'YEAR','UTC')", ColumnType.LONG, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("d1:v", "timestamp_extract(\"__time\",'MONTH','UTC')", ColumnType.LONG, TestExprMacroTable.INSTANCE), new ExpressionVirtualColumn("d2:v", "timestamp_extract(\"__time\",'DAY','UTC')", ColumnType.LONG, TestExprMacroTable.INSTANCE)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0:v", "d0", ColumnType.LONG), new DefaultDimensionSpec("d1:v", "d1", ColumnType.LONG), new DefaultDimensionSpec("d2:v", "d2", ColumnType.LONG)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setLimitSpec((LimitSpec)ls2).setContext((Map)ImmutableMap.of((Object)"applyLimitPushDown", (Object)true)).setGranularity(Granularities.ALL).build();
        Sequence queryResult = finalRunner.run(QueryPlus.wrap((Query)query), ResponseContext.createEmpty());
        List results = queryResult.toList();
        ResultRow expectedRow0 = GroupByQueryRunnerTestHelper.createExpectedRow(query, "2017-07-14T02:40:00.000Z", "d0", 2027L, "d1", 3L, "d2", 17L, "a0", 2L);
        ResultRow expectedRow1 = GroupByQueryRunnerTestHelper.createExpectedRow(query, "2017-07-14T02:40:00.000Z", "d0", 2024L, "d1", 1L, "d2", 14L, "a0", 2L);
        ResultRow expectedRow2 = GroupByQueryRunnerTestHelper.createExpectedRow(query, "2017-07-14T02:40:00.000Z", "d0", 2020L, "d1", 11L, "d2", 13L, "a0", 2L);
        ResultRow expectedRow3 = GroupByQueryRunnerTestHelper.createExpectedRow(query, "2017-07-14T02:40:00.000Z", "d0", 2017L, "d1", 9L, "d2", 13L, "a0", 2L);
        System.out.println(results);
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)expectedRow0, results.get(0));
        Assert.assertEquals((Object)expectedRow1, results.get(1));
        Assert.assertEquals((Object)expectedRow2, results.get(2));
        Assert.assertEquals((Object)expectedRow3, results.get(3));
    }

    @Test
    public void testPartialLimitPushDownMerge() {
        QueryToolChest toolChest = this.groupByFactory.getToolchest();
        FinalizeResultsQueryRunner theRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.groupByFactory.mergeRunners(this.executorService, this.getRunner1(0))), toolChest);
        FinalizeResultsQueryRunner theRunner2 = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.groupByFactory2.mergeRunners(this.executorService, this.getRunner2(1))), toolChest);
        FinalizeResultsQueryRunner finalRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults((QueryRunner)new QueryRunner<ResultRow>((QueryRunner)theRunner, (QueryRunner)theRunner2){
            final /* synthetic */ QueryRunner val$theRunner;
            final /* synthetic */ QueryRunner val$theRunner2;
            {
                this.val$theRunner = queryRunner;
                this.val$theRunner2 = queryRunner2;
            }

            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)this.val$theRunner.run(queryPlus, responseContext), (Object)this.val$theRunner2.run(queryPlus, responseContext))).flatMerge(Function.identity(), queryPlus.getQuery().getResultOrdering());
            }
        }), toolChest);
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)1500000000000L, (long)1600000000000L)));
        GroupByQuery query = GroupByQuery.builder().setDataSource("blah").setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimA", "dimA"), new ExtractionDimensionSpec("__time", "hour", ColumnType.LONG, (ExtractionFn)new TimeFormatExtractionFn(null, null, null, (Granularity)new PeriodGranularity(new Period((Object)"PT1H"), null, DateTimeZone.UTC), true))}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("metASum", "metA")}).setLimitSpec((LimitSpec)new DefaultLimitSpec(Arrays.asList(new OrderByColumnSpec("hour", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC), new OrderByColumnSpec("dimA", OrderByColumnSpec.Direction.ASCENDING)), Integer.valueOf(1000))).setContext((Map)ImmutableMap.of((Object)"applyLimitPushDown", (Object)true)).setGranularity(Granularities.ALL).build();
        Sequence queryResult = finalRunner.run(QueryPlus.wrap((Query)query), ResponseContext.createEmpty());
        List results = queryResult.toList();
        ResultRow expectedRow0 = GroupByQueryRunnerTestHelper.createExpectedRow(query, "2017-07-14T02:40:00.000Z", "dimA", "mango", "hour", 1505260800000L, "metASum", 26L);
        ResultRow expectedRow1 = GroupByQueryRunnerTestHelper.createExpectedRow(query, "2017-07-14T02:40:00.000Z", "dimA", "pomegranate", "hour", 1505260800000L, "metASum", 7113L);
        ResultRow expectedRow2 = GroupByQueryRunnerTestHelper.createExpectedRow(query, "2017-07-14T02:40:00.000Z", "dimA", "mango", "hour", 1505264400000L, "metASum", 10L);
        ResultRow expectedRow3 = GroupByQueryRunnerTestHelper.createExpectedRow(query, "2017-07-14T02:40:00.000Z", "dimA", "pomegranate", "hour", 1505264400000L, "metASum", 7726L);
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)expectedRow0, results.get(0));
        Assert.assertEquals((Object)expectedRow1, results.get(1));
        Assert.assertEquals((Object)expectedRow2, results.get(2));
        Assert.assertEquals((Object)expectedRow3, results.get(3));
    }

    @Test
    public void testForcePushLimitDownAccuracyWhenSortHasNonGroupingFields() {
        List<ResultRow> resultsWithoutLimitPushDown = this.testForcePushLimitDownAccuracyWhenSortHasNonGroupingFieldsHelper((Map<String, Object>)ImmutableMap.of());
        List<ResultRow> resultsWithLimitPushDown = this.testForcePushLimitDownAccuracyWhenSortHasNonGroupingFieldsHelper((Map<String, Object>)ImmutableMap.of((Object)"applyLimitPushDown", (Object)true, (Object)"forceLimitPushDown", (Object)true));
        ImmutableList expectedResults = ImmutableList.of((Object)ResultRow.of((Object[])new Object[]{"mango", "ripe", 16}), (Object)ResultRow.of((Object[])new Object[]{"kiwi", "raw", 15}), (Object)ResultRow.of((Object[])new Object[]{"watermelon", "ripe", 14}), (Object)ResultRow.of((Object[])new Object[]{"avocado", "ripe", 12}), (Object)ResultRow.of((Object[])new Object[]{"orange", "raw", 11}));
        Assert.assertEquals((Object)expectedResults.toString(), (Object)resultsWithoutLimitPushDown.toString());
        Assert.assertEquals((Object)expectedResults.toString(), (Object)resultsWithLimitPushDown.toString());
    }

    private List<ResultRow> testForcePushLimitDownAccuracyWhenSortHasNonGroupingFieldsHelper(Map<String, Object> context) {
        QueryToolChest toolChest = this.groupByFactory.getToolchest();
        FinalizeResultsQueryRunner theRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.groupByFactory.mergeRunners(this.executorService, this.getRunner1(4))), toolChest);
        FinalizeResultsQueryRunner theRunner2 = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.groupByFactory2.mergeRunners(this.executorService, this.getRunner2(5))), toolChest);
        FinalizeResultsQueryRunner finalRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults((QueryRunner)new QueryRunner<ResultRow>((QueryRunner)theRunner, (QueryRunner)theRunner2){
            final /* synthetic */ QueryRunner val$theRunner;
            final /* synthetic */ QueryRunner val$theRunner2;
            {
                this.val$theRunner = queryRunner;
                this.val$theRunner2 = queryRunner2;
            }

            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                return Sequences.simple((Iterable)ImmutableList.of((Object)this.val$theRunner.run(queryPlus, responseContext), (Object)this.val$theRunner2.run(queryPlus, responseContext))).flatMerge(Function.identity(), queryPlus.getQuery().getResultOrdering());
            }
        }), toolChest);
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)1500000000000L, (long)1900000000000L)));
        DefaultLimitSpec ls = new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(5));
        GroupByQuery query = GroupByQuery.builder().setDataSource("blah").setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dimA", "d0", ColumnType.STRING), new DefaultDimensionSpec("dimB", "d1", ColumnType.STRING)}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "metA")}).setLimitSpec((LimitSpec)ls).setContext(context).setGranularity(Granularities.ALL).build();
        Sequence queryResult = finalRunner.run(QueryPlus.wrap((Query)query), ResponseContext.createEmpty());
        return queryResult.toList();
    }

    private List<QueryRunner<ResultRow>> getRunner1(int qIndexNumber) {
        ArrayList<QueryRunner<ResultRow>> runners = new ArrayList<QueryRunner<ResultRow>>();
        QueryableIndex index = this.groupByIndices.get(qIndexNumber);
        QueryRunner<ResultRow> runner = GroupByLimitPushDownMultiNodeMergeTest.makeQueryRunner(this.groupByFactory, SegmentId.dummy((String)index.toString()), (Segment)new QueryableIndexSegment(index, SegmentId.dummy((String)index.toString())));
        runners.add(this.groupByFactory.getToolchest().preMergeQueryDecoration(runner));
        return runners;
    }

    private List<QueryRunner<ResultRow>> getRunner2(int qIndexNumber) {
        ArrayList<QueryRunner<ResultRow>> runners = new ArrayList<QueryRunner<ResultRow>>();
        QueryableIndex index2 = this.groupByIndices.get(qIndexNumber);
        QueryRunner<ResultRow> tooSmallRunner = GroupByLimitPushDownMultiNodeMergeTest.makeQueryRunner(this.groupByFactory2, SegmentId.dummy((String)index2.toString()), (Segment)new QueryableIndexSegment(index2, SegmentId.dummy((String)index2.toString())));
        runners.add(this.groupByFactory2.getToolchest().preMergeQueryDecoration(tooSmallRunner));
        return runners;
    }

    public static <T, QueryType extends Query<T>> QueryRunner<T> makeQueryRunner(QueryRunnerFactory<T, QueryType> factory, SegmentId segmentId, Segment adapter) {
        return new FinalizeResultsQueryRunner((QueryRunner)new BySegmentQueryRunner(segmentId, adapter.getDataInterval().getStart(), factory.createRunner(adapter)), factory.getToolchest());
    }

    static {
        JSON_MAPPER.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class, (Object)ExprMacroTable.nil()));
        INDEX_IO = new IndexIO(JSON_MAPPER, new ColumnConfig(){});
        INDEX_MERGER_V9 = new IndexMergerV9(JSON_MAPPER, INDEX_IO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        NOOP_QUERYWATCHER = (query, future) -> {};
    }
}

