/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.TestGroupByBuffers;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryRunnerTest;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupByTimeseriesQueryRunnerTest
extends TimeseriesQueryRunnerTest {
    private static TestGroupByBuffers BUFFER_POOLS = null;

    @BeforeClass
    public static void setUpClass() {
        BUFFER_POOLS = TestGroupByBuffers.createDefault();
    }

    @AfterClass
    public static void tearDownClass() {
        BUFFER_POOLS.close();
        BUFFER_POOLS = null;
    }

    @Parameterized.Parameters(name="{0}, vectorize = {1}")
    public static Iterable<Object[]> constructorFeeder() {
        GroupByTimeseriesQueryRunnerTest.setUpClass();
        GroupByQueryConfig config = new GroupByQueryConfig();
        GroupByQueryRunnerFactory factory = GroupByQueryRunnerTest.makeQueryRunnerFactory(config, BUFFER_POOLS);
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (final QueryRunner runner : QueryRunnerTestHelper.makeQueryRunnersToMerge(factory)) {
            QueryRunner modifiedRunner = new QueryRunner(){

                public Sequence run(QueryPlus queryPlus, ResponseContext responseContext) {
                    ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
                    TimeseriesQuery tsQuery = (TimeseriesQuery)queryPlus.getQuery();
                    String timeDimension = tsQuery.getTimestampResultField();
                    ArrayList<VirtualColumn> virtualColumns = new ArrayList<VirtualColumn>(Arrays.asList(tsQuery.getVirtualColumns().getVirtualColumns()));
                    HashMap<String, Object> theContext = tsQuery.getContext();
                    if (timeDimension != null) {
                        theContext = new HashMap<String, Object>(tsQuery.getContext());
                        PeriodGranularity granularity = (PeriodGranularity)tsQuery.getGranularity();
                        virtualColumns.add((VirtualColumn)new ExpressionVirtualColumn("v0", StringUtils.format((String)"timestamp_floor(__time, '%s')", (Object[])new Object[]{granularity.getPeriod()}), ColumnType.LONG, TestExprMacroTable.INSTANCE));
                        theContext.put("timestampResultField", timeDimension);
                        try {
                            theContext.put("timestampResultFieldGranularity", jsonMapper.writeValueAsString((Object)granularity));
                        }
                        catch (JsonProcessingException e) {
                            throw new RuntimeException(e);
                        }
                        theContext.put("timestampResultFieldInOriginalDimensions", 0);
                    }
                    final GroupByQuery newQuery = GroupByQuery.builder().setDataSource(tsQuery.getDataSource()).setQuerySegmentSpec(tsQuery.getQuerySegmentSpec()).setGranularity(tsQuery.getGranularity()).setDimFilter(tsQuery.getDimensionsFilter()).setDimensions((List)(timeDimension == null ? ImmutableList.of() : ImmutableList.of((Object)new DefaultDimensionSpec("v0", timeDimension, ColumnType.LONG)))).setAggregatorSpecs(tsQuery.getAggregatorSpecs()).setPostAggregatorSpecs(tsQuery.getPostAggregatorSpecs()).setVirtualColumns(VirtualColumns.create(virtualColumns)).setLimit(tsQuery.getLimit()).setContext(theContext).build();
                    return Sequences.map((Sequence)runner.run(queryPlus.withQuery((Query)newQuery), responseContext), (Function)new Function<ResultRow, Result<TimeseriesResultValue>>(){

                        public Result<TimeseriesResultValue> apply(ResultRow input) {
                            MapBasedRow mapBasedRow = input.toMapBasedRow(newQuery);
                            return new Result(mapBasedRow.getTimestamp(), (Object)new TimeseriesResultValue(mapBasedRow.getEvent()));
                        }
                    });
                }

                public String toString() {
                    return runner.toString();
                }
            };
            UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false, (Object)true).iterator();
            while (unmodifiableIterator.hasNext()) {
                boolean vectorize = (Boolean)unmodifiableIterator.next();
                if (vectorize && !QueryRunnerTestHelper.isTestRunnerVectorizable(runner)) continue;
                constructors.add(new Object[]{modifiedRunner, vectorize});
            }
        }
        return constructors;
    }

    public GroupByTimeseriesQueryRunnerTest(QueryRunner runner, boolean vectorize) {
        super((QueryRunner<Result<TimeseriesResultValue>>)runner, false, vectorize, QueryRunnerTestHelper.COMMON_DOUBLE_AGGREGATORS);
    }

    @Override
    @Test
    public void testFullOnTimeseriesMaxMin() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(Granularities.ALL).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")}).descending(this.descending).build();
        DateTime expectedEarliest = DateTimes.of((String)"1970-01-01");
        DateTime expectedLast = DateTimes.of((String)"2011-04-15");
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        Result result = (Result)results.iterator().next();
        Assert.assertEquals((Object)expectedEarliest, (Object)result.getTimestamp());
        Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{result.getTimestamp(), expectedLast}), (boolean)result.getTimestamp().isAfter((ReadableInstant)expectedLast));
        TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
        Assert.assertEquals((String)result.toString(), (double)1870.061029, (double)value.getDoubleMetric("maxIndex"), (double)0.0018700610289999998);
        Assert.assertEquals((String)result.toString(), (double)59.021022, (double)value.getDoubleMetric("minIndex"), (double)5.9021021999999996E-5);
    }

    @Override
    @Test
    public void testFullOnTimeseriesMinMaxAggregators() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(Granularities.ALL).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.INDEX_LONG_MIN, QueryRunnerTestHelper.INDEX_LONG_MAX, QueryRunnerTestHelper.INDEX_DOUBLE_MIN, QueryRunnerTestHelper.INDEX_DOUBLE_MAX, QueryRunnerTestHelper.INDEX_FLOAT_MIN, QueryRunnerTestHelper.INDEX_FLOAT_MAX}).descending(this.descending).build();
        DateTime expectedEarliest = DateTimes.of((String)"1970-01-01");
        DateTime expectedLast = DateTimes.of((String)"2011-04-15");
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        Result result = (Result)results.iterator().next();
        Assert.assertEquals((Object)expectedEarliest, (Object)result.getTimestamp());
        Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{result.getTimestamp(), expectedLast}), (boolean)result.getTimestamp().isAfter((ReadableInstant)expectedLast));
        Assert.assertEquals((long)59L, (long)((TimeseriesResultValue)result.getValue()).getLongMetric("longMinIndex"));
        Assert.assertEquals((long)1870L, (long)((TimeseriesResultValue)result.getValue()).getLongMetric("longMaxIndex"));
        Assert.assertEquals((double)59.021022, (double)((TimeseriesResultValue)result.getValue()).getDoubleMetric("doubleMinIndex"), (double)0.0);
        Assert.assertEquals((double)1870.061029, (double)((TimeseriesResultValue)result.getValue()).getDoubleMetric("doubleMaxIndex"), (double)0.0);
        Assert.assertEquals((float)59.021023f, (float)((TimeseriesResultValue)result.getValue()).getFloatMetric("floatMinIndex").floatValue(), (float)0.0f);
        Assert.assertEquals((float)1870.061f, (float)((TimeseriesResultValue)result.getValue()).getFloatMetric("floatMaxIndex").floatValue(), (float)0.0f);
    }

    @Override
    public void testEmptyTimeseries() {
    }

    @Override
    public void testFullOnTimeseries() {
    }

    @Override
    public void testFullOnTimeseriesWithFilter() {
    }

    @Override
    public void testTimeseriesQueryZeroFilling() {
    }

    @Override
    public void testTimeseriesWithNonExistentFilter() {
    }

    @Override
    public void testTimeseriesWithNonExistentFilterAndMultiDim() {
    }

    @Override
    public void testTimeseriesWithFilterOnNonExistentDimension() {
    }

    @Override
    public void testTimeseriesWithExpressionAggregatorTooBig() {
        this.cannotVectorize();
        if (!this.vectorize) {
            this.expectedException.expectMessage("Unable to serialize [ARRAY<STRING>]");
        }
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(Granularities.DAY).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(Collections.singletonList(new ExpressionLambdaAggregatorFactory("array_agg_distinct", (Set)ImmutableSet.of((Object)"market"), "acc", "[]", null, null, Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(acc, market)", "array_set_add_all(acc, array_agg_distinct)", null, null, HumanReadableBytes.valueOf((int)10), TestExprMacroTable.INSTANCE))).descending(this.descending).context(this.makeContext()).build();
        this.runner.run(QueryPlus.wrap((Query)query)).toList();
    }

    @Override
    @Test
    public void testTimeseriesWithInvertedFilterOnNonExistentDimension() {
        if (NullHandling.replaceWithDefault()) {
            super.testTimeseriesWithInvertedFilterOnNonExistentDimension();
            return;
        }
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).filters((DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("bobby", "sally", null))).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.aggregatorFactoryList).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).context(this.makeContext()).build();
        List results = this.runner.run(QueryPlus.wrap((Query)query)).toList();
        Assert.assertEquals(Collections.emptyList(), (Object)results);
    }
}

