/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import javax.annotation.Nullable;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.TestBufferPool;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.junit.Assert;

public class TestGroupByBuffers
implements Closeable {
    private final int bufferSize;
    private final int numMergeBuffers;
    @Nullable
    private TestBufferPool processingPool;
    @Nullable
    private TestBufferPool mergePool;

    public TestGroupByBuffers(int bufferSize, int numMergeBuffers) {
        this.bufferSize = bufferSize;
        this.numMergeBuffers = numMergeBuffers;
        this.processingPool = TestBufferPool.offHeap(bufferSize, Integer.MAX_VALUE);
        this.mergePool = TestBufferPool.offHeap(bufferSize, numMergeBuffers);
    }

    public static TestGroupByBuffers createFromProcessingConfig(DruidProcessingConfig config) {
        return new TestGroupByBuffers(config.intermediateComputeSizeBytes(), config.getNumMergeBuffers());
    }

    public static TestGroupByBuffers createDefault() {
        return TestGroupByBuffers.createFromProcessingConfig(GroupByQueryRunnerTest.DEFAULT_PROCESSING_CONFIG);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getNumMergeBuffers() {
        return this.numMergeBuffers;
    }

    public TestBufferPool getProcessingPool() {
        return (TestBufferPool)Preconditions.checkNotNull((Object)this.processingPool, (Object)"processingPool");
    }

    public TestBufferPool getMergePool() {
        return (TestBufferPool)Preconditions.checkNotNull((Object)this.mergePool, (Object)"mergePool");
    }

    @Override
    public void close() {
        if (this.processingPool != null) {
            Assert.assertEquals((long)0L, (long)this.processingPool.getOutstandingObjectCount());
            this.processingPool = null;
        }
        if (this.mergePool != null) {
            if (this.mergePool.getOutstandingObjectCount() != 0L) {
                throw this.mergePool.getOutstandingExceptionsCreated().iterator().next();
            }
            this.mergePool = null;
        }
    }
}

