/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DirectQueryProcessingPool;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.StringFormatExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.TestGroupByBuffers;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnnestGroupByQueryRunnerTest
extends InitializedNullHandlingTest {
    private static TestGroupByBuffers BUFFER_POOLS = null;
    private final GroupByQueryRunnerFactory factory;
    private final GroupByQueryConfig config;
    private final boolean vectorize;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public UnnestGroupByQueryRunnerTest(GroupByQueryConfig config, GroupByQueryRunnerFactory factory, boolean vectorize) {
        this.config = config;
        this.factory = factory;
        this.vectorize = vectorize;
    }

    public static List<GroupByQueryConfig> testConfigs() {
        GroupByQueryConfig v2Config = new GroupByQueryConfig(){

            public int getBufferGrouperInitialBuckets() {
                return 4;
            }

            public String toString() {
                return "v2";
            }
        };
        return ImmutableList.of((Object)v2Config);
    }

    public static GroupByQueryRunnerFactory makeQueryRunnerFactory(GroupByQueryConfig config, TestGroupByBuffers bufferPools) {
        return UnnestGroupByQueryRunnerTest.makeQueryRunnerFactory(GroupByQueryRunnerTest.DEFAULT_MAPPER, config, bufferPools, GroupByQueryRunnerTest.DEFAULT_PROCESSING_CONFIG);
    }

    public static GroupByQueryRunnerFactory makeQueryRunnerFactory(ObjectMapper mapper, GroupByQueryConfig config, TestGroupByBuffers bufferPools) {
        return UnnestGroupByQueryRunnerTest.makeQueryRunnerFactory(mapper, config, bufferPools, GroupByQueryRunnerTest.DEFAULT_PROCESSING_CONFIG);
    }

    public static GroupByQueryRunnerFactory makeQueryRunnerFactory(ObjectMapper mapper, GroupByQueryConfig config, TestGroupByBuffers bufferPools, DruidProcessingConfig processingConfig) {
        if (bufferPools.getBufferSize() != processingConfig.intermediateComputeSizeBytes()) {
            throw new ISE("Provided buffer size [%,d] does not match configured size [%,d]", new Object[]{bufferPools.getBufferSize(), processingConfig.intermediateComputeSizeBytes()});
        }
        if (bufferPools.getNumMergeBuffers() != processingConfig.getNumMergeBuffers()) {
            throw new ISE("Provided merge buffer count [%,d] does not match configured count [%,d]", new Object[]{bufferPools.getNumMergeBuffers(), processingConfig.getNumMergeBuffers()});
        }
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        GroupingEngine groupingEngine = new GroupingEngine(processingConfig, configSupplier, (NonBlockingPool)bufferPools.getProcessingPool(), (BlockingPool)bufferPools.getMergePool(), TestHelper.makeJsonMapper(), mapper, QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        GroupByQueryQueryToolChest toolChest = new GroupByQueryQueryToolChest(groupingEngine);
        return new GroupByQueryRunnerFactory(groupingEngine, toolChest);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() {
        NullHandling.initializeForTests();
        UnnestGroupByQueryRunnerTest.setUpClass();
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (GroupByQueryConfig config : UnnestGroupByQueryRunnerTest.testConfigs()) {
            GroupByQueryRunnerFactory factory = UnnestGroupByQueryRunnerTest.makeQueryRunnerFactory(config, BUFFER_POOLS);
            UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false).iterator();
            while (unmodifiableIterator.hasNext()) {
                boolean vectorize = (Boolean)unmodifiableIterator.next();
                constructors.add(new Object[]{config, factory, vectorize});
            }
        }
        return constructors;
    }

    @BeforeClass
    public static void setUpClass() {
        if (BUFFER_POOLS == null) {
            BUFFER_POOLS = TestGroupByBuffers.createDefault();
        }
    }

    @AfterClass
    public static void tearDownClass() {
        BUFFER_POOLS.close();
        BUFFER_POOLS = null;
    }

    private static ResultRow makeRow(GroupByQuery query, String timestamp, Object ... vals) {
        return GroupByQueryRunnerTestHelper.createExpectedRow(query, timestamp, vals);
    }

    @Test
    public void testGroupBy() {
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "\"placementish\"", null, ExprMacroTable.nil()), null)).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index")}).setGranularity(QueryRunnerTestHelper.DAY_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "automotive", "rows", 2L, "idx", 270L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "business", "rows", 2L, "idx", 236L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "entertainment", "rows", 2L, "idx", 316L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "health", "rows", 2L, "idx", 240L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "mezzanine", "rows", 6L, "idx", 5740L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "news", "rows", 2L, "idx", 242L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "premium", "rows", 6L, "idx", 5800L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "technology", "rows", 2L, "idx", 156L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias", "travel", "rows", 2L, "idx", 238L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "automotive", "rows", 2L, "idx", 294L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "business", "rows", 2L, "idx", 224L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "entertainment", "rows", 2L, "idx", 332L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "health", "rows", 2L, "idx", 226L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "mezzanine", "rows", 6L, "idx", 4894L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "news", "rows", 2L, "idx", 228L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "premium", "rows", 6L, "idx", 5010L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "technology", "rows", 2L, "idx", 194L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-02", "alias", "travel", "rows", 2L, "idx", 252L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy");
    }

    @Test
    public void testGroupByOnMissingColumn() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "\"placementish\"", null, ExprMacroTable.nil()), null)).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("nonexistent0", "alias0"), new ExtractionDimensionSpec("nonexistent1", "alias1", (ExtractionFn)new StringFormatExtractionFn("foo"))}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Collections.singletonList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", null, "alias1", "foo", "rows", 52L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "missing-column");
    }

    @Test
    public void testGroupByOnUnnestedColumn() {
        this.cannotVectorize();
        GroupByQuery query = this.makeQueryBuilder().setDataSource(QueryRunnerTestHelper.UNNEST_DATA_SOURCE).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish_unnest", "alias0")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "a", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "b", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "e", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "h", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "m", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "n", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "p", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "preferred", "rows", 26L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "t", "rows", 4L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-column");
    }

    @Test
    public void testGroupByOnUnnestedVirtualColumn() {
        this.cannotVectorize();
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "mv_to_array(placementish)", ColumnType.STRING_ARRAY, TestExprMacroTable.INSTANCE), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)unnestDataSource).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish_unnest", "alias0")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).addOrderByColumn("alias0", OrderByColumnSpec.Direction.ASCENDING).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "a", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "b", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "e", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "h", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "m", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "n", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "p", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "preferred", "rows", 26L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "t", "rows", 4L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-virtual-column");
    }

    @Test
    public void testGroupByOnUnnestedVirtualMultiColumn() {
        this.cannotVectorize();
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "array(\"market\",\"quality\")", ColumnType.STRING, TestExprMacroTable.INSTANCE), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)unnestDataSource).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish_unnest", "alias0")}).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).setLimit(3).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "automotive", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "business", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "entertainment", "rows", 2L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-virtual-columns");
    }

    private GroupByQuery.Builder makeQueryBuilder() {
        return GroupByQuery.builder().overrideContext(this.makeContext());
    }

    private Iterable<ResultRow> runQuery(GroupByQuery query, IncrementalIndex index) {
        QueryRunner queryRunner = this.factory.mergeRunners((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, Collections.singletonList(QueryRunnerTestHelper.makeQueryRunnerWithSegmentMapFn(this.factory, (Segment)new IncrementalIndexSegment(index, QueryRunnerTestHelper.SEGMENT_ID), query, "rtIndexvc")));
        return GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)this.factory, queryRunner, query);
    }

    @Test
    public void testGroupByOnUnnestedFilterMatch() {
        this.cannotVectorize();
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "\"placementish\"", null, ExprMacroTable.nil()), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)unnestDataSource).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish_unnest", "alias0")}).setDimFilter((DimFilter)new EqualityFilter("placementish_unnest", ColumnType.STRING, (Object)"a", null)).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).addOrderByColumn("alias0", OrderByColumnSpec.Direction.ASCENDING).build();
        List<ResultRow> expectedResults = Collections.singletonList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "a", "rows", 2L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-virtual-column");
    }

    @Test
    public void testGroupByOnUnnestedNotFilterMatch() {
        this.cannotVectorize();
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "\"placementish\"", null, ExprMacroTable.nil()), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)unnestDataSource).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish_unnest", "alias0")}).setDimFilter((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("placementish_unnest", ColumnType.STRING, (Object)"a", null))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).addOrderByColumn("alias0", OrderByColumnSpec.Direction.ASCENDING).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "b", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "e", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "h", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "m", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "n", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "p", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "preferred", "rows", 26L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "t", "rows", 4L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-virtual-column");
    }

    @Test
    public void testGroupByOnUnnestedNotFilterMatchNonexistentValue() {
        this.cannotVectorize();
        UnnestDataSource unnestDataSource = UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "\"placementish\"", null, ExprMacroTable.nil()), null);
        GroupByQuery query = this.makeQueryBuilder().setDataSource((DataSource)unnestDataSource).setQuerySegmentSpec(QueryRunnerTestHelper.FIRST_TO_THIRD).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("placementish_unnest", "alias0")}).setDimFilter((DimFilter)NotDimFilter.of((DimFilter)new EqualityFilter("placementish_unnest", ColumnType.STRING, (Object)"noexist", null))).setAggregatorSpecs(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT}).setGranularity(QueryRunnerTestHelper.ALL_GRAN).addOrderByColumn("alias0", OrderByColumnSpec.Direction.ASCENDING).build();
        List<ResultRow> expectedResults = Arrays.asList(UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "a", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "b", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "e", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "h", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "m", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "n", "rows", 2L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "p", "rows", 6L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "preferred", "rows", 26L), UnnestGroupByQueryRunnerTest.makeRow(query, "2011-04-01", "alias0", "t", "rows", 4L));
        Iterable<ResultRow> results = this.runQuery(query, TestIndex.getIncrementalTestIndex());
        TestHelper.assertExpectedObjects(expectedResults, results, "groupBy-on-unnested-virtual-column");
    }

    private Map<String, Object> makeContext() {
        return ImmutableMap.builder().put((Object)"vectorize", (Object)(this.vectorize ? "force" : "false")).put((Object)"vectorizeVirtualColumns", (Object)(this.vectorize ? "force" : "false")).put((Object)"vectorSize", (Object)16).build();
    }

    private void cannotVectorize() {
        if (this.vectorize) {
            this.expectedException.expect(RuntimeException.class);
            this.expectedException.expectMessage("Cannot vectorize!");
        }
    }
}

