/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.IntKey;

public class IntKeySerde
implements Grouper.KeySerde<IntKey> {
    public static final Grouper.KeySerde<IntKey> INSTANCE = new IntKeySerde();
    public static final Grouper.BufferComparator KEY_COMPARATOR = new Grouper.BufferComparator(){

        public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
            return Ints.compare((int)lhsBuffer.getInt(lhsPosition), (int)rhsBuffer.getInt(rhsPosition));
        }
    };
    private final ByteBuffer buf = ByteBuffer.allocate(4);

    public int keySize() {
        return 4;
    }

    public Class<IntKey> keyClazz() {
        return IntKey.class;
    }

    public List<String> getDictionary() {
        return ImmutableList.of();
    }

    public ByteBuffer toByteBuffer(IntKey key) {
        this.buf.putInt(0, key.intValue());
        this.buf.position(0);
        return this.buf;
    }

    public IntKey createKey() {
        return new IntKey(0);
    }

    public void readFromByteBuffer(IntKey key, ByteBuffer buffer, int position) {
        key.setValue(buffer.getInt(position));
    }

    public Grouper.BufferComparator bufferComparator() {
        return KEY_COMPARATOR;
    }

    public Grouper.BufferComparator bufferComparatorWithAggregators(AggregatorFactory[] aggregatorFactories, int[] aggregatorOffsets) {
        return KEY_COMPARATOR;
    }

    public void reset() {
    }
}

