/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.column.ArrayStringGroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.data.ComparableIntArray;
import org.apache.druid.segment.data.ComparableStringArray;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ArrayStringGroupByColumnSelectorStrategyTest {
    private final BiMap<String, Integer> dictionaryInt = HashBiMap.create();
    private final BiMap<ComparableIntArray, Integer> indexedIntArrays = HashBiMap.create();
    private final ByteBuffer buffer1 = ByteBuffer.allocate(4);
    private final ByteBuffer buffer2 = ByteBuffer.allocate(4);
    private ArrayStringGroupByColumnSelectorStrategy strategy;

    @Before
    public void setup() {
        this.strategy = new ArrayStringGroupByColumnSelectorStrategy(this.dictionaryInt, this.indexedIntArrays);
        this.dictionaryInt.put((Object)"a", (Object)0);
        this.dictionaryInt.put((Object)"b", (Object)1);
        this.dictionaryInt.put((Object)"bd", (Object)2);
        this.dictionaryInt.put((Object)"d", (Object)3);
        this.dictionaryInt.put((Object)"e", (Object)4);
        this.indexedIntArrays.put((Object)ComparableIntArray.of((int[])new int[]{0, 1}), (Object)0);
        this.indexedIntArrays.put((Object)ComparableIntArray.of((int[])new int[]{2, 4}), (Object)1);
        this.indexedIntArrays.put((Object)ComparableIntArray.of((int[])new int[]{0, 2}), (Object)2);
    }

    @Test
    public void testKeySize() {
        Assert.assertEquals((long)4L, (long)this.strategy.getGroupingKeySize());
    }

    @Test
    public void testWriteKey() {
        this.strategy.writeToKeyBuffer(0, 1, this.buffer1);
        Assert.assertEquals((long)1L, (long)this.buffer1.getInt(0));
    }

    @Test
    public void testBufferComparatorCanCompareIntsAndNullStringComparatorShouldUseLexicographicComparator() {
        this.buffer1.putInt(1);
        this.buffer2.putInt(2);
        Grouper.BufferComparator comparator = this.strategy.bufferComparator(0, null);
        Assert.assertTrue((comparator.compare(this.buffer1, this.buffer2, 0, 0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(this.buffer2, this.buffer1, 0, 0) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBufferComparatorCanCompareIntsAndLexicographicStringComparatorShouldUseLexicographicComparator() {
        this.buffer1.putInt(1);
        this.buffer2.putInt(2);
        Grouper.BufferComparator comparator = this.strategy.bufferComparator(0, StringComparators.LEXICOGRAPHIC);
        Assert.assertTrue((comparator.compare(this.buffer1, this.buffer2, 0, 0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(this.buffer2, this.buffer1, 0, 0) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBufferComparatorCanCompareIntsAndStrLenStringComparatorShouldUseLexicographicComparator() {
        this.buffer1.putInt(1);
        this.buffer2.putInt(2);
        Grouper.BufferComparator comparator = this.strategy.bufferComparator(0, StringComparators.STRLEN);
        Assert.assertTrue((comparator.compare(this.buffer1, this.buffer2, 0, 0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(this.buffer2, this.buffer1, 0, 0) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSanity() {
        ColumnValueSelector columnValueSelector = (ColumnValueSelector)Mockito.mock(ColumnValueSelector.class);
        Mockito.when((Object)columnValueSelector.getObject()).thenReturn((Object)ImmutableList.of((Object)"a", (Object)"b"));
        Assert.assertEquals((long)0L, (long)this.strategy.computeDictionaryId(columnValueSelector));
        GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
        Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
        ResultRow row = ResultRow.create((int)1);
        this.buffer1.putInt(0);
        this.strategy.processValueFromGroupingKey(groupByColumnSelectorPlus, this.buffer1, row, 0);
        Assert.assertEquals((Object)ComparableStringArray.of((String[])new String[]{"a", "b"}), (Object)row.get(0));
    }

    @Test
    public void testAddingInDictionary() {
        ColumnValueSelector columnValueSelector = (ColumnValueSelector)Mockito.mock(ColumnValueSelector.class);
        Mockito.when((Object)columnValueSelector.getObject()).thenReturn((Object)ImmutableList.of((Object)"f", (Object)"a"));
        Assert.assertEquals((long)3L, (long)this.strategy.computeDictionaryId(columnValueSelector));
        GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
        Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
        ResultRow row = ResultRow.create((int)1);
        this.buffer1.putInt(3);
        this.strategy.processValueFromGroupingKey(groupByColumnSelectorPlus, this.buffer1, row, 0);
        Assert.assertEquals((Object)ComparableStringArray.of((String[])new String[]{"f", "a"}), (Object)row.get(0));
    }

    @Test
    public void testAddingInDictionaryWithObjects() {
        ColumnValueSelector columnValueSelector = (ColumnValueSelector)Mockito.mock(ColumnValueSelector.class);
        Mockito.when((Object)columnValueSelector.getObject()).thenReturn((Object)new Object[]{"f", "a"});
        Assert.assertEquals((long)3L, (long)this.strategy.computeDictionaryId(columnValueSelector));
        GroupByColumnSelectorPlus groupByColumnSelectorPlus = (GroupByColumnSelectorPlus)Mockito.mock(GroupByColumnSelectorPlus.class);
        Mockito.when((Object)groupByColumnSelectorPlus.getResultRowPosition()).thenReturn((Object)0);
        ResultRow row = ResultRow.create((int)1);
        this.buffer1.putInt(3);
        this.strategy.processValueFromGroupingKey(groupByColumnSelectorPlus, this.buffer1, row, 0);
        Assert.assertEquals((Object)ComparableStringArray.of((String[])new String[]{"f", "a"}), (Object)row.get(0));
    }

    @After
    public void tearDown() {
        this.buffer1.clear();
        this.buffer2.clear();
    }
}

