/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupIntrospectHandler;
import org.apache.druid.query.lookup.LookupSegment;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.RowBasedStorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.timeline.SegmentId;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class LookupSegmentTest {
    public static final String LOOKUP_NAME = "mylookup";
    public static final Map<String, String> LOOKUP_MAP = ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)"b", (Comparable)((Object)"x"), (Object)"y");
    public static final LookupExtractorFactory LOOKUP_EXTRACTOR_FACTORY = new LookupExtractorFactory(){

        public boolean start() {
            return true;
        }

        public boolean close() {
            return true;
        }

        public boolean replaces(@Nullable LookupExtractorFactory other) {
            return true;
        }

        @Nullable
        public LookupIntrospectHandler getIntrospectHandler() {
            throw new UnsupportedOperationException("not needed for this test");
        }

        public void awaitInitialization() {
        }

        public boolean isInitialized() {
            return true;
        }

        public LookupExtractor get() {
            return new MapLookupExtractor(LOOKUP_MAP, false);
        }
    };
    private static final LookupSegment LOOKUP_SEGMENT = new LookupSegment("mylookup", LOOKUP_EXTRACTOR_FACTORY);

    @Test
    public void test_getId() {
        Assert.assertEquals((Object)SegmentId.dummy((String)LOOKUP_NAME), (Object)LOOKUP_SEGMENT.getId());
    }

    @Test
    public void test_getDataInterval() {
        Assert.assertEquals((Object)Intervals.ETERNITY, (Object)LOOKUP_SEGMENT.getDataInterval());
    }

    @Test
    public void test_asQueryableIndex() {
        Assert.assertNull((Object)LOOKUP_SEGMENT.asQueryableIndex());
    }

    @Test
    public void test_asStorageAdapter_getAvailableDimensions() {
        Assert.assertEquals((Object)ImmutableList.of((Object)"k", (Object)"v"), (Object)Lists.newArrayList((Iterator)LOOKUP_SEGMENT.asStorageAdapter().getAvailableDimensions().iterator()));
    }

    @Test
    public void test_asStorageAdapter_getAvailableMetrics() {
        Assert.assertEquals((Object)ImmutableList.of(), (Object)Lists.newArrayList((Iterable)LOOKUP_SEGMENT.asStorageAdapter().getAvailableMetrics()));
    }

    @Test
    public void test_asStorageAdapter_getColumnCapabilitiesK() {
        ColumnCapabilities capabilities = LOOKUP_SEGMENT.asStorageAdapter().getColumnCapabilities("k");
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
        Assert.assertTrue((boolean)capabilities.hasMultipleValues().isUnknown());
        Assert.assertFalse((boolean)capabilities.isDictionaryEncoded().isTrue());
    }

    @Test
    public void test_asStorageAdapter_getColumnCapabilitiesV() {
        ColumnCapabilities capabilities = LOOKUP_SEGMENT.asStorageAdapter().getColumnCapabilities("v");
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
        Assert.assertTrue((boolean)capabilities.hasMultipleValues().isUnknown());
        Assert.assertFalse((boolean)capabilities.isDictionaryEncoded().isTrue());
    }

    @Test
    public void test_asStorageAdapter_getInterval() {
        Assert.assertEquals((Object)Intervals.ETERNITY, (Object)LOOKUP_SEGMENT.asStorageAdapter().getInterval());
    }

    @Test
    public void test_asStorageAdapter_getDimensionCardinalityK() {
        Assert.assertEquals((long)-1L, (long)LOOKUP_SEGMENT.asStorageAdapter().getDimensionCardinality("k"));
    }

    @Test
    public void test_asStorageAdapter_getDimensionCardinalityV() {
        Assert.assertEquals((long)-1L, (long)LOOKUP_SEGMENT.asStorageAdapter().getDimensionCardinality("v"));
    }

    @Test
    public void test_asStorageAdapter_makeCursors() {
        Sequence cursors = LOOKUP_SEGMENT.asStorageAdapter().makeCursors(null, Intervals.of((String)"1970/PT1H"), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        ArrayList kvs = new ArrayList();
        cursors.accumulate(null, (ignored, cursor) -> {
            ColumnValueSelector keySelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("k");
            ColumnValueSelector valueSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("v");
            while (!cursor.isDone()) {
                kvs.add(Pair.of((Object)String.valueOf(keySelector.getObject()), (Object)String.valueOf(valueSelector.getObject())));
                cursor.advanceUninterruptibly();
            }
            return null;
        });
        Assert.assertEquals((Object)ImmutableList.of((Object)Pair.of((Object)"a", (Object)"b"), (Object)Pair.of((Object)"x", (Object)"y")), kvs);
    }

    @Test
    public void test_asStorageAdapter_isRowBasedAdapter() {
        Assert.assertThat((Object)LOOKUP_SEGMENT.asStorageAdapter(), (Matcher)CoreMatchers.instanceOf(RowBasedStorageAdapter.class));
    }
}

