/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.druid.query.operator.InlineScanOperator;
import org.apache.druid.query.operator.NaivePartitioningOperator;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorTestHelper;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.junit.Test;

public class NaivePartitioningOperatorTest {
    @Test
    public void testDefaultImplementation() {
        MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"sorted", (Object)new IntArrayColumn(new int[]{0, 0, 0, 1, 1, 2, 4, 4, 4}), (Object)"unsorted", (Object)new IntArrayColumn(new int[]{3, 54, 21, 1, 5, 54, 2, 3, 92})));
        NaivePartitioningOperator op = new NaivePartitioningOperator((List)ImmutableList.of((Object)"sorted"), (Operator)InlineScanOperator.make(new RowsAndColumns[]{rac}));
        new OperatorTestHelper().expectRowsAndColumns(new RowsAndColumnsHelper().expectColumn("sorted", new int[]{0, 0, 0}).expectColumn("unsorted", new int[]{3, 54, 21}).allColumnsRegistered(), new RowsAndColumnsHelper().expectColumn("sorted", new int[]{1, 1}).expectColumn("unsorted", new int[]{1, 5}).allColumnsRegistered(), new RowsAndColumnsHelper().expectColumn("sorted", new int[]{2}).expectColumn("unsorted", new int[]{54}).allColumnsRegistered(), new RowsAndColumnsHelper().expectColumn("sorted", new int[]{4, 4, 4}).expectColumn("unsorted", new int[]{2, 3, 92}).allColumnsRegistered()).runToCompletion((Operator)op);
    }

    @Test
    public void testStopMidStream() {
        MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"sorted", (Object)new IntArrayColumn(new int[]{0, 0, 0, 1, 1, 2, 4, 4, 4}), (Object)"unsorted", (Object)new IntArrayColumn(new int[]{3, 54, 21, 1, 5, 54, 2, 3, 92})));
        NaivePartitioningOperator op = new NaivePartitioningOperator((List)ImmutableList.of((Object)"sorted"), (Operator)InlineScanOperator.make(new RowsAndColumns[]{rac}));
        new OperatorTestHelper().expectAndStopAfter(new RowsAndColumnsHelper().expectColumn("sorted", new int[]{0, 0, 0}).expectColumn("unsorted", new int[]{3, 54, 21}), new RowsAndColumnsHelper().expectColumn("sorted", new int[]{1, 1}).expectColumn("unsorted", new int[]{1, 5})).runToCompletion((Operator)op);
    }

    @Test
    public void testDoesNotValidateSort() {
        BiFunction<Integer, Integer, RowsAndColumnsHelper> singleHelperMaker = (sorted, unsorted) -> new RowsAndColumnsHelper().expectColumn("sorted", new int[]{sorted}).expectColumn("unsorted", new int[]{unsorted}).allColumnsRegistered();
        MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"sorted", (Object)new IntArrayColumn(new int[]{0, 0, 0, 1, 1, 2, 4, 4, 4}), (Object)"unsorted", (Object)new IntArrayColumn(new int[]{3, 54, 21, 1, 5, 54, 2, 3, 92})));
        NaivePartitioningOperator op = new NaivePartitioningOperator((List)ImmutableList.of((Object)"unsorted"), (Operator)InlineScanOperator.make(new RowsAndColumns[]{rac}));
        new OperatorTestHelper().expectRowsAndColumns(singleHelperMaker.apply(0, 3), singleHelperMaker.apply(0, 54), singleHelperMaker.apply(0, 21), singleHelperMaker.apply(1, 1), singleHelperMaker.apply(1, 5), singleHelperMaker.apply(2, 54), singleHelperMaker.apply(4, 2), singleHelperMaker.apply(4, 3), singleHelperMaker.apply(4, 92)).runToCompletion((Operator)op);
    }
}

