/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.operator.window.RowsAndColumnsHelper;
import org.apache.druid.query.operator.window.WindowFrame;
import org.apache.druid.query.operator.window.WindowFramedAggregateProcessor;
import org.apache.druid.query.rowsandcols.AsOnlyTestRowsAndColumns;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.NoAsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.semantic.FramedOnHeapAggregatable;
import org.junit.Assert;
import org.junit.Test;

public class WindowFramedAggregateProcessorTest {
    @Test
    public void testIsPassThruWhenRACReturnsSemanticInterface() {
        final WindowFrame theFrame = new WindowFrame(WindowFrame.PeerType.ROWS, true, 0, false, 0, null);
        final AggregatorFactory[] theAggs = new AggregatorFactory[]{new LongMaxAggregatorFactory("cummMax", "intCol"), new DoubleSumAggregatorFactory("cummSum", "doubleCol")};
        WindowFramedAggregateProcessor proc = new WindowFramedAggregateProcessor(theFrame, theAggs);
        final MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"yay", (Object)new IntArrayColumn(new int[]{1, 2, 3})));
        RowsAndColumns processed = proc.process((RowsAndColumns)new AsOnlyTestRowsAndColumns(){

            public <T> T as(Class<T> clazz) {
                Assert.assertEquals(clazz, FramedOnHeapAggregatable.class);
                return (T)((FramedOnHeapAggregatable)(frame, aggFactories) -> {
                    Assert.assertEquals((Object)theFrame, (Object)frame);
                    Assert.assertArrayEquals((Object[])theAggs, (Object[])aggFactories);
                    return rac;
                });
            }
        });
        Assert.assertSame((Object)rac, (Object)processed);
    }

    @Test
    public void testDoesStuffWhenNoSemanticInterfacesAvailable() {
        WindowFrame theFrame = new WindowFrame(WindowFrame.PeerType.ROWS, true, 0, false, 0, null);
        AggregatorFactory[] theAggs = new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "intCol")};
        WindowFramedAggregateProcessor proc = new WindowFramedAggregateProcessor(theFrame, theAggs);
        MapOfColumnsRowsAndColumns rac = MapOfColumnsRowsAndColumns.fromMap((Map)ImmutableMap.of((Object)"intCol", (Object)new IntArrayColumn(new int[]{1, 2, 3})));
        RowsAndColumns processed = proc.process((RowsAndColumns)new NoAsRowsAndColumns((RowsAndColumns)rac));
        new RowsAndColumnsHelper().expectColumn("intCol", new int[]{1, 2, 3}).expectColumn("sum", new int[]{1, 3, 6}).allColumnsRegistered().validate(processed);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(WindowFramedAggregateProcessor.class).usingGetClass().verify();
    }

    static {
        NullHandling.initializeForTests();
    }
}

