/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.planning;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinType;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceAnalysisTest {
    private static final List<Interval> MILLENIUM_INTERVALS = ImmutableList.of((Object)Intervals.of((String)"2000/3000"));
    private static final TableDataSource TABLE_FOO = new TableDataSource("foo");
    private static final TableDataSource TABLE_BAR = new TableDataSource("bar");
    private static final LookupDataSource LOOKUP_LOOKYLOO = new LookupDataSource("lookyloo");
    private static final InlineDataSource INLINE = InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[0]), (RowSignature)RowSignature.builder().add("column", ColumnType.STRING).build());

    @Test
    public void testTable() {
        DataSourceAnalysis analysis = TABLE_FOO.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testUnion() {
        UnionDataSource unionDataSource = new UnionDataSource((List)ImmutableList.of((Object)TABLE_FOO, (Object)TABLE_BAR));
        DataSourceAnalysis analysis = unionDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)unionDataSource, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.of(unionDataSource), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testQueryOnTable() {
        QueryDataSource queryDataSource = DataSourceAnalysisTest.subquery((DataSource)TABLE_FOO);
        DataSourceAnalysis analysis = queryDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.of(queryDataSource.getQuery()), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.of(new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS)), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertFalse((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testQueryOnUnion() {
        UnionDataSource unionDataSource = new UnionDataSource((List)ImmutableList.of((Object)TABLE_FOO, (Object)TABLE_BAR));
        QueryDataSource queryDataSource = DataSourceAnalysisTest.subquery((DataSource)unionDataSource);
        DataSourceAnalysis analysis = queryDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)unionDataSource, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.of(unionDataSource), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.of(queryDataSource.getQuery()), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.of(new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS)), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertFalse((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testLookup() {
        DataSourceAnalysis analysis = LOOKUP_LOOKYLOO.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testQueryOnLookup() {
        QueryDataSource queryDataSource = DataSourceAnalysisTest.subquery((DataSource)LOOKUP_LOOKYLOO);
        DataSourceAnalysis analysis = queryDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.of(queryDataSource.getQuery()), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.of(new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS)), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertFalse((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testInline() {
        DataSourceAnalysis analysis = INLINE.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)INLINE, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Collections.emptyList(), (Object)analysis.getPreJoinableClauses());
        Assert.assertFalse((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
    }

    @Test
    public void testJoinSimpleLeftLeaning() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)DataSourceAnalysisTest.join((DataSource)DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER), (DataSource)INLINE, "2.", JoinType.LEFT), (DataSource)DataSourceAnalysisTest.subquery((DataSource)LOOKUP_LOOKYLOO), "3.", JoinType.FULL);
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("1.", (DataSource)LOOKUP_LOOKYLOO, JoinType.INNER, DataSourceAnalysisTest.joinClause("1.")), (Object)new PreJoinableClause("2.", (DataSource)INLINE, JoinType.LEFT, DataSourceAnalysisTest.joinClause("2.")), (Object)new PreJoinableClause("3.", (DataSource)DataSourceAnalysisTest.subquery((DataSource)LOOKUP_LOOKYLOO), JoinType.FULL, DataSourceAnalysisTest.joinClause("3."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("2.foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("3.foo"));
    }

    @Test
    public void testJoinSimpleLeftLeaningWithLeftFilter() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)DataSourceAnalysisTest.join((DataSource)DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance()), (DataSource)INLINE, "2.", JoinType.LEFT), (DataSource)DataSourceAnalysisTest.subquery((DataSource)LOOKUP_LOOKYLOO), "3.", JoinType.FULL);
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals((Object)TrueDimFilter.instance(), analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("1.", (DataSource)LOOKUP_LOOKYLOO, JoinType.INNER, DataSourceAnalysisTest.joinClause("1.")), (Object)new PreJoinableClause("2.", (DataSource)INLINE, JoinType.LEFT, DataSourceAnalysisTest.joinClause("2.")), (Object)new PreJoinableClause("3.", (DataSource)DataSourceAnalysisTest.subquery((DataSource)LOOKUP_LOOKYLOO), JoinType.FULL, DataSourceAnalysisTest.joinClause("3."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("2.foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("3.foo"));
    }

    @Test
    public void testJoinSimpleRightLeaning() {
        JoinDataSource rightLeaningJoinStack = DataSourceAnalysisTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)DataSourceAnalysisTest.join((DataSource)INLINE, (DataSource)DataSourceAnalysisTest.subquery((DataSource)LOOKUP_LOOKYLOO), "1.", JoinType.LEFT), "2.", JoinType.FULL);
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)rightLeaningJoinStack, "3.", JoinType.RIGHT);
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("3.", (DataSource)rightLeaningJoinStack, JoinType.RIGHT, DataSourceAnalysisTest.joinClause("3."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertTrue((boolean)analysis.isBaseColumn("1.foo"));
        Assert.assertTrue((boolean)analysis.isBaseColumn("2.foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("3.foo"));
    }

    @Test
    public void testJoinSimpleRightLeaningWithLeftFilter() {
        JoinDataSource rightLeaningJoinStack = DataSourceAnalysisTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)DataSourceAnalysisTest.join((DataSource)INLINE, (DataSource)DataSourceAnalysisTest.subquery((DataSource)LOOKUP_LOOKYLOO), "1.", JoinType.LEFT), "2.", JoinType.FULL);
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)rightLeaningJoinStack, "3.", JoinType.RIGHT, (DimFilter)TrueDimFilter.instance());
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals((Object)TrueDimFilter.instance(), analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("3.", (DataSource)rightLeaningJoinStack, JoinType.RIGHT, DataSourceAnalysisTest.joinClause("3."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertTrue((boolean)analysis.isBaseColumn("1.foo"));
        Assert.assertTrue((boolean)analysis.isBaseColumn("2.foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("3.foo"));
    }

    @Test
    public void testJoinOverTableSubquery() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)DataSourceAnalysisTest.subquery((DataSource)TABLE_FOO), "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance());
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertFalse((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals((Object)TrueDimFilter.instance(), analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("1.", (DataSource)DataSourceAnalysisTest.subquery((DataSource)TABLE_FOO), JoinType.INNER, DataSourceAnalysisTest.joinClause("1."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
    }

    @Test
    public void testJoinTableUnionToLookup() {
        UnionDataSource unionDataSource = new UnionDataSource((List)ImmutableList.of((Object)TABLE_FOO, (Object)TABLE_BAR));
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)unionDataSource, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER);
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals(Optional.of(unionDataSource), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals((Object)unionDataSource, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("1.", (DataSource)LOOKUP_LOOKYLOO, JoinType.INNER, DataSourceAnalysisTest.joinClause("1."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
    }

    @Test
    public void testJoinUnderTopLevelSubqueries() {
        QueryDataSource queryDataSource = DataSourceAnalysisTest.subquery((DataSource)DataSourceAnalysisTest.subquery((DataSource)DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance())));
        DataSourceAnalysis analysis = queryDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertTrue((boolean)analysis.isTableBased());
        Assert.assertTrue((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)TABLE_FOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals((Object)TrueDimFilter.instance(), analysis.getJoinBaseTableFilter().orElse(null));
        Assert.assertEquals(Optional.of(TABLE_FOO), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.of(DataSourceAnalysisTest.subquery((DataSource)DataSourceAnalysisTest.join((DataSource)TABLE_FOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER, (DimFilter)TrueDimFilter.instance())).getQuery()), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.of(new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS)), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("1.", (DataSource)LOOKUP_LOOKYLOO, JoinType.INNER, DataSourceAnalysisTest.joinClause("1."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertFalse((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
    }

    @Test
    public void testJoinLookupToLookup() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)LOOKUP_LOOKYLOO, "1.", JoinType.INNER);
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertTrue((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("1.", (DataSource)LOOKUP_LOOKYLOO, JoinType.INNER, DataSourceAnalysisTest.joinClause("1."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
    }

    @Test
    public void testJoinLookupToTable() {
        JoinDataSource joinDataSource = DataSourceAnalysisTest.join((DataSource)LOOKUP_LOOKYLOO, (DataSource)TABLE_FOO, "1.", JoinType.INNER);
        DataSourceAnalysis analysis = joinDataSource.getAnalysis();
        Assert.assertFalse((boolean)analysis.isConcreteBased());
        Assert.assertFalse((boolean)analysis.isTableBased());
        Assert.assertFalse((boolean)analysis.isConcreteAndTableBased());
        Assert.assertEquals((Object)LOOKUP_LOOKYLOO, (Object)analysis.getBaseDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseTableDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseUnionDataSource());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuery());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getBaseQuerySegmentSpec());
        Assert.assertEquals(Optional.empty(), (Object)analysis.getJoinBaseTableFilter());
        Assert.assertEquals((Object)ImmutableList.of((Object)new PreJoinableClause("1.", (DataSource)TABLE_FOO, JoinType.INNER, DataSourceAnalysisTest.joinClause("1."))), (Object)analysis.getPreJoinableClauses());
        Assert.assertTrue((boolean)analysis.isJoin());
        Assert.assertTrue((boolean)analysis.isBaseColumn("foo"));
        Assert.assertFalse((boolean)analysis.isBaseColumn("1.foo"));
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(DataSourceAnalysis.class).usingGetClass().withNonnullFields(new String[]{"baseDataSource"}).withIgnoredFields(new String[]{"baseQuery", "preJoinableClauses", "joinBaseTableFilter"}).verify();
    }

    private static JoinDataSource join(DataSource left, DataSource right, String rightPrefix, JoinType joinType, DimFilter dimFilter) {
        return JoinDataSource.create((DataSource)left, (DataSource)right, (String)rightPrefix, (String)DataSourceAnalysisTest.joinClause(rightPrefix).getOriginalExpression(), (JoinType)joinType, (DimFilter)dimFilter, (ExprMacroTable)ExprMacroTable.nil(), null);
    }

    private static JoinDataSource join(DataSource left, DataSource right, String rightPrefix, JoinType joinType) {
        return DataSourceAnalysisTest.join(left, right, rightPrefix, joinType, null);
    }

    private static JoinConditionAnalysis joinClause(String rightPrefix) {
        return JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"x == \"%sx\"", (Object[])new Object[]{rightPrefix}), (String)rightPrefix, (ExprMacroTable)ExprMacroTable.nil());
    }

    private static QueryDataSource subquery(DataSource dataSource) {
        return new QueryDataSource((Query)GroupByQuery.builder().setDataSource(dataSource).setInterval((QuerySegmentSpec)new MultipleIntervalSegmentSpec(MILLENIUM_INTERVALS)).setGranularity(Granularities.ALL).build());
    }
}

