/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.OffsetLimit;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.semantic.RowsAndColumnsDecorator;
import org.apache.druid.query.rowsandcols.semantic.SemanticTestBase;
import org.apache.druid.segment.ArrayListSegment;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class RowsAndColumnsDecoratorTest
extends SemanticTestBase {
    public RowsAndColumnsDecoratorTest(String name, Function<MapOfColumnsRowsAndColumns, RowsAndColumns> fn) {
        super(name, fn);
    }

    @Test
    public void testDecoration() {
        Object[][] vals = new Object[][]{{1L, "a", 123L, 0L}, {2L, "a", 456L, 1L}, {3L, "b", 789L, 2L}, {4L, "b", 123L, 3L}, {5L, "c", 456L, 4L}, {6L, "c", 789L, 5L}, {7L, "c", 123L, 6L}, {8L, "d", 456L, 7L}, {9L, "e", 789L, 8L}, {10L, "f", 123L, 9L}, {11L, "f", 456L, 10L}, {12L, "g", 789L, 11L}};
        RowSignature siggy = RowSignature.builder().add("__time", ColumnType.LONG).add("dim", ColumnType.STRING).add("val", ColumnType.LONG).add("arrayIndex", ColumnType.LONG).build();
        RowsAndColumns base = this.make(MapOfColumnsRowsAndColumns.fromRowObjects((Object[][])vals, (RowSignature)siggy));
        Interval[] intervals = new Interval[]{Intervals.utc((long)0L, (long)6L), Intervals.utc((long)6L, (long)13L), Intervals.utc((long)4L, (long)8L)};
        Filter[] filters = new Filter[]{new InDimFilter("dim", (Set)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"e", (Object)"g")), new AndFilter(Arrays.asList(new InDimFilter("dim", (Set)ImmutableSet.of((Object)"a", (Object)"b", (Object)"g")), new SelectorFilter("val", "789"))), new OrFilter(Arrays.asList(new SelectorFilter("dim", "b"), new SelectorFilter("val", "789"))), new SelectorFilter("dim", "f")};
        int[] limits = new int[]{3, 6, 100};
        List[] orderings = new List[]{Arrays.asList(ColumnWithDirection.descending((String)"__time"), ColumnWithDirection.ascending((String)"dim")), Collections.singletonList(ColumnWithDirection.ascending((String)"val"))};
        for (int i = 0; i <= intervals.length; ++i) {
            Interval interval = i == 0 ? null : intervals[i - 1];
            for (int j = 0; j <= filters.length; ++j) {
                Filter filter = j == 0 ? null : filters[j - 1];
                for (int k = 0; k <= limits.length; ++k) {
                    int limit = k == 0 ? -1 : limits[k - 1];
                    for (int l = 0; l <= orderings.length; ++l) {
                        this.validateDecorated(base, siggy, vals, interval, filter, OffsetLimit.limit((int)limit), l == 0 ? null : orderings[l - 1]);
                    }
                }
            }
        }
    }

    private void validateDecorated(RowsAndColumns base, RowSignature siggy, Object[][] originalVals, Interval interval, Filter filter, OffsetLimit limit, List<ColumnWithDirection> ordering) {
        List vals;
        String msg = StringUtils.format((String)"interval[%s], filter[%s], limit[%s], ordering[%s]", (Object[])new Object[]{interval, filter, limit, ordering});
        RowsAndColumnsDecorator decor = RowsAndColumnsDecorator.fromRAC((RowsAndColumns)base);
        if (interval == null && filter == null) {
            vals = Arrays.asList(originalVals);
        } else {
            decor.limitTimeRange(interval);
            decor.addFilter(filter);
            ArrayListSegment seggy = new ArrayListSegment(SegmentId.dummy((String)"dummy"), new ArrayList(Arrays.asList(originalVals)), columnName -> {
                int index = siggy.indexOf(columnName);
                return arr -> arr[index];
            }, siggy);
            Sequence cursors = seggy.asStorageAdapter().makeCursors(filter, interval == null ? Intervals.ETERNITY : interval, VirtualColumns.EMPTY, Granularities.ALL, false, null);
            vals = (List)cursors.accumulate(new ArrayList(), (accumulated, in) -> {
                ColumnValueSelector idSupplier = in.getColumnSelectorFactory().makeColumnValueSelector("arrayIndex");
                while (!in.isDone()) {
                    accumulated.add(originalVals[(int)idSupplier.getLong()]);
                    in.advance();
                }
                return accumulated;
            });
        }
        if (ordering != null) {
            decor.setOrdering(ordering);
            Comparator comparator = null;
            for (ColumnWithDirection order : ordering) {
                int columnNum = siggy.indexOf(order.getColumn());
                TypeStrategy strategy = ((ColumnType)siggy.getColumnType(columnNum).orElseThrow(() -> new UOE("debug me", new Object[0]))).getStrategy();
                Comparator newComp = (lhs, rhs) -> strategy.compare(lhs[columnNum], rhs[columnNum]) * order.getDirection().getDirectionInt();
                if (comparator == null) {
                    comparator = newComp;
                    continue;
                }
                comparator = comparator.thenComparing(newComp);
            }
            vals = new ArrayList(vals);
            vals.sort(comparator);
        }
        if (limit.isPresent()) {
            decor.setOffsetLimit(limit);
            int size = vals.size();
            vals = vals.subList((int)limit.getFromIndex((long)size), (int)limit.getToIndex((long)vals.size()));
        }
        if (ordering != null) {
            Assert.assertThrows((String)msg, ISE.class, () -> decor.toRowsAndColumns().numRows());
        } else {
            int i;
            RowsAndColumns rac = decor.toRowsAndColumns();
            Assert.assertEquals((String)msg, (long)vals.size(), (long)rac.numRows());
            ColumnAccessor[] accessors = new ColumnAccessor[siggy.size()];
            for (i = 0; i < siggy.size(); ++i) {
                accessors[i] = rac.findColumn(siggy.getColumnName(i)).toAccessor();
            }
            for (i = 0; i < vals.size(); ++i) {
                Object[] actuals = new Object[accessors.length];
                for (int j = 0; j < actuals.length; ++j) {
                    actuals[j] = accessors[j].getObject(i);
                    if (!(actuals[j] instanceof ByteBuffer)) continue;
                    actuals[j] = StringUtils.fromUtf8((ByteBuffer)((ByteBuffer)actuals[j]).asReadOnlyBuffer());
                }
                Assert.assertArrayEquals((String)StringUtils.format((String)"%s, row[%,d]", (Object[])new Object[]{msg, i}), (Object[])((Object[])vals.get(i)), (Object[])actuals);
            }
        }
    }
}

