/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.query.scan.ConcatCursor;
import org.apache.druid.segment.ListCursor;
import org.junit.Assert;
import org.junit.Test;

public class ConcatCursorTest {
    @Test
    public void testConcatCursor() {
        ListCursor dummyCursor1 = new ListCursor(new ArrayList<Object>());
        ListCursor cursor1 = new ListCursor((List<Object>)ImmutableList.of((Object)"a", (Object)"b"));
        ListCursor dummyCursor2 = new ListCursor(new ArrayList<Object>());
        ListCursor cursor2 = new ListCursor((List<Object>)ImmutableList.of((Object)"c", (Object)"d"));
        ListCursor dummyCursor3 = new ListCursor(new ArrayList<Object>());
        ConcatCursor concatCursor = new ConcatCursor((List)ImmutableList.of((Object)dummyCursor1, (Object)cursor1, (Object)dummyCursor2, (Object)cursor2, (Object)dummyCursor3));
        ArrayList<Object> tempList = new ArrayList<Object>();
        while (!concatCursor.isDone()) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"), tempList);
        concatCursor.reset();
        tempList.clear();
        for (int i = 0; i < 3; ++i) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), tempList);
        concatCursor.reset();
        tempList.clear();
        while (!concatCursor.isDone()) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"), tempList);
    }

    @Test
    public void testConcatCursorOfEmptyCursors() {
        ListCursor dummyCursor1 = new ListCursor(new ArrayList<Object>());
        ListCursor dummyCursor2 = new ListCursor(new ArrayList<Object>());
        ConcatCursor concatCursor = new ConcatCursor((List)ImmutableList.of((Object)dummyCursor1, (Object)dummyCursor2));
        Assert.assertTrue((boolean)concatCursor.isDone());
    }

    @Test
    public void testConcatCursorWhenBeginningCursorIsEmpty() {
        ListCursor dummyCursor1 = new ListCursor(new ArrayList<Object>());
        ListCursor cursor1 = new ListCursor((List<Object>)ImmutableList.of((Object)"a", (Object)"b"));
        ConcatCursor concatCursor = new ConcatCursor((List)ImmutableList.of((Object)dummyCursor1, (Object)cursor1));
        ArrayList<Object> tempList = new ArrayList<Object>();
        while (!concatCursor.isDone()) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b"), tempList);
        concatCursor.reset();
        tempList.clear();
        for (int i = 0; i < 1; ++i) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a"), tempList);
        concatCursor.reset();
        tempList.clear();
        while (!concatCursor.isDone()) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b"), tempList);
    }

    @Test
    public void testConcatCursorWhenEndingCursorIsEmpty() {
        ListCursor dummyCursor1 = new ListCursor(new ArrayList<Object>());
        ListCursor cursor1 = new ListCursor((List<Object>)ImmutableList.of((Object)"a", (Object)"b"));
        ConcatCursor concatCursor = new ConcatCursor((List)ImmutableList.of((Object)cursor1, (Object)dummyCursor1));
        ArrayList<Object> tempList = new ArrayList<Object>();
        while (!concatCursor.isDone()) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b"), tempList);
        concatCursor.reset();
        tempList.clear();
        for (int i = 0; i < 1; ++i) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a"), tempList);
        concatCursor.reset();
        tempList.clear();
        while (!concatCursor.isDone()) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b"), tempList);
    }

    @Test
    public void testConcatCursorWhenMultipleEmptyCursorsAtBeginning() {
        ListCursor dummyCursor1 = new ListCursor(new ArrayList<Object>());
        ListCursor dummyCursor2 = new ListCursor(new ArrayList<Object>());
        ListCursor dummyCursor3 = new ListCursor(new ArrayList<Object>());
        ListCursor cursor1 = new ListCursor((List<Object>)ImmutableList.of((Object)"a", (Object)"b"));
        ConcatCursor concatCursor = new ConcatCursor((List)ImmutableList.of((Object)dummyCursor1, (Object)dummyCursor2, (Object)dummyCursor3, (Object)cursor1));
        ArrayList<Object> tempList = new ArrayList<Object>();
        while (!concatCursor.isDone()) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b"), tempList);
        concatCursor.reset();
        tempList.clear();
        for (int i = 0; i < 1; ++i) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a"), tempList);
        concatCursor.reset();
        tempList.clear();
        while (!concatCursor.isDone()) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b"), tempList);
    }

    @Test
    public void testConcatCursorWhenMultipleEmptyCursorsAtEnd() {
        ListCursor dummyCursor1 = new ListCursor(new ArrayList<Object>());
        ListCursor dummyCursor2 = new ListCursor(new ArrayList<Object>());
        ListCursor dummyCursor3 = new ListCursor(new ArrayList<Object>());
        ListCursor cursor1 = new ListCursor((List<Object>)ImmutableList.of((Object)"a", (Object)"b"));
        ConcatCursor concatCursor = new ConcatCursor((List)ImmutableList.of((Object)cursor1, (Object)dummyCursor1, (Object)dummyCursor2, (Object)dummyCursor3));
        ArrayList<Object> tempList = new ArrayList<Object>();
        while (!concatCursor.isDone()) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b"), tempList);
        concatCursor.reset();
        tempList.clear();
        for (int i = 0; i < 1; ++i) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a"), tempList);
        concatCursor.reset();
        tempList.clear();
        while (!concatCursor.isDone()) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b"), tempList);
    }

    @Test
    public void testConcatCursorWhenMultipleEmptyCursorsAtTheMiddle() {
        ListCursor dummyCursor1 = new ListCursor(new ArrayList<Object>());
        ListCursor dummyCursor2 = new ListCursor(new ArrayList<Object>());
        ListCursor dummyCursor3 = new ListCursor(new ArrayList<Object>());
        ListCursor cursor1 = new ListCursor((List<Object>)ImmutableList.of((Object)"a"));
        ListCursor cursor2 = new ListCursor((List<Object>)ImmutableList.of((Object)"b"));
        ConcatCursor concatCursor = new ConcatCursor((List)ImmutableList.of((Object)cursor1, (Object)dummyCursor1, (Object)dummyCursor2, (Object)dummyCursor3, (Object)cursor2));
        ArrayList<Object> tempList = new ArrayList<Object>();
        while (!concatCursor.isDone()) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b"), tempList);
        concatCursor.reset();
        tempList.clear();
        for (int i = 0; i < 1; ++i) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a"), tempList);
        concatCursor.reset();
        tempList.clear();
        while (!concatCursor.isDone()) {
            tempList.add(concatCursor.getColumnSelectorFactory().makeColumnValueSelector("ignored").getObject());
            concatCursor.advance();
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b"), tempList);
    }
}

