/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.druid.collections.CloseableStupidPool;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.Result;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.TestQueryRunners;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.first.DoubleFirstAggregatorFactory;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.druid.query.topn.TopNQueryRunnerFactory;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnnestTopNQueryRunnerTest
extends InitializedNullHandlingTest {
    private static final Closer RESOURCE_CLOSER = Closer.create();
    private final List<AggregatorFactory> commonAggregators;

    public UnnestTopNQueryRunnerTest(List<AggregatorFactory> commonAggregators) {
        this.commonAggregators = commonAggregators;
    }

    @AfterClass
    public static void teardown() throws IOException {
        RESOURCE_CLOSER.close();
    }

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() {
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        constructors.add(new Object[]{QueryRunnerTestHelper.COMMON_FLOAT_AGGREGATORS});
        return constructors;
    }

    private Sequence<Result<TopNResultValue>> assertExpectedResultsWithCustomRunner(Iterable<Result<TopNResultValue>> expectedResults, TopNQuery query, QueryRunner runner) {
        Sequence<Result<TopNResultValue>> retval = this.runWithMerge(query, runner);
        TestHelper.assertExpectedResults(expectedResults, retval);
        return retval;
    }

    private Sequence<Result<TopNResultValue>> runWithMerge(TopNQuery query, QueryRunner runner) {
        return this.runWithMerge(query, ResponseContext.createEmpty(), runner);
    }

    private Sequence<Result<TopNResultValue>> runWithMerge(TopNQuery query, ResponseContext context, QueryRunner runner1) {
        TopNQueryQueryToolChest chest = new TopNQueryQueryToolChest(new TopNQueryConfig());
        FinalizeResultsQueryRunner mergeRunner = new FinalizeResultsQueryRunner(chest.mergeResults(runner1), (QueryToolChest)chest);
        return mergeRunner.run(QueryPlus.wrap((Query)query), context);
    }

    @Test
    public void testEmptyTopN() {
        CloseableStupidPool<ByteBuffer> defaultPool = TestQueryRunners.createDefaultNonBlockingPool();
        TopNQuery query = new TopNQueryBuilder().dataSource(QueryRunnerTestHelper.UNNEST_DATA_SOURCE).granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.EMPTY_INTERVAL).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index"), new DoubleFirstAggregatorFactory("first", "index", null)})))).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        IncrementalIndex rtIndex = TestIndex.getIncrementalTestIndex();
        QueryRunner queryRunner = QueryRunnerTestHelper.makeQueryRunnerWithSegmentMapFn(new TopNQueryRunnerFactory(defaultPool, new TopNQueryQueryToolChest(new TopNQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER), (Segment)new IncrementalIndexSegment(rtIndex, QueryRunnerTestHelper.SEGMENT_ID), query, "rtIndexvc");
        ImmutableList expectedResults = ImmutableList.of((Object)new Result(DateTimes.of((String)"2020-04-02T00:00:00.000Z"), (Object)TopNResultValue.create((List)ImmutableList.of())));
        this.assertExpectedResultsWithCustomRunner((Iterable<Result<TopNResultValue>>)expectedResults, query, queryRunner);
    }

    @Test
    public void testTopNLexicographicUnnest() {
        CloseableStupidPool<ByteBuffer> defaultPool = TestQueryRunners.createDefaultNonBlockingPool();
        TopNQuery query = new TopNQueryBuilder().dataSource(QueryRunnerTestHelper.UNNEST_DATA_SOURCE).granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("placementish_unnest").metric((TopNMetricSpec)new DimensionTopNMetricSpec("", StringComparators.LEXICOGRAPHIC)).threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        IncrementalIndex rtIndex = TestIndex.getIncrementalTestIndex();
        QueryRunner queryRunner = QueryRunnerTestHelper.makeQueryRunnerWithSegmentMapFn(new TopNQueryRunnerFactory(defaultPool, new TopNQueryQueryToolChest(new TopNQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER), (Segment)new IncrementalIndexSegment(rtIndex, QueryRunnerTestHelper.SEGMENT_ID), query, "rtIndexvc");
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"placementish_unnest", (Object)"a", (Object)"rows", (Object)2L, (Object)"index", (Object)283.311029, (Object)"addRowsIndexConstant", (Object)286.311029, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish_unnest", (Object)"b", (Object)"rows", (Object)2L, (Object)"index", (Object)231.557367, (Object)"addRowsIndexConstant", (Object)234.557367, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish_unnest", (Object)"e", (Object)"rows", (Object)2L, (Object)"index", (Object)324.763273, (Object)"addRowsIndexConstant", (Object)327.763273, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish_unnest", (Object)"h", (Object)"rows", (Object)2L, (Object)"index", (Object)233.580712, (Object)"addRowsIndexConstant", (Object)236.580712, (Object)"uniques", (Object)1.0002442201269182)))));
        this.assertExpectedResultsWithCustomRunner(expectedResults, query, queryRunner);
    }

    @Test
    public void testTopNStringVirtualColumnUnnest() {
        CloseableStupidPool<ByteBuffer> defaultPool = TestQueryRunners.createDefaultNonBlockingPool();
        TopNQuery query = new TopNQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "mv_to_array(\"placementish\")", ColumnType.STRING_ARRAY, TestExprMacroTable.INSTANCE), null)).granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("placementish_unnest").metric("rows").threshold(4).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        IncrementalIndex rtIndex = TestIndex.getIncrementalTestIndex();
        QueryRunner vcrunner = QueryRunnerTestHelper.makeQueryRunnerWithSegmentMapFn(new TopNQueryRunnerFactory(defaultPool, new TopNQueryQueryToolChest(new TopNQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER), (Segment)new IncrementalIndexSegment(rtIndex, QueryRunnerTestHelper.SEGMENT_ID), query, "rtIndexvc");
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"placementish_unnest", (Object)"preferred", (Object)"rows", (Object)26L, (Object)"index", (Object)12459.361287, (Object)"addRowsIndexConstant", (Object)12486.361287, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"placementish_unnest", (Object)"m", (Object)"rows", (Object)6L, (Object)"index", (Object)5320.717303, (Object)"addRowsIndexConstant", (Object)5327.717303, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish_unnest", (Object)"p", (Object)"rows", (Object)6L, (Object)"index", (Object)5407.213795, (Object)"addRowsIndexConstant", (Object)5414.213795, (Object)"uniques", (Object)1.0002442201269182), ImmutableMap.of((Object)"placementish_unnest", (Object)"t", (Object)"rows", (Object)4L, (Object)"index", (Object)422.344086, (Object)"addRowsIndexConstant", (Object)427.344086, (Object)"uniques", (Object)2.000977198748901)))));
        this.assertExpectedResultsWithCustomRunner(expectedResults, query, vcrunner);
    }

    @Test
    public void testTopNStringVirtualMultiColumnUnnest() {
        CloseableStupidPool<ByteBuffer> defaultPool = TestQueryRunners.createDefaultNonBlockingPool();
        CloseableStupidPool customPool = new CloseableStupidPool("TopNQueryRunnerFactory-bufferPool", () -> ByteBuffer.allocate(20000));
        TopNQuery query = new TopNQueryBuilder().dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("testing"), (VirtualColumn)new ExpressionVirtualColumn("placementish_unnest", "array(\"market\",\"quality\")", ColumnType.STRING, TestExprMacroTable.INSTANCE), null)).granularity(QueryRunnerTestHelper.ALL_GRAN).dimension("placementish_unnest").metric("rows").threshold(2).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(this.commonAggregators).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).build();
        IncrementalIndex rtIndex = TestIndex.getIncrementalTestIndex();
        QueryRunner vcrunner = QueryRunnerTestHelper.makeQueryRunnerWithSegmentMapFn(new TopNQueryRunnerFactory(defaultPool, new TopNQueryQueryToolChest(new TopNQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER), (Segment)new IncrementalIndexSegment(rtIndex, QueryRunnerTestHelper.SEGMENT_ID), query, "rtIndexvc");
        List<Result<TopNResultValue>> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-04-01T00:00:00.000Z"), (Object)TopNResultValue.create(Arrays.asList(ImmutableMap.of((Object)"placementish_unnest", (Object)"spot", (Object)"rows", (Object)18L, (Object)"index", (Object)2231.876812, (Object)"addRowsIndexConstant", (Object)2250.876812, (Object)"uniques", (Object)9.019833517963864), ImmutableMap.of((Object)"placementish_unnest", (Object)"premium", (Object)"rows", (Object)6L, (Object)"index", (Object)5407.213795, (Object)"addRowsIndexConstant", (Object)5414.213795, (Object)"uniques", (Object)1.0002442201269182)))));
        this.assertExpectedResultsWithCustomRunner(expectedResults, query, vcrunner);
        RESOURCE_CLOSER.register(() -> {
            Assert.assertEquals((String)"defaultPool objects created", (long)defaultPool.poolSize(), (long)defaultPool.objectsCreatedCount());
            Assert.assertEquals((String)"customPool objects created", (long)customPool.poolSize(), (long)customPool.objectsCreatedCount());
            defaultPool.close();
            customPool.close();
        });
    }
}

