/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.NewSpatialDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DoubleDimensionHandler;
import org.apache.druid.segment.FloatDimensionHandler;
import org.apache.druid.segment.LongDimensionHandler;
import org.apache.druid.segment.StringDimensionHandler;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ComparableList;
import org.apache.druid.segment.data.ComparableStringArray;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DimensionHandlerUtilsTest
extends InitializedNullHandlingTest {
    private static final String DIM_NAME = "dim";
    private static final String TYPE = "testType";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final ComparableList<Long> LONG_COMPARABLE_LIST = new ComparableList((List)ImmutableList.of((Object)1L, (Object)2L));
    private static final ComparableList<Double> DOUBLE_COMPARABLE_LIST = new ComparableList((List)ImmutableList.of((Object)1.0, (Object)2.0));
    private static final ComparableList<Float> FLOAT_COMPARABLE_LIST = new ComparableList((List)ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f)));
    private static final ComparableStringArray COMPARABLE_STRING_ARRAY = ComparableStringArray.of((String[])new String[]{"1", "2"});
    private static final ComparableStringArray COMPARABLE_STRING_ARRAY_DECIMAL = ComparableStringArray.of((String[])new String[]{"1.0", "2.0"});

    @BeforeClass
    public static void setupTests() {
        DimensionHandlerUtils.registerDimensionHandlerProvider((String)TYPE, d -> new DoubleDimensionHandler(d){

            public DimensionSchema getDimensionSchema(ColumnCapabilities capabilities) {
                return new TestDimensionSchema(d, null, capabilities.hasBitmapIndexes());
            }
        });
    }

    @Test
    public void testGetHandlerFromComplexCapabilities() {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(ColumnType.ofComplex((String)TYPE));
        DimensionHandler dimensionHandler = DimensionHandlerUtils.getHandlerFromCapabilities((String)DIM_NAME, (ColumnCapabilities)capabilities, null);
        Assert.assertEquals((Object)DIM_NAME, (Object)dimensionHandler.getDimensionName());
        Assert.assertTrue((boolean)(dimensionHandler instanceof DoubleDimensionHandler));
        Assert.assertTrue((boolean)(dimensionHandler.getDimensionSchema((ColumnCapabilities)capabilities) instanceof TestDimensionSchema));
    }

    @Test
    public void testGetHandlerFromUnknownComplexCapabilities() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage("Can't find DimensionHandlerProvider for typeName [unknown]");
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(ColumnType.ofComplex((String)"unknown"));
        DimensionHandlerUtils.getHandlerFromCapabilities((String)DIM_NAME, (ColumnCapabilities)capabilities, null);
    }

    @Test
    public void testGetHandlerFromStringCapabilities() {
        ColumnCapabilitiesImpl stringCapabilities = ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities().setHasBitmapIndexes(true).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesUnique(true);
        DimensionHandler stringHandler = DimensionHandlerUtils.getHandlerFromCapabilities((String)DIM_NAME, (ColumnCapabilities)stringCapabilities, (DimensionSchema.MultiValueHandling)DimensionSchema.MultiValueHandling.SORTED_SET);
        Assert.assertTrue((boolean)(stringHandler instanceof StringDimensionHandler));
        Assert.assertTrue((boolean)(stringHandler.getDimensionSchema((ColumnCapabilities)stringCapabilities) instanceof StringDimensionSchema));
    }

    @Test
    public void testGetHandlerFromStringCapabilitiesSpatialIndexes() {
        ColumnCapabilitiesImpl stringCapabilities = ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities().setHasBitmapIndexes(true).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesUnique(true).setHasSpatialIndexes(true);
        DimensionHandler spatialHandler = DimensionHandlerUtils.getHandlerFromCapabilities((String)DIM_NAME, (ColumnCapabilities)stringCapabilities, (DimensionSchema.MultiValueHandling)DimensionSchema.MultiValueHandling.SORTED_SET);
        Assert.assertTrue((boolean)(spatialHandler instanceof StringDimensionHandler));
        Assert.assertTrue((boolean)(spatialHandler.getDimensionSchema((ColumnCapabilities)stringCapabilities) instanceof NewSpatialDimensionSchema));
    }

    @Test
    public void testGetHandlerFromFloatCapabilities() {
        ColumnCapabilitiesImpl capabilities = ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.FLOAT);
        DimensionHandler handler = DimensionHandlerUtils.getHandlerFromCapabilities((String)DIM_NAME, (ColumnCapabilities)capabilities, null);
        Assert.assertTrue((boolean)(handler instanceof FloatDimensionHandler));
        Assert.assertTrue((boolean)(handler.getDimensionSchema((ColumnCapabilities)capabilities) instanceof FloatDimensionSchema));
    }

    @Test
    public void testGetHandlerFromDoubleCapabilities() {
        ColumnCapabilitiesImpl capabilities = ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.DOUBLE);
        DimensionHandler handler = DimensionHandlerUtils.getHandlerFromCapabilities((String)DIM_NAME, (ColumnCapabilities)capabilities, null);
        Assert.assertTrue((boolean)(handler instanceof DoubleDimensionHandler));
        Assert.assertTrue((boolean)(handler.getDimensionSchema((ColumnCapabilities)capabilities) instanceof DoubleDimensionSchema));
    }

    @Test
    public void testGetHandlerFromLongCapabilities() {
        ColumnCapabilitiesImpl capabilities = ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature)ColumnType.LONG);
        DimensionHandler handler = DimensionHandlerUtils.getHandlerFromCapabilities((String)DIM_NAME, (ColumnCapabilities)capabilities, null);
        Assert.assertTrue((boolean)(handler instanceof LongDimensionHandler));
        Assert.assertTrue((boolean)(handler.getDimensionSchema((ColumnCapabilities)capabilities) instanceof LongDimensionSchema));
    }

    @Test
    public void testComparableLongList() {
        Assert.assertEquals(null, (Object)DimensionHandlerUtils.convertToList(null, (ValueType)ValueType.LONG));
        Assert.assertEquals(LONG_COMPARABLE_LIST, (Object)DimensionHandlerUtils.convertToList((Object)ImmutableList.of((Object)1L, (Object)2L), (ValueType)ValueType.LONG));
        Assert.assertEquals(LONG_COMPARABLE_LIST, (Object)DimensionHandlerUtils.convertToList((Object)new ComparableList((List)ImmutableList.of((Object)1L, (Object)2L)), (ValueType)ValueType.LONG));
        DimensionHandlerUtilsTest.assertArrayCases(LONG_COMPARABLE_LIST, ValueType.LONG);
        Assert.assertThrows((String)"Unable to convert object of type[Long] to [ComparableList]", ISE.class, () -> DimensionHandlerUtils.convertToList((Object)1L, (ValueType)ValueType.LONG));
        Assert.assertThrows((String)"Unable to convert object of type[Long] to [ComparableList]", ISE.class, () -> DimensionHandlerUtils.convertToList((Object)1L, (ValueType)ValueType.ARRAY));
        Assert.assertThrows((String)"Unable to convert object of type[Long] to [ComparableList]", ISE.class, () -> DimensionHandlerUtils.convertToList((Object)1L, (ValueType)ValueType.STRING));
    }

    @Test
    public void testComparableFloatList() {
        Assert.assertEquals(null, (Object)DimensionHandlerUtils.convertToList(null, (ValueType)ValueType.FLOAT));
        Assert.assertEquals(FLOAT_COMPARABLE_LIST, (Object)DimensionHandlerUtils.convertToList((Object)ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f)), (ValueType)ValueType.FLOAT));
        Assert.assertEquals(FLOAT_COMPARABLE_LIST, (Object)DimensionHandlerUtils.convertToList((Object)new ComparableList((List)ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f))), (ValueType)ValueType.FLOAT));
        DimensionHandlerUtilsTest.assertArrayCases(FLOAT_COMPARABLE_LIST, ValueType.FLOAT);
        Assert.assertThrows((String)"Unable to convert object of type[Float] to [ComparableList]", ISE.class, () -> DimensionHandlerUtils.convertToList((Object)Float.valueOf(1.0f), (ValueType)ValueType.FLOAT));
        Assert.assertThrows((String)"Unable to convert object of type[Float] to [ComparableList]", ISE.class, () -> DimensionHandlerUtils.convertToList((Object)Float.valueOf(1.0f), (ValueType)ValueType.ARRAY));
        Assert.assertThrows((String)"Unable to convert object of type[Float] to [ComparableList]", ISE.class, () -> DimensionHandlerUtils.convertToList((Object)Float.valueOf(1.0f), (ValueType)ValueType.STRING));
    }

    @Test
    public void testComparableDoubleList() {
        Assert.assertEquals(null, (Object)DimensionHandlerUtils.convertToList(null, (ValueType)ValueType.DOUBLE));
        Assert.assertEquals(DOUBLE_COMPARABLE_LIST, (Object)DimensionHandlerUtils.convertToList((Object)ImmutableList.of((Object)1.0, (Object)2.0), (ValueType)ValueType.DOUBLE));
        Assert.assertEquals(DOUBLE_COMPARABLE_LIST, (Object)DimensionHandlerUtils.convertToList((Object)new ComparableList((List)ImmutableList.of((Object)1.0, (Object)2.0)), (ValueType)ValueType.DOUBLE));
        DimensionHandlerUtilsTest.assertArrayCases(DOUBLE_COMPARABLE_LIST, ValueType.DOUBLE);
        Assert.assertThrows((String)"Unable to convert object of type[Double] to [ComparableList]", ISE.class, () -> DimensionHandlerUtils.convertToList((Object)1.0, (ValueType)ValueType.DOUBLE));
        Assert.assertThrows((String)"Unable to convert object of type[Double] to [ComparableList]", ISE.class, () -> DimensionHandlerUtils.convertToList((Object)1.0, (ValueType)ValueType.ARRAY));
        Assert.assertThrows((String)"Unable to convert object of type[Double] to [ComparableList]", ISE.class, () -> DimensionHandlerUtils.convertToList((Object)1.0, (ValueType)ValueType.STRING));
    }

    @Test
    public void testComparableStringArrayList() {
        Assert.assertEquals(null, (Object)DimensionHandlerUtils.convertToComparableStringArray(null));
        Assert.assertEquals((Object)COMPARABLE_STRING_ARRAY, (Object)DimensionHandlerUtils.convertToComparableStringArray((Object)ImmutableList.of((Object)"1", (Object)"2")));
        Assert.assertEquals((Object)COMPARABLE_STRING_ARRAY, (Object)DimensionHandlerUtils.convertToComparableStringArray((Object)new Object[]{1L, 2L}));
        Assert.assertEquals((Object)COMPARABLE_STRING_ARRAY, (Object)DimensionHandlerUtils.convertToComparableStringArray((Object)new Long[]{1L, 2L}));
        Assert.assertEquals((Object)COMPARABLE_STRING_ARRAY_DECIMAL, (Object)DimensionHandlerUtils.convertToComparableStringArray((Object)new String[]{"1.0", "2.0"}));
        Assert.assertEquals((Object)COMPARABLE_STRING_ARRAY_DECIMAL, (Object)DimensionHandlerUtils.convertToComparableStringArray((Object)new Double[]{1.0, 2.0}));
        Assert.assertEquals((Object)COMPARABLE_STRING_ARRAY_DECIMAL, (Object)DimensionHandlerUtils.convertToComparableStringArray((Object)new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)}));
        Assert.assertThrows((String)"Unable to convert object of type[String] to [ComparablComparableStringArray]", ISE.class, () -> DimensionHandlerUtils.convertToComparableStringArray((Object)"1"));
    }

    private static void assertArrayCases(ComparableList expectedComparableList, ValueType elementType) {
        Assert.assertEquals((Object)expectedComparableList, (Object)DimensionHandlerUtils.convertToList((Object)new Object[]{1L, 2L}, (ValueType)elementType));
        Assert.assertEquals((Object)expectedComparableList, (Object)DimensionHandlerUtils.convertToList((Object)new Long[]{1L, 2L}, (ValueType)elementType));
        Assert.assertEquals((Object)expectedComparableList, (Object)DimensionHandlerUtils.convertToList((Object)new String[]{"1.0", "2.0"}, (ValueType)elementType));
        Assert.assertEquals((Object)expectedComparableList, (Object)DimensionHandlerUtils.convertToList((Object)new Double[]{1.0, 2.0}, (ValueType)elementType));
        Assert.assertEquals((Object)expectedComparableList, (Object)DimensionHandlerUtils.convertToList((Object)new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)}, (ValueType)elementType));
    }

    private static class TestDimensionSchema
    extends DimensionSchema {
        protected TestDimensionSchema(String name, DimensionSchema.MultiValueHandling multiValueHandling, boolean createBitmapIndex) {
            super(name, multiValueHandling, createBitmapIndex);
        }

        public String getTypeName() {
            return DimensionHandlerUtilsTest.TYPE;
        }

        public ColumnType getColumnType() {
            return ColumnType.ofComplex((String)DimensionHandlerUtilsTest.TYPE);
        }
    }
}

