/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.data.IncrementalIndexTest;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.roaringbitmap.IntIterator;

public class IndexMergerNullHandlingTest {
    private IndexMerger indexMerger;
    private IndexIO indexIO;
    private IndexSpec indexSpec;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void setUp() {
        this.indexMerger = TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        this.indexIO = TestHelper.getTestIndexIO();
        this.indexSpec = IndexSpec.DEFAULT;
    }

    @Test
    public void testStringColumnNullHandling() throws Exception {
        ArrayList<ImmutableMap> nonNullFlavors = new ArrayList<ImmutableMap>();
        nonNullFlavors.add(ImmutableMap.of((Object)"d", (Object)"a"));
        nonNullFlavors.add(ImmutableMap.of((Object)"d", (Object)ImmutableList.of((Object)"a", (Object)"b")));
        ArrayList<Object> nullFlavors = new ArrayList<Object>();
        ImmutableMap mMissing = ImmutableMap.of();
        ImmutableMap mEmptyList = ImmutableMap.of((Object)"d", Collections.emptyList());
        HashMap<String, Object> mNull = new HashMap<String, Object>();
        mNull.put("d", null);
        ImmutableMap mEmptyString = ImmutableMap.of((Object)"d", (Object)"");
        ImmutableMap mListOfNull = ImmutableMap.of((Object)"d", Collections.singletonList(null));
        ImmutableMap mListOfEmptyString = ImmutableMap.of((Object)"d", Collections.singletonList(""));
        nullFlavors.add(mMissing);
        nullFlavors.add(mEmptyList);
        nullFlavors.add(mNull);
        nullFlavors.add(mListOfNull);
        if (NullHandling.replaceWithDefault()) {
            nullFlavors.add(mEmptyString);
            nullFlavors.add(mListOfEmptyString);
        } else {
            nonNullFlavors.add(mEmptyString);
            nonNullFlavors.add(mListOfEmptyString);
        }
        HashSet<Object> allValues = new HashSet<Object>();
        allValues.addAll(nonNullFlavors);
        allValues.addAll(nullFlavors);
        for (Set subset : Sets.powerSet(allValues)) {
            if (subset.isEmpty()) continue;
            ArrayList subsetList = new ArrayList(subset);
            IncrementalIndex toPersist = IncrementalIndexTest.createIndex(new AggregatorFactory[0]);
            for (Map m2 : subsetList) {
                toPersist.add((InputRow)new MapBasedInputRow(0L, (List)ImmutableList.of((Object)"d"), m2));
            }
            File tempDir = this.temporaryFolder.newFolder();
            QueryableIndex index = this.indexIO.loadIndex(this.indexMerger.persist(toPersist, tempDir, this.indexSpec, null));
            try {
                ColumnHolder columnHolder = index.getColumnHolder("d");
                if (nullFlavors.containsAll(subsetList)) {
                    Assert.assertNull((String)((Object)subsetList).toString(), (Object)columnHolder);
                    continue;
                }
                Assert.assertNotNull((String)((Object)subsetList).toString(), (Object)columnHolder);
                boolean hasMultipleValues = subsetList.stream().anyMatch(m -> m.get("d") instanceof List && ((List)m.get("d")).size() > 1);
                HashSet<String> uniqueValues = new HashSet<String>();
                for (Map m3 : subsetList) {
                    List<String> dValues = IndexMergerNullHandlingTest.normalize(m3.get("d"));
                    uniqueValues.addAll(dValues);
                    if (!nullFlavors.contains(m3)) continue;
                    uniqueValues.add(null);
                }
                DictionaryEncodedColumn dictionaryColumn = (DictionaryEncodedColumn)columnHolder.getColumn();
                try {
                    Assert.assertEquals((String)((Object)subsetList).toString(), uniqueValues.stream().sorted(Comparators.naturalNullsFirst()).collect(Collectors.toList()), IntStream.range(0, dictionaryColumn.getCardinality()).mapToObj(arg_0 -> ((DictionaryEncodedColumn)dictionaryColumn).lookupName(arg_0)).collect(Collectors.toList()));
                    Assert.assertEquals((String)((Object)subsetList).toString(), (Object)hasMultipleValues, (Object)dictionaryColumn.hasMultipleValues());
                    Assert.assertEquals((String)((Object)subsetList).toString(), (long)uniqueValues.size(), (long)dictionaryColumn.getCardinality());
                    Assert.assertEquals((String)((Object)subsetList).toString(), (Object)ImmutableMultiset.copyOf((Iterable)subsetList.stream().map(m -> IndexMergerNullHandlingTest.normalize(m.get("d"))).distinct().collect(Collectors.toList())), (Object)ImmutableMultiset.copyOf((Iterable)IntStream.range(0, index.getNumRows()).mapToObj(rowNumber -> IndexMergerNullHandlingTest.getRow((DictionaryEncodedColumn<String>)dictionaryColumn, rowNumber)).distinct().collect(Collectors.toList())));
                    DictionaryEncodedStringValueIndex valueIndex = (DictionaryEncodedStringValueIndex)columnHolder.getIndexSupplier().as(DictionaryEncodedStringValueIndex.class);
                    StringValueSetIndexes valueSetIndex = (StringValueSetIndexes)columnHolder.getIndexSupplier().as(StringValueSetIndexes.class);
                    ArrayList<Integer> expectedNullRows = new ArrayList<Integer>();
                    for (int i = 0; i < index.getNumRows(); ++i) {
                        List<String> row = IndexMergerNullHandlingTest.getRow((DictionaryEncodedColumn<String>)dictionaryColumn, i);
                        if (!row.isEmpty() && !row.stream().anyMatch(NullHandling::isNullOrEquivalent)) continue;
                        expectedNullRows.add(i);
                    }
                    if (expectedNullRows.size() <= 0) continue;
                    ImmutableBitmap nullBitmap = (ImmutableBitmap)valueSetIndex.forValue(null).computeBitmapResult((BitmapResultFactory)new DefaultBitmapResultFactory(this.indexSpec.getBitmapSerdeFactory().getBitmapFactory()), false);
                    ArrayList<Integer> actualNullRows = new ArrayList<Integer>();
                    IntIterator iterator = nullBitmap.iterator();
                    while (iterator.hasNext()) {
                        actualNullRows.add(iterator.next());
                    }
                    Assert.assertEquals((String)((Object)subsetList).toString(), expectedNullRows, actualNullRows);
                }
                finally {
                    if (dictionaryColumn == null) continue;
                    dictionaryColumn.close();
                }
            }
            finally {
                if (index == null) continue;
                index.close();
            }
        }
    }

    private static List<String> normalize(Object value) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (value == null) {
            retVal.add(null);
        } else if (value instanceof String) {
            retVal.add(NullHandling.emptyToNullIfNeeded((String)((String)value)));
        } else if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                retVal.add(null);
            } else {
                retVal.addAll(list.stream().map(NullHandling::emptyToNullIfNeeded).collect(Collectors.toList()));
            }
        } else {
            throw new ISE("didn't expect class[%s]", new Object[]{value.getClass()});
        }
        return retVal;
    }

    private static List<String> getRow(DictionaryEncodedColumn<String> column, int rowNumber) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (column.hasMultipleValues()) {
            IndexedInts rowVals = column.getMultiValueRow(rowNumber);
            if (rowVals.size() == 0) {
                retVal.add(null);
            } else {
                rowVals.forEach(i -> retVal.add((String)((Object)column.lookupName(i))));
            }
        } else {
            retVal.add((String)((Object)column.lookupName(column.getSingleValueRow(rowNumber))));
        }
        return retVal;
    }

    static {
        NullHandling.initializeForTests();
    }
}

