/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.error.DruidException;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.DefaultColumnFormatConfig;
import org.apache.druid.segment.NestedDataColumnSchema;
import org.junit.Assert;
import org.junit.Test;

public class NestedDataColumnSchemaTest {
    private static final DefaultColumnFormatConfig DEFAULT_CONFIG = new DefaultColumnFormatConfig(null);
    private static final DefaultColumnFormatConfig DEFAULT_CONFIG_V4 = new DefaultColumnFormatConfig(Integer.valueOf(4));
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    private static final ObjectMapper MAPPER_V4;

    @Test
    public void testSerdeRoundTrip() throws JsonProcessingException {
        NestedDataColumnSchema v4 = new NestedDataColumnSchema("test", 4);
        NestedDataColumnSchema v5 = new NestedDataColumnSchema("test", 5);
        Assert.assertEquals((Object)v4, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)v4), NestedDataColumnSchema.class));
        Assert.assertEquals((Object)v5, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)v5), NestedDataColumnSchema.class));
    }

    @Test
    public void testSerdeDefault() throws JsonProcessingException {
        String there = "{\"type\":\"json\", \"name\":\"test\"}";
        NestedDataColumnSchema andBack = (NestedDataColumnSchema)MAPPER.readValue("{\"type\":\"json\", \"name\":\"test\"}", NestedDataColumnSchema.class);
        Assert.assertEquals((Object)new NestedDataColumnSchema("test", 5), (Object)andBack);
    }

    @Test
    public void testSerdeSystemDefault() throws JsonProcessingException {
        String there = "{\"type\":\"json\", \"name\":\"test\"}";
        NestedDataColumnSchema andBack = (NestedDataColumnSchema)MAPPER_V4.readValue("{\"type\":\"json\", \"name\":\"test\"}", NestedDataColumnSchema.class);
        Assert.assertEquals((Object)new NestedDataColumnSchema("test", 4), (Object)andBack);
    }

    @Test
    public void testSerdeOverride() throws JsonProcessingException {
        String there = "{\"type\":\"json\", \"name\":\"test\",\"formatVersion\":4}";
        NestedDataColumnSchema andBack = (NestedDataColumnSchema)MAPPER.readValue("{\"type\":\"json\", \"name\":\"test\",\"formatVersion\":4}", NestedDataColumnSchema.class);
        Assert.assertEquals((Object)new NestedDataColumnSchema("test", 4), (Object)andBack);
    }

    @Test
    public void testVersionTooSmall() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> new NestedDataColumnSchema("test", 3));
        Assert.assertEquals((Object)"Unsupported nested column format version[3]", (Object)t.getMessage());
    }

    @Test
    public void testVersionTooBig() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> new NestedDataColumnSchema("test", 6));
        Assert.assertEquals((Object)"Unsupported nested column format version[6]", (Object)t.getMessage());
    }

    static {
        MAPPER.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(DefaultColumnFormatConfig.class, (Object)DEFAULT_CONFIG));
        MAPPER_V4 = new DefaultObjectMapper();
        MAPPER_V4.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(DefaultColumnFormatConfig.class, (Object)DEFAULT_CONFIG_V4));
    }
}

