/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Arrays;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.EncodedKeyComponent;
import org.apache.druid.segment.StringDimensionIndexer;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class StringDimensionIndexerTest
extends InitializedNullHandlingTest {
    @Test
    public void testProcessRowValsToEncodedKeyComponent_usingAvgEstimates() {
        StringDimensionIndexer indexer = new StringDimensionIndexer(DimensionSchema.MultiValueHandling.SORTED_ARRAY, true, false, false);
        long totalEstimatedSize = 0L;
        totalEstimatedSize += this.verifyEncodedValues(indexer, "abc", new int[]{0}, 86L);
        totalEstimatedSize += this.verifyEncodedValues(indexer, null, new int[]{1}, 20L);
        totalEstimatedSize += this.verifyEncodedValues(indexer, "abc", new int[]{0}, 20L);
        totalEstimatedSize += this.verifyEncodedValues(indexer, "def", new int[]{2}, 86L);
        Assert.assertEquals((long)306L, (long)(totalEstimatedSize += this.verifyEncodedValues(indexer, Arrays.asList("abc", "def", "ghi"), new int[]{0, 2, 3}, 94L)));
    }

    @Test
    public void testProcessRowValsToEncodedKeyComponent_usingMaxEstimates() {
        StringDimensionIndexer indexer = new StringDimensionIndexer(DimensionSchema.MultiValueHandling.SORTED_ARRAY, true, false, true);
        long totalEstimatedSize = 0L;
        totalEstimatedSize += this.verifyEncodedValues(indexer, "abc", new int[]{0}, 54L);
        totalEstimatedSize += this.verifyEncodedValues(indexer, null, new int[]{1}, 4L);
        totalEstimatedSize += this.verifyEncodedValues(indexer, "abc", new int[]{0}, 54L);
        totalEstimatedSize += this.verifyEncodedValues(indexer, "def", new int[]{2}, 54L);
        Assert.assertEquals((long)328L, (long)(totalEstimatedSize += this.verifyEncodedValues(indexer, Arrays.asList("abc", "def", "ghi"), new int[]{0, 2, 3}, 162L)));
    }

    @Test
    public void testProcessRowValsToEncodedKeyComponent_comparison() {
        StringDimensionIndexer indexerForAvgEstimates = new StringDimensionIndexer(DimensionSchema.MultiValueHandling.SORTED_ARRAY, true, false, false);
        StringDimensionIndexer indexerForMaxEstimates = new StringDimensionIndexer(DimensionSchema.MultiValueHandling.SORTED_ARRAY, true, false, true);
        long totalSizeWithMaxEstimates = 0L;
        long totalSizeWithAvgEstimates = 0L;
        int i = 0;
        while (i < 10) {
            String dimValue = "value-" + i;
            totalSizeWithMaxEstimates += this.verifyEncodedValues(indexerForMaxEstimates, dimValue, new int[]{i}, 62L);
            totalSizeWithAvgEstimates += this.verifyEncodedValues(indexerForAvgEstimates, dimValue, new int[]{i++}, 94L);
        }
        Assert.assertEquals((long)620L, (long)totalSizeWithMaxEstimates);
        Assert.assertEquals((long)940L, (long)totalSizeWithAvgEstimates);
        for (i = 0; i < 100; ++i) {
            int index = i % 10;
            String dimValue = "value-" + index;
            totalSizeWithMaxEstimates += this.verifyEncodedValues(indexerForMaxEstimates, dimValue, new int[]{index}, 62L);
            totalSizeWithAvgEstimates += this.verifyEncodedValues(indexerForAvgEstimates, dimValue, new int[]{index}, 20L);
        }
        Assert.assertEquals((long)6820L, (long)totalSizeWithMaxEstimates);
        Assert.assertEquals((long)2940L, (long)totalSizeWithAvgEstimates);
    }

    @Test
    public void testBinaryInputs() {
        StringDimensionIndexer indexer = new StringDimensionIndexer(DimensionSchema.MultiValueHandling.SORTED_ARRAY, true, false, false);
        byte[] byteVal = new byte[]{1, 2, 3, 4};
        EncodedKeyComponent keyComponent = indexer.processRowValsToUnsortedEncodedKeyComponent((Object)byteVal, false);
        Assert.assertEquals((Object)StringUtils.encodeBase64String((byte[])byteVal), (Object)indexer.convertUnsortedEncodedKeyComponentToActualList((int[])keyComponent.getComponent()));
    }

    private long verifyEncodedValues(StringDimensionIndexer indexer, Object dimensionValues, int[] expectedEncodedValues, long expectedSizeDelta) {
        EncodedKeyComponent encodedKeyComponent = indexer.processRowValsToUnsortedEncodedKeyComponent(dimensionValues, false);
        Assert.assertArrayEquals((int[])expectedEncodedValues, (int[])((int[])encodedKeyComponent.getComponent()));
        Assert.assertEquals((long)expectedSizeDelta, (long)encodedKeyComponent.getEffectiveSizeBytes());
        return encodedKeyComponent.getEffectiveSizeBytes();
    }
}

