/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.common.config.NullHandling;
import org.apache.druid.segment.TestDoubleColumnSelector;

public class TestNullableDoubleColumnSelector
extends TestDoubleColumnSelector {
    private final Double[] doubles;
    private int index = 0;

    public TestNullableDoubleColumnSelector(Double[] doubles) {
        this.doubles = doubles;
    }

    public double getDouble() {
        if (this.doubles[this.index] != null) {
            return this.doubles[this.index];
        }
        if (NullHandling.replaceWithDefault()) {
            return NullHandling.ZERO_DOUBLE;
        }
        throw new IllegalStateException("Should never be invoked when current value is null && SQL-compatible null handling is enabled!");
    }

    public boolean isNull() {
        return !NullHandling.replaceWithDefault() && this.doubles[this.index] == null;
    }

    public void increment() {
        ++this.index;
    }
}

