/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class V9IndexLoaderTest
extends InitializedNullHandlingTest {
    private static final String COUNT_COLUMN = "count";

    @Test
    public void testLoadSegmentDamagedFileWithLazy() throws IOException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class, (Object)ExprMacroTable.nil()));
        CannotDeserializeCountColumnV9IndexLoader loader = new CannotDeserializeCountColumnV9IndexLoader();
        String path = this.getClass().getClassLoader().getResource("v9SegmentPersistDir/segmentWithDamagedFile/").getPath();
        ForkSegmentLoadDropHandler segmentLoadDropHandler = new ForkSegmentLoadDropHandler();
        ForkSegment segment = new ForkSegment(true);
        Assert.assertTrue((boolean)segment.getSegmentExist());
        File inDir = new File(path);
        QueryableIndex queryableIndex = loader.load(inDir, (ObjectMapper)mapper, true, () -> segmentLoadDropHandler.removeSegment(segment));
        Assert.assertNotNull((Object)queryableIndex);
        V9IndexLoaderTest.assertFailToDeserializeColumn(() -> ((QueryableIndex)queryableIndex).getDimensionHandlers());
        List columnNames = queryableIndex.getColumnNames();
        for (String columnName : columnNames) {
            if (COUNT_COLUMN.equals(columnName)) {
                V9IndexLoaderTest.assertFailToDeserializeColumn(() -> queryableIndex.getColumnHolder(columnName));
                continue;
            }
            Assert.assertNotNull((Object)queryableIndex.getColumnHolder(columnName));
        }
        Assert.assertFalse((boolean)segment.getSegmentExist());
    }

    private static void assertFailToDeserializeColumn(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof RuntimeException));
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
            Assert.assertTrue((boolean)e.getMessage().contains("Exception test while deserializing a column"));
        }
    }

    private static class CannotDeserializeCountColumnV9IndexLoader
    extends IndexIO.V9IndexLoader {
        private CannotDeserializeCountColumnV9IndexLoader() {
            super(ColumnConfig.DEFAULT);
        }

        ColumnHolder deserializeColumn(String columnName, ObjectMapper mapper, ByteBuffer byteBuffer, SmooshedFileMapper smooshedFiles) throws IOException {
            if (V9IndexLoaderTest.COUNT_COLUMN.equals(columnName)) {
                throw new IOException("Exception test while deserializing a column");
            }
            return super.deserializeColumn(columnName, mapper, byteBuffer, smooshedFiles);
        }
    }

    private static class ForkSegment {
        private Boolean segmentExist;

        ForkSegment(Boolean segmentExist) {
            this.segmentExist = segmentExist;
        }

        void setSegmentExist(Boolean value) {
            this.segmentExist = value;
        }

        Boolean getSegmentExist() {
            return this.segmentExist;
        }
    }

    private static class ForkSegmentLoadDropHandler {
        private ForkSegmentLoadDropHandler() {
        }

        public void addSegment() {
        }

        public void removeSegment(ForkSegment segment) {
            segment.setSegmentExist(false);
        }
    }
}

