/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import org.apache.druid.segment.data.ComparableList;
import org.junit.Assert;
import org.junit.Test;

public class ComparableListTest {
    private final List<Integer> integers = ImmutableList.of((Object)1, (Object)2, (Object)3);
    private final ComparableList comparableList = new ComparableList((List)ImmutableList.of((Object)1, (Object)2, (Object)3));

    @Test
    public void testDelegate() {
        Assert.assertEquals(this.integers, (Object)this.comparableList.getDelegate());
        Assert.assertEquals((long)0L, (long)new ComparableList((List)ImmutableList.of()).getDelegate().size());
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)this.integers.hashCode(), (long)this.comparableList.hashCode());
        HashSet<ComparableList> set = new HashSet<ComparableList>();
        set.add(this.comparableList);
        set.add(new ComparableList(this.integers));
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)this.comparableList.equals((Object)new ComparableList(this.integers)));
        Assert.assertFalse((boolean)this.comparableList.equals((Object)new ComparableList((List)ImmutableList.of((Object)1, (Object)2, (Object)5))));
        Assert.assertFalse((boolean)this.comparableList.equals(null));
    }

    @Test
    public void testCompareTo() {
        Assert.assertEquals((long)0L, (long)this.comparableList.compareTo(new ComparableList(this.integers)));
        Assert.assertEquals((long)1L, (long)this.comparableList.compareTo(null));
        Assert.assertEquals((long)1L, (long)this.comparableList.compareTo(new ComparableList((List)ImmutableList.of((Object)1, (Object)2))));
        Assert.assertEquals((long)-1L, (long)this.comparableList.compareTo(new ComparableList((List)ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4))));
        Assert.assertTrue((this.comparableList.compareTo(new ComparableList((List)ImmutableList.of((Object)2))) < 0 ? 1 : 0) != 0);
        ComparableList nullList = new ComparableList((List)Lists.newArrayList((Object[])new Integer[]{null, 1}));
        Assert.assertTrue((this.comparableList.compareTo(nullList) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((nullList.compareTo(this.comparableList) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((nullList.compareTo(new ComparableList((List)Lists.newArrayList((Object[])new Integer[]{null, 1}))) == 0 ? 1 : 0) != 0);
    }
}

