/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.data.FrontCodedIndexed;
import org.apache.druid.segment.data.FrontCodedIndexedWriter;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FrontCodedIndexedTest
extends InitializedNullHandlingTest {
    private final ByteOrder order;
    private final byte version;

    @Parameterized.Parameters(name="byteOrder: {0} useIncrementalBuckets: {1}")
    public static Collection<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{ByteOrder.LITTLE_ENDIAN, (byte)1}, (Object)new Object[]{ByteOrder.LITTLE_ENDIAN, (byte)0}, (Object)new Object[]{ByteOrder.BIG_ENDIAN, (byte)1}, (Object)new Object[]{ByteOrder.BIG_ENDIAN, (byte)0});
    }

    public FrontCodedIndexedTest(ByteOrder byteOrder, byte version) {
        this.order = byteOrder;
        this.version = version;
    }

    @Test
    public void testFrontCodedIndexed() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096).order(this.order);
        ImmutableList theList = ImmutableList.of((Object)"hello", (Object)"helloo", (Object)"hellooo", (Object)"hellooz", (Object)"helloozy");
        FrontCodedIndexedTest.persistToBuffer(buffer, (Iterable<String>)theList, 4, this.version);
        buffer.position(0);
        FrontCodedIndexed codedUtf8Indexed = (FrontCodedIndexed)FrontCodedIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
        Assert.assertEquals((Object)"helloo", (Object)StringUtils.fromUtf8((ByteBuffer)codedUtf8Indexed.get(1)));
        Assert.assertEquals((Object)"helloozy", (Object)StringUtils.fromUtf8((ByteBuffer)codedUtf8Indexed.get(4)));
        Iterator utf8Iterator = codedUtf8Indexed.iterator();
        Iterator newListIterator = theList.iterator();
        int ctr = 0;
        while (newListIterator.hasNext() && utf8Iterator.hasNext()) {
            String next = (String)newListIterator.next();
            ByteBuffer nextUtf8 = (ByteBuffer)utf8Iterator.next();
            Assert.assertEquals((Object)next, (Object)StringUtils.fromUtf8((ByteBuffer)nextUtf8));
            nextUtf8.position(0);
            Assert.assertEquals((Object)next, (Object)StringUtils.fromUtf8((ByteBuffer)codedUtf8Indexed.get(ctr)));
            Assert.assertEquals((long)ctr, (long)codedUtf8Indexed.indexOf(nextUtf8));
            ++ctr;
        }
        Assert.assertEquals((Object)newListIterator.hasNext(), (Object)utf8Iterator.hasNext());
    }

    @Test
    public void testFrontCodedIndexedSingleBucket() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096).order(this.order);
        ImmutableList theList = ImmutableList.of((Object)"hello", (Object)"helloo", (Object)"hellooo", (Object)"hellooz", (Object)"helloozy");
        FrontCodedIndexedTest.persistToBuffer(buffer, (Iterable<String>)theList, 16, this.version);
        FrontCodedIndexed codedUtf8Indexed = (FrontCodedIndexed)FrontCodedIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
        Assert.assertEquals((Object)"hello", (Object)StringUtils.fromUtf8((ByteBuffer)codedUtf8Indexed.get(0)));
        Assert.assertEquals((Object)"helloo", (Object)StringUtils.fromUtf8((ByteBuffer)codedUtf8Indexed.get(1)));
        Assert.assertEquals((Object)"hellooo", (Object)StringUtils.fromUtf8((ByteBuffer)codedUtf8Indexed.get(2)));
        Assert.assertEquals((Object)"hellooz", (Object)StringUtils.fromUtf8((ByteBuffer)codedUtf8Indexed.get(3)));
        Assert.assertEquals((Object)"helloozy", (Object)StringUtils.fromUtf8((ByteBuffer)codedUtf8Indexed.get(4)));
        Iterator newListIterator = theList.iterator();
        Iterator utf8Iterator = codedUtf8Indexed.iterator();
        int ctr = 0;
        while (utf8Iterator.hasNext() && newListIterator.hasNext()) {
            String next = (String)newListIterator.next();
            ByteBuffer nextUtf8 = (ByteBuffer)utf8Iterator.next();
            Assert.assertEquals((Object)next, (Object)StringUtils.fromUtf8((ByteBuffer)nextUtf8));
            nextUtf8.position(0);
            Assert.assertEquals((Object)next, (Object)StringUtils.fromUtf8((ByteBuffer)codedUtf8Indexed.get(ctr)));
            Assert.assertEquals((long)ctr, (long)codedUtf8Indexed.indexOf(nextUtf8));
            ++ctr;
        }
        Assert.assertEquals((Object)newListIterator.hasNext(), (Object)utf8Iterator.hasNext());
    }

    @Test
    public void testFrontCodedIndexedBigger() throws IOException {
        int sizeBase = 10000;
        int bucketSize = 16;
        ByteBuffer buffer = ByteBuffer.allocate(0x1000000).order(this.order);
        for (int sizeAdjust = 0; sizeAdjust < 16; ++sizeAdjust) {
            TreeSet<String> values = new TreeSet<String>((Comparator<String>)GenericIndexed.STRING_STRATEGY);
            for (int i = 0; i < 10000 + sizeAdjust; ++i) {
                values.add(IdUtils.getRandomId() + IdUtils.getRandomId() + IdUtils.getRandomId() + IdUtils.getRandomId());
            }
            FrontCodedIndexedTest.persistToBuffer(buffer, values, 16, this.version);
            FrontCodedIndexed codedUtf8Indexed = (FrontCodedIndexed)FrontCodedIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
            Iterator<String> newListIterator = values.iterator();
            Iterator utf8Iterator = codedUtf8Indexed.iterator();
            int ctr = 0;
            while (utf8Iterator.hasNext() && newListIterator.hasNext()) {
                String next = newListIterator.next();
                ByteBuffer nextUtf8 = (ByteBuffer)utf8Iterator.next();
                Assert.assertEquals((Object)next, (Object)StringUtils.fromUtf8((ByteBuffer)nextUtf8));
                nextUtf8.position(0);
                Assert.assertEquals((Object)next, (Object)StringUtils.fromUtf8((ByteBuffer)codedUtf8Indexed.get(ctr)));
                Assert.assertEquals((long)ctr, (long)codedUtf8Indexed.indexOf(nextUtf8));
                ++ctr;
            }
            Assert.assertEquals((Object)newListIterator.hasNext(), (Object)utf8Iterator.hasNext());
            Assert.assertEquals((long)ctr, (long)(10000 + sizeAdjust));
        }
    }

    @Test
    public void testFrontCodedIndexedBiggerWithNulls() throws IOException {
        int sizeBase = 10000;
        int bucketSize = 16;
        ByteBuffer buffer = ByteBuffer.allocate(0x1000000).order(this.order);
        for (int sizeAdjust = 0; sizeAdjust < 16; ++sizeAdjust) {
            TreeSet<String> values = new TreeSet<String>((Comparator<String>)GenericIndexed.STRING_STRATEGY);
            values.add(null);
            for (int i = 0; i < 10000 + sizeAdjust; ++i) {
                values.add(IdUtils.getRandomId() + IdUtils.getRandomId() + IdUtils.getRandomId() + IdUtils.getRandomId());
            }
            FrontCodedIndexedTest.persistToBuffer(buffer, values, 16, this.version);
            FrontCodedIndexed codedUtf8Indexed = (FrontCodedIndexed)FrontCodedIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
            Iterator<String> newListIterator = values.iterator();
            Iterator utf8Iterator = codedUtf8Indexed.iterator();
            int ctr = 0;
            while (utf8Iterator.hasNext() && newListIterator.hasNext()) {
                String next = newListIterator.next();
                ByteBuffer nextUtf8 = (ByteBuffer)utf8Iterator.next();
                if (next == null) {
                    Assert.assertNull((Object)nextUtf8);
                } else {
                    Assert.assertEquals((Object)next, (Object)StringUtils.fromUtf8((ByteBuffer)nextUtf8));
                    nextUtf8.position(0);
                    Assert.assertEquals((Object)next, (Object)StringUtils.fromUtf8((ByteBuffer)codedUtf8Indexed.get(ctr)));
                }
                Assert.assertEquals((long)ctr, (long)codedUtf8Indexed.indexOf(nextUtf8));
                ++ctr;
            }
            Assert.assertEquals((Object)newListIterator.hasNext(), (Object)utf8Iterator.hasNext());
            Assert.assertEquals((long)ctr, (long)(10000 + sizeAdjust + 1));
        }
    }

    @Test
    public void testFrontCodedIndexedIndexOf() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096).order(this.order);
        ImmutableList theList = ImmutableList.of((Object)"hello", (Object)"helloo", (Object)"hellooo", (Object)"hellooz", (Object)"helloozy");
        FrontCodedIndexedTest.persistToBuffer(buffer, (Iterable<String>)theList, 4, this.version);
        FrontCodedIndexed codedUtf8Indexed = (FrontCodedIndexed)FrontCodedIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
        Assert.assertEquals((long)-1L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"a")));
        Assert.assertEquals((long)0L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"hello")));
        Assert.assertEquals((long)1L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"helloo")));
        Assert.assertEquals((long)-3L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"helloob")));
        Assert.assertEquals((long)4L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"helloozy")));
        Assert.assertEquals((long)-6L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"helloozz")));
        Assert.assertEquals((long)-6L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"wat")));
    }

    @Test
    public void testFrontCodedIndexedIndexOfWithNull() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096).order(this.order);
        ImmutableList theList = ImmutableList.of((Object)"hello", (Object)"helloo", (Object)"hellooo", (Object)"hellooz", (Object)"helloozy");
        TreeSet<String> values = new TreeSet<String>((Comparator<String>)GenericIndexed.STRING_STRATEGY);
        values.add(null);
        values.addAll((Collection<String>)theList);
        FrontCodedIndexedTest.persistToBuffer(buffer, values, 4, this.version);
        FrontCodedIndexed codedUtf8Indexed = (FrontCodedIndexed)FrontCodedIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
        Assert.assertEquals((long)0L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer(null)));
        Assert.assertEquals((long)-2L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"a")));
        Assert.assertEquals((long)1L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"hello")));
        Assert.assertEquals((long)2L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"helloo")));
        Assert.assertEquals((long)-4L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"helloob")));
        Assert.assertEquals((long)5L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"helloozy")));
        Assert.assertEquals((long)-7L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"helloozz")));
        Assert.assertEquals((long)-7L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"wat")));
    }

    @Test
    public void testFrontCodedIndexedUnicodes() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096).order(this.order);
        ImmutableList theList = ImmutableList.of((Object)"Gy\u0151-Moson-Sopron", (Object)"Gy\u0151r", (Object)"\ud83d\udca9", (Object)"\uff08\u8acb\u53c3\u898b\u5df2\u88ab\u522a\u9664\u7248\u672c\uff09");
        FrontCodedIndexedTest.persistToBuffer(buffer, (Iterable<String>)theList, 4, this.version);
        buffer.position(0);
        FrontCodedIndexed codedUtf8Indexed = (FrontCodedIndexed)FrontCodedIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
        Iterator utf8Iterator = codedUtf8Indexed.iterator();
        Iterator newListIterator = theList.iterator();
        int ctr = 0;
        while (newListIterator.hasNext() && utf8Iterator.hasNext()) {
            String next = (String)newListIterator.next();
            ByteBuffer nextUtf8 = (ByteBuffer)utf8Iterator.next();
            Assert.assertEquals((Object)next, (Object)StringUtils.fromUtf8((ByteBuffer)nextUtf8));
            nextUtf8.position(0);
            Assert.assertEquals((String)("mismatch row " + ctr), (Object)next, (Object)StringUtils.fromUtf8((ByteBuffer)codedUtf8Indexed.get(ctr)));
            Assert.assertEquals((long)ctr, (long)codedUtf8Indexed.indexOf(nextUtf8));
            ++ctr;
        }
        Assert.assertEquals((Object)newListIterator.hasNext(), (Object)utf8Iterator.hasNext());
    }

    @Test
    public void testFrontCodedOnlyNull() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096).order(this.order);
        List<Object> theList = Collections.singletonList(null);
        FrontCodedIndexedTest.persistToBuffer(buffer, theList, 4, this.version);
        buffer.position(0);
        FrontCodedIndexed codedUtf8Indexed = (FrontCodedIndexed)FrontCodedIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
        Assert.assertNull((Object)codedUtf8Indexed.get(0));
        Assert.assertThrows(IllegalArgumentException.class, () -> codedUtf8Indexed.get(-1));
        Assert.assertThrows(IllegalArgumentException.class, () -> codedUtf8Indexed.get(theList.size()));
        Assert.assertEquals((long)0L, (long)codedUtf8Indexed.indexOf(null));
        Assert.assertEquals((long)-2L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"hello")));
        Iterator utf8Iterator = codedUtf8Indexed.iterator();
        Assert.assertTrue((boolean)utf8Iterator.hasNext());
        Assert.assertNull(utf8Iterator.next());
        Assert.assertFalse((boolean)utf8Iterator.hasNext());
    }

    @Test
    public void testFrontCodedEmpty() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(64).order(this.order);
        List<String> theList = Collections.emptyList();
        FrontCodedIndexedTest.persistToBuffer(buffer, theList, 4, this.version);
        buffer.position(0);
        FrontCodedIndexed codedUtf8Indexed = (FrontCodedIndexed)FrontCodedIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
        Assert.assertEquals((long)0L, (long)codedUtf8Indexed.size());
        Throwable t = Assert.assertThrows(IAE.class, () -> codedUtf8Indexed.get(0));
        Assert.assertEquals((Object)"Index[0] >= size[0]", (Object)t.getMessage());
        Assert.assertThrows(IllegalArgumentException.class, () -> codedUtf8Indexed.get(-1));
        Assert.assertThrows(IllegalArgumentException.class, () -> codedUtf8Indexed.get(theList.size()));
        Assert.assertEquals((long)-1L, (long)codedUtf8Indexed.indexOf(null));
        Assert.assertEquals((long)-1L, (long)codedUtf8Indexed.indexOf(StringUtils.toUtf8ByteBuffer((String)"hello")));
        Iterator utf8Iterator = codedUtf8Indexed.iterator();
        Assert.assertFalse((boolean)utf8Iterator.hasNext());
    }

    @Test
    public void testBucketSizes() throws IOException {
        int numValues = 10000;
        ByteBuffer buffer = ByteBuffer.allocate(0x1000000).order(this.order);
        int[] bucketSizes = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        TreeSet<String> values = new TreeSet<String>((Comparator<String>)GenericIndexed.STRING_STRATEGY);
        values.add(null);
        for (int i = 0; i < 10000; ++i) {
            values.add(IdUtils.getRandomId() + IdUtils.getRandomId() + IdUtils.getRandomId() + IdUtils.getRandomId());
        }
        for (int bucketSize : bucketSizes) {
            FrontCodedIndexedTest.persistToBuffer(buffer, values, bucketSize, this.version);
            FrontCodedIndexed codedUtf8Indexed = (FrontCodedIndexed)FrontCodedIndexed.read((ByteBuffer)buffer, (ByteOrder)buffer.order()).get();
            Iterator<String> newListIterator = values.iterator();
            Iterator utf8Iterator = codedUtf8Indexed.iterator();
            int ctr = 0;
            while (utf8Iterator.hasNext() && newListIterator.hasNext()) {
                String next = newListIterator.next();
                ByteBuffer nextUtf8 = (ByteBuffer)utf8Iterator.next();
                if (next == null) {
                    Assert.assertNull((Object)nextUtf8);
                } else {
                    Assert.assertEquals((Object)next, (Object)StringUtils.fromUtf8((ByteBuffer)nextUtf8));
                    nextUtf8.position(0);
                    Assert.assertEquals((Object)next, (Object)StringUtils.fromUtf8((ByteBuffer)codedUtf8Indexed.get(ctr)));
                }
                Assert.assertEquals((long)ctr, (long)codedUtf8Indexed.indexOf(nextUtf8));
                ++ctr;
            }
            Assert.assertEquals((Object)newListIterator.hasNext(), (Object)utf8Iterator.hasNext());
            Assert.assertEquals((long)ctr, (long)10001L);
        }
    }

    @Test
    public void testBadBucketSize() {
        OnHeapMemorySegmentWriteOutMedium medium = new OnHeapMemorySegmentWriteOutMedium();
        Assert.assertThrows(IAE.class, () -> new FrontCodedIndexedWriter((SegmentWriteOutMedium)medium, ByteOrder.nativeOrder(), 0, this.version));
        Assert.assertThrows(IAE.class, () -> new FrontCodedIndexedWriter((SegmentWriteOutMedium)medium, ByteOrder.nativeOrder(), 15, this.version));
        Assert.assertThrows(IAE.class, () -> new FrontCodedIndexedWriter((SegmentWriteOutMedium)medium, ByteOrder.nativeOrder(), 256, this.version));
    }

    private static long persistToBuffer(final ByteBuffer buffer, Iterable<String> sortedIterable, int bucketSize, byte version) throws IOException {
        byte[] nextBytes;
        Iterator<String> sortedStrings = sortedIterable.iterator();
        buffer.position(0);
        OnHeapMemorySegmentWriteOutMedium medium = new OnHeapMemorySegmentWriteOutMedium();
        FrontCodedIndexedWriter writer = new FrontCodedIndexedWriter((SegmentWriteOutMedium)medium, buffer.order(), bucketSize, version);
        writer.open();
        int index = 0;
        while (sortedStrings.hasNext()) {
            String next = sortedStrings.next();
            nextBytes = StringUtils.toUtf8Nullable((String)next);
            writer.write((Object)nextBytes);
            if (nextBytes == null) {
                Assert.assertNull((Object)writer.get(index));
            } else {
                Assert.assertArrayEquals((byte[])nextBytes, (byte[])((byte[])writer.get(index)));
            }
            ++index;
        }
        Assert.assertEquals((long)index, (long)writer.getCardinality());
        index = 0;
        for (String next : sortedIterable) {
            nextBytes = StringUtils.toUtf8Nullable((String)next);
            if (nextBytes == null) {
                Assert.assertNull((String)("row " + index), (Object)writer.get(index));
            } else {
                Assert.assertArrayEquals((String)("row " + index), (byte[])nextBytes, (byte[])((byte[])writer.get(index)));
            }
            ++index;
        }
        WritableByteChannel channel = new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) {
                int size = src.remaining();
                buffer.put(src);
                return size;
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() {
            }
        };
        long size = writer.getSerializedSize();
        buffer.position(0);
        writer.writeTo(channel, null);
        Assert.assertEquals((long)size, (long)buffer.position());
        buffer.position(0);
        return size;
    }
}

