/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.filter.ColumnComparisonDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.segment.filter.ColumnComparisonFilter;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ColumnComparisonFilterTest
extends BaseFilterTest {
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final InputRowParser<Map<String, Object>> PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "iso", DateTimes.of((String)"2000")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim0", (Object)"dim1", (Object)"dim2")))));
    private static final List<InputRow> ROWS = ImmutableList.of((Object)((InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"0", (Object)"dim1", (Object)"", (Object)"dim2", (Object)ImmutableList.of((Object)"1", (Object)"2"))).get(0)), (Object)((InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"1", (Object)"dim1", (Object)"10", (Object)"dim2", (Object)ImmutableList.of())).get(0)), (Object)((InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"2", (Object)"dim1", (Object)"2", (Object)"dim2", (Object)ImmutableList.of((Object)""))).get(0)), (Object)((InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"3", (Object)"dim1", (Object)"1", (Object)"dim2", (Object)ImmutableList.of((Object)"3"))).get(0)), (Object)((InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"4", (Object)"dim1", (Object)"1", (Object)"dim2", (Object)ImmutableList.of((Object)"4", (Object)"5"))).get(0)), (Object)((InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"5", (Object)"dim1", (Object)"5", (Object)"dim2", (Object)ImmutableList.of((Object)"4", (Object)"5"))).get(0)), (Object)((InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"6", (Object)"dim1", (Object)"1")).get(0)), (Object)((InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"7", (Object)"dim1", (Object)"a")).get(0)), (Object)((InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"8", (Object)"dim1", (Object)8L)).get(0)), (Object)((InputRow)PARSER.parseBatch((Object)ImmutableMap.of((Object)"dim0", (Object)"9", (Object)"dim1", (Object)Float.valueOf(1.234f), (Object)"dim2", (Object)Float.valueOf(1.234f))).get(0)));

    public ColumnComparisonFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(ColumnComparisonFilterTest.class.getName());
    }

    @Test
    public void testColumnsWithoutNulls() {
        if (this.isAutoSchema()) {
            return;
        }
        this.assertFilterMatchesSkipVectorize((DimFilter)new ColumnComparisonDimFilter((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim0"), (Object)DefaultDimensionSpec.of((String)"dim1"))), (List<String>)ImmutableList.of((Object)"2", (Object)"5", (Object)"8"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new ColumnComparisonDimFilter((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim0"), (Object)DefaultDimensionSpec.of((String)"dim2"))), (List<String>)ImmutableList.of((Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new ColumnComparisonDimFilter((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1"), (Object)DefaultDimensionSpec.of((String)"dim2"))), (List<String>)ImmutableList.of((Object)"5", (Object)"9"));
        this.assertFilterMatchesSkipVectorize((DimFilter)new ColumnComparisonDimFilter((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim0"), (Object)DefaultDimensionSpec.of((String)"dim1"), (Object)DefaultDimensionSpec.of((String)"dim2"))), (List<String>)ImmutableList.of((Object)"5"));
    }

    @Test
    public void testMissingColumnNotSpecifiedInDimensionList() {
        if (this.isAutoSchema()) {
            return;
        }
        this.assertFilterMatchesSkipVectorize((DimFilter)new ColumnComparisonDimFilter((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim6"), (Object)DefaultDimensionSpec.of((String)"dim7"))), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatchesSkipVectorize((DimFilter)new ColumnComparisonDimFilter((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1"), (Object)DefaultDimensionSpec.of((String)"dim6"))), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatchesSkipVectorize((DimFilter)new ColumnComparisonDimFilter((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim2"), (Object)DefaultDimensionSpec.of((String)"dim6"))), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"6", (Object)"7", (Object)"8"));
            this.assertFilterMatchesSkipVectorize((DimFilter)new ColumnComparisonDimFilter((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1"), (Object)DefaultDimensionSpec.of((String)"dim6"))), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatchesSkipVectorize((DimFilter)new ColumnComparisonDimFilter((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim2"), (Object)DefaultDimensionSpec.of((String)"dim6"))), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"6", (Object)"7", (Object)"8"));
        } else {
            this.assertFilterMatchesSkipVectorize((DimFilter)new ColumnComparisonDimFilter((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1"), (Object)DefaultDimensionSpec.of((String)"dim6"))), Collections.emptyList());
            this.assertFilterMatchesSkipVectorize((DimFilter)new ColumnComparisonDimFilter((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim2"), (Object)DefaultDimensionSpec.of((String)"dim6"))), (List<String>)ImmutableList.of((Object)"1", (Object)"6", (Object)"7", (Object)"8"));
            this.assertFilterMatchesSkipVectorize((DimFilter)new ColumnComparisonDimFilter((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1"), (Object)DefaultDimensionSpec.of((String)"dim6"))), (List<String>)ImmutableList.of());
            this.assertFilterMatchesSkipVectorize((DimFilter)new ColumnComparisonDimFilter((List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim2"), (Object)DefaultDimensionSpec.of((String)"dim6"))), (List<String>)ImmutableList.of((Object)"1", (Object)"6", (Object)"7", (Object)"8"));
        }
    }

    @Test
    public void testSelectorWithLookupExtractionFn() {
        ImmutableMap stringMap = ImmutableMap.of((Object)"a", (Object)"7");
        MapLookupExtractor mapExtractor = new MapLookupExtractor((Map)stringMap, false);
        LookupExtractionFn lookupFn = new LookupExtractionFn((LookupExtractor)mapExtractor, true, null, Boolean.valueOf(false), Boolean.valueOf(true));
        this.assertFilterMatchesSkipVectorize((DimFilter)new ColumnComparisonDimFilter((List)ImmutableList.of((Object)new ExtractionDimensionSpec("dim0", "dim0", (ExtractionFn)lookupFn), (Object)new ExtractionDimensionSpec("dim1", "dim1", (ExtractionFn)lookupFn))), (List<String>)ImmutableList.of((Object)"2", (Object)"5", (Object)"7", (Object)"8"));
    }

    @Test
    public void testEqualsContract() {
        EqualsVerifier.forClass(ColumnComparisonFilter.class).usingGetClass().verify();
    }
}

