/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.filter.ExpressionFilterTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExpressionFilterNonStrictBooleansTest
extends ExpressionFilterTest {
    public ExpressionFilterNonStrictBooleansTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, indexBuilder, finisher, cnf, optimize);
    }

    @Override
    @Before
    public void setup() {
        ExpressionProcessing.initializeForStrictBooleansTests((boolean)false);
    }

    @Override
    @Test
    public void testComplement() {
        if (NullHandling.sqlCompatible()) {
            this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("dim5 == 'a'"), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("dim5 == 'a'")), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
            this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("dim5 == ''"), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("dim5 == ''")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        } else {
            this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("dim5 == 'a'"), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("dim5 == 'a'")), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        }
    }

    @Override
    @Test
    public void testMissingColumn() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing == ''"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
            this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing == otherMissing"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        } else {
            this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing == null"), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing == null")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
            this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing == otherMissing"), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing == otherMissing")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        }
        this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing == '1'"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing == 2"), (List<String>)ImmutableList.of());
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing < '2'"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
            this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing < 2"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
            this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing < 2.0"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        } else {
            this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing < '2'"), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing < 2"), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing < 2.0"), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing > '2'"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing > 2"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("missing > 2.0"), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)ExpressionFilterNonStrictBooleansTest.edf("like(missing, '1%')"), (List<String>)ImmutableList.of());
    }
}

