/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.ColumnSelectorColumnIndexSelector;
import org.apache.druid.segment.FilterAnalysis;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.segment.filter.DimensionPredicateFilter;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.segment.filter.cnf.CNFFilterExplosionException;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FilterPartitionTest
extends BaseFilterTest {
    private static final String JS_FN = "function(str) { return 'super-' + str; }";
    private static final ExtractionFn JS_EXTRACTION_FN = new JavaScriptExtractionFn("function(str) { return 'super-' + str; }", false, JavaScriptConfig.getEnabledInstance());
    private static final List<InputRow> ROWS = ImmutableList.builder().addAll((Iterable)DEFAULT_ROWS).add((Object)FilterPartitionTest.makeDefaultSchemaRow("6", "B453B411", ImmutableList.of((Object)"c", (Object)"d", (Object)"e"), null, null, null, null, null)).add((Object)FilterPartitionTest.makeDefaultSchemaRow("7", "HELLO", ImmutableList.of((Object)"foo"), null, null, null, null, null)).add((Object)FilterPartitionTest.makeDefaultSchemaRow("8", "abc", ImmutableList.of((Object)"bar"), null, null, null, null, null)).add((Object)FilterPartitionTest.makeDefaultSchemaRow("9", "1", ImmutableList.of((Object)"foo", (Object)"bar"), null, null, null, null, null)).build();

    public FilterPartitionTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(FilterPartitionTest.class.getName());
    }

    @Test
    public void testSinglePreFilterWithNulls() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", null, null), (List<String>)ImmutableList.of((Object)"0"));
        } else {
            this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", null, null), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "10", null), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "2", null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "1", null), (List<String>)ImmutableList.of((Object)"3", (Object)"9"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "abdef", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "abc", null), (List<String>)ImmutableList.of((Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)new SelectorDimFilter("dim1", "ab", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testSinglePostFilterWithNulls() {
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", null, null), (List<String>)ImmutableList.of((Object)"0"));
        } else {
            this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", null, null), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "10", null), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "2", null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "1", null), (List<String>)ImmutableList.of((Object)"3", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "abdef", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "abc", null), (List<String>)ImmutableList.of((Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "ab", null), (List<String>)ImmutableList.of());
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-null", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"0"));
        } else {
            this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"0"));
        }
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-10", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-2", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-1", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"3", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-abdef", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-abc", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim1", "super-ab", JS_EXTRACTION_FN), (List<String>)ImmutableList.of());
    }

    @Test
    public void testBasicPreAndPostFilterWithNulls() {
        if (this.isAutoSchema()) {
            return;
        }
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim2", "a", null), new NoBitmapSelectorDimFilter("dim1", null, null)})), (List<String>)ImmutableList.of((Object)"0"));
        } else {
            this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim2", "a", null), new NoBitmapSelectorDimFilter("dim1", null, null)})), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "10", null), new NoBitmapSelectorDimFilter("dim2", null, null)})), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "1", null), new NoBitmapSelectorDimFilter("dim2", "foo", null)})), (List<String>)ImmutableList.of((Object)"9"));
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "HELLO", null), new NoBitmapSelectorDimFilter("dim2", "bar", null)})), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim2", "bar", null), new SelectorDimFilter("dim1", "NOT_A_VALUE", null)})), (List<String>)ImmutableList.of());
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim2", "super-a", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim1", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-2", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"2"));
        } else {
            this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim2", "super-a", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim1", "super-", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"0"));
            this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim2", "super-a", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim1", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-2", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-2", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-10", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-1", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-foo", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"9"));
        this.assertFilterMatches((DimFilter)new AndDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-HELLO", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-bar", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of());
    }

    @Test
    public void testOrPostFilterWithNulls() {
        if (this.isAutoSchema()) {
            return;
        }
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim2", "a", null), new NoBitmapSelectorDimFilter("dim1", null, null)})), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "abc", null), new NoBitmapSelectorDimFilter("dim2", null, null)})), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5", (Object)"8"));
        } else {
            this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "abc", null), new NoBitmapSelectorDimFilter("dim2", null, null)})), (List<String>)ImmutableList.of((Object)"1", (Object)"5", (Object)"8"));
        }
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "2", null), new NoBitmapSelectorDimFilter("dim2", null, null)})), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "INVALID_VALUE", null), new NoBitmapSelectorDimFilter("dim2", "foo", null)})), (List<String>)ImmutableList.of((Object)"7", (Object)"9"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "HELLO", null), new NoBitmapSelectorDimFilter("dim2", "bar", null)})), (List<String>)ImmutableList.of((Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "HELLO", null), new SelectorDimFilter("dim2", "NOT_A_VALUE", null)})), (List<String>)ImmutableList.of((Object)"7"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "INVALID", null), new SelectorDimFilter("dim2", "NOT_A_VALUE", null)})), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim2", "super-a", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim1", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-abc", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5", (Object)"8"));
        } else {
            this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-abc", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"1", (Object)"5", (Object)"8"));
            this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-abc", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"2", (Object)"5", (Object)"8"));
        }
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-2", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "INVALID_VALUE", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-foo", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"7", (Object)"9"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new SelectorDimFilter("dim1", "super-HELLO", JS_EXTRACTION_FN), new NoBitmapSelectorDimFilter("dim2", "super-bar", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "super-HELLO", JS_EXTRACTION_FN), new SelectorDimFilter("dim2", "NOT_A_VALUE", null)})), (List<String>)ImmutableList.of((Object)"7"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "INVALID", JS_EXTRACTION_FN), new SelectorDimFilter("dim2", "NOT_A_VALUE", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", null, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        } else {
            this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "", null), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "a", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "b", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "c", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "abc", null), new SelectorDimFilter("dim3", "NOTHERE", null)})), (List<String>)ImmutableList.of((Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "abc", null), new SelectorDimFilter("dim3", null, null)})), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "super-null", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "super-null", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "a", JS_EXTRACTION_FN), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "b", JS_EXTRACTION_FN), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim3", "c", JS_EXTRACTION_FN), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "super-abc", JS_EXTRACTION_FN), new SelectorDimFilter("dim3", "NOTHERE", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"5", (Object)"8"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "abc", JS_EXTRACTION_FN), new SelectorDimFilter("dim3", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
    }

    @Test
    public void testMissingColumnNotSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", null, null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        } else {
            this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "", null), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "a", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "b", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "c", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "abc", null), new SelectorDimFilter("dim4", null, null)})), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim4", null, null), new SelectorDimFilter("dim1", "abc", null)})), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "super-null", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "super-null", JS_EXTRACTION_FN), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "a", JS_EXTRACTION_FN), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "b", JS_EXTRACTION_FN), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new NoBitmapSelectorDimFilter("dim4", "c", JS_EXTRACTION_FN), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "super-abc", JS_EXTRACTION_FN), new SelectorDimFilter("dim4", "super-null", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
        this.assertFilterMatches((DimFilter)new OrDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim4", "super-null", JS_EXTRACTION_FN), new SelectorDimFilter("dim1", "super-abc", JS_EXTRACTION_FN)})), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9"));
    }

    @Test
    public void testDistributeOrCNF() throws CNFFilterExplosionException {
        if (this.isAutoSchema()) {
            return;
        }
        OrDimFilter dimFilter1 = new OrDimFilter(Arrays.asList(new SelectorDimFilter("dim0", "6", null), new AndDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "abdef", null), new SelectorDimFilter("dim2", "c", null)}))));
        Filter filter1 = dimFilter1.toFilter();
        Filter filter1CNF = Filters.toCnf((Filter)filter1);
        Assert.assertEquals(AndFilter.class, filter1CNF.getClass());
        Assert.assertEquals((long)2L, (long)((AndFilter)filter1CNF).getFilters().size());
        this.assertFilterMatches((DimFilter)dimFilter1, (List<String>)ImmutableList.of((Object)"4", (Object)"6"));
        OrDimFilter dimFilter2 = new OrDimFilter(Arrays.asList(new SelectorDimFilter("dim0", "2", null), new SelectorDimFilter("dim0", "3", null), new AndDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "HELLO", null), new SelectorDimFilter("dim2", "foo", null)}))));
        this.assertFilterMatches((DimFilter)dimFilter2, (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"7"));
        OrDimFilter dimFilter3 = new OrDimFilter(Arrays.asList(dimFilter1, dimFilter2, new AndDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "1", null), new SelectorDimFilter("dim2", "foo", null)}))));
        this.assertFilterMatches((DimFilter)dimFilter3, (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4", (Object)"6", (Object)"7", (Object)"9"));
    }

    @Test
    public void testDistributeOrCNFExtractionFn() throws CNFFilterExplosionException {
        if (this.isAutoSchema()) {
            return;
        }
        OrDimFilter dimFilter1 = new OrDimFilter(Arrays.asList(new SelectorDimFilter("dim0", "super-6", JS_EXTRACTION_FN), new AndDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "super-abdef", JS_EXTRACTION_FN), new SelectorDimFilter("dim2", "super-c", JS_EXTRACTION_FN)}))));
        Filter filter1 = dimFilter1.toFilter();
        Filter filter1CNF = Filters.toCnf((Filter)filter1);
        Assert.assertEquals(AndFilter.class, filter1CNF.getClass());
        Assert.assertEquals((long)2L, (long)((AndFilter)filter1CNF).getFilters().size());
        this.assertFilterMatches((DimFilter)dimFilter1, (List<String>)ImmutableList.of((Object)"4", (Object)"6"));
        OrDimFilter dimFilter2 = new OrDimFilter(Arrays.asList(new SelectorDimFilter("dim0", "super-2", JS_EXTRACTION_FN), new SelectorDimFilter("dim0", "super-3", JS_EXTRACTION_FN), new AndDimFilter(Arrays.asList(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "super-HELLO", JS_EXTRACTION_FN), new SelectorDimFilter("dim2", "super-foo", JS_EXTRACTION_FN)}))));
        this.assertFilterMatches((DimFilter)dimFilter2, (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"7"));
        OrDimFilter dimFilter3 = new OrDimFilter(new DimFilter[]{dimFilter1, dimFilter2, new AndDimFilter(new DimFilter[]{new NoBitmapSelectorDimFilter("dim1", "super-1", JS_EXTRACTION_FN), new SelectorDimFilter("dim2", "super-foo", JS_EXTRACTION_FN)})});
        this.assertFilterMatches((DimFilter)dimFilter3, (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4", (Object)"6", (Object)"7", (Object)"9"));
    }

    @Test
    public void testAnalyze() {
        if (!(this.adapter instanceof QueryableIndexStorageAdapter)) {
            return;
        }
        QueryableIndexStorageAdapter storageAdapter = (QueryableIndexStorageAdapter)this.adapter;
        int numRows = this.adapter.getNumRows();
        SelectorFilter normalFilter = new SelectorFilter("dim1", "HELLO");
        ColumnSelectorColumnIndexSelector bitmapIndexSelector = storageAdapter.makeBitmapIndexSelector(BaseFilterTest.VIRTUAL_COLUMNS);
        FilterAnalysis filterAnalysisNormal = FilterAnalysis.analyzeFilter((Filter)normalFilter, (ColumnSelectorColumnIndexSelector)bitmapIndexSelector, null, (int)numRows);
        Assert.assertTrue((filterAnalysisNormal.getPreFilterBitmap() != null ? 1 : 0) != 0);
        Assert.assertTrue((filterAnalysisNormal.getPostFilter() == null ? 1 : 0) != 0);
        NoBitmapSelectorFilter noBitmapFilter = new NoBitmapSelectorFilter("dim1", "HELLO");
        FilterAnalysis noBitmapFilterAnalysis = FilterAnalysis.analyzeFilter((Filter)noBitmapFilter, (ColumnSelectorColumnIndexSelector)bitmapIndexSelector, null, (int)numRows);
        Assert.assertTrue((noBitmapFilterAnalysis.getPreFilterBitmap() == null ? 1 : 0) != 0);
        Assert.assertTrue((noBitmapFilterAnalysis.getPostFilter() != null ? 1 : 0) != 0);
        SelectorFilter bitmapFilterWithForceNoIndexTuning = new SelectorFilter("dim1", "HELLO", new FilterTuning(Boolean.valueOf(false), null, null));
        FilterAnalysis bitmapFilterWithForceNoIndexTuningAnalysis = FilterAnalysis.analyzeFilter((Filter)bitmapFilterWithForceNoIndexTuning, (ColumnSelectorColumnIndexSelector)bitmapIndexSelector, null, (int)numRows);
        Assert.assertTrue((bitmapFilterWithForceNoIndexTuningAnalysis.getPreFilterBitmap() == null ? 1 : 0) != 0);
        Assert.assertTrue((bitmapFilterWithForceNoIndexTuningAnalysis.getPostFilter() != null ? 1 : 0) != 0);
        SelectorFilter bitmapFilterWithCardinalityMax = new SelectorFilter("dim1", "HELLO", new FilterTuning(Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(3)));
        FilterAnalysis bitmapFilterWithCardinalityMaxAnalysis = FilterAnalysis.analyzeFilter((Filter)bitmapFilterWithCardinalityMax, (ColumnSelectorColumnIndexSelector)bitmapIndexSelector, null, (int)numRows);
        Assert.assertTrue((bitmapFilterWithCardinalityMaxAnalysis.getPreFilterBitmap() == null ? 1 : 0) != 0);
        Assert.assertTrue((bitmapFilterWithCardinalityMaxAnalysis.getPostFilter() != null ? 1 : 0) != 0);
        SelectorFilter bitmapFilterWithCardinalityMax2 = new SelectorFilter("dim1", "HELLO", new FilterTuning(Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(1000)));
        FilterAnalysis bitmapFilterWithCardinalityMax2Analysis = FilterAnalysis.analyzeFilter((Filter)bitmapFilterWithCardinalityMax2, (ColumnSelectorColumnIndexSelector)bitmapIndexSelector, null, (int)numRows);
        Assert.assertTrue((bitmapFilterWithCardinalityMax2Analysis.getPreFilterBitmap() != null ? 1 : 0) != 0);
        Assert.assertTrue((bitmapFilterWithCardinalityMax2Analysis.getPostFilter() == null ? 1 : 0) != 0);
        SelectorFilter bitmapFilterWithCardinalityMin = new SelectorFilter("dim1", "HELLO", new FilterTuning(Boolean.valueOf(true), Integer.valueOf(1000), null));
        FilterAnalysis bitmapFilterWithCardinalityMinAnalysis = FilterAnalysis.analyzeFilter((Filter)bitmapFilterWithCardinalityMin, (ColumnSelectorColumnIndexSelector)bitmapIndexSelector, null, (int)numRows);
        Assert.assertTrue((bitmapFilterWithCardinalityMinAnalysis.getPreFilterBitmap() == null ? 1 : 0) != 0);
        Assert.assertTrue((bitmapFilterWithCardinalityMinAnalysis.getPostFilter() != null ? 1 : 0) != 0);
        NoBitmapSelectorFilter noBitmapFilterWithForceUse = new NoBitmapSelectorFilter("dim1", "HELLO", new FilterTuning(Boolean.valueOf(true), null, null));
        FilterAnalysis noBitmapFilterWithForceUseAnalysis = FilterAnalysis.analyzeFilter((Filter)noBitmapFilterWithForceUse, (ColumnSelectorColumnIndexSelector)bitmapIndexSelector, null, (int)numRows);
        Assert.assertTrue((noBitmapFilterWithForceUseAnalysis.getPreFilterBitmap() == null ? 1 : 0) != 0);
        Assert.assertTrue((noBitmapFilterWithForceUseAnalysis.getPostFilter() != null ? 1 : 0) != 0);
    }

    private static class NoBitmapSelectorDimFilter
    extends SelectorDimFilter {
        NoBitmapSelectorDimFilter(String dimension, String value, ExtractionFn extractionFn) {
            super(dimension, value, extractionFn);
        }

        public Filter toFilter() {
            ExtractionFn extractionFn = this.getExtractionFn();
            String dimension = this.getDimension();
            String value = this.getValue();
            if (extractionFn == null) {
                return new NoBitmapSelectorFilter(dimension, value);
            }
            final String valueOrNull = NullHandling.emptyToNullIfNeeded((String)value);
            DruidPredicateFactory predicateFactory = new DruidPredicateFactory(){

                public DruidObjectPredicate<String> makeStringPredicate() {
                    return valueOrNull == null ? DruidObjectPredicate.isNull() : DruidObjectPredicate.equalTo((Object)valueOrNull);
                }

                public DruidLongPredicate makeLongPredicate() {
                    return input -> DruidPredicateMatch.of((boolean)Objects.equals(valueOrNull, String.valueOf(input)));
                }

                public DruidFloatPredicate makeFloatPredicate() {
                    return input -> DruidPredicateMatch.of((boolean)Objects.equals(valueOrNull, String.valueOf(input)));
                }

                public DruidDoublePredicate makeDoublePredicate() {
                    return input -> DruidPredicateMatch.of((boolean)Objects.equals(valueOrNull, String.valueOf(input)));
                }
            };
            return new NoBitmapDimensionPredicateFilter(dimension, predicateFactory, extractionFn);
        }
    }

    private static class NoBitmapDimensionPredicateFilter
    extends DimensionPredicateFilter {
        public NoBitmapDimensionPredicateFilter(String dimension, DruidPredicateFactory predicateFactory, ExtractionFn extractionFn) {
            super(dimension, predicateFactory, extractionFn);
        }

        @Nullable
        public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
            return null;
        }
    }

    private static class NoBitmapSelectorFilter
    extends SelectorFilter {
        public NoBitmapSelectorFilter(String dimension, String value) {
            super(dimension, value);
        }

        public NoBitmapSelectorFilter(String dimension, String value, FilterTuning filterTuning) {
            super(dimension, value, filterTuning);
        }

        @Nullable
        public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
            return null;
        }
    }
}

