/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InFilterTest
extends BaseFilterTest {
    private static final List<InputRow> ROWS = ImmutableList.of((Object)InFilterTest.makeDefaultSchemaRow("a", "", ImmutableList.of((Object)"a", (Object)"b"), "2017-07-25", "", 0.0, Float.valueOf(0.0f), 0L), (Object)InFilterTest.makeDefaultSchemaRow("b", "10", ImmutableList.of(), "2017-07-25", "a", 10.1, Float.valueOf(10.1f), 100L), (Object)InFilterTest.makeDefaultSchemaRow("c", "2", ImmutableList.of((Object)""), "2017-05-25", null, null, Float.valueOf(5.5f), 40L), (Object)InFilterTest.makeDefaultSchemaRow("d", "1", ImmutableList.of((Object)"a"), "2020-01-25", "b", 120.0245, Float.valueOf(110.0f), null), (Object)InFilterTest.makeDefaultSchemaRow("e", "def", ImmutableList.of((Object)"c"), null, "c", 60.0, null, 9001L), (Object)InFilterTest.makeDefaultSchemaRow("f", "abc", null, "2020-01-25", "a", 765.432, Float.valueOf(123.45f), 12345L));

    public InFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(InFilterTest.class.getName());
    }

    @Test
    public void testSingleValueStringColumnWithoutNulls() {
        this.assertFilterMatches(this.toInFilter("dim0"), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)this.toInFilter("dim0")), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        this.assertFilterMatches(this.toInFilter("dim0", null, new String[0]), (List<String>)ImmutableList.of());
        this.assertFilterMatches(this.toInFilter("dim0", "", ""), (List<String>)ImmutableList.of());
        this.assertFilterMatches(this.toInFilter("dim0", "a", "c"), (List<String>)ImmutableList.of((Object)"a", (Object)"c"));
        this.assertFilterMatches(this.toInFilter("dim0", "e", "x"), (List<String>)ImmutableList.of((Object)"e"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)this.toInFilter("dim0", "e", "x")), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"f"));
    }

    @Test
    public void testSingleValueStringColumnWithNulls() {
        this.assertFilterMatches(this.toInFilter("dim1", null, ""), (List<String>)ImmutableList.of((Object)"a"));
        this.assertFilterMatches(this.toInFilter("dim1", "", new String[0]), (List<String>)ImmutableList.of((Object)"a"));
        this.assertFilterMatches(this.toInFilter("dim1", "-1", "ab", "de"), (List<String>)ImmutableList.of());
        this.assertFilterMatches(this.toInFilter("s0", "a", "b"), (List<String>)ImmutableList.of((Object)"b", (Object)"d", (Object)"f"));
        this.assertFilterMatches(this.toInFilter("s0", "noexist", new String[0]), (List<String>)ImmutableList.of());
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches(this.toInFilter("dim1", null, "10", "abc"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"f"));
            this.assertFilterMatches(this.toInFilter("dim1", null, "10", "abc"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)this.toInFilter("dim1", "-1", "ab", "de")), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)this.toInFilter("s0", "a", "b")), (List<String>)ImmutableList.of((Object)"a", (Object)"c", (Object)"e"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)this.toInFilter("s0", "noexist", new String[0])), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        } else {
            this.assertFilterMatches(this.toInFilter("dim1", null, "10", "abc"), (List<String>)ImmutableList.of((Object)"b", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)this.toInFilter("dim1", "-1", "ab", "de")), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)this.toInFilter("s0", "a", "b")), (List<String>)ImmutableList.of((Object)"a", (Object)"e"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)this.toInFilter("s0", "noexist", new String[0])), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"d", (Object)"e", (Object)"f"));
        }
    }

    @Test
    public void testMultiValueStringColumn() {
        if (this.isAutoSchema()) {
            return;
        }
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches(this.toInFilter("dim2", "b", "d"), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches(this.toInFilter("dim2", null, new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"f"));
            this.assertFilterMatches(this.toInFilter("dim2", null, "a"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"f"));
            this.assertFilterMatches(this.toInFilter("dim2", null, "b"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"f"));
            this.assertFilterMatches(this.toInFilter("dim2", "", new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"f"));
        } else {
            this.assertFilterMatches(this.toInFilter("dim2", null, new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"f"));
            this.assertFilterMatches(this.toInFilter("dim2", null, "a"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"d", (Object)"f"));
            this.assertFilterMatches(this.toInFilter("dim2", null, "b"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"f"));
            this.assertFilterMatches(this.toInFilter("dim2", "", new String[0]), (List<String>)ImmutableList.of((Object)"c"));
        }
        this.assertFilterMatches(this.toInFilter("dim2", "", new String[]{null}), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"f"));
        this.assertFilterMatches(this.toInFilter("dim2", "c", new String[0]), (List<String>)ImmutableList.of((Object)"e"));
        this.assertFilterMatches(this.toInFilter("dim2", "d", new String[0]), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumn() {
        this.assertFilterMatches(this.toInFilter("dim3", null, new String[]{null}), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)this.toInFilter("dim3", null, new String[]{null})), (List<String>)ImmutableList.of());
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatches(this.toInFilter("dim3", "", new String[0]), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        } else {
            this.assertFilterMatches(this.toInFilter("dim3", "", new String[0]), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)this.toInFilter("dim3", "", new String[0])), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatches(this.toInFilter("dim3", null, "a"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)this.toInFilter("dim3", null, "a")), (List<String>)ImmutableList.of());
        this.assertFilterMatches(this.toInFilter("dim3", "a", new String[0]), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)this.toInFilter("dim3", "a", new String[0])), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of() : ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f")));
        this.assertFilterMatches(this.toInFilter("dim3", "b", new String[0]), (List<String>)ImmutableList.of());
        this.assertFilterMatches(this.toInFilter("dim3", "c", new String[0]), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMatchWithExtractionFn() {
        String extractionJsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn superFn = new JavaScriptExtractionFn(extractionJsFn, false, JavaScriptConfig.getEnabledInstance());
        String nullJsFn = "function(str) { if (str === null) { return 'YES'; } else { return 'NO';} }";
        JavaScriptExtractionFn yesNullFn = new JavaScriptExtractionFn(nullJsFn, false, JavaScriptConfig.getEnabledInstance());
        if (NullHandling.replaceWithDefault()) {
            this.assertFilterMatchesSkipArrays(this.toInFilterWithFn("dim2", (ExtractionFn)superFn, "super-null", "super-a", "super-b"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"f"));
            this.assertFilterMatchesSkipArrays((DimFilter)NotDimFilter.of((DimFilter)this.toInFilterWithFn("dim2", (ExtractionFn)superFn, "super-null", "super-a", "super-b")), (List<String>)ImmutableList.of((Object)"e"));
            this.assertFilterMatchesSkipArrays(this.toInFilterWithFn("dim2", (ExtractionFn)yesNullFn, "YES", new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"f"));
            this.assertFilterMatchesSkipArrays((DimFilter)NotDimFilter.of((DimFilter)this.toInFilterWithFn("dim2", (ExtractionFn)yesNullFn, "YES", new String[0])), (List<String>)ImmutableList.of((Object)"a", (Object)"d", (Object)"e"));
            this.assertFilterMatches(this.toInFilterWithFn("dim1", (ExtractionFn)superFn, "super-null", "super-10", "super-def"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"e"));
            this.assertFilterMatches(this.toInFilterWithFn("dim1", (ExtractionFn)yesNullFn, "NO", new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        } else {
            this.assertFilterMatchesSkipArrays(this.toInFilterWithFn("dim2", (ExtractionFn)superFn, "super-null", "super-a", "super-b"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"d", (Object)"f"));
            this.assertFilterMatchesSkipArrays((DimFilter)NotDimFilter.of((DimFilter)this.toInFilterWithFn("dim2", (ExtractionFn)superFn, "super-null", "super-a", "super-b")), (List<String>)ImmutableList.of((Object)"c", (Object)"e"));
            this.assertFilterMatchesSkipArrays(this.toInFilterWithFn("dim2", (ExtractionFn)yesNullFn, "YES", new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"f"));
            this.assertFilterMatchesSkipArrays((DimFilter)NotDimFilter.of((DimFilter)this.toInFilterWithFn("dim2", (ExtractionFn)yesNullFn, "YES", new String[0])), (List<String>)ImmutableList.of((Object)"a", (Object)"c", (Object)"d", (Object)"e"));
            this.assertFilterMatches(this.toInFilterWithFn("dim1", (ExtractionFn)superFn, "super-null", "super-10", "super-def"), (List<String>)ImmutableList.of((Object)"b", (Object)"e"));
            this.assertFilterMatches(this.toInFilterWithFn("dim1", (ExtractionFn)yesNullFn, "NO", new String[0]), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        }
        this.assertFilterMatches(this.toInFilterWithFn("dim3", (ExtractionFn)yesNullFn, "NO", new String[0]), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)this.toInFilterWithFn("dim3", (ExtractionFn)yesNullFn, "NO", new String[0])), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        this.assertFilterMatches(this.toInFilterWithFn("dim3", (ExtractionFn)yesNullFn, "YES", new String[0]), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
    }

    @Test
    public void testMatchWithLookupExtractionFn() {
        ImmutableMap stringMap = ImmutableMap.of((Object)"a", (Object)"HELLO", (Object)"10", (Object)"HELLO", (Object)"def", (Object)"HELLO", (Object)"c", (Object)"BYE");
        MapLookupExtractor mapExtractor = new MapLookupExtractor((Map)stringMap, false);
        LookupExtractionFn lookupFn = new LookupExtractionFn((LookupExtractor)mapExtractor, false, "UNKNOWN", Boolean.valueOf(false), Boolean.valueOf(true));
        this.assertFilterMatches(this.toInFilterWithFn("dim0", (ExtractionFn)lookupFn, null, "HELLO"), (List<String>)ImmutableList.of((Object)"a"));
        this.assertFilterMatches(this.toInFilterWithFn("dim0", (ExtractionFn)lookupFn, "HELLO", "BYE"), (List<String>)ImmutableList.of((Object)"a", (Object)"c"));
        this.assertFilterMatches(this.toInFilterWithFn("dim0", (ExtractionFn)lookupFn, "UNKNOWN", new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"d", (Object)"e", (Object)"f"));
        this.assertFilterMatches(this.toInFilterWithFn("dim1", (ExtractionFn)lookupFn, "HELLO", new String[0]), (List<String>)ImmutableList.of((Object)"b", (Object)"e"));
        this.assertFilterMatches(this.toInFilterWithFn("dim1", (ExtractionFn)lookupFn, "N/A", new String[0]), (List<String>)ImmutableList.of());
        if (this.optimize) {
            this.assertFilterMatches(this.toInFilterWithFn("dim2", (ExtractionFn)lookupFn, "a", new String[0]), (List<String>)ImmutableList.of());
        } else {
            this.assertFilterMatchesSkipArrays(this.toInFilterWithFn("dim2", (ExtractionFn)lookupFn, "a", new String[0]), (List<String>)ImmutableList.of());
        }
        this.assertFilterMatchesSkipArrays(this.toInFilterWithFn("dim2", (ExtractionFn)lookupFn, "HELLO", new String[0]), (List<String>)ImmutableList.of((Object)"a", (Object)"d"));
        this.assertFilterMatchesSkipArrays(this.toInFilterWithFn("dim2", (ExtractionFn)lookupFn, "HELLO", "BYE", "UNKNOWN"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f"));
        ImmutableMap stringMap2 = ImmutableMap.of((Object)"a", (Object)"e");
        MapLookupExtractor mapExtractor2 = new MapLookupExtractor((Map)stringMap2, false);
        LookupExtractionFn lookupFn2 = new LookupExtractionFn((LookupExtractor)mapExtractor2, true, null, Boolean.valueOf(false), Boolean.valueOf(true));
        this.assertFilterMatches(this.toInFilterWithFn("dim0", (ExtractionFn)lookupFn2, null, "e"), (List<String>)ImmutableList.of((Object)"a", (Object)"e"));
        this.assertFilterMatches(this.toInFilterWithFn("dim0", (ExtractionFn)lookupFn2, "a", new String[0]), (List<String>)ImmutableList.of());
        ImmutableMap stringMap3 = ImmutableMap.of((Object)"c", (Object)"500", (Object)"100", (Object)"e");
        MapLookupExtractor mapExtractor3 = new MapLookupExtractor((Map)stringMap3, false);
        LookupExtractionFn lookupFn3 = new LookupExtractionFn((LookupExtractor)mapExtractor3, false, null, Boolean.valueOf(false), Boolean.valueOf(true));
        this.assertFilterMatches(this.toInFilterWithFn("dim0", (ExtractionFn)lookupFn3, null, "c"), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"d", (Object)"e", (Object)"f"));
        this.assertFilterMatches(this.toInFilterWithFn("dim0", (ExtractionFn)lookupFn3, "e", new String[0]), (List<String>)ImmutableList.of());
    }

    @Test
    public void testNumericColumnNullsAndDefaults() {
        if (this.canTestNumericNullsAsDefaultValues) {
            this.assertFilterMatches((DimFilter)new InDimFilter("f0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null), (List<String>)ImmutableList.of((Object)"a", (Object)"e"));
            this.assertFilterMatches((DimFilter)new InDimFilter("d0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null), (List<String>)ImmutableList.of((Object)"a", (Object)"c"));
            this.assertFilterMatches((DimFilter)new InDimFilter("l0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null), (List<String>)ImmutableList.of((Object)"a", (Object)"d"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("f0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null)), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"d", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("d0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null)), (List<String>)ImmutableList.of((Object)"b", (Object)"d", (Object)"e", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("l0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null)), (List<String>)ImmutableList.of((Object)"b", (Object)"c", (Object)"e", (Object)"f"));
            this.assertFilterMatches((DimFilter)new InDimFilter("f0", Collections.singleton(null), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new InDimFilter("d0", Collections.singleton(null), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new InDimFilter("l0", Collections.singleton(null), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new InDimFilter("f0", (Collection)Sets.newHashSet((Object[])new String[]{"0", "999"}), null), (List<String>)ImmutableList.of((Object)"a", (Object)"e"));
            this.assertFilterMatches((DimFilter)new InDimFilter("d0", (Collection)Sets.newHashSet((Object[])new String[]{"0", "999"}), null), (List<String>)ImmutableList.of((Object)"a", (Object)"c"));
            this.assertFilterMatches((DimFilter)new InDimFilter("l0", (Collection)Sets.newHashSet((Object[])new String[]{"0", "999"}), null), (List<String>)ImmutableList.of((Object)"a", (Object)"d"));
            this.assertFilterMatches((DimFilter)new InDimFilter("f0", (Collection)Sets.newHashSet((Object[])new String[]{null, "999"}), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new InDimFilter("d0", (Collection)Sets.newHashSet((Object[])new String[]{null, "999"}), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new InDimFilter("l0", (Collection)Sets.newHashSet((Object[])new String[]{null, "999"}), null), (List<String>)ImmutableList.of());
        } else {
            this.assertFilterMatches((DimFilter)new InDimFilter("f0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches((DimFilter)new InDimFilter("d0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches((DimFilter)new InDimFilter("l0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("f0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)"b", (Object)"c", (Object)"d", (Object)"f") : ImmutableList.of((Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f")));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("d0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)"b", (Object)"d", (Object)"e", (Object)"f") : ImmutableList.of((Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f")));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("l0", (Collection)Sets.newHashSet((Object[])new String[]{"0"}), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)"b", (Object)"c", (Object)"e", (Object)"f") : ImmutableList.of((Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f")));
            this.assertFilterMatches((DimFilter)new InDimFilter("f0", Collections.singleton(null), null), (List<String>)ImmutableList.of((Object)"e"));
            this.assertFilterMatches((DimFilter)new InDimFilter("d0", Collections.singleton(null), null), (List<String>)ImmutableList.of((Object)"c"));
            this.assertFilterMatches((DimFilter)new InDimFilter("l0", Collections.singleton(null), null), (List<String>)ImmutableList.of((Object)"d"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("f0", Collections.singleton(null), null)), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("d0", Collections.singleton(null), null)), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"d", (Object)"e", (Object)"f"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new InDimFilter("l0", Collections.singleton(null), null)), (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"e", (Object)"f"));
            this.assertFilterMatches((DimFilter)new InDimFilter("f0", (Collection)Sets.newHashSet((Object[])new String[]{"0", "999"}), null), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches((DimFilter)new InDimFilter("d0", (Collection)Sets.newHashSet((Object[])new String[]{"0", "999"}), null), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches((DimFilter)new InDimFilter("l0", (Collection)Sets.newHashSet((Object[])new String[]{"0", "999"}), null), (List<String>)ImmutableList.of((Object)"a"));
            this.assertFilterMatches((DimFilter)new InDimFilter("f0", (Collection)Sets.newHashSet((Object[])new String[]{null, "999"}), null), (List<String>)ImmutableList.of((Object)"e"));
            this.assertFilterMatches((DimFilter)new InDimFilter("d0", (Collection)Sets.newHashSet((Object[])new String[]{null, "999"}), null), (List<String>)ImmutableList.of((Object)"c"));
            this.assertFilterMatches((DimFilter)new InDimFilter("l0", (Collection)Sets.newHashSet((Object[])new String[]{null, "999"}), null), (List<String>)ImmutableList.of((Object)"d"));
        }
    }

    @Test
    public void testRequiredColumnRewrite() {
        InDimFilter filter = (InDimFilter)this.toInFilter("dim0", "a", "c").toFilter();
        InDimFilter filter2 = (InDimFilter)this.toInFilter("dim1", "a", "c").toFilter();
        Assert.assertTrue((boolean)filter.supportsRequiredColumnRewrite());
        Assert.assertTrue((boolean)filter2.supportsRequiredColumnRewrite());
        Filter rewrittenFilter = filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"dim0", (Object)"dim1"));
        Assert.assertEquals((Object)filter2, (Object)rewrittenFilter);
        Throwable t = Assert.assertThrows(IAE.class, () -> filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"invalidName", (Object)"dim1")));
        Assert.assertEquals((Object)"Received a non-applicable rewrite: {invalidName=dim1}, filter's dimension: dim0", (Object)t.getMessage());
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(InDimFilter.class).usingGetClass().withNonnullFields(new String[]{"dimension", "values"}).withIgnoredFields(new String[]{"cacheKeySupplier", "predicateFactory", "optimizedFilterIncludeUnknown", "optimizedFilterNoIncludeUnknown", "valuesUtf8"}).verify();
    }

    @Test
    public void test_equals_forInFilterDruidPredicateFactory() {
        EqualsVerifier.forClass(InDimFilter.InFilterDruidPredicateFactory.class).usingGetClass().withNonnullFields(new String[]{"values"}).withIgnoredFields(new String[]{"longPredicateSupplier", "floatPredicateSupplier", "doublePredicateSupplier", "stringPredicateSupplier"}).verify();
    }

    private DimFilter toInFilter(String dim) {
        ArrayList emptyList = new ArrayList();
        return new InDimFilter(dim, emptyList, null);
    }

    private DimFilter toInFilter(String dim, String value, String ... values) {
        return new InDimFilter(dim, (Collection)Lists.asList((Object)value, (Object[])values), null);
    }

    private DimFilter toInFilterWithFn(String dim, ExtractionFn fn, String value, String ... values) {
        return new InDimFilter(dim, (Collection)Lists.asList((Object)value, (Object[])values), fn);
    }
}

