/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class NullFilterTests {

    public static class NullFilterNonParameterizedTest {
        @Test
        public void testGetDimensionRangeSet() {
            NullFilter filter = new NullFilter("x", null);
            Assert.assertEquals((Object)TreeRangeSet.create(Collections.singleton(Range.lessThan((Comparable)((Object)"")))), (Object)filter.getDimensionRangeSet("x"));
            Assert.assertNull((Object)filter.getDimensionRangeSet("y"));
        }

        @Test
        public void testSerde() throws JsonProcessingException {
            DefaultObjectMapper mapper = new DefaultObjectMapper();
            NullFilter filter = new NullFilter("x", null);
            String s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, NullFilter.class));
        }

        @Test
        public void testGetCacheKey() {
            NullFilter f1 = new NullFilter("x", null);
            NullFilter f1_2 = new NullFilter("x", null);
            NullFilter f2 = new NullFilter("y", null);
            NullFilter f3 = new NullFilter("x", new FilterTuning(Boolean.valueOf(true), Integer.valueOf(1234), null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
        }

        @Test
        public void test_equals() {
            EqualsVerifier.forClass(NullFilter.class).usingGetClass().withNonnullFields(new String[]{"column"}).withIgnoredFields(new String[]{"optimizedFilterIncludeUnknown", "optimizedFilterNoIncludeUnknown"}).verify();
        }
    }

    @RunWith(value=Parameterized.class)
    public static class NullFilterTest
    extends BaseFilterTest {
        public NullFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
            super(testName, DEFAULT_ROWS, indexBuilder, finisher, cnf, optimize);
        }

        @AfterClass
        public static void tearDown() throws Exception {
            BaseFilterTest.tearDown(NullFilterTest.class.getName());
        }

        @Test
        public void testSingleValueStringColumnWithoutNulls() {
            this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"dim0"), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"dim0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        }

        @Test
        public void testSingleValueVirtualStringColumnWithoutNulls() {
            this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vdim0"), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vdim0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        }

        @Test
        public void testListFilteredVirtualColumn() {
            this.assertFilterMatchesSkipVectorize((DimFilter)NullFilter.forColumn((String)"allow-dim0"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
            this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"allow-dim0")), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
            this.assertFilterMatchesSkipVectorize((DimFilter)NullFilter.forColumn((String)"deny-dim0"), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
            this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"deny-dim0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
            if (this.isAutoSchema()) {
                return;
            }
            this.assertFilterMatchesSkipVectorize((DimFilter)NullFilter.forColumn((String)"allow-dim2"), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"allow-dim2")), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
            if (NullHandling.replaceWithDefault()) {
                this.assertFilterMatchesSkipVectorize((DimFilter)NullFilter.forColumn((String)"deny-dim2"), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"5"));
                this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"deny-dim2")), (List<String>)ImmutableList.of((Object)"0", (Object)"4"));
            } else {
                this.assertFilterMatchesSkipVectorize((DimFilter)NullFilter.forColumn((String)"deny-dim2"), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"5"));
                this.assertFilterMatchesSkipVectorize((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"deny-dim2")), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"4"));
            }
        }

        @Test
        public void testSingleValueStringColumnWithNulls() {
            if (NullHandling.replaceWithDefault()) {
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"dim1"), (List<String>)ImmutableList.of((Object)"0"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"dim1")), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"s0"), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"s0")), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            } else {
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"dim1"), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"dim1")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"s0"), (List<String>)ImmutableList.of((Object)"3"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"s0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            }
        }

        @Test
        public void testSingleValueVirtualStringColumnWithNulls() {
            if (NullHandling.replaceWithDefault()) {
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vdim1"), (List<String>)ImmutableList.of((Object)"0"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vdim1")), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vs0"), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vs0")), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            } else {
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vdim1"), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vdim1")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vs0"), (List<String>)ImmutableList.of((Object)"3"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vs0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            }
        }

        @Test
        public void testMultiValueStringColumn() {
            if (NullHandling.replaceWithDefault()) {
                if (this.isAutoSchema()) {
                    this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"dim2"), (List<String>)ImmutableList.of((Object)"5"));
                    this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"dim2")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4"));
                } else {
                    this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"dim2"), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
                    this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"dim2")), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4"));
                }
            } else if (this.isAutoSchema()) {
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"dim2"), (List<String>)ImmutableList.of((Object)"5"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"dim2")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4"));
            } else {
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"dim2"), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"dim2")), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4"));
            }
        }

        @Test
        public void testMissingColumnSpecifiedInDimensionList() {
            this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"dim3"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"dim3")), (List<String>)ImmutableList.of());
        }

        @Test
        public void testMissingColumnNotSpecifiedInDimensionList() {
            this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"dim4"), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"dim4")), (List<String>)ImmutableList.of());
        }

        @Test
        public void testVirtualNumericColumnNullsAndDefaults() {
            if (this.canTestNumericNullsAsDefaultValues) {
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vf0"), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vf0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vd0"), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vd0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vl0"), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vl0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vf0-add-sub"), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vf0-add-sub")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vd0-add-sub"), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vd0-add-sub")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vl0-add-sub"), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vl0-add-sub")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"double-vf0-add-sub"), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"double-vf0-add-sub")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"double-vd0-add-sub"), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"double-vd0-add-sub")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"double-vl0-add-sub"), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"double-vl0-add-sub")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            } else {
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vf0"), (List<String>)ImmutableList.of((Object)"4"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vf0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vd0"), (List<String>)ImmutableList.of((Object)"2"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vd0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vl0"), (List<String>)ImmutableList.of((Object)"3"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vl0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
                if (NullHandling.sqlCompatible()) {
                    this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vf0-add-sub"), (List<String>)ImmutableList.of((Object)"4"));
                    this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vf0-add-sub")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"5"));
                    this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vd0-add-sub"), (List<String>)ImmutableList.of((Object)"2"));
                    this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vd0-add-sub")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4", (Object)"5"));
                    this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vl0-add-sub"), (List<String>)ImmutableList.of((Object)"3"));
                    this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"vl0-add-sub")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
                    this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"double-vf0-add-sub"), (List<String>)ImmutableList.of((Object)"4"));
                    this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"double-vf0-add-sub")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"5"));
                    this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"double-vd0-add-sub"), (List<String>)ImmutableList.of((Object)"2"));
                    this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"double-vd0-add-sub")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4", (Object)"5"));
                    this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"vl0-add-sub"), (List<String>)ImmutableList.of((Object)"3"));
                    this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"double-vl0-add-sub")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
                }
            }
        }

        @Test
        public void testNumericColumnNullsAndDefaults() {
            if (this.canTestNumericNullsAsDefaultValues) {
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"f0"), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"f0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"d0"), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"d0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"l0"), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"l0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
            } else {
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"f0"), (List<String>)ImmutableList.of((Object)"4"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"f0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"d0"), (List<String>)ImmutableList.of((Object)"2"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"d0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"l0"), (List<String>)ImmutableList.of((Object)"3"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"l0")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            }
        }

        @Test
        public void testArrays() {
            if (this.isAutoSchema()) {
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"arrayString"), (List<String>)ImmutableList.of((Object)"2"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"arrayString")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"arrayLong"), (List<String>)ImmutableList.of((Object)"3"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"arrayLong")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
                this.assertFilterMatches((DimFilter)NullFilter.forColumn((String)"arrayDouble"), (List<String>)ImmutableList.of((Object)"5"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)NullFilter.forColumn((String)"arrayDouble")), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4"));
            }
        }
    }
}

