/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Function;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.error.DruidException;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.RangeFilter;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class RangeFilterTests {

    public static class RangeFilterNonParameterizedTests
    extends InitializedNullHandlingTest {
        @Test
        public void testSerde() throws JsonProcessingException {
            DefaultObjectMapper mapper = new DefaultObjectMapper();
            RangeFilter filter = new RangeFilter("x", ColumnType.STRING, (Object)"abc", (Object)"xyz", Boolean.valueOf(true), Boolean.valueOf(true), null);
            String s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, RangeFilter.class));
            filter = new RangeFilter("x", ColumnType.STRING, (Object)"abc", (Object)"xyz", Boolean.valueOf(false), Boolean.valueOf(false), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, RangeFilter.class));
            filter = new RangeFilter("x", ColumnType.LONG, (Object)100L, null, Boolean.valueOf(true), Boolean.valueOf(false), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, RangeFilter.class));
            filter = new RangeFilter("x", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b"}, (Object)new Object[]{"x", null, "z"}, Boolean.valueOf(true), Boolean.valueOf(true), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, RangeFilter.class));
            filter = new RangeFilter("x", ColumnType.LONG_ARRAY, (Object)new Object[]{101L, 1L}, (Object)new Object[]{101L, 100L}, Boolean.valueOf(true), Boolean.valueOf(true), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, RangeFilter.class));
            filter = new RangeFilter("x", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, null, 1.2}, (Object)new Object[]{2.02, 3.03}, Boolean.valueOf(true), Boolean.valueOf(true), null);
            s = mapper.writeValueAsString((Object)filter);
            Assert.assertEquals((Object)filter, (Object)mapper.readValue(s, RangeFilter.class));
        }

        @Test
        public void testGetCacheKey() {
            RangeFilter f1 = new RangeFilter("x", ColumnType.STRING, (Object)"abc", (Object)"xyz", Boolean.valueOf(true), Boolean.valueOf(true), null);
            RangeFilter f1_2 = new RangeFilter("x", ColumnType.STRING, (Object)"abc", (Object)"xyz", Boolean.valueOf(true), Boolean.valueOf(true), null);
            RangeFilter f2 = new RangeFilter("x", ColumnType.STRING, (Object)"abc", (Object)"xyz", Boolean.valueOf(false), Boolean.valueOf(true), null);
            RangeFilter f2_2 = new RangeFilter("x", ColumnType.STRING, (Object)"abc", (Object)"xyzz", Boolean.valueOf(true), Boolean.valueOf(true), null);
            RangeFilter f3 = new RangeFilter("x", ColumnType.STRING, (Object)"abc", (Object)"xyz", Boolean.valueOf(true), Boolean.valueOf(true), new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2_2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new RangeFilter("x", ColumnType.LONG, (Object)100L, (Object)300L, Boolean.valueOf(true), Boolean.valueOf(true), null);
            f1_2 = new RangeFilter("x", ColumnType.LONG, (Object)100, (Object)300, Boolean.valueOf(true), Boolean.valueOf(true), null);
            f2 = new RangeFilter("x", ColumnType.LONG, (Object)100L, (Object)300L, Boolean.valueOf(false), Boolean.valueOf(true), null);
            f2_2 = new RangeFilter("x", ColumnType.LONG, (Object)101L, (Object)300L, Boolean.valueOf(true), Boolean.valueOf(true), null);
            f3 = new RangeFilter("x", ColumnType.LONG, (Object)100L, (Object)300L, Boolean.valueOf(true), Boolean.valueOf(true), new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2_2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new RangeFilter("x", ColumnType.DOUBLE, (Object)-1.1, (Object)1.1, Boolean.valueOf(true), Boolean.valueOf(true), null);
            f1_2 = new RangeFilter("x", ColumnType.DOUBLE, (Object)-1.1, (Object)1.1, Boolean.valueOf(true), Boolean.valueOf(true), null);
            f2 = new RangeFilter("x", ColumnType.DOUBLE, (Object)-1.1, (Object)1.1, Boolean.valueOf(false), Boolean.valueOf(true), null);
            f2_2 = new RangeFilter("x", ColumnType.DOUBLE, (Object)-1.1000000001, (Object)1.1, Boolean.valueOf(true), Boolean.valueOf(true), null);
            f3 = new RangeFilter("x", ColumnType.DOUBLE, (Object)-1.1, (Object)1.1, Boolean.valueOf(true), Boolean.valueOf(true), new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2_2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new RangeFilter("x", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b"}, (Object)new Object[]{"x", null, "z"}, Boolean.valueOf(true), Boolean.valueOf(true), null);
            f1_2 = new RangeFilter("x", ColumnType.STRING_ARRAY, Arrays.asList("a", "b"), Arrays.asList("x", null, "z"), Boolean.valueOf(true), Boolean.valueOf(true), null);
            f2 = new RangeFilter("x", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b"}, (Object)new Object[]{"x", null, "z"}, Boolean.valueOf(false), Boolean.valueOf(true), null);
            f2_2 = new RangeFilter("x", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b"}, (Object)new Object[]{"x", "z"}, Boolean.valueOf(true), Boolean.valueOf(true), null);
            f3 = new RangeFilter("x", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b"}, (Object)new Object[]{"x", null, "z"}, Boolean.valueOf(true), Boolean.valueOf(true), new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2_2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new RangeFilter("x", ColumnType.LONG_ARRAY, (Object)new Object[]{101L, 1L}, (Object)new Object[]{101L, 100L}, Boolean.valueOf(true), Boolean.valueOf(true), null);
            f1_2 = new RangeFilter("x", ColumnType.LONG_ARRAY, Arrays.asList(101L, 1L), Arrays.asList(101L, 100L), Boolean.valueOf(true), Boolean.valueOf(true), null);
            f2 = new RangeFilter("x", ColumnType.LONG_ARRAY, (Object)new Object[]{101L, 1L}, (Object)new Object[]{101L, 100L}, Boolean.valueOf(false), Boolean.valueOf(true), null);
            f2_2 = new RangeFilter("x", ColumnType.LONG_ARRAY, (Object)new Object[]{101L, 1L}, (Object)new Object[]{101L, 99L}, Boolean.valueOf(true), Boolean.valueOf(true), null);
            f3 = new RangeFilter("x", ColumnType.LONG_ARRAY, (Object)new Object[]{101L, 1L}, (Object)new Object[]{101L, 100L}, Boolean.valueOf(true), Boolean.valueOf(true), new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2_2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
            f1 = new RangeFilter("x", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, null, 1.2}, (Object)new Object[]{2.02, 3.03}, Boolean.valueOf(true), Boolean.valueOf(true), null);
            f1_2 = new RangeFilter("x", ColumnType.DOUBLE_ARRAY, Arrays.asList(1.1, null, 1.2), Arrays.asList(2.02, 3.03), Boolean.valueOf(true), Boolean.valueOf(true), null);
            f2 = new RangeFilter("x", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, null, 1.2}, (Object)new Object[]{2.02, 3.03}, Boolean.valueOf(false), Boolean.valueOf(true), null);
            f2_2 = new RangeFilter("x", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, 1.2}, (Object)new Object[]{2.02, 3.03}, Boolean.valueOf(true), Boolean.valueOf(true), null);
            f3 = new RangeFilter("x", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, null, 1.2}, (Object)new Object[]{2.02, 3.03}, Boolean.valueOf(true), Boolean.valueOf(true), new FilterTuning(Boolean.valueOf(true), null, null));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f1_2.getCacheKey());
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2.getCacheKey()));
            Assert.assertFalse((boolean)Arrays.equals(f1.getCacheKey(), f2_2.getCacheKey()));
            Assert.assertArrayEquals((byte[])f1.getCacheKey(), (byte[])f3.getCacheKey());
        }

        @Test
        public void testRequiredColumnRewrite() {
            RangeFilter filter = new RangeFilter("dim0", ColumnType.STRING, (Object)"abc", (Object)"def", Boolean.valueOf(false), Boolean.valueOf(false), null);
            RangeFilter filter2 = new RangeFilter("dim1", ColumnType.STRING, (Object)"abc", (Object)"def", Boolean.valueOf(false), Boolean.valueOf(false), null);
            Assert.assertTrue((boolean)filter.supportsRequiredColumnRewrite());
            Assert.assertTrue((boolean)filter2.supportsRequiredColumnRewrite());
            Filter rewrittenFilter = filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"dim0", (Object)"dim1"));
            Assert.assertEquals((Object)filter2, (Object)rewrittenFilter);
            Throwable t = Assert.assertThrows(IAE.class, () -> filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"invalidName", (Object)"dim1")));
            Assert.assertEquals((Object)"Received a non-applicable rewrite: {invalidName=dim1}, filter's dimension: dim0", (Object)t.getMessage());
        }

        @Test
        public void testNumericMatchBadParameters() {
            Throwable t = Assert.assertThrows(DruidException.class, () -> new RangeFilter(null, ColumnType.DOUBLE, (Object)"1234", (Object)"", Boolean.valueOf(false), Boolean.valueOf(false), null));
            Assert.assertEquals((Object)"Invalid range filter, column cannot be null", (Object)t.getMessage());
            t = Assert.assertThrows(DruidException.class, () -> new RangeFilter("dim0", null, (Object)"1234", (Object)"", Boolean.valueOf(false), Boolean.valueOf(false), null));
            Assert.assertEquals((Object)"Invalid range filter on column [dim0], matchValueType cannot be null", (Object)t.getMessage());
            t = Assert.assertThrows(DruidException.class, () -> new RangeFilter("dim0", ColumnType.DOUBLE, null, null, Boolean.valueOf(false), Boolean.valueOf(false), null));
            Assert.assertEquals((Object)"Invalid range filter on column [dim0], lower and upper cannot be null at the same time", (Object)t.getMessage());
            t = Assert.assertThrows(DruidException.class, () -> new RangeFilter("dim0", ColumnType.DOUBLE, (Object)"1234", (Object)"", Boolean.valueOf(false), Boolean.valueOf(false), null));
            Assert.assertEquals((Object)"Invalid range filter on column [dim0], upper bound [] cannot be parsed as specified match value type [DOUBLE]", (Object)t.getMessage());
            t = Assert.assertThrows(DruidException.class, () -> new RangeFilter("dim0", ColumnType.DOUBLE, (Object)"abc", (Object)"1234", Boolean.valueOf(false), Boolean.valueOf(false), null));
            Assert.assertEquals((Object)"Invalid range filter on column [dim0], lower bound [abc] cannot be parsed as specified match value type [DOUBLE]", (Object)t.getMessage());
        }

        @Test
        public void testGetDimensionRangeSet() {
            RangeFilter filter = new RangeFilter("x", ColumnType.STRING, (Object)"abc", (Object)"xyz", Boolean.valueOf(true), Boolean.valueOf(true), null);
            TreeRangeSet set = TreeRangeSet.create();
            set.add(Range.range((Comparable)((Object)"abc"), (BoundType)BoundType.OPEN, (Comparable)((Object)"xyz"), (BoundType)BoundType.OPEN));
            Assert.assertEquals((Object)set, (Object)filter.getDimensionRangeSet("x"));
            Assert.assertNull((Object)filter.getDimensionRangeSet("y"));
            ExprEval evalLower = ExprEval.ofType((ExpressionType)ExpressionType.STRING_ARRAY, (Object)new Object[]{"abc", "def"});
            filter = new RangeFilter("x", ColumnType.STRING_ARRAY, evalLower.value(), null, Boolean.valueOf(true), Boolean.valueOf(false), null);
            set = TreeRangeSet.create();
            set.add(Range.greaterThan((Comparable)((Object)Arrays.deepToString(evalLower.asArray()))));
            Assert.assertEquals((Object)set, (Object)filter.getDimensionRangeSet("x"));
            Assert.assertNull((Object)filter.getDimensionRangeSet("y"));
        }

        @Test
        public void test_equals() {
            EqualsVerifier.forClass(RangeFilter.class).withNonnullFields(new String[]{"column", "matchValueType", "lowerEval", "upperEval"}).withIgnoredFields(new String[]{"lower", "upper", "optimizedFilterIncludeUnknown", "optimizedFilterNoIncludeUnknown", "stringPredicateSupplier", "longPredicateSupplier", "floatPredicateSupplier", "doublePredicateSupplier", "arrayPredicates", "typeDetectingArrayPredicateSupplier"}).withPrefabValues(ColumnType.class, (Object)ColumnType.STRING, (Object)ColumnType.DOUBLE).usingGetClass().verify();
        }
    }

    @RunWith(value=Parameterized.class)
    public static class RangeFilterTest
    extends BaseFilterTest {
        private static final List<InputRow> ROWS = ImmutableList.builder().addAll((Iterable)DEFAULT_ROWS).add((Object)RangeFilterTest.makeDefaultSchemaRow("6", "-1000", ImmutableList.of((Object)"a"), null, "d", 6.6, null, 10L, new Object[]{"x", "y"}, new Object[]{100, 200}, new Object[]{1.1, null, 3.3}, null, TestHelper.makeMapWithExplicitNull("s0", "d", "d0", 6.6, "f0", null, "l0", 10L, "arrayString", new Object[]{"x", "y"}, "arrayLong", new Object[]{100, 200}, "arrayDouble", new Object[]{1.1, null, 3.3}))).add((Object)RangeFilterTest.makeDefaultSchemaRow("7", "-10.012", ImmutableList.of((Object)"d"), null, "e", null, Float.valueOf(3.0f), null, new Object[]{null, "hello", "world"}, new Object[]{1234, 3456L, null}, new Object[]{1.23, 4.56, 6.78}, null, TestHelper.makeMapWithExplicitNull("s0", "e", "d0", null, "f0", Float.valueOf(3.0f), "l0", null, "arrayString", new Object[]{null, "hello", "world"}, "arrayLong", new Object[]{1234, 3456L, null}, "arrayDouble", new Object[]{1.23, 4.56, 6.78}))).build();

        public RangeFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<StorageAdapter, Closeable>> finisher, boolean cnf, boolean optimize) {
            super(testName, ROWS, indexBuilder, finisher, cnf, optimize);
        }

        @AfterClass
        public static void tearDown() throws Exception {
            BaseFilterTest.tearDown(RangeFilterTest.class.getName());
        }

        @Test
        public void testLexicographicalMatch() {
            this.assertFilterMatches((DimFilter)new RangeFilter("dim0", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("vdim0", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            if (NullHandling.sqlCompatible()) {
                this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
                this.assertFilterMatches((DimFilter)new RangeFilter("vdim0", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("dim1", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("vdim0", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)new RangeFilter("s0", ColumnType.STRING, null, (Object)"b", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
                this.assertFilterMatches((DimFilter)new RangeFilter("vs0", ColumnType.STRING, null, (Object)"b", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("s0", ColumnType.STRING, null, (Object)"b", Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)ImmutableList.of((Object)"4", (Object)"6", (Object)"7"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("vs0", ColumnType.STRING, null, (Object)"b", Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)ImmutableList.of((Object)"4", (Object)"6", (Object)"7"));
            } else {
                this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
                this.assertFilterMatches((DimFilter)new RangeFilter("vdim0", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("dim1", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of() : ImmutableList.of((Object)"0")));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("vdim0", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)"0") : ImmutableList.of()));
                this.assertFilterMatches((DimFilter)new RangeFilter("s0", ColumnType.STRING, null, (Object)"b", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
                this.assertFilterMatches((DimFilter)new RangeFilter("vs0", ColumnType.STRING, null, (Object)"b", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("s0", ColumnType.STRING, null, (Object)"b", Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)"4", (Object)"6", (Object)"7") : ImmutableList.of((Object)"0", (Object)"3", (Object)"4", (Object)"6", (Object)"7")));
                this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("vs0", ColumnType.STRING, null, (Object)"b", Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)"4", (Object)"6", (Object)"7") : ImmutableList.of((Object)"0", (Object)"3", (Object)"4", (Object)"6", (Object)"7")));
            }
            if (!this.isAutoSchema()) {
                this.assertFilterMatches((DimFilter)new RangeFilter("dim2", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"6", (Object)"7") : ImmutableList.of((Object)"0", (Object)"3", (Object)"4", (Object)"6", (Object)"7")));
                this.assertFilterMatches((DimFilter)new RangeFilter("dim3", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            }
        }

        @Test
        public void testLexicographicMatchWithEmptyString() {
            if (NullHandling.sqlCompatible()) {
                this.assertFilterMatches((DimFilter)new RangeFilter("dim0", ColumnType.STRING, (Object)"", (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
                this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, (Object)"", (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
                if (!this.isAutoSchema()) {
                    this.assertFilterMatches((DimFilter)new RangeFilter("dim2", ColumnType.STRING, (Object)"", (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"6", (Object)"7"));
                }
                this.assertFilterMatches((DimFilter)new RangeFilter("dim3", ColumnType.STRING, (Object)"", (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            } else {
                this.assertFilterMatches((DimFilter)new RangeFilter("dim0", ColumnType.STRING, (Object)"", (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
                this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, (Object)"", (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
                if (!this.isAutoSchema()) {
                    this.assertFilterMatches((DimFilter)new RangeFilter("dim2", ColumnType.STRING, (Object)"", (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"4", (Object)"6", (Object)"7"));
                }
                this.assertFilterMatches((DimFilter)new RangeFilter("dim3", ColumnType.STRING, (Object)"", (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            }
        }

        @Test
        public void testLexicographicMatchNull() {
            if (NullHandling.replaceWithDefault()) {
                Throwable t = Assert.assertThrows(DruidException.class, () -> this.assertFilterMatches((DimFilter)new RangeFilter("dim0", ColumnType.STRING, (Object)"", (Object)"", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of()));
                Assert.assertEquals((Object)"Invalid range filter on column [dim0], lower and upper cannot be null at the same time", (Object)t.getMessage());
            } else {
                this.assertFilterMatches((DimFilter)new RangeFilter("dim0", ColumnType.STRING, (Object)"", (Object)"", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
                this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, (Object)"", (Object)"", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0"));
                this.assertFilterMatches((DimFilter)new RangeFilter("dim2", ColumnType.STRING, (Object)"", (Object)"", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"2"));
            }
        }

        @Test
        public void testLexicographicMatchMissingColumn() {
            this.assertFilterMatches((DimFilter)new RangeFilter("dim3", ColumnType.STRING, (Object)"", (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("dim3", ColumnType.STRING, (Object)"a", null, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("dim3", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("dim3", ColumnType.STRING, (Object)"", (Object)"z", Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("dim3", ColumnType.STRING, (Object)"", (Object)"z", Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("dim3", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("dim3", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("dim3", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(true), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of() : ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7")));
        }

        @Test
        public void testLexicographicMatchTooStrict() {
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, (Object)"abc", (Object)"abc", Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, (Object)"abc", (Object)"abc", Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, (Object)"abc", (Object)"abc", Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("dim1", ColumnType.STRING, (Object)"abc", (Object)"abc", Boolean.valueOf(false), Boolean.valueOf(true), null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
        }

        @Test
        public void testLexicographicMatchExactlySingleValue() {
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, (Object)"abc", (Object)"abc", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("dim1", ColumnType.STRING, (Object)"abc", (Object)"abc", Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"6", (Object)"7"));
        }

        @Test
        public void testLexicographicMatchSurroundingSingleValue() {
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, (Object)"ab", (Object)"abd", Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"5"));
        }

        @Test
        public void testLexicographicMatchNoUpperLimit() {
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, (Object)"ab", null, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
        }

        @Test
        public void testLexicographicMatchNoLowerLimit() {
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, null, (Object)"abd", Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"5", (Object)"6", (Object)"7") : ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"5", (Object)"6", (Object)"7")));
        }

        @Test
        public void testLexicographicMatchNumbers() {
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, (Object)"1", (Object)"3", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, (Object)"1", (Object)"3", Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2"));
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.STRING, (Object)"-1", (Object)"3", Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"6", (Object)"7"));
        }

        @Test
        public void testNumericMatchTooStrict() {
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.LONG, (Object)2L, (Object)2L, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.LONG, (Object)2L, (Object)2L, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.LONG, (Object)2L, (Object)2L, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("d0", ColumnType.LONG, (Object)2L, (Object)3L, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("d0", ColumnType.DOUBLE, (Object)2L, (Object)3L, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("d0", ColumnType.DOUBLE, (Object)2L, (Object)3L, Boolean.valueOf(false), Boolean.valueOf(true), null)), (List<String>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7") : ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"4", (Object)"5", (Object)"6")));
            this.assertFilterMatches((DimFilter)new RangeFilter("f0", ColumnType.LONG, (Object)2L, (Object)3L, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("f0", ColumnType.DOUBLE, (Object)2L, (Object)3L, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("f0", ColumnType.DOUBLE, (Object)2L, (Object)3L, Boolean.valueOf(false), Boolean.valueOf(true), null)), (List<String>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7") : ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"5", (Object)"7")));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.LONG, (Object)2L, (Object)3L, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)2L, (Object)3L, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)2L, (Object)3L, Boolean.valueOf(false), Boolean.valueOf(true), null)), (List<String>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7") : ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6")));
        }

        @Test
        public void testNumericMatchVirtualColumn() {
            this.assertFilterMatches((DimFilter)new RangeFilter("expr", ColumnType.LONG, (Object)1L, (Object)2L, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("expr", ColumnType.DOUBLE, (Object)1.1, (Object)2.0, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("expr", ColumnType.FLOAT, (Object)Float.valueOf(1.1f), (Object)Float.valueOf(2.0f), Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("expr", ColumnType.LONG, (Object)2L, (Object)3L, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("expr", ColumnType.DOUBLE, (Object)2.0, (Object)3.0, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("expr", ColumnType.FLOAT, (Object)Float.valueOf(2.0f), (Object)Float.valueOf(3.0f), Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
        }

        @Test
        public void testNumericMatchExactlySingleValue() {
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.LONG, (Object)2L, (Object)2L, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.DOUBLE, (Object)-10.012, (Object)-10.012, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("d0", ColumnType.DOUBLE, (Object)120.0245, (Object)120.0245, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("d0", ColumnType.DOUBLE, (Object)120.0245, (Object)120.0245, Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)"0", (Object)"1", (Object)"4", (Object)"5", (Object)"6") : ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6", (Object)"7")));
            this.assertFilterMatches((DimFilter)new RangeFilter("d0", ColumnType.FLOAT, (Object)Float.valueOf(120.0245f), (Object)Float.valueOf(120.0245f), Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("d0", ColumnType.FLOAT, (Object)Float.valueOf(60.0f), (Object)Float.valueOf(60.0f), Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new RangeFilter("f0", ColumnType.DOUBLE, (Object)10.1, (Object)10.1, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("f0", ColumnType.FLOAT, (Object)Float.valueOf(10.1f), (Object)Float.valueOf(10.1f), Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("f0", ColumnType.FLOAT, (Object)Float.valueOf(10.1f), (Object)Float.valueOf(10.1f), Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"5", (Object)"7") : ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7")));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.LONG, (Object)12345L, (Object)12345L, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("l0", ColumnType.LONG, (Object)12345L, (Object)12345L, Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"6") : ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"6", (Object)"7")));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12345.0, (Object)12345.0, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.FLOAT, (Object)Float.valueOf(12345.0f), (Object)Float.valueOf(12345.0f), Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"5"));
        }

        @Test
        public void testNumericMatchSurroundingSingleValue() {
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.LONG, (Object)1L, (Object)3L, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"2"));
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.LONG, (Object)-11L, (Object)-10L, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("d0", ColumnType.DOUBLE, (Object)120.0, (Object)120.03, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatches((DimFilter)new RangeFilter("d0", ColumnType.FLOAT, (Object)Float.valueOf(120.02f), (Object)Float.valueOf(120.03f), Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatches((DimFilter)new RangeFilter("d0", ColumnType.FLOAT, (Object)Float.valueOf(59.5f), (Object)Float.valueOf(60.01f), Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new RangeFilter("f0", ColumnType.DOUBLE, (Object)10.0, (Object)10.2, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new RangeFilter("f0", ColumnType.FLOAT, (Object)Float.valueOf(10.05f), (Object)Float.valueOf(10.11f), Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.LONG, (Object)12344L, (Object)12346L, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12344.0, (Object)12345.5, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.FLOAT, (Object)Float.valueOf(12344.0f), (Object)Float.valueOf(12345.5f), Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"5"));
        }

        @Test
        public void testNumericMatchNoUpperLimit() {
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.LONG, (Object)1L, null, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2"));
            this.assertFilterMatches((DimFilter)new RangeFilter("d0", ColumnType.DOUBLE, (Object)1.0, null, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
            this.assertFilterMatches((DimFilter)new RangeFilter("f0", ColumnType.FLOAT, (Object)Float.valueOf(1.0f), null, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"5", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.LONG, (Object)1L, null, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6"));
        }

        @Test
        public void testNumericMatchNoLowerLimit() {
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.LONG, null, (Object)2L, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7") : ImmutableList.of((Object)"0", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7")));
            this.assertFilterMatches((DimFilter)new RangeFilter("d0", ColumnType.DOUBLE, null, (Object)10.0, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)(this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"2", (Object)"6", (Object)"7") : ImmutableList.of((Object)"0", (Object)"6")));
            this.assertFilterMatches((DimFilter)new RangeFilter("f0", ColumnType.FLOAT, null, (Object)50.5, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)(this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"6", (Object)"7") : ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"7")));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.LONG, null, (Object)100L, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)(this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"6", (Object)"7") : ImmutableList.of((Object)"0", (Object)"2", (Object)"6")));
        }

        @Test
        public void testNumericMatchWithNegatives() {
            this.assertFilterMatches((DimFilter)new RangeFilter("dim1", ColumnType.LONG, (Object)-2000L, (Object)3L, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"6", (Object)"7"));
        }

        @Test
        public void testNumericMatchStringyBounds() {
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.STRING, (Object)"abc", null, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.STRING, (Object)"abc", (Object)"def", Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.STRING, null, (Object)"abc", Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)(this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7") : ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6")));
        }

        @Test
        public void testNumericMatchPrecisionLoss() {
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12345.1, (Object)12345.4, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12344.1, (Object)12345.4, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12344.1, (Object)12345.4, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12344.1, (Object)12345.4, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12344.1, (Object)12345.4, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12345.0, (Object)12345.1, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12345.0, (Object)12345.1, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12344.0, (Object)12344.9, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12344.0, (Object)12344.9, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12344.5, null, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12344.5, null, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12345.5, null, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, (Object)12345.5, null, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            if (this.canTestNumericNullsAsDefaultValues) {
                this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, null, (Object)12344.5, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"6", (Object)"7"));
                this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, null, (Object)12344.5, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"6", (Object)"7"));
                this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, null, (Object)12345.5, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
                this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, null, (Object)12345.5, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            } else {
                this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, null, (Object)12344.5, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"6"));
                this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, null, (Object)12344.5, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"6"));
                this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, null, (Object)12345.5, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6"));
                this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.DOUBLE, null, (Object)12345.5, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6"));
            }
        }

        @Test
        public void testNumericNullsAndZeros() {
            this.assertFilterMatches((DimFilter)new RangeFilter("d0", ColumnType.DOUBLE, (Object)0.0, (Object)1.1, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)(this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"2", (Object)"7") : ImmutableList.of((Object)"0")));
            this.assertFilterMatches((DimFilter)new RangeFilter("f0", ColumnType.FLOAT, (Object)0.0, (Object)1.0, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)(this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"4", (Object)"6") : ImmutableList.of((Object)"0")));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.LONG, (Object)0L, (Object)1L, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)(NullHandling.replaceWithDefault() && this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"3", (Object)"7") : ImmutableList.of((Object)"0")));
        }

        @Test
        public void testVirtualNumericNullsAndZeros() {
            this.assertFilterMatches((DimFilter)new RangeFilter("vd0", ColumnType.DOUBLE, (Object)0.0, (Object)1.0, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)(this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"2", (Object)"7") : ImmutableList.of((Object)"0")));
            this.assertFilterMatches((DimFilter)new RangeFilter("vf0", ColumnType.FLOAT, (Object)0.0, (Object)1.0, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)(this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"4", (Object)"6") : ImmutableList.of((Object)"0")));
            this.assertFilterMatches((DimFilter)new RangeFilter("vl0", ColumnType.LONG, (Object)0L, (Object)1L, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)(NullHandling.replaceWithDefault() && this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"3", (Object)"7") : ImmutableList.of((Object)"0")));
            if (NullHandling.sqlCompatible() || this.canTestNumericNullsAsDefaultValues) {
                this.assertFilterMatches((DimFilter)new RangeFilter("vd0-add-sub", ColumnType.DOUBLE, (Object)0.0, (Object)1.0, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)(NullHandling.replaceWithDefault() && this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"2", (Object)"7") : ImmutableList.of((Object)"0")));
                this.assertFilterMatches((DimFilter)new RangeFilter("vf0-add-sub", ColumnType.FLOAT, (Object)0.0, (Object)1.0, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)(NullHandling.replaceWithDefault() && this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"4", (Object)"6") : ImmutableList.of((Object)"0")));
                this.assertFilterMatches((DimFilter)new RangeFilter("vl0-add-sub", ColumnType.LONG, (Object)0L, (Object)1L, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)(NullHandling.replaceWithDefault() && this.canTestNumericNullsAsDefaultValues ? ImmutableList.of((Object)"0", (Object)"3", (Object)"7") : ImmutableList.of((Object)"0")));
            }
        }

        @Test
        public void testNumericNulls() {
            this.assertFilterMatches((DimFilter)new RangeFilter("f0", ColumnType.FLOAT, (Object)1.0, null, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"5", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("d0", ColumnType.DOUBLE, (Object)1.0, null, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1", (Object)"3", (Object)"4", (Object)"5", (Object)"6"));
            this.assertFilterMatches((DimFilter)new RangeFilter("l0", ColumnType.LONG, (Object)1L, null, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6"));
        }

        @Test
        public void testListFilteredVirtualColumn() {
            this.assertFilterMatchesSkipVectorize((DimFilter)new RangeFilter("allow-dim0", ColumnType.STRING, (Object)"0", (Object)"2", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            this.assertFilterMatchesSkipVectorize((DimFilter)new RangeFilter("allow-dim0", ColumnType.STRING, (Object)"0", (Object)"6", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
            this.assertFilterMatchesSkipVectorize((DimFilter)new RangeFilter("allow-dim0", ColumnType.STRING, null, (Object)"6", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
            this.assertFilterMatchesSkipVectorize((DimFilter)new RangeFilter("deny-dim0", ColumnType.STRING, (Object)"0", (Object)"6", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5", (Object)"6"));
            this.assertFilterMatchesSkipVectorize((DimFilter)new RangeFilter("deny-dim0", ColumnType.STRING, (Object)"3", (Object)"4", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            this.assertFilterMatchesSkipVectorize((DimFilter)new RangeFilter("deny-dim0", ColumnType.STRING, null, (Object)"6", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5", (Object)"6"));
            Assume.assumeFalse((boolean)this.isAutoSchema());
            this.assertFilterMatchesSkipVectorize((DimFilter)new RangeFilter("allow-dim2", ColumnType.STRING, (Object)"a", (Object)"c", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"6"));
            this.assertFilterMatchesSkipVectorize((DimFilter)new RangeFilter("allow-dim2", ColumnType.STRING, (Object)"c", (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of());
            this.assertFilterMatchesSkipVectorize((DimFilter)new RangeFilter("allow-dim2", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"3", (Object)"6"));
            this.assertFilterMatchesSkipVectorize((DimFilter)new RangeFilter("deny-dim2", ColumnType.STRING, (Object)"a", (Object)"b", Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of());
            this.assertFilterMatchesSkipVectorize((DimFilter)new RangeFilter("deny-dim2", ColumnType.STRING, (Object)"c", (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"4", (Object)"7"));
            this.assertFilterMatchesSkipVectorize((DimFilter)new RangeFilter("deny-dim2", ColumnType.STRING, null, (Object)"z", Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)"0", (Object)"4", (Object)"7") : ImmutableList.of((Object)"0", (Object)"2", (Object)"4", (Object)"7")));
        }

        @Test
        public void testArrayRanges() {
            Assume.assumeTrue((boolean)this.isAutoSchema());
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayString", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b", "c"}, (Object)new Object[]{"a", "b", "c"}, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("arrayString", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b", "c"}, (Object)new Object[]{"a", "b", "c"}, Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)"1", (Object)"4", (Object)"5", (Object)"6", (Object)"7") : ImmutableList.of((Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6", (Object)"7")));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayString", ColumnType.STRING_ARRAY, null, (Object)new Object[]{"a", "b", "c"}, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"3", (Object)"5", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayString", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b", "c"}, null, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"4", (Object)"6"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayString", ColumnType.STRING_ARRAY, null, (Object)new Object[]{"a", "b", "c"}, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"1", (Object)"5", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayString", ColumnType.STRING_ARRAY, (Object)new Object[]{"a", "b"}, (Object)new Object[]{"a", "b", "c", "d"}, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayString", ColumnType.STRING_ARRAY, (Object)new Object[]{"c", "d"}, (Object)new Object[]{"c", "d", "e"}, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayString", ColumnType.STRING_ARRAY, null, (Object)new Object[0], Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayString", ColumnType.STRING_ARRAY, null, (Object)new Object[]{null}, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.LONG_ARRAY, null, (Object)new Object[0], Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("arrayLong", ColumnType.LONG_ARRAY, null, (Object)new Object[0], Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)"0", (Object)"2", (Object)"4", (Object)"5", (Object)"6", (Object)"7") : ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object)"7")));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.LONG_ARRAY, (Object)new Object[0], null, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"4", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.LONG_ARRAY, null, (Object)new Object[]{null}, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1", (Object)"4"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.LONG_ARRAY, (Object)new Object[]{1L, 2L, 3L}, (Object)new Object[]{1L, 2L, 3L}, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.LONG_ARRAY, null, (Object)new Object[]{1L, 2L, 3L}, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"1", (Object)"4"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.LONG_ARRAY, (Object)new Object[]{1L, 2L, 3L}, null, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.LONG_ARRAY, null, (Object)new Object[]{-1L}, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1", (Object)"4"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, null, (Object)new Object[0], Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, null, (Object)new Object[0], Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"6", (Object)"7") : ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5", (Object)"6", (Object)"7")));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)new Object[0], null, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, null, (Object)new Object[]{null}, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"2", (Object)"3"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, 2.2, 3.3}, (Object)new Object[]{1.1, 2.2, 3.3}, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, 2.2, 3.3}, null, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, null, (Object)new Object[]{1.1, 2.2, 3.3}, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"6"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayDouble", ColumnType.DOUBLE_ARRAY, null, (Object)new Object[]{0.0}, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"4"));
        }

        @Test
        public void testArrayRangesPrecisionLoss() {
            Assume.assumeTrue((boolean)this.isAutoSchema());
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.DOUBLE_ARRAY, null, (Object)new Object[]{1.0, 2.0, 3.0}, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.DOUBLE_ARRAY, null, (Object)new Object[]{1.0, 2.0, 3.0}, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"1", (Object)"4"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.DOUBLE_ARRAY, null, (Object)new Object[]{1.1, 2.1, 3.1}, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.0, 2.0, 3.0}, null, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{0.8, 1.8, 2.8}, null, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{0.8, 1.8, 2.8}, null, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.0, 2.0, 3.0}, null, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, 2.1, 3.1}, null, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, 2.1, 3.1}, null, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{0.8, 1.8, 2.8}, (Object)new Object[]{1.1, 2.1, 3.1}, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{0.8, 1.8, 2.8}, (Object)new Object[]{1.1, 2.1, 3.1}, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{0.8, 1.8, 2.8}, (Object)new Object[]{1.1, 2.1, 3.1}, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new RangeFilter("arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{0.8, 1.8, 2.8}, (Object)new Object[]{1.1, 2.1, 3.1}, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
        }

        @Test
        public void testVariant() {
            Assume.assumeTrue((boolean)this.isAutoSchema());
            this.assertFilterMatches((DimFilter)new RangeFilter("variant", ColumnType.LONG, (Object)100L, null, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
            this.assertFilterMatches((DimFilter)NotDimFilter.of((DimFilter)new RangeFilter("variant", ColumnType.LONG, (Object)100L, null, Boolean.valueOf(false), Boolean.valueOf(false), null)), (List<String>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)"0", (Object)"3", (Object)"4") : ImmutableList.of((Object)"0", (Object)"3", (Object)"4", (Object)"6", (Object)"7")));
            this.assertFilterMatches((DimFilter)new RangeFilter("variant", ColumnType.STRING, (Object)"100", null, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("variant", ColumnType.LONG_ARRAY, Collections.singletonList(100L), Arrays.asList(100L, 200L, 300L), Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"5"));
        }

        @Test
        public void testNested() {
            Assume.assumeTrue((boolean)this.canTestArrayColumns());
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.d0", ColumnType.DOUBLE, (Object)120.0, (Object)120.03, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.d0", ColumnType.FLOAT, (Object)Float.valueOf(120.02f), (Object)Float.valueOf(120.03f), Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"3"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.d0", ColumnType.FLOAT, (Object)Float.valueOf(59.5f), (Object)Float.valueOf(60.01f), Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"4"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.l0", ColumnType.LONG, (Object)12344L, (Object)12346L, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.l0", ColumnType.DOUBLE, (Object)12344.0, (Object)12345.5, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.l0", ColumnType.FLOAT, (Object)Float.valueOf(12344.0f), (Object)Float.valueOf(12345.5f), Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"5"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, null, (Object)new Object[]{1.0, 2.0, 3.0}, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, null, (Object)new Object[]{1.0, 2.0, 3.0}, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"1", (Object)"4"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, null, (Object)new Object[]{1.1, 2.1, 3.1}, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.0, 2.0, 3.0}, null, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{0.8, 1.8, 2.8}, null, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{0.8, 1.8, 2.8}, null, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.0, 2.0, 3.0}, null, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, 2.1, 3.1}, null, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{1.1, 2.1, 3.1}, null, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"5", (Object)"6", (Object)"7"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{0.8, 1.8, 2.8}, (Object)new Object[]{1.1, 2.1, 3.1}, Boolean.valueOf(true), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{0.8, 1.8, 2.8}, (Object)new Object[]{1.1, 2.1, 3.1}, Boolean.valueOf(false), Boolean.valueOf(true), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{0.8, 1.8, 2.8}, (Object)new Object[]{1.1, 2.1, 3.1}, Boolean.valueOf(true), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
            this.assertFilterMatches((DimFilter)new RangeFilter("nested.arrayLong", ColumnType.DOUBLE_ARRAY, (Object)new Object[]{0.8, 1.8, 2.8}, (Object)new Object[]{1.1, 2.1, 3.1}, Boolean.valueOf(false), Boolean.valueOf(false), null), (List<String>)ImmutableList.of((Object)"0", (Object)"2"));
        }
    }
}

