/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.join.BaseHashJoinSegmentStorageAdapterTest;
import org.apache.druid.segment.join.HashJoinSegmentStorageAdapter;
import org.apache.druid.segment.join.JoinTestHelper;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.PostJoinCursor;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class PostJoinCursorTest
extends BaseHashJoinSegmentStorageAdapterTest {
    public QueryableIndexSegment infiniteFactSegment;

    @Test
    public void testAdvanceWithInterruption() throws IOException, InterruptedException {
        int rowsBeforeInterrupt = 1000;
        CountDownLatch countDownLatch = new CountDownLatch(1000);
        this.infiniteFactSegment = new TestInfiniteQueryableIndexSegment(JoinTestHelper.createFactIndexBuilder(this.temporaryFolder.newFolder()).buildMMappedIndex(), SegmentId.dummy((String)"facts"), countDownLatch);
        this.countriesTable = JoinTestHelper.createCountriesIndexedTable();
        Thread joinCursorThread = new Thread(() -> this.makeCursorAndAdvance());
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        joinCursorThread.setUncaughtExceptionHandler(exceptionHandler);
        joinCursorThread.start();
        countDownLatch.await(1L, TimeUnit.SECONDS);
        joinCursorThread.interrupt();
        for (int i = 0; i < 1000; ++i) {
            if (exceptionHandler.getException() != null) {
                Assert.assertTrue((boolean)(exceptionHandler.getException() instanceof QueryInterruptedException));
                return;
            }
            Thread.sleep(1L);
        }
        Assert.fail();
    }

    public void makeCursorAndAdvance() {
        ImmutableList joinableClauses = ImmutableList.of((Object)this.factToCountryOnIsoCode(JoinType.LEFT));
        JoinFilterPreAnalysis joinFilterPreAnalysis = PostJoinCursorTest.makeDefaultConfigPreAnalysis(null, (List<JoinableClause>)joinableClauses, VirtualColumns.EMPTY);
        HashJoinSegmentStorageAdapter hashJoinSegmentStorageAdapter = new HashJoinSegmentStorageAdapter(this.infiniteFactSegment.asStorageAdapter(), (List)joinableClauses, joinFilterPreAnalysis);
        Cursor cursor = (Cursor)Iterables.getOnlyElement((Iterable)hashJoinSegmentStorageAdapter.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null).toList());
        ((PostJoinCursor)cursor).setValueMatcher(new ValueMatcher(){

            public boolean matches(boolean includeUnknown) {
                return false;
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        });
        cursor.advance();
    }

    private static class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        Throwable exception;

        private ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.exception = e;
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    private static class TestInfiniteQueryableIndexSegment
    extends QueryableIndexSegment {
        private final StorageAdapter testStorageAdaptor;

        public TestInfiniteQueryableIndexSegment(QueryableIndex index, SegmentId segmentId, CountDownLatch countDownLatch) {
            super(index, segmentId);
            this.testStorageAdaptor = new InfiniteQueryableIndexStorageAdapter(index, countDownLatch);
        }

        public StorageAdapter asStorageAdapter() {
            return this.testStorageAdaptor;
        }

        private static class InfiniteQueryableIndexStorageAdapter
        extends QueryableIndexStorageAdapter {
            CountDownLatch countDownLatch;

            public InfiniteQueryableIndexStorageAdapter(QueryableIndex index, CountDownLatch countDownLatch) {
                super(index);
                this.countDownLatch = countDownLatch;
            }

            public Sequence<Cursor> makeCursors(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
                return super.makeCursors(filter, interval, virtualColumns, gran, descending, queryMetrics).map(cursor -> new CursorNoAdvance((Cursor)cursor, this.countDownLatch));
            }

            private static class CursorNoAdvance
            implements Cursor {
                Cursor cursor;
                CountDownLatch countDownLatch;

                public CursorNoAdvance(Cursor cursor, CountDownLatch countDownLatch) {
                    this.cursor = cursor;
                    this.countDownLatch = countDownLatch;
                }

                public ColumnSelectorFactory getColumnSelectorFactory() {
                    return this.cursor.getColumnSelectorFactory();
                }

                public DateTime getTime() {
                    return this.cursor.getTime();
                }

                public void advance() {
                    this.countDownLatch.countDown();
                }

                public void advanceUninterruptibly() {
                    this.countDownLatch.countDown();
                }

                public boolean isDone() {
                    return false;
                }

                public boolean isDoneOrInterrupted() {
                    return this.cursor.isDoneOrInterrupted();
                }

                public void reset() {
                }
            }
        }
    }
}

