/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.HeapMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.allocation.SingleMemoryAllocatorFactory;
import org.apache.druid.frame.segment.FrameCursorUtils;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.query.FrameSignaturePair;
import org.apache.druid.query.IterableRowsCursorHelper;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.table.FrameBasedIndexedTable;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FrameBasedIndexedTableTest
extends InitializedNullHandlingTest {
    private static final String STRING_COL_1 = "market";
    private static final String LONG_COL_1 = "longNumericNull";
    private static final String DOUBLE_COL_1 = "doubleNumericNull";
    private static final String FLOAT_COL_1 = "floatNumericNull";
    private static final String STRING_COL_2 = "partial_null_column";
    private static final String MULTI_VALUE_COLUMN = "placementish";
    private static final String NON_INDEXED_STRING_COL = "nonIndexedString";
    private static final String NON_INDEXED_LONG_COL = "nonIndexedNumeric";
    private static final String NON_INDEXED_DOUBLE_COL = "nonIndexedDouble";
    private static final String NON_INDEXED_FLOAT_COL = "nonIndexedFloat";
    private static final String DIM_NOT_EXISTS = "DIM_NOT_EXISTS";
    private static final List<Object[]> DATASOURCE_ROWS = ImmutableList.builder().add((Object)new Object[]{"spot", 1L, null, Float.valueOf(3.1f), "preferred", new Object[]{"val1", "val2"}, "spot", 1L, null, Float.valueOf(3.1f)}).add((Object)new Object[]{"total_market", 1L, 1.2, Float.valueOf(3.2f), null, new Object[]{"val1", "val2"}, "total_market", 1L, 1.2, Float.valueOf(3.2f)}).add((Object)new Object[]{"spot", 2L, 1.3, Float.valueOf(3.1f), "preferred", new Object[]{"val1", "val2"}, "spot", 2L, 1.3, Float.valueOf(3.1f)}).add((Object)new Object[]{"upfront", 1L, 1.5, Float.valueOf(3.5f), "preferred", new Object[]{"val1", "val2"}, "upfront", 1L, 1.5, Float.valueOf(3.5f)}).add((Object)new Object[]{"total_market", null, 1.1, Float.valueOf(3.1f), null, new Object[]{"val1", "val2"}, "total_market", null, 1.1, Float.valueOf(3.1f)}).add((Object)new Object[]{"upfront", 2L, 1.5, null, "preferred", new Object[]{"val1", "val2"}, "upfront", 2L, 1.5, null}).add((Object)new Object[]{"upfront", 4L, 1.1, Float.valueOf(3.9f), "preferred", new Object[]{"val1", "val2"}, "upfront", 4L, 1.1, Float.valueOf(3.9f)}).add((Object)new Object[]{"total_market", 1L, 1.7, Float.valueOf(3.8f), "preferred", new Object[]{"val1", "val2"}, "total_market", 1L, 1.7, Float.valueOf(3.8f)}).add((Object)new Object[]{"spot", 5L, 1.8, Float.valueOf(3.1f), null, new Object[]{"val1", "val2"}, "spot", 5L, 1.8, Float.valueOf(3.1f)}).build();
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("market", ColumnType.STRING).add("longNumericNull", ColumnType.LONG).add("doubleNumericNull", ColumnType.DOUBLE).add("floatNumericNull", ColumnType.FLOAT).add("partial_null_column", ColumnType.STRING).add("placementish", ColumnType.STRING_ARRAY).add("nonIndexedString", ColumnType.STRING).add("nonIndexedNumeric", ColumnType.LONG).add("nonIndexedDouble", ColumnType.DOUBLE).add("nonIndexedFloat", ColumnType.FLOAT).build();
    private static final Set<String> KEY_COLUMNS = ImmutableSet.builder().add((Object)"market").add((Object)"partial_null_column").add((Object)"longNumericNull").add((Object)"doubleNumericNull").add((Object)"floatNumericNull").add((Object)"placementish").add((Object)"DIM_NOT_EXISTS").build();
    private FrameBasedInlineDataSource dataSource;
    private FrameBasedIndexedTable frameBasedIndexedTable;
    private Pair<Cursor, Closeable> cursorCloseablePair;

    @Before
    public void setup() {
        this.cursorCloseablePair = IterableRowsCursorHelper.getCursorFromIterable(DATASOURCE_ROWS, (RowSignature)ROW_SIGNATURE);
        Cursor cursor = (Cursor)this.cursorCloseablePair.lhs;
        FrameWriterFactory frameWriterFactory = FrameWriters.makeFrameWriterFactory((FrameType)FrameType.COLUMNAR, (MemoryAllocatorFactory)new SingleMemoryAllocatorFactory((MemoryAllocator)HeapMemoryAllocator.unlimited()), (RowSignature)ROW_SIGNATURE, new ArrayList());
        Frame frame = (Frame)Iterables.getOnlyElement((Iterable)FrameCursorUtils.cursorToFrames((Cursor)cursor, (FrameWriterFactory)frameWriterFactory).toList());
        this.dataSource = new FrameBasedInlineDataSource((List)ImmutableList.of((Object)new FrameSignaturePair(frame, ROW_SIGNATURE)), ROW_SIGNATURE);
        this.frameBasedIndexedTable = new FrameBasedIndexedTable(this.dataSource, KEY_COLUMNS, "test");
    }

    @After
    public void tearDown() throws IOException {
        ((Closeable)this.cursorCloseablePair.rhs).close();
    }

    @Test
    public void testInitShouldGenerateCorrectTable() {
        Assert.assertEquals((long)9L, (long)this.frameBasedIndexedTable.numRows());
    }

    @Test
    public void testStringKeyColumn() {
        Object[] vals = new String[]{"spot", "total_market", "upfront"};
        this.checkIndexAndReader(STRING_COL_1, vals);
    }

    @Test
    public void testNullableStringKeyColumn() {
        Object[] vals = new String[]{null, "preferred"};
        this.checkIndexAndReader(STRING_COL_2, vals);
    }

    @Test
    public void testMultiValueStringKeyColumn() {
        Object[] nonMatchingVals = new Object[]{ImmutableList.of((Object)"a", (Object)"preferred")};
        this.checkIndexAndReader(MULTI_VALUE_COLUMN, new Object[0], nonMatchingVals);
    }

    @Test
    public void testLongKeyColumn() {
        Object[] vals = new Long[]{NullHandling.replaceWithDefault() ? Long.valueOf(0L) : null, 1L, 2L, 4L, 5L};
        this.checkIndexAndReader(LONG_COL_1, vals);
    }

    @Test
    public void testFloatKeyColumn() {
        Object[] vals = new Float[]{NullHandling.replaceWithDefault() ? Float.valueOf(0.0f) : null, Float.valueOf(3.1f), Float.valueOf(3.2f), Float.valueOf(3.5f), Float.valueOf(3.8f), Float.valueOf(3.9f)};
        this.checkIndexAndReader(FLOAT_COL_1, vals);
    }

    @Test
    public void testDoubleKeyColumn() {
        Object[] vals = new Double[]{NullHandling.replaceWithDefault() ? Double.valueOf(0.0) : null, 1.1, 1.2, 1.3, 1.5, 1.7, 1.8};
        this.checkIndexAndReader(DOUBLE_COL_1, vals);
    }

    @Test
    public void testStringNonKeyColumn() {
        this.checkNonIndexedReader(NON_INDEXED_STRING_COL);
    }

    @Test
    public void testLongNonKeyColumn() {
        this.checkNonIndexedReader(NON_INDEXED_LONG_COL);
    }

    @Test
    public void testFloatNonKeyColumn() {
        this.checkNonIndexedReader(NON_INDEXED_FLOAT_COL);
    }

    @Test
    public void testDoubleNonKeyColumn() {
        this.checkNonIndexedReader(NON_INDEXED_DOUBLE_COL);
    }

    @Test
    public void testIsCacheable() {
        Assert.assertFalse((boolean)this.frameBasedIndexedTable.isCacheable());
    }

    private void checkIndexAndReader(String columnName, Object[] vals) {
        this.checkIndexAndReader(columnName, vals, new Object[0]);
    }

    private void checkIndexAndReader(String columnName, Object[] vals, Object[] nonmatchingVals) {
        this.checkColumnReader(columnName);
        try (Closer closer = Closer.create();){
            IntSortedSet valIndex;
            int columnIndex = ROW_SIGNATURE.indexOf(columnName);
            IndexedTable.Reader reader = this.frameBasedIndexedTable.columnReader(columnIndex);
            closer.register((Closeable)reader);
            IndexedTable.Index valueIndex = this.frameBasedIndexedTable.columnIndex(columnIndex);
            for (Object val : vals) {
                valIndex = valueIndex.find(val);
                Assert.assertTrue((valIndex.size() > 0 ? 1 : 0) != 0);
                IntBidirectionalIterator rowIterator = valIndex.iterator();
                while (rowIterator.hasNext()) {
                    Assert.assertEquals((Object)val, (Object)reader.read(rowIterator.nextInt()));
                }
            }
            for (Object val : nonmatchingVals) {
                valIndex = valueIndex.find(val);
                Assert.assertEquals((long)0L, (long)valIndex.size());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkNonIndexedReader(String columnName) {
        this.checkColumnReader(columnName);
        int columnIndex = ROW_SIGNATURE.indexOf(columnName);
        try {
            Assert.assertNull((Object)this.frameBasedIndexedTable.columnIndex(columnIndex));
        }
        catch (IAE iae) {
            Assert.assertEquals((Object)StringUtils.format((String)"Column[%d] is not a key column", (Object[])new Object[]{columnIndex}), (Object)iae.getMessage());
        }
    }

    private void checkColumnReader(String columnName) {
        int numRows = DATASOURCE_ROWS.size();
        int columnNumber = ROW_SIGNATURE.indexOf(columnName);
        IndexedTable.Reader reader = this.frameBasedIndexedTable.columnReader(columnNumber);
        List originalRows = this.dataSource.getRowsAsSequence().toList();
        for (int i = 0; i < numRows; ++i) {
            Object actualValue;
            Object originalValue = ((Object[])originalRows.get(i))[columnNumber];
            if (Objects.deepEquals(originalValue, actualValue = reader.read(i))) continue;
            Assert.assertEquals((Object)(originalValue instanceof Object[] ? Arrays.toString((Object[])originalValue) : originalValue), (Object)(actualValue instanceof Object[] ? Arrays.toString((Object[])actualValue) : actualValue));
        }
    }
}

