/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.ints.IntSortedSets;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ConstantDimensionSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableJoinMatcher;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=Enclosed.class)
public class IndexedTableJoinMatcherTest {
    private static final int SIZE = 3;

    private static IndexedTable.Index stringToLengthIndex() {
        return new IndexedTable.Index(){

            public ColumnType keyType() {
                return ColumnType.STRING;
            }

            public boolean areKeysUnique(boolean includeNull) {
                return false;
            }

            public IntSortedSet find(Object key) {
                return IntSortedSets.singleton((int)((String)key).length());
            }

            public int findUniqueLong(long key) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static IndexedTable.Index certainStringToThreeIndex() {
        return new IndexedTable.Index(){

            public ColumnType keyType() {
                return ColumnType.STRING;
            }

            public boolean areKeysUnique(boolean includeNull) {
                return true;
            }

            public IntSortedSet find(Object key) {
                if ("1".equals(DimensionHandlerUtils.convertObjectToString((Object)key))) {
                    return IntSortedSets.singleton((int)3);
                }
                return IntSortedSets.EMPTY_SET;
            }

            public int findUniqueLong(long key) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static IndexedTable.Index longPlusOneIndex() {
        return new IndexedTable.Index(){

            public ColumnType keyType() {
                return ColumnType.LONG;
            }

            public boolean areKeysUnique(boolean includeNull) {
                return true;
            }

            public IntSortedSet find(Object key) {
                Long l = DimensionHandlerUtils.convertObjectToLong((Object)key);
                if (l == null && NullHandling.sqlCompatible()) {
                    return IntSortedSets.EMPTY_SET;
                }
                return IntSortedSets.singleton((int)Ints.checkedCast((long)((l == null ? 0L : l) + 1L)));
            }

            public int findUniqueLong(long key) {
                return Ints.checkedCast((long)(key + 1L));
            }
        };
    }

    private static IndexedTable.Index longAlwaysOneTwoThreeIndex() {
        return new IndexedTable.Index(){

            public ColumnType keyType() {
                return ColumnType.LONG;
            }

            public boolean areKeysUnique(boolean includeNull) {
                return false;
            }

            public IntSortedSet find(Object key) {
                return new IntAVLTreeSet(new int[]{1, 2, 3});
            }

            public int findUniqueLong(long key) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static class Int2IntSortedSetLruCache {
        private IndexedTableJoinMatcher.Int2IntSortedSetLruCache target;
        private AtomicLong counter;

        @Before
        public void setup() {
            this.counter = new AtomicLong(0L);
            IntFunction<IntSortedSet> loader = key -> {
                this.counter.incrementAndGet();
                return IntSortedSets.singleton((int)key);
            };
            this.target = new IndexedTableJoinMatcher.Int2IntSortedSetLruCache(3, loader);
        }

        @Test
        public void loadsValueIfAbsent() {
            int key = 1;
            Assert.assertEquals((Object)IntSortedSets.singleton((int)key), (Object)this.target.getAndLoadIfAbsent(key));
            Assert.assertEquals((long)1L, (long)this.counter.longValue());
        }

        @Test
        public void doesNotLoadIfPresent() {
            int key = 1;
            Assert.assertEquals((Object)IntSortedSets.singleton((int)key), (Object)this.target.getAndLoadIfAbsent(key));
            Assert.assertEquals((Object)IntSortedSets.singleton((int)key), (Object)this.target.getAndLoadIfAbsent(key));
            Assert.assertEquals((long)1L, (long)this.counter.longValue());
        }

        @Test
        public void evictsLeastRecentlyUsed() {
            int start = 1;
            int next = start + 3;
            for (int key = start; key < next; ++key) {
                Assert.assertEquals((Object)IntSortedSets.singleton((int)key), (Object)this.target.getAndLoadIfAbsent(key));
            }
            Assert.assertEquals((Object)IntSortedSets.singleton((int)next), (Object)this.target.getAndLoadIfAbsent(next));
            Assert.assertNull((Object)this.target.get(start));
            Assert.assertEquals((long)4L, (long)this.counter.longValue());
        }
    }

    public static class Int2IntListLookupTableTest {
        private IndexedTableJoinMatcher.Int2IntSortedSetLookupTable target;
        private AtomicLong counter;

        @Before
        public void setup() {
            this.counter = new AtomicLong(0L);
            IntFunction<IntSortedSet> loader = key -> {
                this.counter.incrementAndGet();
                return IntSortedSets.singleton((int)key);
            };
            this.target = new IndexedTableJoinMatcher.Int2IntSortedSetLookupTable(3, loader);
        }

        @Test
        public void loadsValueIfAbsent() {
            int key = 1;
            Assert.assertEquals((Object)IntSortedSets.singleton((int)key), (Object)this.target.getAndLoadIfAbsent(key));
            Assert.assertEquals((long)1L, (long)this.counter.longValue());
        }

        @Test
        public void doesNotLoadIfPresent() {
            int key = 1;
            Assert.assertEquals((Object)IntSortedSets.singleton((int)key), (Object)this.target.getAndLoadIfAbsent(key));
            Assert.assertEquals((Object)IntSortedSets.singleton((int)key), (Object)this.target.getAndLoadIfAbsent(key));
            Assert.assertEquals((long)1L, (long)this.counter.longValue());
        }
    }

    public static class LruLoadingHashMapTest {
        private IndexedTableJoinMatcher.LruLoadingHashMap<Long, Long> target;
        private AtomicLong counter;

        @Before
        public void setup() {
            this.counter = new AtomicLong(0L);
            Function<Long, Long> loader = key -> {
                this.counter.incrementAndGet();
                return key;
            };
            this.target = new IndexedTableJoinMatcher.LruLoadingHashMap(3, loader);
        }

        @Test
        public void loadsValueIfAbsent() {
            Long key = 1L;
            Assert.assertEquals((Object)key, (Object)this.target.getAndLoadIfAbsent((Object)key));
            Assert.assertEquals((long)1L, (long)this.counter.longValue());
        }

        @Test
        public void doesNotLoadIfPresent() {
            Long key = 1L;
            Assert.assertEquals((Object)key, (Object)this.target.getAndLoadIfAbsent((Object)key));
            Assert.assertEquals((Object)key, (Object)this.target.getAndLoadIfAbsent((Object)key));
            Assert.assertEquals((long)1L, (long)this.counter.longValue());
        }

        @Test
        public void evictsLeastRecentlyUsed() {
            Long start = 1L;
            Long next = start + 3L;
            for (long i = start.longValue(); i < next; ++i) {
                Long key = i;
                Assert.assertEquals((Object)key, (Object)this.target.getAndLoadIfAbsent((Object)key));
            }
            Assert.assertEquals((Object)next, (Object)this.target.getAndLoadIfAbsent((Object)next));
            Assert.assertNull((Object)this.target.get((Object)start));
            Assert.assertEquals((long)4L, (long)this.counter.longValue());
        }
    }

    @RunWith(value=Enclosed.class)
    public static class ConditionMatcherFactoryTest {

        public static class MakeDimensionProcessorTest
        extends InitializedNullHandlingTest {
            @Rule
            public ExpectedException expectedException = ExpectedException.none();
            @Mock
            private DimensionSelector dimensionSelector;
            private static final String KEY = "key";

            @Test
            public void testMatchMultiValuedRowCardinalityUnknownShouldThrowException() throws Exception {
                try (AutoCloseable mocks = MockitoAnnotations.openMocks((Object)this);){
                    ArrayBasedIndexedInts row = new ArrayBasedIndexedInts(new int[]{2, 4, 6});
                    ((DimensionSelector)Mockito.doReturn((Object)row).when((Object)this.dimensionSelector)).getRow();
                    ((DimensionSelector)Mockito.doReturn((Object)-1).when((Object)this.dimensionSelector)).getValueCardinality();
                    IndexedTableJoinMatcher.ConditionMatcherFactory conditionMatcherFactory = new IndexedTableJoinMatcher.ConditionMatcherFactory(IndexedTableJoinMatcherTest.stringToLengthIndex(), false);
                    IndexedTableJoinMatcher.ConditionMatcher dimensionProcessor = conditionMatcherFactory.makeDimensionProcessor(this.dimensionSelector, false);
                    this.expectedException.expect(QueryUnsupportedException.class);
                    dimensionProcessor.match();
                }
            }

            @Test
            public void testMatchMultiValuedRowCardinalityKnownShouldThrowException() throws Exception {
                try (AutoCloseable mocks = MockitoAnnotations.openMocks((Object)this);){
                    ArrayBasedIndexedInts row = new ArrayBasedIndexedInts(new int[]{2, 4, 6});
                    ((DimensionSelector)Mockito.doReturn((Object)row).when((Object)this.dimensionSelector)).getRow();
                    ((DimensionSelector)Mockito.doReturn((Object)3).when((Object)this.dimensionSelector)).getValueCardinality();
                    IndexedTableJoinMatcher.ConditionMatcherFactory conditionMatcherFactory = new IndexedTableJoinMatcher.ConditionMatcherFactory(IndexedTableJoinMatcherTest.stringToLengthIndex(), false);
                    IndexedTableJoinMatcher.ConditionMatcher dimensionProcessor = conditionMatcherFactory.makeDimensionProcessor(this.dimensionSelector, false);
                    this.expectedException.expect(QueryUnsupportedException.class);
                    dimensionProcessor.match();
                }
            }

            @Test
            public void testMatchEmptyRowCardinalityUnknown() throws Exception {
                try (AutoCloseable mocks = MockitoAnnotations.openMocks((Object)this);){
                    ArrayBasedIndexedInts row = new ArrayBasedIndexedInts(new int[0]);
                    ((DimensionSelector)Mockito.doReturn((Object)row).when((Object)this.dimensionSelector)).getRow();
                    ((DimensionSelector)Mockito.doReturn((Object)-1).when((Object)this.dimensionSelector)).getValueCardinality();
                    IndexedTableJoinMatcher.ConditionMatcherFactory conditionMatcherFactory = new IndexedTableJoinMatcher.ConditionMatcherFactory(IndexedTableJoinMatcherTest.stringToLengthIndex(), false);
                    IndexedTableJoinMatcher.ConditionMatcher dimensionProcessor = conditionMatcherFactory.makeDimensionProcessor(this.dimensionSelector, false);
                    Assert.assertNotNull((Object)dimensionProcessor.match());
                    Assert.assertTrue((boolean)dimensionProcessor.match().isEmpty());
                    Assert.assertEquals((long)-1L, (long)dimensionProcessor.matchSingleRow());
                }
            }

            @Test
            public void testMatchEmptyRowCardinalityKnown() throws Exception {
                try (AutoCloseable mocks = MockitoAnnotations.openMocks((Object)this);){
                    ArrayBasedIndexedInts row = new ArrayBasedIndexedInts(new int[0]);
                    ((DimensionSelector)Mockito.doReturn((Object)row).when((Object)this.dimensionSelector)).getRow();
                    ((DimensionSelector)Mockito.doReturn((Object)0).when((Object)this.dimensionSelector)).getValueCardinality();
                    IndexedTableJoinMatcher.ConditionMatcherFactory conditionMatcherFactory = new IndexedTableJoinMatcher.ConditionMatcherFactory(IndexedTableJoinMatcherTest.stringToLengthIndex(), false);
                    IndexedTableJoinMatcher.ConditionMatcher dimensionProcessor = conditionMatcherFactory.makeDimensionProcessor(this.dimensionSelector, false);
                    Assert.assertNotNull((Object)dimensionProcessor.match());
                    Assert.assertTrue((boolean)dimensionProcessor.match().isEmpty());
                    Assert.assertEquals((long)-1L, (long)dimensionProcessor.matchSingleRow());
                }
            }

            @Test
            public void getsCorrectResultWhenSelectorCardinalityUnknown() {
                IndexedTableJoinMatcher.ConditionMatcher target = MakeDimensionProcessorTest.makeConditionMatcher(-1);
                Assert.assertEquals((Object)ImmutableList.of((Object)KEY.length()), (Object)new IntArrayList((IntCollection)target.match()));
                Assert.assertEquals((long)KEY.length(), (long)target.matchSingleRow());
            }

            @Test
            public void getsCorrectResultWhenSelectorCardinalityLow() {
                int lowCardinality = 100;
                IndexedTableJoinMatcher.ConditionMatcher target = MakeDimensionProcessorTest.makeConditionMatcher(lowCardinality);
                Assert.assertEquals((Object)ImmutableList.of((Object)KEY.length()), (Object)new IntArrayList((IntCollection)target.match()));
                Assert.assertEquals((long)KEY.length(), (long)target.matchSingleRow());
            }

            @Test
            public void getsCorrectResultWhenSelectorCardinalityHigh() {
                int highCardinality = 100;
                IndexedTableJoinMatcher.ConditionMatcher target = MakeDimensionProcessorTest.makeConditionMatcher(highCardinality);
                Assert.assertEquals((Object)ImmutableList.of((Object)KEY.length()), (Object)new IntArrayList((IntCollection)target.match()));
                Assert.assertEquals((long)KEY.length(), (long)target.matchSingleRow());
            }

            private static IndexedTableJoinMatcher.ConditionMatcher makeConditionMatcher(int valueCardinality) {
                IndexedTableJoinMatcher.ConditionMatcherFactory conditionMatcherFactory = new IndexedTableJoinMatcher.ConditionMatcherFactory(IndexedTableJoinMatcherTest.stringToLengthIndex(), false);
                return conditionMatcherFactory.makeDimensionProcessor((DimensionSelector)new TestDimensionSelector(KEY, valueCardinality), false);
            }

            private static class TestDimensionSelector
            extends ConstantDimensionSelector {
                private final int valueCardinality;

                TestDimensionSelector(String value, int valueCardinality) {
                    super(value);
                    this.valueCardinality = valueCardinality;
                }

                public int getValueCardinality() {
                    return this.valueCardinality;
                }
            }
        }

        public static class MakeComplexProcessorTest
        extends InitializedNullHandlingTest {
            @Rule
            public ExpectedException expectedException = ExpectedException.none();
            @Mock
            private BaseObjectColumnValueSelector<?> selector;
            private AutoCloseable mocks;

            @Before
            public void setUp() {
                this.mocks = MockitoAnnotations.openMocks((Object)this);
            }

            @After
            public void tearDown() throws Exception {
                this.mocks.close();
            }

            @Test
            public void testMatch() {
                IndexedTableJoinMatcher.ConditionMatcherFactory conditionMatcherFactory = new IndexedTableJoinMatcher.ConditionMatcherFactory(IndexedTableJoinMatcherTest.longPlusOneIndex(), false);
                IndexedTableJoinMatcher.ConditionMatcher processor = conditionMatcherFactory.makeComplexProcessor(this.selector);
                Assert.assertEquals((Object)ImmutableList.of(), (Object)ImmutableList.copyOf((Collection)processor.match()));
            }

            @Test
            public void testMatchSingleRow() {
                IndexedTableJoinMatcher.ConditionMatcherFactory conditionMatcherFactory = new IndexedTableJoinMatcher.ConditionMatcherFactory(IndexedTableJoinMatcherTest.longPlusOneIndex(), false);
                IndexedTableJoinMatcher.ConditionMatcher processor = conditionMatcherFactory.makeComplexProcessor(this.selector);
                Assert.assertEquals((long)-1L, (long)processor.matchSingleRow());
            }
        }

        public static class MakeLongProcessorTest
        extends InitializedNullHandlingTest {
            @Mock
            private BaseLongColumnValueSelector selector;
            private AutoCloseable mocks;

            @Before
            public void setUp() {
                this.mocks = MockitoAnnotations.openMocks((Object)this);
                if (NullHandling.sqlCompatible()) {
                    ((BaseLongColumnValueSelector)Mockito.doReturn((Object)false).when((Object)this.selector)).isNull();
                }
                ((BaseLongColumnValueSelector)Mockito.doReturn((Object)1L).when((Object)this.selector)).getLong();
            }

            @After
            public void tearDown() throws Exception {
                this.mocks.close();
            }

            @Test
            public void testMatchToUniqueLongIndex() {
                IndexedTableJoinMatcher.ConditionMatcherFactory conditionMatcherFactory = new IndexedTableJoinMatcher.ConditionMatcherFactory(IndexedTableJoinMatcherTest.longPlusOneIndex(), false);
                IndexedTableJoinMatcher.ConditionMatcher processor = conditionMatcherFactory.makeLongProcessor(this.selector);
                Assert.assertEquals((Object)ImmutableList.of((Object)2), (Object)ImmutableList.copyOf((Collection)processor.match()));
            }

            @Test
            public void testMatchSingleRowToUniqueLongIndex() {
                IndexedTableJoinMatcher.ConditionMatcherFactory conditionMatcherFactory = new IndexedTableJoinMatcher.ConditionMatcherFactory(IndexedTableJoinMatcherTest.longPlusOneIndex(), false);
                IndexedTableJoinMatcher.ConditionMatcher processor = conditionMatcherFactory.makeLongProcessor(this.selector);
                Assert.assertEquals((long)2L, (long)processor.matchSingleRow());
            }

            @Test
            public void testMatchToNonUniqueLongIndex() {
                IndexedTableJoinMatcher.ConditionMatcherFactory conditionMatcherFactory = new IndexedTableJoinMatcher.ConditionMatcherFactory(IndexedTableJoinMatcherTest.longAlwaysOneTwoThreeIndex(), false);
                IndexedTableJoinMatcher.ConditionMatcher processor = conditionMatcherFactory.makeLongProcessor(this.selector);
                Assert.assertEquals((Object)ImmutableList.of((Object)1, (Object)2, (Object)3), (Object)ImmutableList.copyOf((Collection)processor.match()));
            }

            @Test
            public void testMatchSingleRowToNonUniqueLongIndex() {
                IndexedTableJoinMatcher.ConditionMatcherFactory conditionMatcherFactory = new IndexedTableJoinMatcher.ConditionMatcherFactory(IndexedTableJoinMatcherTest.longAlwaysOneTwoThreeIndex(), false);
                IndexedTableJoinMatcher.ConditionMatcher processor = conditionMatcherFactory.makeLongProcessor(this.selector);
                Assert.assertThrows(UnsupportedOperationException.class, () -> ((IndexedTableJoinMatcher.ConditionMatcher)processor).matchSingleRow());
            }

            @Test
            public void testMatchToUniqueStringIndex() {
                IndexedTableJoinMatcher.ConditionMatcherFactory conditionMatcherFactory = new IndexedTableJoinMatcher.ConditionMatcherFactory(IndexedTableJoinMatcherTest.certainStringToThreeIndex(), false);
                IndexedTableJoinMatcher.ConditionMatcher processor = conditionMatcherFactory.makeLongProcessor(this.selector);
                Assert.assertEquals((Object)ImmutableList.of((Object)3), (Object)ImmutableList.copyOf((Collection)processor.match()));
            }

            @Test
            public void testMatchSingleRowToUniqueStringIndex() {
                IndexedTableJoinMatcher.ConditionMatcherFactory conditionMatcherFactory = new IndexedTableJoinMatcher.ConditionMatcherFactory(IndexedTableJoinMatcherTest.certainStringToThreeIndex(), false);
                IndexedTableJoinMatcher.ConditionMatcher processor = conditionMatcherFactory.makeLongProcessor(this.selector);
                Assert.assertEquals((long)3L, (long)processor.matchSingleRow());
            }
        }
    }
}

