/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.WrappedRoaringBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.guice.NestedDataModule;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.SelectorPredicateFactory;
import org.apache.druid.query.filter.StringPredicateDruidPredicateFactory;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AutoTypeColumnIndexer;
import org.apache.druid.segment.AutoTypeColumnMerger;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.NestedDataColumnSerializer;
import org.apache.druid.segment.nested.NestedDataColumnSupplier;
import org.apache.druid.segment.nested.NestedDataComplexColumn;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.SortedValueDictionary;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.NestedCommonFormatColumnPartSerde;
import org.apache.druid.segment.vector.BitmapVectorOffset;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class NestedDataColumnSupplierTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();
    private static final String NO_MATCH = "no";
    private static final ColumnConfig ALWAYS_USE_INDEXES = new ColumnConfig(){

        public double skipValueRangeIndexScale() {
            return 1.0;
        }

        public double skipValuePredicateIndexScale() {
            return 1.0;
        }
    };
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    BitmapSerdeFactory bitmapSerdeFactory = RoaringBitmapSerdeFactory.getInstance();
    DefaultBitmapResultFactory resultFactory = new DefaultBitmapResultFactory(this.bitmapSerdeFactory.getBitmapFactory());
    List<Map<String, Object>> data = ImmutableList.of(TestHelper.makeMap("x", 1L, "y", 1.0, "z", "a", "v", "100", "nullish", "notnull"), TestHelper.makeMap("y", 3.0, "z", "d", "v", 1000L, "nullish", null), TestHelper.makeMap("x", 5L, "y", 5.0, "z", "b", "nullish", ""), TestHelper.makeMap("x", 3L, "y", 4.0, "z", "c", "v", 3000.333, "nullish", "null"), TestHelper.makeMap("x", 2L, "v", "40000"), TestHelper.makeMap("x", 4L, "y", 2.0, "z", "e", "v", 11111L, "nullish", null));
    List<Map<String, Object>> arrayTestData = ImmutableList.of(TestHelper.makeMap("s", new Object[]{"a", "b", "c"}, "l", new Object[]{1L, 2L, 3L}, "d", new Object[]{1.1, 2.2}), TestHelper.makeMap("s", new Object[]{null, "b", "c"}, "l", new Object[]{1L, null, 3L}, "d", new Object[]{2.2, 2.2}), TestHelper.makeMap("s", new Object[]{"b", "c"}, "l", new Object[]{null, null}, "d", new Object[]{1.1, null, 2.2}), TestHelper.makeMap("s", new Object[]{"a", "b", "c", "d"}, "l", new Object[]{4L, 2L, 3L}), TestHelper.makeMap("s", new Object[]{"d", "b", "c", "a"}, "d", new Object[]{1.1, 2.2}), TestHelper.makeMap("l", new Object[]{1L, 2L, 3L}, "d", new Object[]{3.1, 2.2, 1.9}));
    Closer closer = Closer.create();
    SmooshedFileMapper fileMapper;
    ByteBuffer baseBuffer;
    SmooshedFileMapper arrayFileMapper;
    ByteBuffer arrayBaseBuffer;

    @BeforeClass
    public static void staticSetup() {
        NestedDataModule.registerHandlersAndSerde();
    }

    @Before
    public void setup() throws IOException {
        String fileNameBase = "test/column";
        String arrayFileNameBase = "array";
        this.fileMapper = this.smooshify("test/column", this.tempFolder.newFolder(), this.data);
        this.baseBuffer = this.fileMapper.mapFile("test/column");
        this.arrayFileMapper = this.smooshify("array", this.tempFolder.newFolder(), this.arrayTestData);
        this.arrayBaseBuffer = this.arrayFileMapper.mapFile("array");
    }

    private SmooshedFileMapper smooshify(String fileNameBase, File tmpFile, List<Map<String, Object>> data) throws IOException {
        TmpFileSegmentWriteOutMediumFactory writeOutMediumFactory = TmpFileSegmentWriteOutMediumFactory.instance();
        try (FileSmoosher smoosher = new FileSmoosher(tmpFile);){
            NestedDataColumnSerializer serializer = new NestedDataColumnSerializer(fileNameBase, IndexSpec.DEFAULT, writeOutMediumFactory.makeSegmentWriteOutMedium(this.tempFolder.newFolder()), this.closer);
            AutoTypeColumnIndexer indexer = new AutoTypeColumnIndexer("test", null);
            for (Map<String, Object> o : data) {
                indexer.processRowValsToUnsortedEncodedKeyComponent(o, false);
            }
            TreeMap sortedFields = new TreeMap();
            IndexableAdapter.NestedColumnMergable mergable = (IndexableAdapter.NestedColumnMergable)this.closer.register((Closeable)new IndexableAdapter.NestedColumnMergable(indexer.getSortedValueLookups(), indexer.getFieldTypeInfo(), false, false, null));
            SortedValueDictionary globalDictionarySortedCollector = mergable.getValueDictionary();
            mergable.mergeFieldsInto(sortedFields);
            serializer.openDictionaryWriter();
            serializer.serializeFields(sortedFields);
            serializer.serializeDictionaries((Iterable)globalDictionarySortedCollector.getSortedStrings(), (Iterable)globalDictionarySortedCollector.getSortedLongs(), (Iterable)globalDictionarySortedCollector.getSortedDoubles(), () -> new AutoTypeColumnMerger.ArrayDictionaryMergingIterator(new Iterable[]{globalDictionarySortedCollector.getSortedArrays()}, serializer.getGlobalLookup()));
            serializer.open();
            SettableSelector valueSelector = new SettableSelector();
            for (Map<String, Object> o : data) {
                valueSelector.setObject(StructuredData.wrap(o));
                serializer.serialize((ColumnValueSelector)valueSelector);
            }
            try (SmooshedWriter writer = smoosher.addWithSmooshedWriter(fileNameBase, serializer.getSerializedSize());){
                serializer.writeTo((WritableByteChannel)writer, smoosher);
            }
            smoosher.close();
            SmooshedFileMapper smooshedFileMapper = (SmooshedFileMapper)this.closer.register((Closeable)SmooshedFileMapper.load((File)tmpFile));
            return smooshedFileMapper;
        }
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testBasicFunctionality() throws IOException {
        ColumnBuilder bob = new ColumnBuilder();
        NestedCommonFormatColumnPartSerde partSerde = NestedCommonFormatColumnPartSerde.createDeserializer((ColumnType)ColumnType.NESTED_DATA, (boolean)false, (boolean)false, (boolean)false, (ByteOrder)ByteOrder.nativeOrder(), (BitmapSerdeFactory)RoaringBitmapSerdeFactory.getInstance());
        bob.setFileMapper(this.fileMapper);
        ColumnPartSerde.Deserializer deserializer = partSerde.getDeserializer();
        deserializer.read(this.baseBuffer, bob, ALWAYS_USE_INDEXES);
        ColumnHolder holder = bob.build();
        ColumnCapabilities capabilities = holder.getCapabilities();
        Assert.assertEquals((Object)ColumnType.NESTED_DATA, (Object)capabilities.toColumnType());
        Assert.assertTrue((boolean)(holder.getColumnFormat() instanceof NestedCommonFormatColumn.Format));
        try (NestedDataComplexColumn column = (NestedDataComplexColumn)holder.getColumn();){
            this.smokeTest(column);
        }
    }

    @Test
    public void testArrayFunctionality() throws IOException {
        ColumnBuilder bob = new ColumnBuilder();
        NestedCommonFormatColumnPartSerde partSerde = NestedCommonFormatColumnPartSerde.createDeserializer((ColumnType)ColumnType.NESTED_DATA, (boolean)false, (boolean)false, (boolean)false, (ByteOrder)ByteOrder.nativeOrder(), (BitmapSerdeFactory)RoaringBitmapSerdeFactory.getInstance());
        bob.setFileMapper(this.arrayFileMapper);
        ColumnPartSerde.Deserializer deserializer = partSerde.getDeserializer();
        deserializer.read(this.arrayBaseBuffer, bob, ALWAYS_USE_INDEXES);
        ColumnHolder holder = bob.build();
        ColumnCapabilities capabilities = holder.getCapabilities();
        Assert.assertEquals((Object)ColumnType.NESTED_DATA, (Object)capabilities.toColumnType());
        Assert.assertTrue((boolean)(holder.getColumnFormat() instanceof NestedCommonFormatColumn.Format));
        try (NestedDataComplexColumn column = (NestedDataComplexColumn)holder.getColumn();){
            this.smokeTestArrays(column);
        }
    }

    @Test
    public void testConcurrency() throws ExecutionException, InterruptedException {
        ColumnBuilder bob = new ColumnBuilder();
        bob.setFileMapper(this.fileMapper);
        NestedDataColumnSupplier supplier = NestedDataColumnSupplier.read((ColumnType)ColumnType.NESTED_DATA, (boolean)false, (ByteBuffer)this.baseBuffer, (ColumnBuilder)bob, (ColumnConfig)ALWAYS_USE_INDEXES, (BitmapSerdeFactory)this.bitmapSerdeFactory, (ByteOrder)ByteOrder.nativeOrder());
        String expectedReason = "none";
        AtomicReference<String> failureReason = new AtomicReference<String>("none");
        int threads = 10;
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)10, (String)"StandardNestedColumnSupplierTest-%d"));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(10);
        CountDownLatch threadsStartLatch = new CountDownLatch(1);
        for (int i = 0; i < 10; ++i) {
            futures.add(executorService.submit(() -> {
                try {
                    threadsStartLatch.await();
                    for (int iter = 0; iter < 5000; ++iter) {
                        try (NestedDataComplexColumn column = (NestedDataComplexColumn)supplier.get();){
                            this.smokeTest(column);
                            continue;
                        }
                    }
                }
                catch (Throwable ex) {
                    failureReason.set(ex.getMessage());
                }
            }));
        }
        threadsStartLatch.countDown();
        Futures.allAsList(futures).get();
        Assert.assertEquals((Object)"none", (Object)failureReason.get());
    }

    private void smokeTest(NestedDataComplexColumn column) throws IOException {
        SimpleAscendingOffset offset = new SimpleAscendingOffset(this.data.size());
        ColumnValueSelector rawSelector = column.makeColumnValueSelector((ReadableOffset)offset);
        List xPath = NestedPathFinder.parseJsonPath((String)"$.x");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.LONG), (Object)column.getColumnTypes(xPath));
        Assert.assertEquals((Object)ColumnType.LONG, (Object)column.getColumnHolder(xPath).getCapabilities().toColumnType());
        ColumnValueSelector xSelector = column.makeColumnValueSelector(xPath, (ReadableOffset)offset);
        DimensionSelector xDimSelector = column.makeDimensionSelector(xPath, (ReadableOffset)offset, null);
        ColumnIndexSupplier xIndexSupplier = column.getColumnIndexSupplier(xPath);
        Assert.assertNotNull((Object)xIndexSupplier);
        StringValueSetIndexes xValueIndex = (StringValueSetIndexes)xIndexSupplier.as(StringValueSetIndexes.class);
        DruidPredicateIndexes xPredicateIndex = (DruidPredicateIndexes)xIndexSupplier.as(DruidPredicateIndexes.class);
        NullValueIndex xNulls = (NullValueIndex)xIndexSupplier.as(NullValueIndex.class);
        List yPath = NestedPathFinder.parseJsonPath((String)"$.y");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.DOUBLE), (Object)column.getColumnTypes(yPath));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)column.getColumnHolder(yPath).getCapabilities().toColumnType());
        ColumnValueSelector ySelector = column.makeColumnValueSelector(yPath, (ReadableOffset)offset);
        DimensionSelector yDimSelector = column.makeDimensionSelector(yPath, (ReadableOffset)offset, null);
        ColumnIndexSupplier yIndexSupplier = column.getColumnIndexSupplier(yPath);
        Assert.assertNotNull((Object)yIndexSupplier);
        StringValueSetIndexes yValueIndex = (StringValueSetIndexes)yIndexSupplier.as(StringValueSetIndexes.class);
        DruidPredicateIndexes yPredicateIndex = (DruidPredicateIndexes)yIndexSupplier.as(DruidPredicateIndexes.class);
        NullValueIndex yNulls = (NullValueIndex)yIndexSupplier.as(NullValueIndex.class);
        List zPath = NestedPathFinder.parseJsonPath((String)"$.z");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.STRING), (Object)column.getColumnTypes(zPath));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)column.getColumnHolder(zPath).getCapabilities().toColumnType());
        ColumnValueSelector zSelector = column.makeColumnValueSelector(zPath, (ReadableOffset)offset);
        DimensionSelector zDimSelector = column.makeDimensionSelector(zPath, (ReadableOffset)offset, null);
        ColumnIndexSupplier zIndexSupplier = column.getColumnIndexSupplier(zPath);
        Assert.assertNotNull((Object)zIndexSupplier);
        StringValueSetIndexes zValueIndex = (StringValueSetIndexes)zIndexSupplier.as(StringValueSetIndexes.class);
        DruidPredicateIndexes zPredicateIndex = (DruidPredicateIndexes)zIndexSupplier.as(DruidPredicateIndexes.class);
        NullValueIndex zNulls = (NullValueIndex)zIndexSupplier.as(NullValueIndex.class);
        List vPath = NestedPathFinder.parseJsonPath((String)"$.v");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.STRING, (Object)ColumnType.LONG, (Object)ColumnType.DOUBLE), (Object)column.getColumnTypes(vPath));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)column.getColumnHolder(vPath).getCapabilities().toColumnType());
        ColumnValueSelector vSelector = column.makeColumnValueSelector(vPath, (ReadableOffset)offset);
        DimensionSelector vDimSelector = column.makeDimensionSelector(vPath, (ReadableOffset)offset, null);
        ColumnIndexSupplier vIndexSupplier = column.getColumnIndexSupplier(vPath);
        Assert.assertNotNull((Object)vIndexSupplier);
        StringValueSetIndexes vValueIndex = (StringValueSetIndexes)vIndexSupplier.as(StringValueSetIndexes.class);
        DruidPredicateIndexes vPredicateIndex = (DruidPredicateIndexes)vIndexSupplier.as(DruidPredicateIndexes.class);
        NullValueIndex vNulls = (NullValueIndex)vIndexSupplier.as(NullValueIndex.class);
        List nullishPath = NestedPathFinder.parseJsonPath((String)"$.nullish");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.STRING), (Object)column.getColumnTypes(nullishPath));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)column.getColumnHolder(nullishPath).getCapabilities().toColumnType());
        ColumnValueSelector nullishSelector = column.makeColumnValueSelector(nullishPath, (ReadableOffset)offset);
        DimensionSelector nullishDimSelector = column.makeDimensionSelector(nullishPath, (ReadableOffset)offset, null);
        ColumnIndexSupplier nullishIndexSupplier = column.getColumnIndexSupplier(nullishPath);
        Assert.assertNotNull((Object)nullishIndexSupplier);
        StringValueSetIndexes nullishValueIndex = (StringValueSetIndexes)nullishIndexSupplier.as(StringValueSetIndexes.class);
        DruidPredicateIndexes nullishPredicateIndex = (DruidPredicateIndexes)nullishIndexSupplier.as(DruidPredicateIndexes.class);
        NullValueIndex nullishNulls = (NullValueIndex)nullishIndexSupplier.as(NullValueIndex.class);
        Assert.assertEquals((Object)ImmutableList.of((Object)nullishPath, (Object)vPath, (Object)xPath, (Object)yPath, (Object)zPath), (Object)column.getNestedFields());
        for (int i = 0; i < this.data.size(); ++i) {
            Map<String, Object> row = this.data.get(i);
            Assert.assertEquals((Object)JSON_MAPPER.writeValueAsString(row), (Object)JSON_MAPPER.writeValueAsString(StructuredData.unwrap((Object)rawSelector.getObject())));
            this.testPath(row, i, "v", vSelector, vDimSelector, vValueIndex, vPredicateIndex, vNulls, null);
            this.testPath(row, i, "x", xSelector, xDimSelector, xValueIndex, xPredicateIndex, xNulls, ColumnType.LONG);
            this.testPath(row, i, "y", ySelector, yDimSelector, yValueIndex, yPredicateIndex, yNulls, ColumnType.DOUBLE);
            this.testPath(row, i, "z", zSelector, zDimSelector, zValueIndex, zPredicateIndex, zNulls, ColumnType.STRING);
            this.testPath(row, i, "nullish", nullishSelector, nullishDimSelector, nullishValueIndex, nullishPredicateIndex, nullishNulls, ColumnType.STRING);
            offset.increment();
        }
    }

    private void smokeTestArrays(NestedDataComplexColumn column) throws IOException {
        boolean[] lElementNulls;
        long[] lElementVector;
        Object[] sElementVector;
        Object[] dVector;
        Object[] lVector;
        Object[] sVector;
        Object[] rawVector;
        SimpleAscendingOffset offset = new SimpleAscendingOffset(this.arrayTestData.size());
        NoFilterVectorOffset vectorOffset = new NoFilterVectorOffset(4, 0, this.arrayTestData.size());
        WrappedRoaringBitmap bitmap = new WrappedRoaringBitmap();
        for (int i = 0; i < this.arrayTestData.size(); ++i) {
            if (i % 2 != 0) continue;
            bitmap.add(i);
        }
        BitmapVectorOffset bitmapVectorOffset = new BitmapVectorOffset(4, bitmap.toImmutableBitmap(), 0, this.arrayTestData.size());
        ColumnValueSelector rawSelector = column.makeColumnValueSelector((ReadableOffset)offset);
        VectorObjectSelector rawVectorSelector = column.makeVectorObjectSelector((ReadableVectorOffset)vectorOffset);
        VectorObjectSelector rawVectorSelectorFiltered = column.makeVectorObjectSelector((ReadableVectorOffset)bitmapVectorOffset);
        List sPath = NestedPathFinder.parseJsonPath((String)"$.s");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.STRING_ARRAY), (Object)column.getColumnTypes(sPath));
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, (Object)column.getColumnHolder(sPath).getCapabilities().toColumnType());
        ColumnValueSelector sSelector = column.makeColumnValueSelector(sPath, (ReadableOffset)offset);
        VectorObjectSelector sVectorSelector = column.makeVectorObjectSelector(sPath, (ReadableVectorOffset)vectorOffset);
        VectorObjectSelector sVectorSelectorFiltered = column.makeVectorObjectSelector(sPath, (ReadableVectorOffset)bitmapVectorOffset);
        ColumnIndexSupplier sIndexSupplier = column.getColumnIndexSupplier(sPath);
        Assert.assertNotNull((Object)sIndexSupplier);
        Assert.assertNull((Object)sIndexSupplier.as(StringValueSetIndexes.class));
        Assert.assertNull((Object)sIndexSupplier.as(DruidPredicateIndexes.class));
        NullValueIndex sNulls = (NullValueIndex)sIndexSupplier.as(NullValueIndex.class);
        List sElementPath = NestedPathFinder.parseJsonPath((String)"$.s[1]");
        ColumnValueSelector sElementSelector = column.makeColumnValueSelector(sElementPath, (ReadableOffset)offset);
        VectorObjectSelector sElementVectorSelector = column.makeVectorObjectSelector(sElementPath, (ReadableVectorOffset)vectorOffset);
        VectorObjectSelector sElementFilteredVectorSelector = column.makeVectorObjectSelector(sElementPath, (ReadableVectorOffset)bitmapVectorOffset);
        ColumnIndexSupplier sElementIndexSupplier = column.getColumnIndexSupplier(sElementPath);
        Assert.assertNotNull((Object)sElementIndexSupplier);
        Assert.assertNull((Object)sElementIndexSupplier.as(StringValueSetIndexes.class));
        Assert.assertNull((Object)sElementIndexSupplier.as(DruidPredicateIndexes.class));
        Assert.assertNull((Object)sElementIndexSupplier.as(NullValueIndex.class));
        List lPath = NestedPathFinder.parseJsonPath((String)"$.l");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.LONG_ARRAY), (Object)column.getColumnTypes(lPath));
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, (Object)column.getColumnHolder(lPath).getCapabilities().toColumnType());
        ColumnValueSelector lSelector = column.makeColumnValueSelector(lPath, (ReadableOffset)offset);
        VectorObjectSelector lVectorSelector = column.makeVectorObjectSelector(lPath, (ReadableVectorOffset)vectorOffset);
        VectorObjectSelector lVectorSelectorFiltered = column.makeVectorObjectSelector(lPath, (ReadableVectorOffset)bitmapVectorOffset);
        ColumnIndexSupplier lIndexSupplier = column.getColumnIndexSupplier(lPath);
        Assert.assertNotNull((Object)lIndexSupplier);
        Assert.assertNull((Object)lIndexSupplier.as(StringValueSetIndexes.class));
        Assert.assertNull((Object)lIndexSupplier.as(DruidPredicateIndexes.class));
        NullValueIndex lNulls = (NullValueIndex)lIndexSupplier.as(NullValueIndex.class);
        List lElementPath = NestedPathFinder.parseJsonPath((String)"$.l[1]");
        ColumnValueSelector lElementSelector = column.makeColumnValueSelector(lElementPath, (ReadableOffset)offset);
        VectorValueSelector lElementVectorSelector = column.makeVectorValueSelector(lElementPath, (ReadableVectorOffset)vectorOffset);
        VectorObjectSelector lElementVectorObjectSelector = column.makeVectorObjectSelector(lElementPath, (ReadableVectorOffset)vectorOffset);
        VectorValueSelector lElementFilteredVectorSelector = column.makeVectorValueSelector(lElementPath, (ReadableVectorOffset)bitmapVectorOffset);
        ColumnIndexSupplier lElementIndexSupplier = column.getColumnIndexSupplier(lElementPath);
        Assert.assertNotNull((Object)lElementIndexSupplier);
        Assert.assertNull((Object)lElementIndexSupplier.as(StringValueSetIndexes.class));
        Assert.assertNull((Object)lElementIndexSupplier.as(DruidPredicateIndexes.class));
        Assert.assertNull((Object)lElementIndexSupplier.as(NullValueIndex.class));
        List dPath = NestedPathFinder.parseJsonPath((String)"$.d");
        Assert.assertEquals((Object)ImmutableSet.of((Object)ColumnType.DOUBLE_ARRAY), (Object)column.getColumnTypes(dPath));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, (Object)column.getColumnHolder(dPath).getCapabilities().toColumnType());
        ColumnValueSelector dSelector = column.makeColumnValueSelector(dPath, (ReadableOffset)offset);
        VectorObjectSelector dVectorSelector = column.makeVectorObjectSelector(dPath, (ReadableVectorOffset)vectorOffset);
        VectorObjectSelector dVectorSelectorFiltered = column.makeVectorObjectSelector(dPath, (ReadableVectorOffset)bitmapVectorOffset);
        ColumnIndexSupplier dIndexSupplier = column.getColumnIndexSupplier(dPath);
        Assert.assertNotNull((Object)dIndexSupplier);
        Assert.assertNull((Object)dIndexSupplier.as(StringValueSetIndexes.class));
        Assert.assertNull((Object)dIndexSupplier.as(DruidPredicateIndexes.class));
        NullValueIndex dNulls = (NullValueIndex)dIndexSupplier.as(NullValueIndex.class);
        List dElementPath = NestedPathFinder.parseJsonPath((String)"$.d[1]");
        ColumnValueSelector dElementSelector = column.makeColumnValueSelector(dElementPath, (ReadableOffset)offset);
        VectorValueSelector dElementVectorSelector = column.makeVectorValueSelector(dElementPath, (ReadableVectorOffset)vectorOffset);
        VectorObjectSelector dElementVectorObjectSelector = column.makeVectorObjectSelector(dElementPath, (ReadableVectorOffset)vectorOffset);
        VectorValueSelector dElementFilteredVectorSelector = column.makeVectorValueSelector(dElementPath, (ReadableVectorOffset)bitmapVectorOffset);
        ColumnIndexSupplier dElementIndexSupplier = column.getColumnIndexSupplier(dElementPath);
        Assert.assertNotNull((Object)dElementIndexSupplier);
        Assert.assertNull((Object)dElementIndexSupplier.as(StringValueSetIndexes.class));
        Assert.assertNull((Object)dElementIndexSupplier.as(DruidPredicateIndexes.class));
        Assert.assertNull((Object)dElementIndexSupplier.as(NullValueIndex.class));
        ImmutableBitmap sNullIndex = (ImmutableBitmap)sNulls.get().computeBitmapResult((BitmapResultFactory)this.resultFactory, false);
        ImmutableBitmap lNullIndex = (ImmutableBitmap)lNulls.get().computeBitmapResult((BitmapResultFactory)this.resultFactory, false);
        ImmutableBitmap dNullIndex = (ImmutableBitmap)dNulls.get().computeBitmapResult((BitmapResultFactory)this.resultFactory, false);
        int rowCounter = 0;
        while (offset.withinBounds()) {
            Map<String, Object> row = this.arrayTestData.get(rowCounter);
            Assert.assertEquals((Object)JSON_MAPPER.writeValueAsString(row), (Object)JSON_MAPPER.writeValueAsString(StructuredData.unwrap((Object)rawSelector.getObject())));
            Object[] s = (Object[])row.get("s");
            Object[] l = (Object[])row.get("l");
            Object[] d = (Object[])row.get("d");
            Assert.assertArrayEquals((Object[])s, (Object[])((Object[])sSelector.getObject()));
            Assert.assertArrayEquals((Object[])l, (Object[])((Object[])lSelector.getObject()));
            Assert.assertArrayEquals((Object[])d, (Object[])((Object[])dSelector.getObject()));
            Assert.assertEquals((Object)(s == null ? 1 : 0), (Object)sNullIndex.get(rowCounter));
            Assert.assertEquals((Object)(l == null ? 1 : 0), (Object)lNullIndex.get(rowCounter));
            Assert.assertEquals((Object)(d == null ? 1 : 0), (Object)dNullIndex.get(rowCounter));
            if (s == null || s.length < 1) {
                Assert.assertNull((Object)sElementSelector.getObject());
            } else {
                Assert.assertEquals((Object)s[1], (Object)sElementSelector.getObject());
            }
            if (l == null || l.length < 1 || l[1] == null) {
                Assert.assertTrue((boolean)lElementSelector.isNull());
                Assert.assertNull((Object)lElementSelector.getObject());
            } else {
                Assert.assertEquals((Object)l[1], (Object)lElementSelector.getLong());
                Assert.assertEquals((Object)l[1], (Object)lElementSelector.getObject());
            }
            if (d == null || d.length < 1 || d[1] == null) {
                Assert.assertTrue((boolean)dElementSelector.isNull());
                Assert.assertNull((Object)dElementSelector.getObject());
            } else {
                Assert.assertEquals((double)((Double)d[1]), (double)dElementSelector.getDouble(), (double)0.0);
                Assert.assertEquals((Object)d[1], (Object)dElementSelector.getObject());
            }
            offset.increment();
            ++rowCounter;
        }
        rowCounter = 0;
        while (!vectorOffset.isDone()) {
            rawVector = rawVectorSelector.getObjectVector();
            sVector = sVectorSelector.getObjectVector();
            lVector = lVectorSelector.getObjectVector();
            dVector = dVectorSelector.getObjectVector();
            sElementVector = sElementVectorSelector.getObjectVector();
            lElementVector = lElementVectorSelector.getLongVector();
            lElementNulls = lElementVectorSelector.getNullVector();
            Object[] lElementObjectVector = lElementVectorObjectSelector.getObjectVector();
            double[] dElementVector = dElementVectorSelector.getDoubleVector();
            boolean[] dElementNulls = dElementVectorSelector.getNullVector();
            Object[] dElementObjectVector = dElementVectorObjectSelector.getObjectVector();
            int i = 0;
            while (i < vectorOffset.getCurrentVectorSize()) {
                Map<String, Object> row = this.arrayTestData.get(rowCounter);
                Assert.assertEquals((Object)JSON_MAPPER.writeValueAsString(row), (Object)JSON_MAPPER.writeValueAsString(StructuredData.unwrap((Object)rawVector[i])));
                Object[] s = (Object[])row.get("s");
                Object[] l = (Object[])row.get("l");
                Object[] d = (Object[])row.get("d");
                Assert.assertArrayEquals((Object[])s, (Object[])((Object[])sVector[i]));
                Assert.assertArrayEquals((Object[])l, (Object[])((Object[])lVector[i]));
                Assert.assertArrayEquals((Object[])d, (Object[])((Object[])dVector[i]));
                if (s == null || s.length < 1) {
                    Assert.assertNull((Object)sElementVector[i]);
                } else {
                    Assert.assertEquals((Object)s[1], (Object)sElementVector[i]);
                }
                if (l == null || l.length < 1 || l[1] == null) {
                    Assert.assertTrue((boolean)lElementNulls[i]);
                    Assert.assertNull((Object)lElementObjectVector[i]);
                } else {
                    Assert.assertEquals((Object)l[1], (Object)lElementVector[i]);
                    Assert.assertEquals((Object)l[1], (Object)lElementObjectVector[i]);
                }
                if (d == null || d.length < 1 || d[1] == null) {
                    Assert.assertTrue((boolean)dElementNulls[i]);
                    Assert.assertNull((Object)dElementObjectVector[i]);
                } else {
                    Assert.assertEquals((double)((Double)d[1]), (double)dElementVector[i], (double)0.0);
                    Assert.assertEquals((Object)d[1], (Object)dElementObjectVector[i]);
                }
                ++i;
                ++rowCounter;
            }
            vectorOffset.advance();
        }
        rowCounter = 0;
        while (!bitmapVectorOffset.isDone()) {
            rawVector = rawVectorSelectorFiltered.getObjectVector();
            sVector = sVectorSelectorFiltered.getObjectVector();
            lVector = lVectorSelectorFiltered.getObjectVector();
            dVector = dVectorSelectorFiltered.getObjectVector();
            sElementVector = sElementFilteredVectorSelector.getObjectVector();
            lElementVector = lElementFilteredVectorSelector.getLongVector();
            lElementNulls = lElementFilteredVectorSelector.getNullVector();
            double[] dElementVector = dElementFilteredVectorSelector.getDoubleVector();
            boolean[] dElementNulls = dElementFilteredVectorSelector.getNullVector();
            int i = 0;
            while (i < bitmapVectorOffset.getCurrentVectorSize()) {
                Map<String, Object> row = this.arrayTestData.get(rowCounter);
                Assert.assertEquals((Object)JSON_MAPPER.writeValueAsString(row), (Object)JSON_MAPPER.writeValueAsString(StructuredData.unwrap((Object)rawVector[i])));
                Object[] s = (Object[])row.get("s");
                Object[] l = (Object[])row.get("l");
                Object[] d = (Object[])row.get("d");
                Assert.assertArrayEquals((Object[])s, (Object[])((Object[])sVector[i]));
                Assert.assertArrayEquals((Object[])l, (Object[])((Object[])lVector[i]));
                Assert.assertArrayEquals((Object[])d, (Object[])((Object[])dVector[i]));
                if (s == null || s.length < 1) {
                    Assert.assertNull((Object)sElementVector[i]);
                } else {
                    Assert.assertEquals((Object)s[1], (Object)sElementVector[i]);
                }
                if (l == null || l.length < 1 || l[1] == null) {
                    Assert.assertTrue((boolean)lElementNulls[i]);
                } else {
                    Assert.assertEquals((Object)l[1], (Object)lElementVector[i]);
                }
                if (d == null || d.length < 1 || d[1] == null) {
                    Assert.assertTrue((boolean)dElementNulls[i]);
                } else {
                    Assert.assertEquals((double)((Double)d[1]), (double)dElementVector[i], (double)0.0);
                }
                ++i;
                rowCounter += 2;
            }
            bitmapVectorOffset.advance();
        }
    }

    private void testPath(Map row, int rowNumber, String path, ColumnValueSelector<?> valueSelector, DimensionSelector dimSelector, StringValueSetIndexes valueSetIndex, DruidPredicateIndexes predicateIndex, NullValueIndex nullValueIndex, @Nullable ColumnType singleType) {
        boolean isStringAndNullEquivalent;
        Object inputValue = row.get(path);
        boolean bl = isStringAndNullEquivalent = inputValue instanceof String && NullHandling.isNullOrEquivalent((String)((String)inputValue));
        if (row.containsKey(path) && inputValue != null && !isStringAndNullEquivalent) {
            Assert.assertEquals(inputValue, (Object)valueSelector.getObject());
            if (ColumnType.LONG.equals((Object)singleType)) {
                Assert.assertEquals(inputValue, (Object)valueSelector.getLong());
                Assert.assertFalse((String)(path + " is not null"), (boolean)valueSelector.isNull());
            } else if (ColumnType.DOUBLE.equals((Object)singleType)) {
                Assert.assertEquals((double)((Double)inputValue), (double)valueSelector.getDouble(), (double)0.0);
                Assert.assertFalse((String)(path + " is not null"), (boolean)valueSelector.isNull());
            }
            String theString = String.valueOf(inputValue);
            Assert.assertEquals((Object)theString, (Object)dimSelector.getObject());
            String dimSelectorLookupVal = dimSelector.lookupName(dimSelector.getRow().get(0));
            Assert.assertEquals((Object)theString, (Object)dimSelectorLookupVal);
            Assert.assertEquals((long)dimSelector.idLookup().lookupId(dimSelectorLookupVal), (long)dimSelector.getRow().get(0));
            Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forValue(theString).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)theString))).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertTrue((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(theString)).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forSortedValues(new TreeSet(ImmutableSet.of((Object)NO_MATCH))).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(NO_MATCH)).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)nullValueIndex.get().computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertTrue((boolean)dimSelector.makeValueMatcher(theString).matches(false));
            Assert.assertFalse((boolean)dimSelector.makeValueMatcher(NO_MATCH).matches(false));
            Assert.assertTrue((boolean)dimSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)theString)).matches(false));
            Assert.assertFalse((boolean)dimSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)NO_MATCH)).matches(false));
        } else {
            Assert.assertNull((Object)valueSelector.getObject());
            Assert.assertTrue((String)path, (boolean)valueSelector.isNull());
            Assert.assertEquals((long)0L, (long)dimSelector.getRow().get(0));
            Assert.assertNull((Object)dimSelector.getObject());
            Assert.assertNull((Object)dimSelector.lookupName(dimSelector.getRow().get(0)));
            Assert.assertTrue((boolean)((ImmutableBitmap)nullValueIndex.get().computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertTrue((boolean)((ImmutableBitmap)valueSetIndex.forValue(null).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertTrue((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(null)).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)valueSetIndex.forValue(NO_MATCH).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertFalse((boolean)((ImmutableBitmap)predicateIndex.forPredicate((DruidPredicateFactory)new SelectorPredicateFactory(NO_MATCH)).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(rowNumber));
            Assert.assertTrue((boolean)dimSelector.makeValueMatcher((String)null).matches(false));
            Assert.assertFalse((boolean)dimSelector.makeValueMatcher(NO_MATCH).matches(false));
            Assert.assertTrue((boolean)dimSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo(null)).matches(false));
            Assert.assertFalse((boolean)dimSelector.makeValueMatcher((DruidPredicateFactory)StringPredicateDruidPredicateFactory.equalTo((String)NO_MATCH)).matches(false));
        }
    }

    static class SettableSelector
    extends ObjectColumnSelector<StructuredData> {
        private StructuredData data;

        SettableSelector() {
        }

        public void setObject(StructuredData o) {
            this.data = o;
        }

        @Nullable
        public StructuredData getObject() {
            return this.data;
        }

        public Class classOfObject() {
            return StructuredData.class;
        }

        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }
    }
}

